import urllib3
import json
import os

http = urllib3.PoolManager()

def lambda_handler(event, context):
    print(f'Event: {event}');
    slack_webhook_url = os.getenv("SLACK_WEBHOOK_URL")
    channel = os.getenv("SLACK_CHANNEL")
    username = os.getenv("SLACK_USERNAME")

    message = create_slack_message(event['Records'][0]['Sns']['Message'])

    msg = {
        "channel": channel,
        "username": username,
        "text": message,
        "icon_emoji": ""
    }
    
    encoded_msg = json.dumps(msg).encode('utf-8')
    resp = http.request('POST', slack_webhook_url, body=encoded_msg)
    print(f'Response: {resp.status} {resp.data}')

def create_slack_message(unparsed):
    msg = json.loads(unparsed)
    
    slack_msg = f'{msg["name"]} version {msg["version"]}/{msg["buildVersion"]} finished building. Result: {msg["state"]["status"]}'
    return slack_msg