"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PipelineBuilder = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const yaml = require("yaml");
const component_builder_1 = require("./component_builder");
const component_synchronizer_1 = require("./component_synchronizer");
const index_1 = require("./index");
const utils = require("./utils");
class PipelineBuilder {
    constructor(config) {
        this.cacheDir = 'component_cache';
        this.config = config;
    }
    async create(stack, pipelineConfigDir) {
        // Get all YAMLs from the pipelineConfigDir
        const pipelineConfigs = fs.readdirSync(pipelineConfigDir)
            .filter(c => c.endsWith('.yaml'))
            .map(f => ({
            name: utils.pascalize(f.substring(0, f.lastIndexOf('.'))),
            fileContent: fs.readFileSync(path.join(pipelineConfigDir, f), 'utf-8'),
        }));
        let pipelineYamls = pipelineConfigs.map(c => ({
            name: c.name,
            ...yaml.parse(c.fileContent),
        }));
        // Get all component dependencies
        const allComponentDeps = pipelineYamls
            .filter(y => y.component_dependencies && y.component_dependencies.length > 0)
            .map(y => y.component_dependencies.map((d) => ({ platform: y.parent_image, ...d })))
            .reduce((acc, val) => acc.concat(val), []);
        // Get all git component dependencies
        const allGitComponentDeps = allComponentDeps
            .filter((c) => c.type == 'git');
        const synchronizer = new component_synchronizer_1.ComponentSynchronizer();
        await synchronizer.synchronize(allGitComponentDeps);
        let componentBuilder = new component_builder_1.ComponentBuilder(stack, allComponentDeps);
        let pipelines = pipelineYamls
            .filter(c => c.pipeline && c.component_dependencies)
            .map(c => new index_1.AmiPipelineLib(stack, c.name, c.pipeline, c.component_dependencies, componentBuilder, {
            channel: this.config.SLACK_CHANNEL,
            slackWebhookUrl: this.config.SLACK_WEBHOOK_URL,
            username: this.config.SLACK_USERNAME,
        }));
        return pipelines;
    }
}
exports.PipelineBuilder = PipelineBuilder;
_a = JSII_RTTI_SYMBOL_1;
PipelineBuilder[_a] = { fqn: "halloumi-ami-pipelines.PipelineBuilder", version: "0.0.39" };
//# sourceMappingURL=data:application/json;base64,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