# Generated by Django 3.1.12 on 2021-09-16 09:16

import django.db.models.deletion
import django_cryptography.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("sites", "0002_alter_domain_unique"),
    ]

    operations = [
        migrations.CreateModel(
            name="HSOAuth",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "refresh_token",
                    django_cryptography.fields.encrypt(
                        models.CharField(max_length=3000)
                    ),
                ),
                (
                    "access_token",
                    django_cryptography.fields.encrypt(
                        models.CharField(max_length=3000)
                    ),
                ),
                ("expires_in", models.CharField(max_length=500)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "site",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="hs_oa",
                        to="sites.site",
                    ),
                ),
            ],
            options={
                "verbose_name": "HubSpot: OAuth",
                "verbose_name_plural": "HubSpot: OAuth",
            },
        ),
        migrations.CreateModel(
            name="HSDeal",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("deal_id", models.CharField(max_length=3000, unique=True)),
                ("properties", models.JSONField(blank=True, default=dict, null=True)),
                ("associations", models.JSONField(blank=True, null=True)),
                ("deleted_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "oauth",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="hs_oa",
                        to="hubspot.hsoauth",
                    ),
                ),
            ],
            options={
                "verbose_name": "HubSpot: Deal",
                "verbose_name_plural": "HubSpot: Deals",
            },
        ),
        migrations.CreateModel(
            name="HSContact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("contact_id", models.CharField(max_length=3000, unique=True)),
                ("properties", models.JSONField()),
                ("associations", models.JSONField(blank=True, null=True)),
                ("deleted_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "oauth",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="hubspot.hsoauth",
                    ),
                ),
            ],
            options={
                "verbose_name": "HubSpot: Contact",
                "verbose_name_plural": "HubSpot: Contacts",
            },
        ),
        migrations.CreateModel(
            name="HSCompany",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("company_id", models.CharField(max_length=3000, unique=True)),
                ("properties", models.JSONField()),
                ("associations", models.JSONField(blank=True, null=True)),
                ("deleted_at", models.DateTimeField(blank=True, null=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True, null=True)),
                (
                    "oauth",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="hubspot.hsoauth",
                    ),
                ),
            ],
            options={
                "verbose_name": "HubSpot: Company",
                "verbose_name_plural": "HubSpot: Companies",
            },
        ),
    ]
