from typing import Any

from pingsafe_cli.psgraph.common.models.enums import CheckResult, CheckCategories
from pingsafe_cli.psgraph.cloudformation.checks.resource.base_resource_value_check import BaseResourceValueCheck


class AmazonMQBrokerPublicAccess(BaseResourceValueCheck):
    def __init__(self) -> None:
        name = "Ensure Amazon MQ Broker should not have public access"
        id = "CKV_AWS_69"
        supported_resources = ('AWS::AmazonMQ::Broker',)
        categories = (CheckCategories.GENERAL_SECURITY,)
        super().__init__(
            name=name,
            id=id,
            categories=categories,
            supported_resources=supported_resources,
            missing_block_result=CheckResult.FAILED,
        )

    def get_expected_value(self) -> Any:
        return False

    def get_inspected_key(self) -> str:
        """
            validates Amazon MQ Broker should not have public access
            https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amazonmq-broker.html
        :return: <CheckResult>
        """
        return 'Properties/PubliclyAccessible'


check = AmazonMQBrokerPublicAccess()
