from typing import Optional, Any, Dict

from pingsafe_cli.psgraph.common.graph.checks_infra.enums import Operators
from pingsafe_cli.psgraph.common.checks_infra.solvers.attribute_solvers.base_attribute_solver import BaseAttributeSolver


class IsTrueAttributeSolver(BaseAttributeSolver):
    operator = Operators.IS_TRUE  # noqa: CCE003  # a static attribute

    def _get_operation(self, vertex: Dict[str, Any], attribute: Optional[str]) -> bool:
        attr = vertex.get(attribute)  # type:ignore[arg-type]  # due to attribute can be None
        if attr is None:
            return False

        return attr is True
