from __future__ import annotations

from typing import Any

from pingsafe_cli.psgraph.common.models.enums import CheckCategories, CheckResult
from pingsafe_cli.psgraph.terraform.checks.resource.base_resource_value_check import BaseResourceCheck


class GithubRepositoryVulnerabilityAlerts(BaseResourceCheck):
    def __init__(self) -> None:
        name = "Ensure GitHub repository has vulnerability alerts enabled"
        id = "CKV_GIT_3"
        supported_resources = ["github_repository"]
        categories = [CheckCategories.GENERAL_SECURITY]
        super().__init__(name=name, id=id, categories=categories, supported_resources=supported_resources)

    def scan_resource_conf(self, conf: dict[str, list[Any]]) -> CheckResult:
        # GitHub disables the alerts when archiving the repository without an option to turn them on again.
        if conf.get("archived") == [True]:
            return CheckResult.PASSED
        # GitHub enables the alerts on public repos but disables them on private repos by default.
        # is private repo
        if conf.get("private") == [True] or conf.get("visibility") in [["private"], ["internal"]]:
            if conf.get("vulnerability_alerts"):
                return CheckResult.PASSED
            return CheckResult.FAILED
        # is public repo
        if conf.get("vulnerability_alerts") == [False]:
            return CheckResult.FAILED
        return CheckResult.PASSED


check = GithubRepositoryVulnerabilityAlerts()
