from pingsafe_cli.psgraph.common.models.enums import CheckResult, CheckCategories
from pingsafe_cli.psgraph.terraform.checks.resource.base_resource_check import BaseResourceCheck
from pingsafe_cli.psgraph.common.util.type_forcers import force_int


class AbsSecurityGroupUnrestrictedIngress(BaseResourceCheck):
    def __init__(self, check_id: str, port: int) -> None:
        name = f"Ensure no security groups rules allow ingress from 0.0.0.0/0 to port {port}"
        supported_resources = ['oci_core_network_security_group_security_rule']
        categories = [CheckCategories.NETWORKING]
        super().__init__(name=name, id=check_id, categories=categories, supported_resources=supported_resources)
        self.port = port

    def scan_resource_conf(self, conf):
        direction = conf.get('direction')
        source = conf.get('source')
        protocol = conf.get('protocol')
        tcp_options = conf.get('tcp_options')
        self.evaluated_keys = ["direction"]
        if direction and direction[0] != 'INGRESS':
            return CheckResult.UNKNOWN
        self.evaluated_keys.append("source")
        if source and source[0] != "0.0.0.0/0":
            return CheckResult.PASSED
        elif (tcp_options is None and (protocol[0] == 'all' or protocol[0] == '6')) \
                or tcp_options and self.scan_protocol_conf(tcp_options) is False:
            self.evaluated_keys.append("protocol")
            return CheckResult.FAILED
        return CheckResult.PASSED

    def scan_protocol_conf(self, protocol_name):
        """ scan tcp_options configuration"""
        if 'destination_port_range' not in protocol_name[0]:
            return False
        max_port = force_int(protocol_name[0]['destination_port_range'][0]['max'][0])
        min_port = force_int(protocol_name[0]['destination_port_range'][0]['min'][0])
        if max_port and min_port and min_port <= self.port <= max_port:
            return False
        return True
