# Generated by Django 4.2.4 on 2023-09-13 09:33

from django.conf import settings
import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import taggit.managers
import utilities.json


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("extras", "0098_webhook_custom_field_data_webhook_tags"),
    ]

    operations = [
        migrations.CreateModel(
            name="ScriptInstance",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ("created", models.DateTimeField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                ("custom_field_data", models.JSONField(blank=True, default=dict, encoder=utilities.json.CustomFieldJSONEncoder)),
                ("description", models.CharField(blank=True, max_length=200)),
                ("comments", models.TextField(blank=True)),
                ("name", models.CharField(max_length=100)),
                ("module_path", models.CharField(max_length=1000)),
                ("class_name", models.CharField(max_length=1000)),
                ("group", models.CharField(blank=True, max_length=100, null=True)),
                ("weight", models.PositiveSmallIntegerField(default=1000)),
                (
                    "task_queues",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.CharField(blank=True, max_length=100), blank=True, default=list, size=None
                    ),
                ),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "ordering": ("group", "weight", "name"),
            },
        ),
        migrations.CreateModel(
            name="ScriptExecution",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("started", models.DateTimeField(blank=True, null=True)),
                ("completed", models.DateTimeField(blank=True, null=True)),
                ("status", models.CharField(default="pending", max_length=30)),
                ("scheduled", models.DateTimeField(blank=True, null=True)),
                ("task_queue", models.CharField(default="default", max_length=100)),
                ("interval", models.PositiveIntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1)])),
                ("task_id", models.UUIDField(unique=True)),
                ("request_id", models.UUIDField(unique=True)),
                ("data", models.JSONField(blank=True, default=dict, null=True)),
                (
                    "script_instance",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="script_executions",
                        to="netbox_script_manager.scriptinstance",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name="+", to=settings.AUTH_USER_MODEL
                    ),
                ),
            ],
            options={
                "ordering": ("-created",),
            },
        ),
        migrations.CreateModel(
            name="ScriptArtifact",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ("data", models.BinaryField()),
                ("name", models.CharField(default="text/plain", max_length=100)),
                ("content_type", models.CharField(max_length=100)),
                (
                    "script_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="script_artifacts",
                        to="netbox_script_manager.scriptexecution",
                    ),
                ),
            ],
            options={
                "ordering": ("id",),
            },
        ),
        migrations.CreateModel(
            name="ScriptLogLine",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False)),
                ("level", models.CharField(max_length=50)),
                ("message", models.TextField()),
                ("timestamp", models.DateTimeField(auto_now_add=True)),
                (
                    "script_execution",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="script_log_lines",
                        to="netbox_script_manager.scriptexecution",
                    ),
                ),
            ],
            options={
                "ordering": ("timestamp",),
                "indexes": [
                    models.Index(fields=["level"], name="netbox_scri_level_8445b8_idx"),
                    models.Index(fields=["timestamp"], name="netbox_scri_timesta_535a98_idx"),
                ],
            },
        ),
        migrations.AddIndex(
            model_name="scriptinstance",
            index=models.Index(fields=["name"], name="netbox_scri_name_d36576_idx"),
        ),
        migrations.AddConstraint(
            model_name="scriptinstance",
            constraint=models.UniqueConstraint(
                fields=("module_path", "class_name"), name="netbox_script_manager_scriptinstance_unique_module_path_class_name"
            ),
        ),
        migrations.AddIndex(
            model_name="scriptexecution",
            index=models.Index(fields=["started"], name="netbox_scri_started_ca0f36_idx"),
        ),
        migrations.AddIndex(
            model_name="scriptexecution",
            index=models.Index(fields=["completed"], name="netbox_scri_complet_0824df_idx"),
        ),
    ]
