# License: BSD 3 clause

import unittest

import numpy as np

from tick.prox import ProxNuclear
from tick.prox.tests.prox import TestProx


class Test(TestProx):
    def test_ProxNuclear(self):
        """...Test of ProxNuclear
        """
        np.random.seed(seed=123)
        a = np.random.randn(10, 10)
        prox = ProxNuclear(1., n_rows=10, range=(0, 100))
        a_prox = prox.call(a.ravel(), step=5.).reshape(10, 10)
        ap_truth = np.array([
            [0.09532317, 0.14427577, -0.01612392, 0.00976117, -0.08345184,
             0.0431009, -0.23546516, -0.18228506, -0.05259422, -0.18079527],
            [-0.18550691, -0.22492326, 0.07534259, -0.06637995, 0.12161585,
             -0.02924132, 0.35612826, 0.32456755, 0.1073274, 0.28054944],
            [0.11129089, 0.1273176, -0.05119876, 0.04628843, -0.06739552,
             0.01008791, -0.19971975, -0.19060023, -0.06506752, -0.15858213],
            [-0.08168301, -0.11097552, 0.02377876, -0.01910139, 0.0622679,
             -0.02455299, 0.17863458, 0.14936376, 0.04619554, 0.1387698],
            [-0.20229393, -0.26487258, 0.06673527, -0.0557617, 0.14693227,
             -0.05105731, 0.42418052, 0.36452559, 0.11529435, 0.33095115],
            [-0.18922827, -0.22113309, 0.08338942, -0.07475536, 0.11799217,
             -0.02170597, 0.34809383, 0.32659298, 0.11021994, 0.27557937],
            [-0.01120396, -0.00719888, 0.00957715, -0.00942686, 0.00268153,
             0.00448093, 0.00983428, 0.01615265, 0.00705098, 0.0087927],
            [0.06426987, 0.09498211, -0.01267638, 0.00852683, -0.05459111,
             0.02681664, -0.15456557, -0.12166336, -0.03566493, -0.11897059],
            [0.0370187, 0.04576006, -0.01434563, 0.01250348, -0.02490848,
             0.00669187, -0.07266784, -0.06524194, -0.02133965, -0.05710264],
            [0.08961473, 0.10999195, -0.03534487, 0.0309334, -0.0597259,
             0.01543284, -0.174481, -0.15751398, -0.05172876, -0.13723328]
        ])
        np.testing.assert_almost_equal(a_prox, ap_truth, decimal=7)
        self.assertAlmostEqual(prox.value(a), 29.66421102679314)


if __name__ == '__main__':
    unittest.main()
