# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.11.2593
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from typing import Optional, Set
from typing_extensions import Self

class TableCustomfields(BaseModel):
    """
    Custom fields for table.
    """ # noqa: E501
    datetime_1: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    datetime_2: Optional[datetime] = Field(default=None, description="A custom field containing date and time in the [ISO 8601](https://tools.ietf.org/html/rfc3339#section-5.6) format. Supported filter type is `DATETIME_RANGE`. ")
    int_1: Optional[Annotated[int, Field(le=10000000000, strict=True, ge=-10000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    int_2: Optional[Annotated[int, Field(le=10000000000, strict=True, ge=-10000000000)]] = Field(default=None, description="A custom field containing an integer value. Supported filter type is `INT_RANGE`. ")
    float_1: Optional[Union[Annotated[float, Field(le=10000000000, strict=True, ge=-10000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    float_2: Optional[Union[Annotated[float, Field(le=10000000000, strict=True, ge=-10000000000)], Annotated[int, Field(le=2147483647, strict=True, ge=-2147483648)]]] = Field(default=None, description="A custom field containing a floating point value. Supported filter type is `FLOAT_RANGE`. ")
    duration_1: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    duration_2: Optional[Annotated[str, Field(min_length=3, strict=True, max_length=16)]] = Field(default=None, description="A custom field containing the duration of the time period. Supported filter type is `DURATION_RANGE`. ")
    bool_1: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    bool_2: Optional[StrictBool] = Field(default=None, description="A custom field containing a boolean value. Supported filter type is `BOOL_LIST`. ")
    string_1: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    string_2: Optional[Annotated[str, Field(min_length=1, strict=True, max_length=1024)]] = Field(default=None, description="A custom field containing an string value. Supported filter type is `STRING_SEARCH`. ")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["datetime_1", "datetime_2", "int_1", "int_2", "float_1", "float_2", "duration_1", "duration_2", "bool_1", "bool_2", "string_1", "string_2"]

    @field_validator('duration_1')
    def duration_1_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    @field_validator('duration_2')
    def duration_2_validate_regular_expression(cls, value):
        """Validates the regular expression"""
        if value is None:
            return value

        if not re.match(r"^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$", value):
            raise ValueError(r"must validate the regular expression /^P(?!$)((\d+Y)|(\d+\.\d+Y$))?((\d+M)|(\d+\.\d+M$))?((\d+W)|(\d+\.\d+W$))?((\d+D)|(\d+\.\d+D$))?(T(?=\d)((\d+H)|(\d+\.\d+H$))?((\d+M)|(\d+\.\d+M$))?(\d+(\.\d+)?S)?)??$/")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TableCustomfields from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        # set to None if datetime_1 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_1 is None and "datetime_1" in self.model_fields_set:
            _dict['datetime_1'] = None

        # set to None if datetime_2 (nullable) is None
        # and model_fields_set contains the field
        if self.datetime_2 is None and "datetime_2" in self.model_fields_set:
            _dict['datetime_2'] = None

        # set to None if int_1 (nullable) is None
        # and model_fields_set contains the field
        if self.int_1 is None and "int_1" in self.model_fields_set:
            _dict['int_1'] = None

        # set to None if int_2 (nullable) is None
        # and model_fields_set contains the field
        if self.int_2 is None and "int_2" in self.model_fields_set:
            _dict['int_2'] = None

        # set to None if float_1 (nullable) is None
        # and model_fields_set contains the field
        if self.float_1 is None and "float_1" in self.model_fields_set:
            _dict['float_1'] = None

        # set to None if float_2 (nullable) is None
        # and model_fields_set contains the field
        if self.float_2 is None and "float_2" in self.model_fields_set:
            _dict['float_2'] = None

        # set to None if duration_1 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_1 is None and "duration_1" in self.model_fields_set:
            _dict['duration_1'] = None

        # set to None if duration_2 (nullable) is None
        # and model_fields_set contains the field
        if self.duration_2 is None and "duration_2" in self.model_fields_set:
            _dict['duration_2'] = None

        # set to None if bool_1 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_1 is None and "bool_1" in self.model_fields_set:
            _dict['bool_1'] = None

        # set to None if bool_2 (nullable) is None
        # and model_fields_set contains the field
        if self.bool_2 is None and "bool_2" in self.model_fields_set:
            _dict['bool_2'] = None

        # set to None if string_1 (nullable) is None
        # and model_fields_set contains the field
        if self.string_1 is None and "string_1" in self.model_fields_set:
            _dict['string_1'] = None

        # set to None if string_2 (nullable) is None
        # and model_fields_set contains the field
        if self.string_2 is None and "string_2" in self.model_fields_set:
            _dict['string_2'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TableCustomfields from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "datetime_1": obj.get("datetime_1"),
            "datetime_2": obj.get("datetime_2"),
            "int_1": obj.get("int_1"),
            "int_2": obj.get("int_2"),
            "float_1": obj.get("float_1"),
            "float_2": obj.get("float_2"),
            "duration_1": obj.get("duration_1"),
            "duration_2": obj.get("duration_2"),
            "bool_1": obj.get("bool_1"),
            "bool_2": obj.get("bool_2"),
            "string_1": obj.get("string_1"),
            "string_2": obj.get("string_2")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


