# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.11.2593
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing_extensions import Annotated
from vrt_lss_studio.models.compatibility_penalty import CompatibilityPenalty
from typing import Optional, Set
from typing_extensions import Self

class TripPenalties(BaseModel):
    """
    Planning penalties - ability to disrupt a part of the planning business rules. 
    """ # noqa: E501
    compatibilities: Optional[Annotated[List[CompatibilityPenalty], Field(min_length=0, max_length=1000000)]] = Field(default=None, description="Penalties for violation of compatibility. When taking into account transport-location compatibility violations, the penalty is applied for each stop  and cannot exceed the `max_penalty_cost` of the performer assigned to the trip. Only the absence of a property is penalized; the time windows of the life of a property cannot be violated for a fine. ")
    max_locations_limits_penalty: Optional[Union[Annotated[float, Field(le=1000000000, strict=True, ge=0)], Annotated[int, Field(le=1000000000, strict=True, ge=0)]]] = Field(default=0, description="The maximum allowable amount of fines for violating location's capacity limit.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["compatibilities", "max_locations_limits_penalty"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TripPenalties from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in compatibilities (list)
        _items = []
        if self.compatibilities:
            for _item in self.compatibilities:
                if _item:
                    _items.append(_item.to_dict())
            _dict['compatibilities'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TripPenalties from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "compatibilities": [CompatibilityPenalty.from_dict(_item) for _item in obj["compatibilities"]] if obj.get("compatibilities") is not None else None,
            "max_locations_limits_penalty": obj.get("max_locations_limits_penalty") if obj.get("max_locations_limits_penalty") is not None else 0
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


