# coding: utf-8

"""
    VRt.Studio [ST]

    Veeroute Studio API.  # Description  Server part of the Veeroute Studio.  ## Entity relationship diagram  ![erd](../uml/studio.svg) 

    The version of the OpenAPI document: 7.11.2593
    Contact: servicedesk@veeroute.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from vrt_lss_studio.models.trackpoint import Trackpoint
from typing import Optional, Set
from typing_extensions import Self

class WebTripTrack(BaseModel):
    """
    Track for map.
    """ # noqa: E501
    geotrack: Annotated[List[Trackpoint], Field(min_length=0, max_length=1000000)] = Field(description="An array of geographic points with time reference between which a path is built.")
    trip_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Trip key, unique identifier.")
    trip_name: Optional[Annotated[str, Field(min_length=0, strict=True, max_length=128)]] = Field(default='', description="Name, information field.")
    performer_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer's key.")
    performer_shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Performer shift's key, unique identifier.")
    transport_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Transport's key.")
    transport_shift_key: Annotated[str, Field(min_length=1, strict=True, max_length=1024)] = Field(description="Transport shift's key, unique identifier.")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["geotrack", "trip_key", "trip_name", "performer_key", "performer_shift_key", "transport_key", "transport_shift_key"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of WebTripTrack from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in geotrack (list)
        _items = []
        if self.geotrack:
            for _item in self.geotrack:
                if _item:
                    _items.append(_item.to_dict())
            _dict['geotrack'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of WebTripTrack from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "geotrack": [Trackpoint.from_dict(_item) for _item in obj["geotrack"]] if obj.get("geotrack") is not None else None,
            "trip_key": obj.get("trip_key"),
            "trip_name": obj.get("trip_name") if obj.get("trip_name") is not None else '',
            "performer_key": obj.get("performer_key"),
            "performer_shift_key": obj.get("performer_shift_key"),
            "transport_key": obj.get("transport_key"),
            "transport_shift_key": obj.get("transport_shift_key")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


