/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beakerx.chart.categoryplot;

import com.twosigma.beakerx.chart.AbstractChart;
import com.twosigma.beakerx.chart.ChartToJson;
import com.twosigma.beakerx.chart.categoryplot.plotitem.CategoryGraphics;
import com.twosigma.beakerx.chart.xychart.plotitem.PlotOrientationType;
import java.util.ArrayList;
import java.util.List;

public class CategoryPlot
extends AbstractChart {
    private final List<CategoryGraphics> categoryGraphics = new ArrayList<CategoryGraphics>();
    private List<String> categoryNames = new ArrayList<String>();
    private PlotOrientationType orientation = PlotOrientationType.VERTICAL;
    private double categoryMargin = 0.2;
    private double categoryNamesLabelAngle = 0.0;

    public CategoryPlot() {
        this.openComm();
    }

    @Override
    public String getModelNameValue() {
        return "PlotModel";
    }

    @Override
    public String getViewNameValue() {
        return "PlotView";
    }

    public CategoryPlot leftShift(CategoryGraphics graphics) {
        return this.add(graphics);
    }

    public List<CategoryGraphics> getGraphics() {
        return this.categoryGraphics;
    }

    public CategoryPlot add(CategoryGraphics graphics) {
        this.categoryGraphics.add(graphics);
        this.sendModelUpdate(ChartToJson.serializeCategoryGraphics(this.categoryGraphics));
        return this;
    }

    @Override
    public CategoryPlot add(List items) {
        for (Object o : items) {
            if (o instanceof CategoryGraphics) {
                this.add((CategoryGraphics)o);
                continue;
            }
            super.add(items);
        }
        return this;
    }

    public List<String> getCategoryNames() {
        return this.categoryNames;
    }

    public CategoryPlot setCategoryNames(List<String> categoryNames) {
        this.categoryNames = categoryNames;
        this.sendModelUpdate(ChartToJson.serializeCategoryNames(this.categoryNames));
        return this;
    }

    public List<CategoryGraphics> getCategoryGraphics() {
        return this.categoryGraphics;
    }

    public PlotOrientationType getOrientation() {
        return this.orientation;
    }

    public void setOrientation(PlotOrientationType orientation) {
        this.orientation = orientation;
        this.sendModelUpdate(ChartToJson.serializePlotOrientationType(this.orientation));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double categoryMargin) {
        this.categoryMargin = categoryMargin;
        this.sendModelUpdate(ChartToJson.serializeCategoryMargin(this.categoryMargin));
    }

    public double getCategoryNamesLabelAngle() {
        return this.categoryNamesLabelAngle;
    }

    public void setCategoryNamesLabelAngle(double categoryNamesLabelAngle) {
        this.categoryNamesLabelAngle = categoryNamesLabelAngle;
        this.sendModelUpdate(ChartToJson.serializeCategoryNamesLabelAngle(this.categoryNamesLabelAngle));
    }
}

