ANALYZER_PREFIX = "/analyzer"
CHEMISTRY_PREFIX = "/chemistry"
EXECUTE_PREFIX = "/execute"

ANALYZER_CIRCUIT_PAGE = "circuit"
DEFAULT_IDE_FE_APP = "https://platform.classiq.io/"

ANALYZER_HC_GRAPH = "/graphs/hardware_connectivity"
ANALYZER_HC_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_HC_GRAPH

ANALYZER_HC_TABLE_GRAPH = "/graphs/hardware_comparison_table"
ANALYZER_HC_TABLE_GRAPH_FULL_PATH = ANALYZER_PREFIX + ANALYZER_HC_TABLE_GRAPH

ANALYZER_HC_GRAPH_NEW = "/graphs/hardware_connectivity/new"

ANALYZER_OPTIONAL_DEVICES = "/graphs/available_devices"
ANALYZER_OPTIONAL_DEVICES_FULL_PATH = ANALYZER_PREFIX + ANALYZER_OPTIONAL_DEVICES

TASKS_SUFFIX = "/tasks"
GENERATED_CIRCUIT_SUFFIX = "/generated_circuit"
QUANTUM_PROGRAM_SUFFIX = "/quantum_program"
FINANCE_SUFFIX = "/finance"
ESTIMATE_SUFFIX = "/estimate"
RB = "/rb"
ANALYZER_DATA_TASK = f"{TASKS_SUFFIX}/data"
ANALYZER_QASM_TASK = f"{TASKS_SUFFIX}/qasm"
IDE_EVENT_TASK = f"{TASKS_SUFFIX}/event"
DATA_DOG_EVENT_TASK = f"{TASKS_SUFFIX}/data_dog_event"

ANALYZER_DATA_TASK_UPLOAD_FILE = f"{TASKS_SUFFIX}/data/file_upload"
ANALYZER_DATA_FULL_PATH = f"{ANALYZER_PREFIX}{ANALYZER_DATA_TASK}"
ANALYZER_QASM_FULL_PATH = f"{ANALYZER_PREFIX}{ANALYZER_QASM_TASK}"
IDE_EVENT_TASK_FULL_PATH = f"{ANALYZER_PREFIX}{IDE_EVENT_TASK}"
DATA_DOG_EVENT_TASK_FULL_PATH = f"{ANALYZER_PREFIX}{DATA_DOG_EVENT_TASK}"

IDE_QASM_TASK = f"{TASKS_SUFFIX}/generated_circuit_from_qasm"
IDE_QASM_FULL_PATH = f"{ANALYZER_PREFIX}{IDE_QASM_TASK}"
IDE_EXECUTION_RESULTS_PATH = f"/results{EXECUTE_PREFIX}"
ASYNC_TASKS_SUFFIX = "/async_tasks"
TASKS_GENERATE_SUFFIX = TASKS_SUFFIX + "/generate"
SEMANTICS_CHECK_SUFFIX = TASKS_SUFFIX + "/semantic_checks"
TASKS_SOLVE_SUFFIX = "/tasks/solve"
DEVICES_INFORMATION = "/devices_inform"
AWS_TASKS_COST = "/aws/tagged-tasks"
MODEL_GENERATE_PREFIX = "/generate_model"
CHEMISTRY_GENERATE_MODEL_PATH = MODEL_GENERATE_PREFIX + "/chemistry"

TASK_TRAIN_SUFFIX = TASKS_SUFFIX + "/train"
TASK_TEST_SUFFIX = TASKS_SUFFIX + "/test"
TASK_PREDICT_SUFFIX = TASKS_SUFFIX + "/predict"
TASK_RB_SUFFIX = TASKS_SUFFIX + RB
TASKS_GENERATE_FULL_PATH = TASKS_GENERATE_SUFFIX
TASKS_SOLVE_EXACT_SUFFIX = "/tasks/solve_exact"
TASKS_UCC_OPERATORS_SUFFIX = "/tasks/ucc_operators"

TASKS_GET_MAX_CUT_MODEL = "/tasks/get_max_cut_model"

EXECUTE_GENERATED_CIRCUIT_FULL_PATH = EXECUTE_PREFIX + GENERATED_CIRCUIT_SUFFIX
EXECUTE_QUANTUM_PROGRAM_FULL_PATH = EXECUTE_PREFIX + QUANTUM_PROGRAM_SUFFIX
EXECUTE_QUANTUM_PROGRAM_PREFIX = EXECUTE_QUANTUM_PROGRAM_FULL_PATH
EXECUTE_FINANCE_FULL_PATH = EXECUTE_PREFIX + FINANCE_SUFFIX
EXECUTE_ESTIMATE_FULL_PATH = EXECUTE_PREFIX + ESTIMATE_SUFFIX
EXECUTE_ASYNC_TASKS_FULL_PATH = EXECUTE_PREFIX + ASYNC_TASKS_SUFFIX

EXECUTE_DEVICES_INFORMATION_FULL_PATH = ANALYZER_PREFIX + DEVICES_INFORMATION
ANALYZER_FULL_PATH = ANALYZER_PREFIX + TASKS_SUFFIX
ANALYZER_RB_FULL_PATH = ANALYZER_PREFIX + TASK_RB_SUFFIX
GENERATE_RESOURCE_ESTIMATOR_REPORT = "/resource_estimator_report"

CHEMISTRY_GENERATE_HAMILTONIAN_FULL_PATH = CHEMISTRY_PREFIX + TASKS_SUFFIX
CHEMISTRY_GENERATE_UCC_OPERATORS_FULL_PATH = (
    CHEMISTRY_PREFIX + TASKS_UCC_OPERATORS_SUFFIX
)
CHEMISTRY_SOLVE_EXACT_FULL_PATH = CHEMISTRY_PREFIX + TASKS_SOLVE_EXACT_SUFFIX
CHEMISTRY_SOLVE_FULL_PATH = CHEMISTRY_PREFIX + TASKS_SOLVE_SUFFIX

FINANCE_GENERATE_MODEL_PATH = MODEL_GENERATE_PREFIX + "/finance"

GROVER_GENERATE_MODEL_PATH = MODEL_GENERATE_PREFIX + "/grover"

AWS_TASKS_COST_FULL_PATH = EXECUTE_ASYNC_TASKS_FULL_PATH + AWS_TASKS_COST
QMOD_PREFIX = ANALYZER_PREFIX + "/qmods"
QMOD_METADATA_PATH = QMOD_PREFIX + "/metadata"
QMOD_FILE_PATH = QMOD_PREFIX + "/file"
