# This file was auto-generated by Fern from our API Definition.
from typing import Optional
from .client import RulebricksApi, AsyncRulebricksApi
from .errors import BadRequestError, InternalServerError
from .resources import (
    ListResponseItem,
    ListResponseItemRequestSchemaItem,
    ListResponseItemResponseSchemaItem,
    UsageResponse,
    flows,
    rules,
)
from .resources.rules.client import RulesClient, AsyncRulesClient
from .resources.flows.client import FlowsClient, AsyncFlowsClient

class Config:
    api_key: Optional[str] = None
    base_url: str = "https://rulebricks.com"
    timeout: float = 60

def set_api_key(api_key: str) -> None:
    Config.api_key = api_key
    APIManager.reset_instances()

def set_instance_url(base_url: str) -> None:
    Config.base_url = base_url
    APIManager.reset_instances()

def set_timeout(timeout: float) -> None:
    Config.timeout = timeout
    APIManager.reset_instances()

class APIManager:
    _instance: Optional[RulebricksApi] = None
    _async_instance: Optional[AsyncRulebricksApi] = None

    @staticmethod
    def reset_instances():
        APIManager._instance = None
        APIManager._async_instance = None

    @staticmethod
    def get_api() -> RulebricksApi:
        if APIManager._instance is None:
            if Config.api_key is None:
                raise ValueError("API key not set. Please set the API key first.")
            APIManager._instance = RulebricksApi(
                base_url=Config.base_url,
                api_key=Config.api_key,
                timeout=Config.timeout
            )
        return APIManager._instance

    @staticmethod
    async def get_async_api() -> AsyncRulebricksApi:
        if APIManager._async_instance is None:
            if Config.api_key is None:
                raise ValueError("API key not set. Please set the API key first.")
            APIManager._async_instance = AsyncRulebricksApi(
                base_url=Config.base_url,
                api_key=Config.api_key,
                timeout=Config.timeout
            )
        return APIManager._async_instance

# Synchronous API with lazy loading
class SyncAPI:
    @property
    def rules(self) -> RulesClient:
        return APIManager.get_api().rules

    @property
    def flows(self) -> FlowsClient:
        return APIManager.get_api().flows

sync_api = SyncAPI()

# Asynchronous API with type hints and lazy loading
class AsyncAPI:
    @property
    async def rules(self) -> AsyncRulesClient:
        return (await APIManager.get_async_api()).rules

    @property
    async def flows(self) -> AsyncFlowsClient:
        return (await APIManager.get_async_api()).flows

async_api = AsyncAPI()

__all__ = [
    "BadRequestError",
    "InternalServerError",
    "async_api",
    "set_api_key",
    "set_instance_url",
    "set_timeout",
    "sync_api",  # Exporting sync_api
]

__all__ = [
    "BadRequestError",
    "InternalServerError",
    "ListResponseItem",
    "ListResponseItemRequestSchemaItem",
    "ListResponseItemResponseSchemaItem",
    "UsageResponse",
    "flows",
    "rules",
    "set_api_key",
    "set_instance_url",
    "async_api",
]
