""" Code is generated by ucloud-model, DO NOT EDIT IT. """

from ucloud.core.typesystem import schema, fields
from ucloud.services.ucloudstack.schemas import models

""" UCloudStack API Schema
"""


"""
API: AllocateEIP

申请外网IP
"""


class AllocateEIPRequestSchema(schema.RequestSchema):
    """AllocateEIP - 申请外网IP"""

    fields = {
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "IP": fields.Str(required=False, dump_to="IP"),
        "IPVersion": fields.Str(required=False, dump_to="IPVersion"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "OperatorName": fields.Str(required=True, dump_to="OperatorName"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AllocateEIPResponseSchema(schema.ResponseSchema):
    """AllocateEIP - 申请外网IP"""

    fields = {
        "EIPID": fields.Str(required=True, load_from="EIPID"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: AttachDisk

绑定硬盘
"""


class AttachDiskRequestSchema(schema.RequestSchema):
    """AttachDisk - 绑定硬盘"""

    fields = {
        "DiskID": fields.Str(required=True, dump_to="DiskID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AttachDiskResponseSchema(schema.ResponseSchema):
    """AttachDisk - 绑定硬盘"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: AttachNIC

绑定UCloudStack网卡
"""


class AttachNICRequestSchema(schema.RequestSchema):
    """AttachNIC - 绑定UCloudStack网卡"""

    fields = {
        "NICID": fields.Str(required=True, dump_to="NICID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class AttachNICResponseSchema(schema.ResponseSchema):
    """AttachNIC - 绑定UCloudStack网卡"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: BindAlarmTemplate

绑定告警模板
"""


class BindAlarmTemplateRequestSchema(schema.RequestSchema):
    """BindAlarmTemplate - 绑定告警模板"""

    fields = {
        "AlarmTemplateID": fields.Str(required=True, dump_to="AlarmTemplateID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceIDs": fields.List(fields.Str()),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class BindAlarmTemplateResponseSchema(schema.ResponseSchema):
    """BindAlarmTemplate - 绑定告警模板"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: BindEIP

绑定外网 IP
"""


class BindEIPRequestSchema(schema.RequestSchema):
    """BindEIP - 绑定外网 IP"""

    fields = {
        "EIPID": fields.Str(required=True, dump_to="EIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class BindEIPResponseSchema(schema.ResponseSchema):
    """BindEIP - 绑定外网 IP"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: BindPhysicalIP

绑定物理 IP ，被绑定的资源必须处于运行中或有效状态。
"""


class BindPhysicalIPRequestSchema(schema.RequestSchema):
    """BindPhysicalIP - 绑定物理 IP ，被绑定的资源必须处于运行中或有效状态。"""

    fields = {
        "PhysicalIPID": fields.Str(required=True, dump_to="PhysicalIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class BindPhysicalIPResponseSchema(schema.ResponseSchema):
    """BindPhysicalIP - 绑定物理 IP ，被绑定的资源必须处于运行中或有效状态。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: BindSecurityGroup

绑定安全组
"""


class BindSecurityGroupRequestSchema(schema.RequestSchema):
    """BindSecurityGroup - 绑定安全组"""

    fields = {
        "NICType": fields.Str(required=False, dump_to="NICType"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class BindSecurityGroupResponseSchema(schema.ResponseSchema):
    """BindSecurityGroup - 绑定安全组"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CloneDisk

克隆硬盘
"""


class CloneDiskRequestSchema(schema.RequestSchema):
    """CloneDisk - 克隆硬盘"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SrcID": fields.Str(required=True, dump_to="SrcID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CloneDiskResponseSchema(schema.ResponseSchema):
    """CloneDisk - 克隆硬盘"""

    fields = {
        "DiskID": fields.Str(required=True, load_from="DiskID"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateCertificate

创建证书
"""


class CreateCertificateRequestSchema(schema.RequestSchema):
    """CreateCertificate - 创建证书"""

    fields = {
        "Certificate": fields.Str(required=True, dump_to="Certificate"),
        "CertificateType": fields.Str(required=True, dump_to="CertificateType"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "PrivateKey": fields.Str(required=False, dump_to="PrivateKey"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateCertificateResponseSchema(schema.ResponseSchema):
    """CreateCertificate - 创建证书"""

    fields = {
        "CertificateID": fields.Str(required=True, load_from="CertificateID"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateCustomImage

创建自制镜像
"""


class CreateCustomImageRequestSchema(schema.RequestSchema):
    """CreateCustomImage - 创建自制镜像"""

    fields = {
        "ImageDescription": fields.Str(
            required=False, dump_to="ImageDescription"
        ),
        "ImageName": fields.Str(required=True, dump_to="ImageName"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateCustomImageResponseSchema(schema.ResponseSchema):
    """CreateCustomImage - 创建自制镜像"""

    fields = {
        "ImageID": fields.Str(required=True, load_from="ImageID"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateDisk

创建硬盘
"""


class CreateDiskRequestSchema(schema.RequestSchema):
    """CreateDisk - 创建硬盘"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SetType": fields.Str(required=True, dump_to="SetType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateDiskResponseSchema(schema.ResponseSchema):
    """CreateDisk - 创建硬盘"""

    fields = {
        "DiskID": fields.Str(required=True, load_from="DiskID"),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: CreateLB

创建负载均衡
"""


class CreateLBRequestSchema(schema.RequestSchema):
    """CreateLB - 创建负载均衡"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "EIPID": fields.Str(required=False, dump_to="EIPID"),
        "LBType": fields.Str(required=True, dump_to="LBType"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SGID": fields.Str(required=False, dump_to="SGID"),
        "SubnetID": fields.Str(required=True, dump_to="SubnetID"),
        "VMType": fields.Str(required=True, dump_to="VMType"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateLBResponseSchema(schema.ResponseSchema):
    """CreateLB - 创建负载均衡"""

    fields = {
        "LBID": fields.Str(required=False, load_from="LBID"),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: CreateNATGW

创建NAT网关
"""


class CreateNATGWRequestSchema(schema.RequestSchema):
    """CreateNATGW - 创建NAT网关"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "EIPID": fields.Str(required=True, dump_to="EIPID"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "SubnetID": fields.Str(required=True, dump_to="SubnetID"),
        "VMType": fields.Str(required=True, dump_to="VMType"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateNATGWResponseSchema(schema.ResponseSchema):
    """CreateNATGW - 创建NAT网关"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "NATGWID": fields.Str(required=False, load_from="NATGWID"),
    }


"""
API: CreateNATGWRule

添加NAT网关白名单
"""


class CreateNATGWRuleRequestSchema(schema.RequestSchema):
    """CreateNATGWRule - 添加NAT网关白名单"""

    fields = {
        "BindResourceID": fields.Str(required=True, dump_to="BindResourceID"),
        "NATGWID": fields.Str(required=True, dump_to="NATGWID"),
        "NATGWType": fields.Str(required=True, dump_to="NATGWType"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateNATGWRuleResponseSchema(schema.ResponseSchema):
    """CreateNATGWRule - 添加NAT网关白名单"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "RuleID": fields.Str(required=False, load_from="RuleID"),
    }


"""
API: CreateNIC

创建网卡
"""


class CreateNICRequestSchema(schema.RequestSchema):
    """CreateNIC - 创建网卡"""

    fields = {
        "IP": fields.Str(required=False, dump_to="IP"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SGID": fields.Str(required=False, dump_to="SGID"),
        "SubnetID": fields.Str(required=True, dump_to="SubnetID"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateNICResponseSchema(schema.ResponseSchema):
    """CreateNIC - 创建网卡"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "NICID": fields.Str(required=True, load_from="NICID"),
    }


"""
API: CreatePhysicalIP

创建物理 IP ，需确保平台已配置物理 IP 线路相关信息及物理网络联通性。
"""


class CreatePhysicalIPRequestSchema(schema.RequestSchema):
    """CreatePhysicalIP - 创建物理 IP ，需确保平台已配置物理 IP 线路相关信息及物理网络联通性。"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "OperatorName": fields.Str(required=True, dump_to="OperatorName"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreatePhysicalIPResponseSchema(schema.ResponseSchema):
    """CreatePhysicalIP - 创建物理 IP ，需确保平台已配置物理 IP 线路相关信息及物理网络联通性。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "PhysicalIPID": fields.Str(required=True, load_from="PhysicalIPID"),
    }


"""
API: CreateRS

为负载均衡的 VServer 添加后端服务节点。
"""


class CreateRSRequestSchema(schema.RequestSchema):
    """CreateRS - 为负载均衡的 VServer 添加后端服务节点。"""

    fields = {
        "BindResourceID": fields.Str(required=True, dump_to="BindResourceID"),
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Port": fields.Int(required=True, dump_to="Port"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Weight": fields.Int(required=True, dump_to="Weight"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateRSResponseSchema(schema.ResponseSchema):
    """CreateRS - 为负载均衡的 VServer 添加后端服务节点。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "RSID": fields.Str(required=False, load_from="RSID"),
    }


"""
API: CreateSecurityGroup

创建安全组
"""


class CreateSecurityGroupRequestSchema(schema.RequestSchema):
    """CreateSecurityGroup - 创建安全组"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Rule": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateSecurityGroupResponseSchema(schema.ResponseSchema):
    """CreateSecurityGroup - 创建安全组"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "SGID": fields.Str(required=False, load_from="SGID"),
    }


"""
API: CreateSecurityGroupRule

创建安全组规则
"""


class CreateSecurityGroupRuleRequestSchema(schema.RequestSchema):
    """CreateSecurityGroupRule - 创建安全组规则"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "Rules": fields.List(fields.Str()),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateSecurityGroupRuleResponseSchema(schema.ResponseSchema):
    """CreateSecurityGroupRule - 创建安全组规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "SGRuleID": fields.Str(required=False, load_from="SGRuleID"),
    }


"""
API: CreateSnapshot

创建硬盘快照
"""


class CreateSnapshotRequestSchema(schema.RequestSchema):
    """CreateSnapshot - 创建硬盘快照"""

    fields = {
        "DiskID": fields.Str(required=True, dump_to="DiskID"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateSnapshotResponseSchema(schema.ResponseSchema):
    """CreateSnapshot - 创建硬盘快照"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "SnapshotID": fields.Str(required=True, load_from="SnapshotID"),
    }


"""
API: CreateSubnet

创建子网
"""


class CreateSubnetRequestSchema(schema.RequestSchema):
    """CreateSubnet - 创建子网"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "Network": fields.Str(required=True, dump_to="Network"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateSubnetResponseSchema(schema.ResponseSchema):
    """CreateSubnet - 创建子网"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "SubnetID": fields.Str(required=False, load_from="SubnetID"),
    }


"""
API: CreateUser

管理员添加账号
"""


class CreateUserRequestSchema(schema.RequestSchema):
    """CreateUser - 管理员添加账号"""

    fields = {
        "PassWord": fields.Str(required=True, dump_to="PassWord"),
        "UserEmail": fields.Str(required=True, dump_to="UserEmail"),
    }


class CreateUserResponseSchema(schema.ResponseSchema):
    """CreateUser - 管理员添加账号"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "UserID": fields.Int(required=False, load_from="UserID"),
    }


"""
API: CreateVMInstance

创建虚拟机
"""


class CreateVMInstanceRequestSchema(schema.RequestSchema):
    """CreateVMInstance - 创建虚拟机"""

    fields = {
        "Bandwidth": fields.Str(required=False, dump_to="Bandwidth"),
        "BootDiskSetType": fields.Str(required=True, dump_to="BootDiskSetType"),
        "CPU": fields.Int(required=True, dump_to="CPU"),
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "DataDiskSetType": fields.Str(required=True, dump_to="DataDiskSetType"),
        "DataDiskSpace": fields.Int(required=False, dump_to="DataDiskSpace"),
        "GPU": fields.Int(required=False, dump_to="GPU"),
        "IPVersion": fields.Str(required=False, dump_to="IPVersion"),
        "ImageID": fields.Str(required=True, dump_to="ImageID"),
        "InternalIP": fields.Str(required=False, dump_to="InternalIP"),
        "InternetIP": fields.Str(required=False, dump_to="InternetIP"),
        "LANSGID": fields.Str(required=False, dump_to="LANSGID"),
        "Memory": fields.Int(required=True, dump_to="Memory"),
        "Name": fields.Str(required=True, dump_to="Name"),
        "OperatorName": fields.Str(required=False, dump_to="OperatorName"),
        "Password": fields.Str(required=True, dump_to="Password"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetID": fields.Str(required=True, dump_to="SubnetID"),
        "VMType": fields.Str(required=True, dump_to="VMType"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
        "WANSGID": fields.Str(required=True, dump_to="WANSGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateVMInstanceResponseSchema(schema.ResponseSchema):
    """CreateVMInstance - 创建虚拟机"""

    fields = {
        "DiskID": fields.Str(required=False, load_from="DiskID"),
        "EIPID": fields.Str(required=False, load_from="EIPID"),
        "Message": fields.Str(required=False, load_from="Message"),
        "VMID": fields.Str(required=False, load_from="VMID"),
    }


"""
API: CreateVPC

创建VPC
"""


class CreateVPCRequestSchema(schema.RequestSchema):
    """CreateVPC - 创建VPC"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "Network": fields.Str(required=True, dump_to="Network"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateVPCResponseSchema(schema.ResponseSchema):
    """CreateVPC - 创建VPC"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
        "VPCID": fields.Str(required=False, load_from="VPCID"),
    }


"""
API: CreateVS

创建负载均衡VServer
"""


class CreateVSRequestSchema(schema.RequestSchema):
    """CreateVS - 创建负载均衡VServer"""

    fields = {
        "CACertificateID": fields.Str(
            required=False, dump_to="CACertificateID"
        ),
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "HealthcheckType": fields.Str(required=True, dump_to="HealthcheckType"),
        "KeepaliveTimeout": fields.Int(
            required=False, dump_to="KeepaliveTimeout"
        ),
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "PersistenceKey": fields.Str(required=False, dump_to="PersistenceKey"),
        "PersistenceType": fields.Str(
            required=False, dump_to="PersistenceType"
        ),
        "Port": fields.Int(required=True, dump_to="Port"),
        "Protocol": fields.Str(required=True, dump_to="Protocol"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLMode": fields.Str(required=False, dump_to="SSLMode"),
        "Scheduler": fields.Str(required=True, dump_to="Scheduler"),
        "ServerCertificateID": fields.Str(
            required=False, dump_to="ServerCertificateID"
        ),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateVSResponseSchema(schema.ResponseSchema):
    """CreateVS - 创建负载均衡VServer"""

    fields = {
        "Action": fields.Str(required=True, load_from="Action"),
        "Message": fields.Str(required=False, load_from="Message"),
        "RetCode": fields.Int(required=True, load_from="RetCode"),
        "VSID": fields.Str(required=False, load_from="VSID"),
    }


"""
API: CreateVSPolicy

创建七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。
"""


class CreateVSPolicyRequestSchema(schema.RequestSchema):
    """CreateVSPolicy - 创建七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "RSIDs": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class CreateVSPolicyResponseSchema(schema.ResponseSchema):
    """CreateVSPolicy - 创建七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "PolicyID": fields.Str(required=False, load_from="PolicyID"),
    }


"""
API: DeleteCertificate

删除证书
"""


class DeleteCertificateRequestSchema(schema.RequestSchema):
    """DeleteCertificate - 删除证书"""

    fields = {
        "CertificateID": fields.Str(required=True, dump_to="CertificateID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteCertificateResponseSchema(schema.ResponseSchema):
    """DeleteCertificate - 删除证书"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteCustomImage

删除自制镜像
"""


class DeleteCustomImageRequestSchema(schema.RequestSchema):
    """DeleteCustomImage - 删除自制镜像"""

    fields = {
        "ImageID": fields.Str(required=True, dump_to="ImageID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteCustomImageResponseSchema(schema.ResponseSchema):
    """DeleteCustomImage - 删除自制镜像"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteDisk

删除硬盘
"""


class DeleteDiskRequestSchema(schema.RequestSchema):
    """DeleteDisk - 删除硬盘"""

    fields = {
        "DiskID": fields.Str(required=True, dump_to="DiskID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteDiskResponseSchema(schema.ResponseSchema):
    """DeleteDisk - 删除硬盘"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteLB

删除负载均衡
"""


class DeleteLBRequestSchema(schema.RequestSchema):
    """DeleteLB - 删除负载均衡"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteLBResponseSchema(schema.ResponseSchema):
    """DeleteLB - 删除负载均衡"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteNATGW

删除NAT网关
"""


class DeleteNATGWRequestSchema(schema.RequestSchema):
    """DeleteNATGW - 删除NAT网关"""

    fields = {
        "NATGWID": fields.Str(required=True, dump_to="NATGWID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteNATGWResponseSchema(schema.ResponseSchema):
    """DeleteNATGW - 删除NAT网关"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteNATGWRule

删除NAT网关白名单
"""


class DeleteNATGWRuleRequestSchema(schema.RequestSchema):
    """DeleteNATGWRule - 删除NAT网关白名单"""

    fields = {
        "NATGWID": fields.Str(required=True, dump_to="NATGWID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleID": fields.Str(required=True, dump_to="RuleID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteNATGWRuleResponseSchema(schema.ResponseSchema):
    """DeleteNATGWRule - 删除NAT网关白名单"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteNIC

删除网卡
"""


class DeleteNICRequestSchema(schema.RequestSchema):
    """DeleteNIC - 删除网卡"""

    fields = {
        "NICID": fields.Str(required=True, dump_to="NICID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteNICResponseSchema(schema.ResponseSchema):
    """DeleteNIC - 删除网卡"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeletePhysicalIP

删除物理IP
"""


class DeletePhysicalIPRequestSchema(schema.RequestSchema):
    """DeletePhysicalIP - 删除物理IP"""

    fields = {
        "PhysicalIPID": fields.Str(required=True, dump_to="PhysicalIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeletePhysicalIPResponseSchema(schema.ResponseSchema):
    """DeletePhysicalIP - 删除物理IP"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteRS

移除负载均衡的单个服务节点
"""


class DeleteRSRequestSchema(schema.RequestSchema):
    """DeleteRS - 移除负载均衡的单个服务节点"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "RSID": fields.Str(required=True, dump_to="RSID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteRSResponseSchema(schema.ResponseSchema):
    """DeleteRS - 移除负载均衡的单个服务节点"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteSecurityGroup

删除安全组
"""


class DeleteSecurityGroupRequestSchema(schema.RequestSchema):
    """DeleteSecurityGroup - 删除安全组"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteSecurityGroupResponseSchema(schema.ResponseSchema):
    """DeleteSecurityGroup - 删除安全组"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteSecurityGroupRule

删除安全组规则
"""


class DeleteSecurityGroupRuleRequestSchema(schema.RequestSchema):
    """DeleteSecurityGroupRule - 删除安全组规则"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "SGRuleID": fields.Str(required=True, dump_to="SGRuleID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteSecurityGroupRuleResponseSchema(schema.ResponseSchema):
    """DeleteSecurityGroupRule - 删除安全组规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteSnapshot

删除快照，仅支持状态为正常的快照进行删除操作。
"""


class DeleteSnapshotRequestSchema(schema.RequestSchema):
    """DeleteSnapshot - 删除快照，仅支持状态为正常的快照进行删除操作。"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnapshotID": fields.Str(required=True, dump_to="SnapshotID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteSnapshotResponseSchema(schema.ResponseSchema):
    """DeleteSnapshot - 删除快照，仅支持状态为正常的快照进行删除操作。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteSubnet

删除子网
"""


class DeleteSubnetRequestSchema(schema.RequestSchema):
    """DeleteSubnet - 删除子网"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetID": fields.Str(required=True, dump_to="SubnetID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteSubnetResponseSchema(schema.ResponseSchema):
    """DeleteSubnet - 删除子网"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteVMInstance

删除虚拟机
"""


class DeleteVMInstanceRequestSchema(schema.RequestSchema):
    """DeleteVMInstance - 删除虚拟机"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteVMInstanceResponseSchema(schema.ResponseSchema):
    """DeleteVMInstance - 删除虚拟机"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DeleteVPC

删除VPC
"""


class DeleteVPCRequestSchema(schema.RequestSchema):
    """DeleteVPC - 删除VPC"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCID": fields.Str(required=True, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteVPCResponseSchema(schema.ResponseSchema):
    """DeleteVPC - 删除VPC"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteVS

删除VServer
"""


class DeleteVSRequestSchema(schema.RequestSchema):
    """DeleteVS - 删除VServer"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteVSResponseSchema(schema.ResponseSchema):
    """DeleteVS - 删除VServer"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DeleteVSPolicy

删除七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。
"""


class DeleteVSPolicyRequestSchema(schema.RequestSchema):
    """DeleteVSPolicy - 删除七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "PolicyID": fields.Str(required=True, dump_to="PolicyID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DeleteVSPolicyResponseSchema(schema.ResponseSchema):
    """DeleteVSPolicy - 删除七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: DescribeCertificate

查询证书
"""


class DescribeCertificateRequestSchema(schema.RequestSchema):
    """DescribeCertificate - 查询证书"""

    fields = {
        "CertificateIDs": fields.List(fields.Str()),
        "CertificateType": fields.Str(
            required=False, dump_to="CertificateType"
        ),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeCertificateResponseSchema(schema.ResponseSchema):
    """DescribeCertificate - 查询证书"""

    fields = {
        "Infos": fields.List(
            models.CertificateInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeDisk

获取硬盘信息
"""


class DescribeDiskRequestSchema(schema.RequestSchema):
    """DescribeDisk - 获取硬盘信息"""

    fields = {
        "DiskIDs": fields.List(fields.Str()),
        "DiskType": fields.Str(required=False, dump_to="DiskType"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeDiskResponseSchema(schema.ResponseSchema):
    """DescribeDisk - 获取硬盘信息"""

    fields = {
        "Infos": fields.List(
            models.DiskInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeEIP

获取外网IP的信息
"""


class DescribeEIPRequestSchema(schema.RequestSchema):
    """DescribeEIP - 获取外网IP的信息"""

    fields = {
        "BindResourceID": fields.Str(required=False, dump_to="BindResourceID"),
        "EIPIDs": fields.List(fields.Str()),
        "IPVersion": fields.Str(required=False, dump_to="IPVersion"),
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "Offset": fields.Str(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeEIPResponseSchema(schema.ResponseSchema):
    """DescribeEIP - 获取外网IP的信息"""

    fields = {
        "Infos": fields.List(
            models.EIPInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "Totalcount": fields.Int(required=False, load_from="Totalcount"),
    }


"""
API: DescribeImage

获取镜像信息，包括默认镜像和自制镜像。
"""


class DescribeImageRequestSchema(schema.RequestSchema):
    """DescribeImage - 获取镜像信息，包括默认镜像和自制镜像。"""

    fields = {
        "ImageIDs": fields.List(fields.Str()),
        "ImageType": fields.Str(required=False, dump_to="ImageType"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeImageResponseSchema(schema.ResponseSchema):
    """DescribeImage - 获取镜像信息，包括默认镜像和自制镜像。"""

    fields = {
        "Action": fields.Str(required=True, load_from="Action"),
        "Infos": fields.List(
            models.ImageInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "RetCode": fields.Int(required=True, load_from="RetCode"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeLB

获取负载均衡信息
"""


class DescribeLBRequestSchema(schema.RequestSchema):
    """DescribeLB - 获取负载均衡信息"""

    fields = {
        "LBIDs": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetID": fields.Str(required=False, dump_to="SubnetID"),
        "VPCID": fields.Str(required=False, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeLBResponseSchema(schema.ResponseSchema):
    """DescribeLB - 获取负载均衡信息"""

    fields = {
        "Infos": fields.List(
            models.LBInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeMetric

获取资源监控信息
"""


class DescribeMetricRequestSchema(schema.RequestSchema):
    """DescribeMetric - 获取资源监控信息"""

    fields = {
        "BeginTime": fields.Str(required=True, dump_to="BeginTime"),
        "EndTime": fields.Str(required=True, dump_to="EndTime"),
        "MetricName": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeMetricResponseSchema(schema.ResponseSchema):
    """DescribeMetric - 获取资源监控信息"""

    fields = {
        "Infos": fields.List(
            models.MetricInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeNATGW

获取NAT网关信息
"""


class DescribeNATGWRequestSchema(schema.RequestSchema):
    """DescribeNATGW - 获取NAT网关信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWIDs": fields.List(fields.Str()),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeNATGWResponseSchema(schema.ResponseSchema):
    """DescribeNATGW - 获取NAT网关信息"""

    fields = {
        "Infos": fields.List(
            models.NATGWInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeNATGWRule

获取NAT网关白名单信息 
"""


class DescribeNATGWRuleRequestSchema(schema.RequestSchema):
    """DescribeNATGWRule - 获取NAT网关白名单信息"""

    fields = {
        "BindResourceIDs": fields.List(fields.Str()),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NATGWID": fields.Str(required=True, dump_to="NATGWID"),
        "NATGWType": fields.Str(required=True, dump_to="NATGWType"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "RuleIDs": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeNATGWRuleResponseSchema(schema.ResponseSchema):
    """DescribeNATGWRule - 获取NAT网关白名单信息"""

    fields = {
        "Infos": fields.List(
            models.NATGWRuleInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeNIC

获取网卡信息
"""


class DescribeNICRequestSchema(schema.RequestSchema):
    """DescribeNIC - 获取网卡信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "NICIDs": fields.List(fields.Str()),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeNICResponseSchema(schema.ResponseSchema):
    """DescribeNIC - 获取网卡信息"""

    fields = {
        "Infos": fields.List(
            models.NICInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeOPLogs

查询操作日志
"""


class DescribeOPLogsRequestSchema(schema.RequestSchema):
    """DescribeOPLogs - 查询操作日志"""

    fields = {
        "BeginTime": fields.Int(required=True, dump_to="BeginTime"),
        "EndTime": fields.Int(required=True, dump_to="EndTime"),
        "IsSuccess": fields.Str(required=False, dump_to="IsSuccess"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=False, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=False, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeOPLogsResponseSchema(schema.ResponseSchema):
    """DescribeOPLogs - 查询操作日志"""

    fields = {
        "Infos": fields.List(
            models.OPLogInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribePhysicalIP

获取物理IP信息 
"""


class DescribePhysicalIPRequestSchema(schema.RequestSchema):
    """DescribePhysicalIP - 获取物理IP信息"""

    fields = {
        "Limit": fields.Str(required=False, dump_to="Limit"),
        "Offset": fields.Str(required=False, dump_to="Offset"),
        "PhysicalIPIDs": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribePhysicalIPResponseSchema(schema.ResponseSchema):
    """DescribePhysicalIP - 获取物理IP信息"""

    fields = {
        "Infos": fields.List(
            models.PhysicalIPInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeRS

获取负载均衡服务的服务节点信息
"""


class DescribeRSRequestSchema(schema.RequestSchema):
    """DescribeRS - 获取负载均衡服务的服务节点信息"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "RSIDs": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=False, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeRSResponseSchema(schema.ResponseSchema):
    """DescribeRS - 获取负载均衡服务的服务节点信息"""

    fields = {
        "Infos": fields.List(
            models.RSInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeRecycledResource

查询回收站资源
"""


class DescribeRecycledResourceRequestSchema(schema.RequestSchema):
    """DescribeRecycledResource - 查询回收站资源"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceIDs": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeRecycledResourceResponseSchema(schema.ResponseSchema):
    """DescribeRecycledResource - 查询回收站资源"""

    fields = {
        "Infos": fields.List(
            models.RecycledResourceInfoSchema(),
            required=True,
            load_from="Infos",
        ),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeSecurityGroup

查询安全组信息
"""


class DescribeSecurityGroupRequestSchema(schema.RequestSchema):
    """DescribeSecurityGroup - 查询安全组信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SGIDs": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeSecurityGroupResponseSchema(schema.ResponseSchema):
    """DescribeSecurityGroup - 查询安全组信息"""

    fields = {
        "Infos": fields.List(
            models.SGInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSecurityGroupResource

查询安全组绑定的资源信息
"""


class DescribeSecurityGroupResourceRequestSchema(schema.RequestSchema):
    """DescribeSecurityGroupResource - 查询安全组绑定的资源信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeSecurityGroupResourceResponseSchema(schema.ResponseSchema):
    """DescribeSecurityGroupResource - 查询安全组绑定的资源信息"""

    fields = {
        "Infos": fields.List(
            models.SGResourceInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeSnapshot

查询硬盘快照信息
"""


class DescribeSnapshotRequestSchema(schema.RequestSchema):
    """DescribeSnapshot - 查询硬盘快照信息"""

    fields = {
        "DiskID": fields.Str(required=False, dump_to="DiskID"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnapshotIDs": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeSnapshotResponseSchema(schema.ResponseSchema):
    """DescribeSnapshot - 查询硬盘快照信息"""

    fields = {
        "Infos": fields.List(
            models.SnapshotInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeStorageType

查询存储类型
"""


class DescribeStorageTypeRequestSchema(schema.RequestSchema):
    """DescribeStorageType - 查询存储类型"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeStorageTypeResponseSchema(schema.ResponseSchema):
    """DescribeStorageType - 查询存储类型"""

    fields = {
        "Infos": fields.List(
            models.StorageTypeInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeSubnet

查询子网信息
"""


class DescribeSubnetRequestSchema(schema.RequestSchema):
    """DescribeSubnet - 查询子网信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetIDs": fields.List(fields.Str()),
        "VPCID": fields.Str(required=False, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeSubnetResponseSchema(schema.ResponseSchema):
    """DescribeSubnet - 查询子网信息"""

    fields = {
        "Infos": fields.List(
            models.SubnetInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeUser

查询租户信息
"""


class DescribeUserRequestSchema(schema.RequestSchema):
    """DescribeUser - 查询租户信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "UserIDs": fields.List(fields.Int()),
    }


class DescribeUserResponseSchema(schema.ResponseSchema):
    """DescribeUser - 查询租户信息"""

    fields = {
        "Infos": fields.List(
            models.UserInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeVMInstance

查询虚拟机
"""


class DescribeVMInstanceRequestSchema(schema.RequestSchema):
    """DescribeVMInstance - 查询虚拟机"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SubnetID": fields.Str(required=False, dump_to="SubnetID"),
        "VMIDs": fields.List(fields.Str()),
        "VPCID": fields.Str(required=False, dump_to="VPCID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeVMInstanceResponseSchema(schema.ResponseSchema):
    """DescribeVMInstance - 查询虚拟机"""

    fields = {
        "Infos": fields.List(
            models.VMInstanceInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeVMType

查询主机机型
"""


class DescribeVMTypeRequestSchema(schema.RequestSchema):
    """DescribeVMType - 查询主机机型"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeVMTypeResponseSchema(schema.ResponseSchema):
    """DescribeVMType - 查询主机机型"""

    fields = {
        "Infos": fields.List(
            models.VMTypeInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeVPC

查询VPC信息
"""


class DescribeVPCRequestSchema(schema.RequestSchema):
    """DescribeVPC - 查询VPC信息"""

    fields = {
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VPCIDs": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeVPCResponseSchema(schema.ResponseSchema):
    """DescribeVPC - 查询VPC信息"""

    fields = {
        "Infos": fields.List(
            models.VPCInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=False, load_from="TotalCount"),
    }


"""
API: DescribeVS

获取负载均衡 VServer 信息
"""


class DescribeVSRequestSchema(schema.RequestSchema):
    """DescribeVS - 获取负载均衡 VServer 信息"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSIDs": fields.List(fields.Str()),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeVSResponseSchema(schema.ResponseSchema):
    """DescribeVS - 获取负载均衡 VServer 信息"""

    fields = {
        "Infos": fields.List(
            models.VSInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DescribeVSPolicy

获取七层负载均衡内容转发规则信息，仅当 VServer 的监听协议为 HTTP 时有效。
"""


class DescribeVSPolicyRequestSchema(schema.RequestSchema):
    """DescribeVSPolicy - 获取七层负载均衡内容转发规则信息，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Limit": fields.Int(required=False, dump_to="Limit"),
        "Offset": fields.Int(required=False, dump_to="Offset"),
        "PolicyIDs": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=False, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DescribeVSPolicyResponseSchema(schema.ResponseSchema):
    """DescribeVSPolicy - 获取七层负载均衡内容转发规则信息，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "Infos": fields.List(
            models.VSPolicyInfoSchema(), required=True, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
        "TotalCount": fields.Int(required=True, load_from="TotalCount"),
    }


"""
API: DetachDisk

解绑硬盘
"""


class DetachDiskRequestSchema(schema.RequestSchema):
    """DetachDisk - 解绑硬盘"""

    fields = {
        "DiskID": fields.Str(required=True, dump_to="DiskID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DetachDiskResponseSchema(schema.ResponseSchema):
    """DetachDisk - 解绑硬盘"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DetachNIC

解绑UClouStack网卡
"""


class DetachNICRequestSchema(schema.RequestSchema):
    """DetachNIC - 解绑UClouStack网卡"""

    fields = {
        "NICID": fields.Str(required=True, dump_to="NICID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DetachNICResponseSchema(schema.ResponseSchema):
    """DetachNIC - 解绑UClouStack网卡"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: DisableRS

禁用负载均衡的单个服务节点
"""


class DisableRSRequestSchema(schema.RequestSchema):
    """DisableRS - 禁用负载均衡的单个服务节点"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "RSID": fields.Str(required=True, dump_to="RSID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class DisableRSResponseSchema(schema.ResponseSchema):
    """DisableRS - 禁用负载均衡的单个服务节点"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: EnableRS

启用负载均衡的单个服务节点
"""


class EnableRSRequestSchema(schema.RequestSchema):
    """EnableRS - 启用负载均衡的单个服务节点"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "RSID": fields.Str(required=True, dump_to="RSID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class EnableRSResponseSchema(schema.ResponseSchema):
    """EnableRS - 启用负载均衡的单个服务节点"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: GetDiskPrice

获取硬盘价格
"""


class GetDiskPriceRequestSchema(schema.RequestSchema):
    """GetDiskPrice - 获取硬盘价格"""

    fields = {
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SetType": fields.Str(required=True, dump_to="SetType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetDiskPriceResponseSchema(schema.ResponseSchema):
    """GetDiskPrice - 获取硬盘价格"""

    fields = {
        "Infos": fields.List(
            models.PriceInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: GetEIPPrice

获取外网IP价格
"""


class GetEIPPriceRequestSchema(schema.RequestSchema):
    """GetEIPPrice - 获取外网IP价格"""

    fields = {
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "OpertatorName": fields.Str(required=True, dump_to="OpertatorName"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetEIPPriceResponseSchema(schema.ResponseSchema):
    """GetEIPPrice - 获取外网IP价格"""

    fields = {
        "Infos": fields.List(
            models.PriceInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: GetVMInstancePrice

获取虚拟机价格
"""


class GetVMInstancePriceRequestSchema(schema.RequestSchema):
    """GetVMInstancePrice - 获取虚拟机价格"""

    fields = {
        "BootDiskSetType": fields.Str(required=True, dump_to="BootDiskSetType"),
        "CPU": fields.Int(required=True, dump_to="CPU"),
        "ChargeType": fields.Str(required=True, dump_to="ChargeType"),
        "DataDiskSetType": fields.Str(required=True, dump_to="DataDiskSetType"),
        "DataDiskSpace": fields.Int(required=True, dump_to="DataDiskSpace"),
        "GPU": fields.Int(required=False, dump_to="GPU"),
        "ImageID": fields.Str(required=True, dump_to="ImageID"),
        "Memory": fields.Int(required=True, dump_to="Memory"),
        "OSType": fields.Str(required=True, dump_to="OSType"),
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMType": fields.Str(required=True, dump_to="VMType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class GetVMInstancePriceResponseSchema(schema.ResponseSchema):
    """GetVMInstancePrice - 获取虚拟机价格"""

    fields = {
        "Infos": fields.List(
            models.PriceInfoSchema(), required=False, load_from="Infos"
        ),
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ModifyEIPBandwidth

调整外网IP带宽
"""


class ModifyEIPBandwidthRequestSchema(schema.RequestSchema):
    """ModifyEIPBandwidth - 调整外网IP带宽"""

    fields = {
        "Bandwidth": fields.Int(required=True, dump_to="Bandwidth"),
        "EIPID": fields.Str(required=True, dump_to="EIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ModifyEIPBandwidthResponseSchema(schema.ResponseSchema):
    """ModifyEIPBandwidth - 调整外网IP带宽"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ModifyNameAndRemark

修改资源名称和备注
"""


class ModifyNameAndRemarkRequestSchema(schema.RequestSchema):
    """ModifyNameAndRemark - 修改资源名称和备注"""

    fields = {
        "Name": fields.Str(required=True, dump_to="Name"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Remark": fields.Str(required=False, dump_to="Remark"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ModifyNameAndRemarkResponseSchema(schema.ResponseSchema):
    """ModifyNameAndRemark - 修改资源名称和备注"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: PoweroffVMInstance

断电虚拟机，可能导致丢失数据甚至损坏操作系统，仅适用于虚拟机死机及级端测试场景。
"""


class PoweroffVMInstanceRequestSchema(schema.RequestSchema):
    """PoweroffVMInstance - 断电虚拟机，可能导致丢失数据甚至损坏操作系统，仅适用于虚拟机死机及级端测试场景。"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class PoweroffVMInstanceResponseSchema(schema.ResponseSchema):
    """PoweroffVMInstance - 断电虚拟机，可能导致丢失数据甚至损坏操作系统，仅适用于虚拟机死机及级端测试场景。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: Recharge

管理员给租户充值
"""


class RechargeRequestSchema(schema.RequestSchema):
    """Recharge - 管理员给租户充值"""

    fields = {
        "Amount": fields.Int(required=True, dump_to="Amount"),
        "FromType": fields.Str(required=True, dump_to="FromType"),
        "SerialNo": fields.Str(required=True, dump_to="SerialNo"),
        "UserID": fields.Int(required=True, dump_to="UserID"),
    }


class RechargeResponseSchema(schema.ResponseSchema):
    """Recharge - 管理员给租户充值"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ReinstallVMInstance

重装系统，关机的虚拟机才可以重装系统
"""


class ReinstallVMInstanceRequestSchema(schema.RequestSchema):
    """ReinstallVMInstance - 重装系统，关机的虚拟机才可以重装系统"""

    fields = {
        "ImageID": fields.Str(required=True, dump_to="ImageID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ReinstallVMInstanceResponseSchema(schema.ResponseSchema):
    """ReinstallVMInstance - 重装系统，关机的虚拟机才可以重装系统"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ReleaseEIP

删除外网IP
"""


class ReleaseEIPRequestSchema(schema.RequestSchema):
    """ReleaseEIP - 删除外网IP"""

    fields = {
        "EIPID": fields.Str(required=True, dump_to="EIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ReleaseEIPResponseSchema(schema.ResponseSchema):
    """ReleaseEIP - 删除外网IP"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RenewResource

续费回收站资源 
"""


class RenewResourceRequestSchema(schema.RequestSchema):
    """RenewResource - 续费回收站资源"""

    fields = {
        "Quantity": fields.Int(required=False, dump_to="Quantity"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RenewResourceResponseSchema(schema.ResponseSchema):
    """RenewResource - 续费回收站资源"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: ResetVMInstancePassword

重置虚拟机密码，主机必须开机才可以重置密码
"""


class ResetVMInstancePasswordRequestSchema(schema.RequestSchema):
    """ResetVMInstancePassword - 重置虚拟机密码，主机必须开机才可以重置密码"""

    fields = {
        "Password": fields.Str(required=True, dump_to="Password"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ResetVMInstancePasswordResponseSchema(schema.ResponseSchema):
    """ResetVMInstancePassword - 重置虚拟机密码，主机必须开机才可以重置密码"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: ResizeVMConfig

修改虚拟机配置
"""


class ResizeVMConfigRequestSchema(schema.RequestSchema):
    """ResizeVMConfig - 修改虚拟机配置"""

    fields = {
        "CPU": fields.Int(required=True, dump_to="CPU"),
        "Memory": fields.Int(required=True, dump_to="Memory"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class ResizeVMConfigResponseSchema(schema.ResponseSchema):
    """ResizeVMConfig - 修改虚拟机配置"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RestartVMInstance

重启虚拟机
"""


class RestartVMInstanceRequestSchema(schema.RequestSchema):
    """RestartVMInstance - 重启虚拟机"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RestartVMInstanceResponseSchema(schema.ResponseSchema):
    """RestartVMInstance - 重启虚拟机"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: RollbackResource

恢复回收站资源
"""


class RollbackResourceRequestSchema(schema.RequestSchema):
    """RollbackResource - 恢复回收站资源"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RollbackResourceResponseSchema(schema.ResponseSchema):
    """RollbackResource - 恢复回收站资源"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: RollbackSnapshot

将某个快照内的数据回滚到原云硬盘，仅支持正常状态的快照进行回滚操作，回滚时硬盘必须处于未绑定或其挂载的主机为关机状态。
"""


class RollbackSnapshotRequestSchema(schema.RequestSchema):
    """RollbackSnapshot - 将某个快照内的数据回滚到原云硬盘，仅支持正常状态的快照进行回滚操作，回滚时硬盘必须处于未绑定或其挂载的主机为关机状态。"""

    fields = {
        "DiskID": fields.Str(required=True, dump_to="DiskID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SnapshotID": fields.Str(required=True, dump_to="SnapshotID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class RollbackSnapshotResponseSchema(schema.ResponseSchema):
    """RollbackSnapshot - 将某个快照内的数据回滚到原云硬盘，仅支持正常状态的快照进行回滚操作，回滚时硬盘必须处于未绑定或其挂载的主机为关机状态。"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: StartVMInstance

开启虚拟机
"""


class StartVMInstanceRequestSchema(schema.RequestSchema):
    """StartVMInstance - 开启虚拟机"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class StartVMInstanceResponseSchema(schema.ResponseSchema):
    """StartVMInstance - 开启虚拟机"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: StopVMInstance

关闭虚拟机
"""


class StopVMInstanceRequestSchema(schema.RequestSchema):
    """StopVMInstance - 关闭虚拟机"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "VMID": fields.Str(required=True, dump_to="VMID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class StopVMInstanceResponseSchema(schema.ResponseSchema):
    """StopVMInstance - 关闭虚拟机"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
        "VMID": fields.Str(required=False, load_from="VMID"),
    }


"""
API: TerminateResource

销毁资源
"""


class TerminateResourceRequestSchema(schema.RequestSchema):
    """TerminateResource - 销毁资源"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class TerminateResourceResponseSchema(schema.ResponseSchema):
    """TerminateResource - 销毁资源"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: UnBindEIP

解绑外网IP
"""


class UnBindEIPRequestSchema(schema.RequestSchema):
    """UnBindEIP - 解绑外网IP"""

    fields = {
        "EIPID": fields.Str(required=True, dump_to="EIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UnBindEIPResponseSchema(schema.ResponseSchema):
    """UnBindEIP - 解绑外网IP"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UnBindSecurityGroup

解绑安全组
"""


class UnBindSecurityGroupRequestSchema(schema.RequestSchema):
    """UnBindSecurityGroup - 解绑安全组"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UnBindSecurityGroupResponseSchema(schema.ResponseSchema):
    """UnBindSecurityGroup - 解绑安全组"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UnbindAlarmTemplate

解绑告警模板
"""


class UnbindAlarmTemplateRequestSchema(schema.RequestSchema):
    """UnbindAlarmTemplate - 解绑告警模板"""

    fields = {
        "AlarmTemplateID": fields.Str(required=True, dump_to="AlarmTemplateID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceIDs": fields.List(fields.Str()),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UnbindAlarmTemplateResponseSchema(schema.ResponseSchema):
    """UnbindAlarmTemplate - 解绑告警模板"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UnbindPhysicalIP

解绑物理IP
"""


class UnbindPhysicalIPRequestSchema(schema.RequestSchema):
    """UnbindPhysicalIP - 解绑物理IP"""

    fields = {
        "PhysicalIPID": fields.Str(required=True, dump_to="PhysicalIPID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceID": fields.Str(required=True, dump_to="ResourceID"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UnbindPhysicalIPResponseSchema(schema.ResponseSchema):
    """UnbindPhysicalIP - 解绑物理IP"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpdateAlarmTemplateRule

更新告警模板规则
"""


class UpdateAlarmTemplateRuleRequestSchema(schema.RequestSchema):
    """UpdateAlarmTemplateRule - 更新告警模板规则"""

    fields = {
        "AlarmStrategy": fields.Str(required=True, dump_to="AlarmStrategy"),
        "AlarmTemplateID": fields.Str(required=True, dump_to="AlarmTemplateID"),
        "AlarmTemplateRuleID": fields.Str(
            required=True, dump_to="AlarmTemplateRuleID"
        ),
        "Compare": fields.Str(required=True, dump_to="Compare"),
        "ContactGroupID": fields.Str(required=True, dump_to="ContactGroupID"),
        "MetricName": fields.Str(required=True, dump_to="MetricName"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "ResourceType": fields.Str(required=True, dump_to="ResourceType"),
        "Threshold": fields.Str(required=True, dump_to="Threshold"),
        "TriggerCount": fields.Str(required=True, dump_to="TriggerCount"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateAlarmTemplateRuleResponseSchema(schema.ResponseSchema):
    """UpdateAlarmTemplateRule - 更新告警模板规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpdateRS

修改负载均衡的服务节点
"""


class UpdateRSRequestSchema(schema.RequestSchema):
    """UpdateRS - 修改负载均衡的服务节点"""

    fields = {
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Port": fields.Int(required=False, dump_to="Port"),
        "RSID": fields.Str(required=True, dump_to="RSID"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Weight": fields.Int(required=False, dump_to="Weight"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateRSResponseSchema(schema.ResponseSchema):
    """UpdateRS - 修改负载均衡的服务节点"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: UpdateSecurityGroupRule

修改安全组规则
"""


class UpdateSecurityGroupRuleRequestSchema(schema.RequestSchema):
    """UpdateSecurityGroupRule - 修改安全组规则"""

    fields = {
        "Region": fields.Str(required=True, dump_to="Region"),
        "Rules": fields.List(fields.Str()),
        "SGID": fields.Str(required=True, dump_to="SGID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateSecurityGroupRuleResponseSchema(schema.ResponseSchema):
    """UpdateSecurityGroupRule - 修改安全组规则"""

    fields = {
        "Message": fields.Str(required=True, load_from="Message"),
    }


"""
API: UpdateVS

修改负载均衡VServer
"""


class UpdateVSRequestSchema(schema.RequestSchema):
    """UpdateVS - 修改负载均衡VServer"""

    fields = {
        "CACertificateID": fields.Str(
            required=False, dump_to="CACertificateID"
        ),
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "HealthcheckType": fields.Str(
            required=False, dump_to="HealthcheckType"
        ),
        "KeepaliveTimeout": fields.Int(
            required=False, dump_to="KeepaliveTimeout"
        ),
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "PersistenceKey": fields.Str(required=False, dump_to="PersistenceKey"),
        "PersistenceType": fields.Str(
            required=False, dump_to="PersistenceType"
        ),
        "Port": fields.Int(required=False, dump_to="Port"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "SSLMode": fields.Str(required=False, dump_to="SSLMode"),
        "Scheduler": fields.Str(required=False, dump_to="Scheduler"),
        "ServerCertificateID": fields.Str(
            required=False, dump_to="ServerCertificateID"
        ),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateVSResponseSchema(schema.ResponseSchema):
    """UpdateVS - 修改负载均衡VServer"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: UpdateVSPolicy

更新七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。
"""


class UpdateVSPolicyRequestSchema(schema.RequestSchema):
    """UpdateVSPolicy - 更新七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "Domain": fields.Str(required=False, dump_to="Domain"),
        "LBID": fields.Str(required=True, dump_to="LBID"),
        "Path": fields.Str(required=False, dump_to="Path"),
        "PolicyID": fields.Str(required=True, dump_to="PolicyID"),
        "RSIDs": fields.List(fields.Str()),
        "Region": fields.Str(required=True, dump_to="Region"),
        "VSID": fields.Str(required=True, dump_to="VSID"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpdateVSPolicyResponseSchema(schema.ResponseSchema):
    """UpdateVSPolicy - 更新七层负载均衡内容转发规则，仅当 VServer 的监听协议为 HTTP 时有效。"""

    fields = {
        "Message": fields.Str(required=False, load_from="Message"),
    }


"""
API: UpgradeDisk

扩容硬盘，为保证数据完整性，容量扩容前建议暂停对当前硬盘的所有文件系统读写操作，并进入操作系统进行 `umount ` 或`脱机` 操作。
"""


class UpgradeDiskRequestSchema(schema.RequestSchema):
    """UpgradeDisk - 扩容硬盘，为保证数据完整性，容量扩容前建议暂停对当前硬盘的所有文件系统读写操作，并进入操作系统进行 `umount ` 或`脱机` 操作。"""

    fields = {
        "DiskID": fields.Str(required=True, dump_to="DiskID"),
        "DiskSpace": fields.Int(required=True, dump_to="DiskSpace"),
        "Region": fields.Str(required=True, dump_to="Region"),
        "Zone": fields.Str(required=True, dump_to="Zone"),
    }


class UpgradeDiskResponseSchema(schema.ResponseSchema):
    """UpgradeDisk - 扩容硬盘，为保证数据完整性，容量扩容前建议暂停对当前硬盘的所有文件系统读写操作，并进入操作系统进行 `umount ` 或`脱机` 操作。"""

    fields = {
        "Action": fields.Str(required=True, load_from="Action"),
        "Message": fields.Str(required=True, load_from="Message"),
        "RetCode": fields.Int(required=True, load_from="RetCode"),
    }
