# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetStreamSourcesResult',
    'AwaitableGetStreamSourcesResult',
    'get_stream_sources',
    'get_stream_sources_output',
]

@pulumi.output_type
class GetStreamSourcesResult:
    """
    A collection of values returned by getStreamSources.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, state=None, stream_source_collections=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if stream_source_collections and not isinstance(stream_source_collections, list):
            raise TypeError("Expected argument 'stream_source_collections' to be a list")
        pulumi.set(__self__, "stream_source_collections", stream_source_collections)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[_builtins.str]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartm.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[_builtins.str]:
        """
        display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetStreamSourcesFilterResult']]:
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the streamSource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the streamSource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="streamSourceCollections")
    def stream_source_collections(self) -> Sequence['outputs.GetStreamSourcesStreamSourceCollectionResult']:
        """
        The list of stream_source_collection.
        """
        return pulumi.get(self, "stream_source_collections")


class AwaitableGetStreamSourcesResult(GetStreamSourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetStreamSourcesResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state,
            stream_source_collections=self.stream_source_collections)


def get_stream_sources(compartment_id: Optional[_builtins.str] = None,
                       display_name: Optional[_builtins.str] = None,
                       filters: Optional[Sequence[Union['GetStreamSourcesFilterArgs', 'GetStreamSourcesFilterArgsDict']]] = None,
                       id: Optional[_builtins.str] = None,
                       state: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetStreamSourcesResult:
    """
    This data source provides the list of Stream Sources in Oracle Cloud Infrastructure Ai Vision service.

    Gets a list of the streamSources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_sources = oci.AiVision.get_stream_sources(compartment_id=compartment_id,
        display_name=stream_source_display_name,
        id=stream_source_id,
        state=stream_source_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: The filter to find the device with the given identifier.
    :param _builtins.str state: The filter to match projects with the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:AiVision/getStreamSources:getStreamSources', __args__, opts=opts, typ=GetStreamSourcesResult).value

    return AwaitableGetStreamSourcesResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        stream_source_collections=pulumi.get(__ret__, 'stream_source_collections'))
def get_stream_sources_output(compartment_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              display_name: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              filters: Optional[pulumi.Input[Optional[Sequence[Union['GetStreamSourcesFilterArgs', 'GetStreamSourcesFilterArgsDict']]]]] = None,
                              id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              state: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetStreamSourcesResult]:
    """
    This data source provides the list of Stream Sources in Oracle Cloud Infrastructure Ai Vision service.

    Gets a list of the streamSources in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_stream_sources = oci.AiVision.get_stream_sources(compartment_id=compartment_id,
        display_name=stream_source_display_name,
        id=stream_source_id,
        state=stream_source_state)
    ```


    :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
    :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
    :param _builtins.str id: The filter to find the device with the given identifier.
    :param _builtins.str state: The filter to match projects with the given lifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['id'] = id
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:AiVision/getStreamSources:getStreamSources', __args__, opts=opts, typ=GetStreamSourcesResult)
    return __ret__.apply(lambda __response__: GetStreamSourcesResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        stream_source_collections=pulumi.get(__response__, 'stream_source_collections')))
