# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetBdsInstanceNodeBackupResult',
    'AwaitableGetBdsInstanceNodeBackupResult',
    'get_bds_instance_node_backup',
    'get_bds_instance_node_backup_output',
]

@pulumi.output_type
class GetBdsInstanceNodeBackupResult:
    """
    A collection of values returned by getBdsInstanceNodeBackup.
    """
    def __init__(__self__, backup_trigger_type=None, backup_type=None, bds_instance_id=None, display_name=None, id=None, node_backup_config_id=None, node_backup_id=None, node_host_name=None, node_instance_id=None, state=None, time_created=None):
        if backup_trigger_type and not isinstance(backup_trigger_type, str):
            raise TypeError("Expected argument 'backup_trigger_type' to be a str")
        pulumi.set(__self__, "backup_trigger_type", backup_trigger_type)
        if backup_type and not isinstance(backup_type, str):
            raise TypeError("Expected argument 'backup_type' to be a str")
        pulumi.set(__self__, "backup_type", backup_type)
        if bds_instance_id and not isinstance(bds_instance_id, str):
            raise TypeError("Expected argument 'bds_instance_id' to be a str")
        pulumi.set(__self__, "bds_instance_id", bds_instance_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node_backup_config_id and not isinstance(node_backup_config_id, str):
            raise TypeError("Expected argument 'node_backup_config_id' to be a str")
        pulumi.set(__self__, "node_backup_config_id", node_backup_config_id)
        if node_backup_id and not isinstance(node_backup_id, str):
            raise TypeError("Expected argument 'node_backup_id' to be a str")
        pulumi.set(__self__, "node_backup_id", node_backup_id)
        if node_host_name and not isinstance(node_host_name, str):
            raise TypeError("Expected argument 'node_host_name' to be a str")
        pulumi.set(__self__, "node_host_name", node_host_name)
        if node_instance_id and not isinstance(node_instance_id, str):
            raise TypeError("Expected argument 'node_instance_id' to be a str")
        pulumi.set(__self__, "node_instance_id", node_instance_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @_builtins.property
    @pulumi.getter(name="backupTriggerType")
    def backup_trigger_type(self) -> _builtins.str:
        """
        type based on how backup action was initiated.
        """
        return pulumi.get(self, "backup_trigger_type")

    @_builtins.property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> _builtins.str:
        """
        Incremental backup type includes only the changes since the last backup. Full backup type includes all changes since the volume was created.
        """
        return pulumi.get(self, "backup_type")

    @_builtins.property
    @pulumi.getter(name="bdsInstanceId")
    def bds_instance_id(self) -> _builtins.str:
        return pulumi.get(self, "bds_instance_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        BDS generated name for the backup. Format is nodeHostName_timeCreated.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="nodeBackupConfigId")
    def node_backup_config_id(self) -> _builtins.str:
        """
        The ID of the nodeBackupConfiguration if the NodeBackup is automatically created by applying the configuration.
        """
        return pulumi.get(self, "node_backup_config_id")

    @_builtins.property
    @pulumi.getter(name="nodeBackupId")
    def node_backup_id(self) -> _builtins.str:
        return pulumi.get(self, "node_backup_id")

    @_builtins.property
    @pulumi.getter(name="nodeHostName")
    def node_host_name(self) -> _builtins.str:
        """
        Host name of the node to which this backup belongs.
        """
        return pulumi.get(self, "node_host_name")

    @_builtins.property
    @pulumi.getter(name="nodeInstanceId")
    def node_instance_id(self) -> _builtins.str:
        """
        The instance OCID of the node, which is the resource from which the node backup was acquired.
        """
        return pulumi.get(self, "node_instance_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of the NodeBackup.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the cluster was created, shown as an RFC 3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")


class AwaitableGetBdsInstanceNodeBackupResult(GetBdsInstanceNodeBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBdsInstanceNodeBackupResult(
            backup_trigger_type=self.backup_trigger_type,
            backup_type=self.backup_type,
            bds_instance_id=self.bds_instance_id,
            display_name=self.display_name,
            id=self.id,
            node_backup_config_id=self.node_backup_config_id,
            node_backup_id=self.node_backup_id,
            node_host_name=self.node_host_name,
            node_instance_id=self.node_instance_id,
            state=self.state,
            time_created=self.time_created)


def get_bds_instance_node_backup(bds_instance_id: Optional[_builtins.str] = None,
                                 node_backup_id: Optional[_builtins.str] = None,
                                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBdsInstanceNodeBackupResult:
    """
    This data source provides details about a specific Bds Instance Node Backup resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of NodeBackup identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_backup = oci.BigDataService.get_bds_instance_node_backup(bds_instance_id=test_bds_instance["id"],
        node_backup_id=test_backup["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str node_backup_id: Unique assigned identifier of the nodeBackupId.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['nodeBackupId'] = node_backup_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:BigDataService/getBdsInstanceNodeBackup:getBdsInstanceNodeBackup', __args__, opts=opts, typ=GetBdsInstanceNodeBackupResult).value

    return AwaitableGetBdsInstanceNodeBackupResult(
        backup_trigger_type=pulumi.get(__ret__, 'backup_trigger_type'),
        backup_type=pulumi.get(__ret__, 'backup_type'),
        bds_instance_id=pulumi.get(__ret__, 'bds_instance_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        node_backup_config_id=pulumi.get(__ret__, 'node_backup_config_id'),
        node_backup_id=pulumi.get(__ret__, 'node_backup_id'),
        node_host_name=pulumi.get(__ret__, 'node_host_name'),
        node_instance_id=pulumi.get(__ret__, 'node_instance_id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_bds_instance_node_backup_output(bds_instance_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        node_backup_id: Optional[pulumi.Input[_builtins.str]] = None,
                                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetBdsInstanceNodeBackupResult]:
    """
    This data source provides details about a specific Bds Instance Node Backup resource in Oracle Cloud Infrastructure Big Data Service service.

    Returns details of NodeBackup identified by the given ID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_bds_instance_node_backup = oci.BigDataService.get_bds_instance_node_backup(bds_instance_id=test_bds_instance["id"],
        node_backup_id=test_backup["id"])
    ```


    :param _builtins.str bds_instance_id: The OCID of the cluster.
    :param _builtins.str node_backup_id: Unique assigned identifier of the nodeBackupId.
    """
    __args__ = dict()
    __args__['bdsInstanceId'] = bds_instance_id
    __args__['nodeBackupId'] = node_backup_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:BigDataService/getBdsInstanceNodeBackup:getBdsInstanceNodeBackup', __args__, opts=opts, typ=GetBdsInstanceNodeBackupResult)
    return __ret__.apply(lambda __response__: GetBdsInstanceNodeBackupResult(
        backup_trigger_type=pulumi.get(__response__, 'backup_trigger_type'),
        backup_type=pulumi.get(__response__, 'backup_type'),
        bds_instance_id=pulumi.get(__response__, 'bds_instance_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        node_backup_config_id=pulumi.get(__response__, 'node_backup_config_id'),
        node_backup_id=pulumi.get(__response__, 'node_backup_id'),
        node_host_name=pulumi.get(__response__, 'node_host_name'),
        node_instance_id=pulumi.get(__response__, 'node_instance_id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
