# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAlertRuleResult',
    'AwaitableGetAlertRuleResult',
    'get_alert_rule',
    'get_alert_rule_output',
]

@pulumi.output_type
class GetAlertRuleResult:
    """
    A collection of values returned by getAlertRule.
    """
    def __init__(__self__, alert_rule_id=None, budget_id=None, defined_tags=None, description=None, display_name=None, freeform_tags=None, id=None, message=None, recipients=None, state=None, threshold=None, threshold_type=None, time_created=None, time_updated=None, type=None, version=None):
        if alert_rule_id and not isinstance(alert_rule_id, str):
            raise TypeError("Expected argument 'alert_rule_id' to be a str")
        pulumi.set(__self__, "alert_rule_id", alert_rule_id)
        if budget_id and not isinstance(budget_id, str):
            raise TypeError("Expected argument 'budget_id' to be a str")
        pulumi.set(__self__, "budget_id", budget_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if message and not isinstance(message, str):
            raise TypeError("Expected argument 'message' to be a str")
        pulumi.set(__self__, "message", message)
        if recipients and not isinstance(recipients, str):
            raise TypeError("Expected argument 'recipients' to be a str")
        pulumi.set(__self__, "recipients", recipients)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if threshold and not isinstance(threshold, float):
            raise TypeError("Expected argument 'threshold' to be a float")
        pulumi.set(__self__, "threshold", threshold)
        if threshold_type and not isinstance(threshold_type, str):
            raise TypeError("Expected argument 'threshold_type' to be a str")
        pulumi.set(__self__, "threshold_type", threshold_type)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)
        if version and not isinstance(version, int):
            raise TypeError("Expected argument 'version' to be a int")
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="alertRuleId")
    def alert_rule_id(self) -> _builtins.str:
        return pulumi.get(self, "alert_rule_id")

    @_builtins.property
    @pulumi.getter(name="budgetId")
    def budget_id(self) -> _builtins.str:
        """
        The OCID of the budget.
        """
        return pulumi.get(self, "budget_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        The description of the alert rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The name of the alert rule. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the alert rule.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def message(self) -> _builtins.str:
        """
        The custom message that will be sent when the alert is triggered.
        """
        return pulumi.get(self, "message")

    @_builtins.property
    @pulumi.getter
    def recipients(self) -> _builtins.str:
        """
        The delimited list of email addresses to receive the alert when it triggers. Delimiter characters can be a comma, space, TAB, or semicolon.
        """
        return pulumi.get(self, "recipients")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the alert rule.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.float:
        """
        The threshold for triggering the alert. If the thresholdType is PERCENTAGE, the maximum value is 10000.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> _builtins.str:
        """
        The type of threshold.
        """
        return pulumi.get(self, "threshold_type")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time when the budget was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time when the budget was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the alert. Valid values are ACTUAL (the alert triggers based on actual usage), or FORECAST (the alert triggers based on predicted usage).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.int:
        """
        The version of the alert rule. Starts from 1 and increments by 1.
        """
        return pulumi.get(self, "version")


class AwaitableGetAlertRuleResult(GetAlertRuleResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAlertRuleResult(
            alert_rule_id=self.alert_rule_id,
            budget_id=self.budget_id,
            defined_tags=self.defined_tags,
            description=self.description,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            message=self.message,
            recipients=self.recipients,
            state=self.state,
            threshold=self.threshold,
            threshold_type=self.threshold_type,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type,
            version=self.version)


def get_alert_rule(alert_rule_id: Optional[_builtins.str] = None,
                   budget_id: Optional[_builtins.str] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAlertRuleResult:
    """
    This data source provides details about a specific Alert Rule resource in Oracle Cloud Infrastructure Budget service.

    Gets an Alert Rule for a specified budget.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_rule = oci.Budget.get_alert_rule(alert_rule_id=test_alert_rule_oci_budget_alert_rule["id"],
        budget_id=test_budget["id"])
    ```


    :param _builtins.str alert_rule_id: The unique Alert Rule OCID.
    :param _builtins.str budget_id: The unique budget OCID.
    """
    __args__ = dict()
    __args__['alertRuleId'] = alert_rule_id
    __args__['budgetId'] = budget_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Budget/getAlertRule:getAlertRule', __args__, opts=opts, typ=GetAlertRuleResult).value

    return AwaitableGetAlertRuleResult(
        alert_rule_id=pulumi.get(__ret__, 'alert_rule_id'),
        budget_id=pulumi.get(__ret__, 'budget_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        message=pulumi.get(__ret__, 'message'),
        recipients=pulumi.get(__ret__, 'recipients'),
        state=pulumi.get(__ret__, 'state'),
        threshold=pulumi.get(__ret__, 'threshold'),
        threshold_type=pulumi.get(__ret__, 'threshold_type'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'),
        version=pulumi.get(__ret__, 'version'))
def get_alert_rule_output(alert_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                          budget_id: Optional[pulumi.Input[_builtins.str]] = None,
                          opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAlertRuleResult]:
    """
    This data source provides details about a specific Alert Rule resource in Oracle Cloud Infrastructure Budget service.

    Gets an Alert Rule for a specified budget.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_alert_rule = oci.Budget.get_alert_rule(alert_rule_id=test_alert_rule_oci_budget_alert_rule["id"],
        budget_id=test_budget["id"])
    ```


    :param _builtins.str alert_rule_id: The unique Alert Rule OCID.
    :param _builtins.str budget_id: The unique budget OCID.
    """
    __args__ = dict()
    __args__['alertRuleId'] = alert_rule_id
    __args__['budgetId'] = budget_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Budget/getAlertRule:getAlertRule', __args__, opts=opts, typ=GetAlertRuleResult)
    return __ret__.apply(lambda __response__: GetAlertRuleResult(
        alert_rule_id=pulumi.get(__response__, 'alert_rule_id'),
        budget_id=pulumi.get(__response__, 'budget_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        message=pulumi.get(__response__, 'message'),
        recipients=pulumi.get(__response__, 'recipients'),
        state=pulumi.get(__response__, 'state'),
        threshold=pulumi.get(__response__, 'threshold'),
        threshold_type=pulumi.get(__response__, 'threshold_type'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type'),
        version=pulumi.get(__response__, 'version')))
