# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDelegatedResourceAccessRequestApprovalInfoResult',
    'GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionResult',
    'GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult',
    'GetDelegatedResourceAccessRequestHistoriesFilterResult',
    'GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionResult',
    'GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult',
    'GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult',
    'GetDelegatedResourceAccessRequestsFilterResult',
    'GetDelegationControlResourcesDelegationControlResourceCollectionResult',
    'GetDelegationControlResourcesDelegationControlResourceCollectionItemResult',
    'GetDelegationControlResourcesFilterResult',
    'GetDelegationControlsDelegationControlSummaryCollectionResult',
    'GetDelegationControlsDelegationControlSummaryCollectionItemResult',
    'GetDelegationControlsFilterResult',
    'GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionResult',
    'GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult',
    'GetDelegationSubscriptionsFilterResult',
    'GetServiceProviderActionPropertyResult',
    'GetServiceProviderActionsFilterResult',
    'GetServiceProviderActionsServiceProviderActionSummaryCollectionResult',
    'GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult',
    'GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult',
    'GetServiceProvidersFilterResult',
    'GetServiceProvidersServiceProviderSummaryCollectionResult',
    'GetServiceProvidersServiceProviderSummaryCollectionItemResult',
]

@pulumi.output_type
class GetDelegatedResourceAccessRequestApprovalInfoResult(dict):
    def __init__(__self__, *,
                 approval_action: _builtins.str,
                 approval_type: _builtins.str,
                 approver_additional_message: _builtins.str,
                 approver_comment: _builtins.str,
                 approver_id: _builtins.str,
                 time_approved_for_access: _builtins.str):
        """
        :param _builtins.str approval_action: Indicated whether the request is approved or rejected.
        :param _builtins.str approval_type: approval type, initial or extension
        :param _builtins.str approver_additional_message: Additional message specified by the approver of the request.
        :param _builtins.str approver_comment: Comment specified by the approver of the request.
        :param _builtins.str approver_id: User ID of the approver.
        :param _builtins.str time_approved_for_access: Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_type", approval_type)
        pulumi.set(__self__, "approver_additional_message", approver_additional_message)
        pulumi.set(__self__, "approver_comment", approver_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)

    @_builtins.property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> _builtins.str:
        """
        Indicated whether the request is approved or rejected.
        """
        return pulumi.get(self, "approval_action")

    @_builtins.property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> _builtins.str:
        """
        approval type, initial or extension
        """
        return pulumi.get(self, "approval_type")

    @_builtins.property
    @pulumi.getter(name="approverAdditionalMessage")
    def approver_additional_message(self) -> _builtins.str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approver_additional_message")

    @_builtins.property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> _builtins.str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @_builtins.property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> _builtins.str:
        """
        User ID of the approver.
        """
        return pulumi.get(self, "approver_id")

    @_builtins.property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> _builtins.str:
        """
        Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_approved_for_access")


@pulumi.output_type
class GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult']):
        """
        :param Sequence['GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemArgs'] items: List of DelegatedResourceAccessRequestHistorySummary objects.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult']:
        """
        List of DelegatedResourceAccessRequestHistorySummary objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegatedResourceAccessRequestHistoriesDelegatedResourceAccessRequestHistoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 comment: _builtins.str,
                 request_status: _builtins.str,
                 state: _builtins.str,
                 timestamp: _builtins.str,
                 user_id: _builtins.str):
        """
        :param _builtins.str comment: Comment about the status change.
        :param _builtins.str request_status: The current status of the Delegated Resource Access Request.
        :param _builtins.str state: The current lifecycle state of the Delegated Resource Access Request.
        :param _builtins.str timestamp: Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        :param _builtins.str user_id: ID of user who modified the Delegated Resource Access Request. For operator, this field is "Operator".
        """
        pulumi.set(__self__, "comment", comment)
        pulumi.set(__self__, "request_status", request_status)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "timestamp", timestamp)
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter
    def comment(self) -> _builtins.str:
        """
        Comment about the status change.
        """
        return pulumi.get(self, "comment")

    @_builtins.property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> _builtins.str:
        """
        The current status of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "request_status")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current lifecycle state of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter
    def timestamp(self) -> _builtins.str:
        """
        Time when the respective action happened in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "timestamp")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        ID of user who modified the Delegated Resource Access Request. For operator, this field is "Operator".
        """
        return pulumi.get(self, "user_id")


@pulumi.output_type
class GetDelegatedResourceAccessRequestHistoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 approval_infos: Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult'],
                 audit_types: Sequence[_builtins.str],
                 closure_comment: _builtins.str,
                 compartment_id: _builtins.str,
                 database_name_lists: Sequence[_builtins.str],
                 defined_tags: Mapping[str, _builtins.str],
                 delegation_control_id: _builtins.str,
                 delegation_subscription_ids: Sequence[_builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 duration_in_hours: _builtins.int,
                 extend_duration_in_hours: _builtins.int,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_auto_approved: _builtins.bool,
                 is_pending_more_info: _builtins.bool,
                 lifecycle_state_details: _builtins.str,
                 num_extension_approvals: _builtins.int,
                 num_initial_approvals: _builtins.int,
                 provided_service_types: Sequence[_builtins.str],
                 reason_for_request: _builtins.str,
                 request_status: _builtins.str,
                 requested_action_names: Sequence[_builtins.str],
                 requester_type: _builtins.str,
                 resource_id: _builtins.str,
                 resource_name: _builtins.str,
                 resource_type: _builtins.str,
                 severity: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 ticket_numbers: Sequence[_builtins.str],
                 time_access_requested: _builtins.str,
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param Sequence['GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoArgs'] approval_infos: In case of single approval, this will have only one item. Else, a list of approvals.
        :param Sequence[_builtins.str] audit_types: Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.
        :param _builtins.str closure_comment: The comment entered by the support operator while closing the request.
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Sequence[_builtins.str] database_name_lists: List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str delegation_control_id: unique Delegation Control identifier
        :param Sequence[_builtins.str] delegation_subscription_ids: List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.
        :param _builtins.str description: Detailed description of this Delegated Resource Access Request.
        :param _builtins.str display_name: Display name. This is generated by the system automatically.
        :param _builtins.int duration_in_hours: Duration in hours for which access is sought on the target resource.
        :param _builtins.int extend_duration_in_hours: Duration in hours for which extension access is sought on the target resource.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the Delegated Resource Access Request.
        :param _builtins.bool is_auto_approved: Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
        :param _builtins.bool is_pending_more_info: Indicates if the delegated resource access request is waiting on more information from the operator
        :param _builtins.str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param _builtins.int num_extension_approvals: Number of extension approvals that have been obtained so far.
        :param _builtins.int num_initial_approvals: Number of initial approvals that have been obtained so far.
        :param Sequence[_builtins.str] provided_service_types: List of Service Provider Service Types being provided by the support operator user.
        :param _builtins.str reason_for_request: A short description explaining why this Delegated Resource Access Request is needed by the support operator.
        :param _builtins.str request_status: A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.
        :param Sequence[_builtins.str] requested_action_names: List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
        :param _builtins.str requester_type: Requester type
        :param _builtins.str resource_id: A filter to return only Delegated Resource Access Requests for the given resource identifier.
        :param _builtins.str resource_name: The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        :param _builtins.str resource_type: Resource type for which the associated Delegation Control is applicable to.
        :param _builtins.str severity: Priority assigned to the Delegated Resource Access Request by the support operator
        :param _builtins.str state: A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence[_builtins.str] ticket_numbers: A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        :param _builtins.str time_access_requested: Requested access start time in UTC.
        :param _builtins.str time_created: Time when the Delegated Resource Access Request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        :param _builtins.str time_updated: Time when the Delegated Resource Access Request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "approval_infos", approval_infos)
        pulumi.set(__self__, "audit_types", audit_types)
        pulumi.set(__self__, "closure_comment", closure_comment)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "database_name_lists", database_name_lists)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "delegation_control_id", delegation_control_id)
        pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "duration_in_hours", duration_in_hours)
        pulumi.set(__self__, "extend_duration_in_hours", extend_duration_in_hours)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_approved", is_auto_approved)
        pulumi.set(__self__, "is_pending_more_info", is_pending_more_info)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "num_extension_approvals", num_extension_approvals)
        pulumi.set(__self__, "num_initial_approvals", num_initial_approvals)
        pulumi.set(__self__, "provided_service_types", provided_service_types)
        pulumi.set(__self__, "reason_for_request", reason_for_request)
        pulumi.set(__self__, "request_status", request_status)
        pulumi.set(__self__, "requested_action_names", requested_action_names)
        pulumi.set(__self__, "requester_type", requester_type)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "ticket_numbers", ticket_numbers)
        pulumi.set(__self__, "time_access_requested", time_access_requested)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="approvalInfos")
    def approval_infos(self) -> Sequence['outputs.GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult']:
        """
        In case of single approval, this will have only one item. Else, a list of approvals.
        """
        return pulumi.get(self, "approval_infos")

    @_builtins.property
    @pulumi.getter(name="auditTypes")
    def audit_types(self) -> Sequence[_builtins.str]:
        """
        Specifies the type of auditing to be enabled. There are two levels of auditing: command-level and keystroke-level.  By default, both command-level and keystroke-level auditing are enabled, i.e. commands and key strokes issued by the support operator are logged.
        """
        return pulumi.get(self, "audit_types")

    @_builtins.property
    @pulumi.getter(name="closureComment")
    def closure_comment(self) -> _builtins.str:
        """
        The comment entered by the support operator while closing the request.
        """
        return pulumi.get(self, "closure_comment")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="databaseNameLists")
    def database_name_lists(self) -> Sequence[_builtins.str]:
        """
        List of Database unique names for which access is requested. This parameter is required for DLGT_MGMT_SYS_MAINT_ACCESS cage when database access in needed.
        """
        return pulumi.get(self, "database_name_lists")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="delegationControlId")
    def delegation_control_id(self) -> _builtins.str:
        """
        unique Delegation Control identifier
        """
        return pulumi.get(self, "delegation_control_id")

    @_builtins.property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> Sequence[_builtins.str]:
        """
        List of Delegation Subscription OCID that are associated with this Delegated Resource Access Request based on the service types being requested.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Detailed description of this Delegated Resource Access Request.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Display name. This is generated by the system automatically.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="durationInHours")
    def duration_in_hours(self) -> _builtins.int:
        """
        Duration in hours for which access is sought on the target resource.
        """
        return pulumi.get(self, "duration_in_hours")

    @_builtins.property
    @pulumi.getter(name="extendDurationInHours")
    def extend_duration_in_hours(self) -> _builtins.int:
        """
        Duration in hours for which extension access is sought on the target resource.
        """
        return pulumi.get(self, "extend_duration_in_hours")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the Delegated Resource Access Request.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoApproved")
    def is_auto_approved(self) -> _builtins.bool:
        """
        Set to true if the request is approved automatically based on preApprovedServiceProviderActionNames or isAutoApproveDuringMaintenance in the associated Delegation Control.
        """
        return pulumi.get(self, "is_auto_approved")

    @_builtins.property
    @pulumi.getter(name="isPendingMoreInfo")
    def is_pending_more_info(self) -> _builtins.bool:
        """
        Indicates if the delegated resource access request is waiting on more information from the operator
        """
        return pulumi.get(self, "is_pending_more_info")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter(name="numExtensionApprovals")
    def num_extension_approvals(self) -> _builtins.int:
        """
        Number of extension approvals that have been obtained so far.
        """
        return pulumi.get(self, "num_extension_approvals")

    @_builtins.property
    @pulumi.getter(name="numInitialApprovals")
    def num_initial_approvals(self) -> _builtins.int:
        """
        Number of initial approvals that have been obtained so far.
        """
        return pulumi.get(self, "num_initial_approvals")

    @_builtins.property
    @pulumi.getter(name="providedServiceTypes")
    def provided_service_types(self) -> Sequence[_builtins.str]:
        """
        List of Service Provider Service Types being provided by the support operator user.
        """
        return pulumi.get(self, "provided_service_types")

    @_builtins.property
    @pulumi.getter(name="reasonForRequest")
    def reason_for_request(self) -> _builtins.str:
        """
        A short description explaining why this Delegated Resource Access Request is needed by the support operator.
        """
        return pulumi.get(self, "reason_for_request")

    @_builtins.property
    @pulumi.getter(name="requestStatus")
    def request_status(self) -> _builtins.str:
        """
        A filter to return only Delegated Resource Access Requests whose status matches the given Delegated Resource Access Request status.
        """
        return pulumi.get(self, "request_status")

    @_builtins.property
    @pulumi.getter(name="requestedActionNames")
    def requested_action_names(self) -> Sequence[_builtins.str]:
        """
        List of Service Provider Action names for which approval is sought by the support operator user. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API.
        """
        return pulumi.get(self, "requested_action_names")

    @_builtins.property
    @pulumi.getter(name="requesterType")
    def requester_type(self) -> _builtins.str:
        """
        Requester type
        """
        return pulumi.get(self, "requester_type")

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        A filter to return only Delegated Resource Access Requests for the given resource identifier.
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> _builtins.str:
        """
        The name of the target resource associated with the Delegated Resource Access Request. The support operator raises a Delegated Resource Access Request to get approval to  access the target resource.
        """
        return pulumi.get(self, "resource_name")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        Resource type for which the associated Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def severity(self) -> _builtins.str:
        """
        Priority assigned to the Delegated Resource Access Request by the support operator
        """
        return pulumi.get(self, "severity")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Delegated Resource Access Requests whose lifecycleState matches the given Delegated Resource Access Request lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="ticketNumbers")
    def ticket_numbers(self) -> Sequence[_builtins.str]:
        """
        A list of ticket numbers related to this Delegated Resource Access Request, e.g. Service Request (SR) number and JIRA ticket number.
        """
        return pulumi.get(self, "ticket_numbers")

    @_builtins.property
    @pulumi.getter(name="timeAccessRequested")
    def time_access_requested(self) -> _builtins.str:
        """
        Requested access start time in UTC.
        """
        return pulumi.get(self, "time_access_requested")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the Delegated Resource Access Request was created in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the Delegated Resource Access Request was last modified in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsDelegatedResourceAccessRequestSummaryCollectionItemApprovalInfoResult(dict):
    def __init__(__self__, *,
                 approval_action: _builtins.str,
                 approval_type: _builtins.str,
                 approver_additional_message: _builtins.str,
                 approver_comment: _builtins.str,
                 approver_id: _builtins.str,
                 time_approved_for_access: _builtins.str):
        """
        :param _builtins.str approval_action: Indicated whether the request is approved or rejected.
        :param _builtins.str approval_type: approval type, initial or extension
        :param _builtins.str approver_additional_message: Additional message specified by the approver of the request.
        :param _builtins.str approver_comment: Comment specified by the approver of the request.
        :param _builtins.str approver_id: User ID of the approver.
        :param _builtins.str time_approved_for_access: Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        pulumi.set(__self__, "approval_action", approval_action)
        pulumi.set(__self__, "approval_type", approval_type)
        pulumi.set(__self__, "approver_additional_message", approver_additional_message)
        pulumi.set(__self__, "approver_comment", approver_comment)
        pulumi.set(__self__, "approver_id", approver_id)
        pulumi.set(__self__, "time_approved_for_access", time_approved_for_access)

    @_builtins.property
    @pulumi.getter(name="approvalAction")
    def approval_action(self) -> _builtins.str:
        """
        Indicated whether the request is approved or rejected.
        """
        return pulumi.get(self, "approval_action")

    @_builtins.property
    @pulumi.getter(name="approvalType")
    def approval_type(self) -> _builtins.str:
        """
        approval type, initial or extension
        """
        return pulumi.get(self, "approval_type")

    @_builtins.property
    @pulumi.getter(name="approverAdditionalMessage")
    def approver_additional_message(self) -> _builtins.str:
        """
        Additional message specified by the approver of the request.
        """
        return pulumi.get(self, "approver_additional_message")

    @_builtins.property
    @pulumi.getter(name="approverComment")
    def approver_comment(self) -> _builtins.str:
        """
        Comment specified by the approver of the request.
        """
        return pulumi.get(self, "approver_comment")

    @_builtins.property
    @pulumi.getter(name="approverId")
    def approver_id(self) -> _builtins.str:
        """
        User ID of the approver.
        """
        return pulumi.get(self, "approver_id")

    @_builtins.property
    @pulumi.getter(name="timeApprovedForAccess")
    def time_approved_for_access(self) -> _builtins.str:
        """
        Access start time that is actually approved by the customer in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'.
        """
        return pulumi.get(self, "time_approved_for_access")


@pulumi.output_type
class GetDelegatedResourceAccessRequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegationControlResourcesDelegationControlResourceCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegationControlResourcesDelegationControlResourceCollectionItemResult']):
        """
        :param Sequence['GetDelegationControlResourcesDelegationControlResourceCollectionItemArgs'] items: List of DelegationControlResourceSummary objects.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegationControlResourcesDelegationControlResourceCollectionItemResult']:
        """
        List of DelegationControlResourceSummary objects.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegationControlResourcesDelegationControlResourceCollectionItemResult(dict):
    def __init__(__self__, *,
                 id: _builtins.str,
                 resource_status: _builtins.str):
        """
        :param _builtins.str id: OCID of the resource.
        :param _builtins.str resource_status: The current status of the resource in Delegation Control.
        """
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "resource_status", resource_status)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        OCID of the resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="resourceStatus")
    def resource_status(self) -> _builtins.str:
        """
        The current status of the resource in Delegation Control.
        """
        return pulumi.get(self, "resource_status")


@pulumi.output_type
class GetDelegationControlResourcesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegationControlsDelegationControlSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegationControlsDelegationControlSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegationControlsDelegationControlSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegationControlsDelegationControlSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 delegation_subscription_ids: Sequence[_builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 is_auto_approve_during_maintenance: _builtins.bool,
                 lifecycle_state_details: _builtins.str,
                 notification_message_format: _builtins.str,
                 notification_topic_id: _builtins.str,
                 num_approvals_required: _builtins.int,
                 pre_approved_service_provider_action_names: Sequence[_builtins.str],
                 resource_ids: Sequence[_builtins.str],
                 resource_type: _builtins.str,
                 state: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_deleted: _builtins.str,
                 time_updated: _builtins.str,
                 vault_id: _builtins.str,
                 vault_key_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param Sequence[_builtins.str] delegation_subscription_ids: List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        :param _builtins.str description: Description of the Delegation Control.
        :param _builtins.str display_name: A filter to return Delegation Control resources that match the given display name.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: The OCID of the Delegation Control.
        :param _builtins.bool is_auto_approve_during_maintenance: Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        :param _builtins.str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param _builtins.str notification_message_format: The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        :param _builtins.str notification_topic_id: The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        :param _builtins.int num_approvals_required: number of approvals required.
        :param Sequence[_builtins.str] pre_approved_service_provider_action_names: List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        :param Sequence[_builtins.str] resource_ids: The OCID of the selected resources that this Delegation Control is applicable to.
        :param _builtins.str resource_type: A filter to return only resources that match the given resource type.
        :param _builtins.str state: A filter to return only Delegation Control resources whose lifecycleState matches the given Delegation Control lifecycle state.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param _builtins.str time_deleted: Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        :param _builtins.str time_updated: Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param _builtins.str vault_id: The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        :param _builtins.str vault_key_id: The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "delegation_subscription_ids", delegation_subscription_ids)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "notification_message_format", notification_message_format)
        pulumi.set(__self__, "notification_topic_id", notification_topic_id)
        pulumi.set(__self__, "num_approvals_required", num_approvals_required)
        pulumi.set(__self__, "pre_approved_service_provider_action_names", pre_approved_service_provider_action_names)
        pulumi.set(__self__, "resource_ids", resource_ids)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_deleted", time_deleted)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vault_id", vault_id)
        pulumi.set(__self__, "vault_key_id", vault_key_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="delegationSubscriptionIds")
    def delegation_subscription_ids(self) -> Sequence[_builtins.str]:
        """
        List of Delegation Subscription OCID that are allowed for this Delegation Control. The allowed subscriptions will determine the available Service Provider Actions. Only support operators for the allowed subscriptions are allowed to create Delegated Resource Access Request.
        """
        return pulumi.get(self, "delegation_subscription_ids")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Delegation Control.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return Delegation Control resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the Delegation Control.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> _builtins.bool:
        """
        Set to true to allow all Delegated Resource Access Request to be approved automatically during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter(name="notificationMessageFormat")
    def notification_message_format(self) -> _builtins.str:
        """
        The format of the Oracle Cloud Infrastructure Notification messages for this Delegation Control.
        """
        return pulumi.get(self, "notification_message_format")

    @_builtins.property
    @pulumi.getter(name="notificationTopicId")
    def notification_topic_id(self) -> _builtins.str:
        """
        The OCID of the Oracle Cloud Infrastructure Notification topic to publish messages related to this Delegation Control.
        """
        return pulumi.get(self, "notification_topic_id")

    @_builtins.property
    @pulumi.getter(name="numApprovalsRequired")
    def num_approvals_required(self) -> _builtins.int:
        """
        number of approvals required.
        """
        return pulumi.get(self, "num_approvals_required")

    @_builtins.property
    @pulumi.getter(name="preApprovedServiceProviderActionNames")
    def pre_approved_service_provider_action_names(self) -> Sequence[_builtins.str]:
        """
        List of pre-approved Service Provider Action names. The list of pre-defined Service Provider Actions can be obtained from the ListServiceProviderActions API. Delegated Resource Access Requests associated with a resource governed by this Delegation Control will be automatically approved if the Delegated Resource Access Request only contain Service Provider Actions in the pre-approved list.
        """
        return pulumi.get(self, "pre_approved_service_provider_action_names")

    @_builtins.property
    @pulumi.getter(name="resourceIds")
    def resource_ids(self) -> Sequence[_builtins.str]:
        """
        The OCID of the selected resources that this Delegation Control is applicable to.
        """
        return pulumi.get(self, "resource_ids")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        A filter to return only resources that match the given resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Delegation Control resources whose lifecycleState matches the given Delegation Control lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the Delegation Control was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> _builtins.str:
        """
        Time when the Delegation Control was deleted expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format, e.g. '2020-05-22T21:10:29.600Z'. Note a deleted Delegation Control still stays in the system, so that you can still audit Service Provider Actions associated with Delegated Resource Access Requests raised on target resources governed by the deleted Delegation Control.
        """
        return pulumi.get(self, "time_deleted")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the Delegation Control was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="vaultId")
    def vault_id(self) -> _builtins.str:
        """
        The OCID of the Oracle Cloud Infrastructure Vault that will store the secrets containing the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER. Delegate Access Control Service will generate the SSH keys and store them as secrets in the Oracle Cloud Infrastructure Vault.
        """
        return pulumi.get(self, "vault_id")

    @_builtins.property
    @pulumi.getter(name="vaultKeyId")
    def vault_key_id(self) -> _builtins.str:
        """
        The OCID of the Master Encryption Key in the Oracle Cloud Infrastructure Vault specified by vaultId. This key will be used to encrypt the SSH keys to access the resource governed by this Delegation Control by Delegate Access Control Service. This property is required when resourceType is CLOUDVMCLUSTER.
        """
        return pulumi.get(self, "vault_key_id")


@pulumi.output_type
class GetDelegationControlsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetDelegationSubscriptionsDelegationSubscriptionSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_state_details: _builtins.str,
                 service_provider_id: _builtins.str,
                 state: _builtins.str,
                 subscribed_service_type: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: Description of the Delegation Subscription.
        :param _builtins.str display_name: A filter to return Delegation Subscription resources that match the given display name.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: Unique identifier for the Delegation Subscription.
        :param _builtins.str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param _builtins.str service_provider_id: Unique identifier of the Service Provider.
        :param _builtins.str state: A filter to return only Delegation Subscription resources whose lifecycleState matches the given Delegation Subscription lifecycle state.
        :param _builtins.str subscribed_service_type: Subscribed Service Provider Service Type.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param _builtins.str time_updated: Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "service_provider_id", service_provider_id)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subscribed_service_type", subscribed_service_type)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Delegation Subscription.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return Delegation Subscription resources that match the given display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier for the Delegation Subscription.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter(name="serviceProviderId")
    def service_provider_id(self) -> _builtins.str:
        """
        Unique identifier of the Service Provider.
        """
        return pulumi.get(self, "service_provider_id")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Delegation Subscription resources whose lifecycleState matches the given Delegation Subscription lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subscribedServiceType")
    def subscribed_service_type(self) -> _builtins.str:
        """
        Subscribed Service Provider Service Type.
        """
        return pulumi.get(self, "subscribed_service_type")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


@pulumi.output_type
class GetDelegationSubscriptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceProviderActionPropertyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: Name of the property
        :param _builtins.str value: value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceProviderActionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to return only resources that match the entire name given.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceProviderActionsServiceProviderActionSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetServiceProviderActionsServiceProviderActionSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 component: _builtins.str,
                 customer_display_name: _builtins.str,
                 description: _builtins.str,
                 id: _builtins.str,
                 name: _builtins.str,
                 properties: Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult'],
                 resource_type: _builtins.str,
                 service_provider_service_types: Sequence[_builtins.str],
                 state: _builtins.str):
        """
        :param _builtins.str component: Name of the infrastructure layer associated with the Service Provider Action.
        :param _builtins.str customer_display_name: Display Name of the Service Provider Action.
        :param _builtins.str description: Description of the Service Provider Action in terms of associated risk profile, and characteristics of the operating system commands made available to the support operator under this Service Provider Action.
        :param _builtins.str id: Unique Oracle assigned identifier for the Service Provider Action.
        :param _builtins.str name: A filter to return only resources that match the entire name given.
        :param Sequence['GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyArgs'] properties: Fine grained properties associated with the Delegation Control.
        :param _builtins.str resource_type: A filter to return only resources that match the given resource type.
        :param Sequence[_builtins.str] service_provider_service_types: List of Service Provider Service Types that this Service Provider Action is applicable to.
        :param _builtins.str state: A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "customer_display_name", customer_display_name)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "service_provider_service_types", service_provider_service_types)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter
    def component(self) -> _builtins.str:
        """
        Name of the infrastructure layer associated with the Service Provider Action.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter(name="customerDisplayName")
    def customer_display_name(self) -> _builtins.str:
        """
        Display Name of the Service Provider Action.
        """
        return pulumi.get(self, "customer_display_name")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Service Provider Action in terms of associated risk profile, and characteristics of the operating system commands made available to the support operator under this Service Provider Action.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique Oracle assigned identifier for the Service Provider Action.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult']:
        """
        Fine grained properties associated with the Delegation Control.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> _builtins.str:
        """
        A filter to return only resources that match the given resource type.
        """
        return pulumi.get(self, "resource_type")

    @_builtins.property
    @pulumi.getter(name="serviceProviderServiceTypes")
    def service_provider_service_types(self) -> Sequence[_builtins.str]:
        """
        List of Service Provider Service Types that this Service Provider Action is applicable to.
        """
        return pulumi.get(self, "service_provider_service_types")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources whose lifecycleState matches the given Service Provider Action lifecycleState.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetServiceProviderActionsServiceProviderActionSummaryCollectionItemPropertyResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: A filter to return only resources that match the entire name given.
        :param _builtins.str value: value of the property
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire name given.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        value of the property
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetServiceProvidersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        """
        :param _builtins.str name: A filter to return Service Provider resources that match the given name.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return Service Provider resources that match the given name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetServiceProvidersServiceProviderSummaryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetServiceProvidersServiceProviderSummaryCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetServiceProvidersServiceProviderSummaryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetServiceProvidersServiceProviderSummaryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 description: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 lifecycle_state_details: _builtins.str,
                 name: _builtins.str,
                 service_provider_type: _builtins.str,
                 service_types: Sequence[_builtins.str],
                 state: _builtins.str,
                 supported_resource_types: Sequence[_builtins.str],
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str):
        """
        :param _builtins.str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param _builtins.str description: Description of the Service Provider.
        :param Mapping[str, _builtins.str] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param _builtins.str id: Unique identifier for the Service Provider.
        :param _builtins.str lifecycle_state_details: Description of the current lifecycle state in more detail.
        :param _builtins.str name: A filter to return Service Provider resources that match the given name.
        :param _builtins.str service_provider_type: A filter to return only Service Provider resources whose provider type matches the given provider type.
        :param Sequence[_builtins.str] service_types: Types of services offered by this provider.
        :param _builtins.str state: A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.
        :param Sequence[_builtins.str] supported_resource_types: Resource types for which this provider will provide service. Default to all if not specified.
        :param Mapping[str, _builtins.str] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        :param _builtins.str time_updated: Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "lifecycle_state_details", lifecycle_state_details)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "service_provider_type", service_provider_type)
        pulumi.set(__self__, "service_types", service_types)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "supported_resource_types", supported_resource_types)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Service Provider.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Unique identifier for the Service Provider.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="lifecycleStateDetails")
    def lifecycle_state_details(self) -> _builtins.str:
        """
        Description of the current lifecycle state in more detail.
        """
        return pulumi.get(self, "lifecycle_state_details")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        A filter to return Service Provider resources that match the given name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="serviceProviderType")
    def service_provider_type(self) -> _builtins.str:
        """
        A filter to return only Service Provider resources whose provider type matches the given provider type.
        """
        return pulumi.get(self, "service_provider_type")

    @_builtins.property
    @pulumi.getter(name="serviceTypes")
    def service_types(self) -> Sequence[_builtins.str]:
        """
        Types of services offered by this provider.
        """
        return pulumi.get(self, "service_types")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only Service Provider resources whose lifecycleState matches the given Service Provider lifecycle state.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="supportedResourceTypes")
    def supported_resource_types(self) -> Sequence[_builtins.str]:
        """
        Resource types for which this provider will provide service. Default to all if not specified.
        """
        return pulumi.get(self, "supported_resource_types")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        Time when the Service Provider was created expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        Time when the Service Provider was last modified expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format, e.g. '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_updated")


