# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetViewResult',
    'AwaitableGetViewResult',
    'get_view',
    'get_view_output',
]

@pulumi.output_type
class GetViewResult:
    """
    A collection of values returned by getView.
    """
    def __init__(__self__, compartment_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, is_protected=None, scope=None, self=None, state=None, time_created=None, time_updated=None, view_id=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_protected and not isinstance(is_protected, bool):
            raise TypeError("Expected argument 'is_protected' to be a bool")
        pulumi.set(__self__, "is_protected", is_protected)
        if scope and not isinstance(scope, str):
            raise TypeError("Expected argument 'scope' to be a str")
        pulumi.set(__self__, "scope", scope)
        if self and not isinstance(self, str):
            raise TypeError("Expected argument 'self' to be a str")
        pulumi.set(__self__, "self", self)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if view_id and not isinstance(view_id, str):
            raise TypeError("Expected argument 'view_id' to be a str")
        pulumi.set(__self__, "view_id", view_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The OCID of the owning compartment.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of the view.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The OCID of the view.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isProtected")
    def is_protected(self) -> _builtins.bool:
        """
        A Boolean flag indicating whether or not parts of the resource are unable to be explicitly managed.
        """
        return pulumi.get(self, "is_protected")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "scope")

    @_builtins.property
    @pulumi.getter
    def self(self) -> _builtins.str:
        """
        The canonical absolute URL of the resource.
        """
        return pulumi.get(self, "self")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the resource was created in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The date and time the resource was last updated in "YYYY-MM-ddThh:mm:ssZ" format with a Z offset, as defined by RFC 3339.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="viewId")
    def view_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "view_id")


class AwaitableGetViewResult(GetViewResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetViewResult(
            compartment_id=self.compartment_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_protected=self.is_protected,
            scope=self.scope,
            self=self.self,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated,
            view_id=self.view_id)


def get_view(scope: Optional[_builtins.str] = None,
             view_id: Optional[_builtins.str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetViewResult:
    """
    This data source provides details about a specific View resource in Oracle Cloud Infrastructure DNS service.

    Gets information about a specific view.

    Note that attempting to get a
    view in the DELETED lifecycleState will result in a `404` response to be
    consistent with other operations of the API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_view = oci.Dns.get_view(view_id=test_view_oci_dns_view["id"],
        scope="PRIVATE")
    ```


    :param _builtins.str scope: Value must be `PRIVATE` when listing views for private zones.
    :param _builtins.str view_id: The OCID of the target view.
    """
    __args__ = dict()
    __args__['scope'] = scope
    __args__['viewId'] = view_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Dns/getView:getView', __args__, opts=opts, typ=GetViewResult).value

    return AwaitableGetViewResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_protected=pulumi.get(__ret__, 'is_protected'),
        scope=pulumi.get(__ret__, 'scope'),
        self=pulumi.get(__ret__, 'self'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        view_id=pulumi.get(__ret__, 'view_id'))
def get_view_output(scope: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    view_id: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                    opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetViewResult]:
    """
    This data source provides details about a specific View resource in Oracle Cloud Infrastructure DNS service.

    Gets information about a specific view.

    Note that attempting to get a
    view in the DELETED lifecycleState will result in a `404` response to be
    consistent with other operations of the API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_view = oci.Dns.get_view(view_id=test_view_oci_dns_view["id"],
        scope="PRIVATE")
    ```


    :param _builtins.str scope: Value must be `PRIVATE` when listing views for private zones.
    :param _builtins.str view_id: The OCID of the target view.
    """
    __args__ = dict()
    __args__['scope'] = scope
    __args__['viewId'] = view_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Dns/getView:getView', __args__, opts=opts, typ=GetViewResult)
    return __ret__.apply(lambda __response__: GetViewResult(
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_protected=pulumi.get(__response__, 'is_protected'),
        scope=pulumi.get(__response__, 'scope'),
        self=pulumi.get(__response__, 'self'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        view_id=pulumi.get(__response__, 'view_id')))
