# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AgentAgentEndpointArgs', 'AgentAgentEndpoint']

@pulumi.input_type
class AgentAgentEndpointArgs:
    def __init__(__self__, *,
                 agent_id: pulumi.Input[_builtins.str],
                 compartment_id: pulumi.Input[_builtins.str],
                 content_moderation_config: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guardrail_config: Optional[pulumi.Input['AgentAgentEndpointGuardrailConfigArgs']] = None,
                 human_input_config: Optional[pulumi.Input['AgentAgentEndpointHumanInputConfigArgs']] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 output_config: Optional[pulumi.Input['AgentAgentEndpointOutputConfigArgs']] = None,
                 session_config: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']] = None,
                 should_enable_citation: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_multi_language: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a AgentAgentEndpoint resource.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input['AgentAgentEndpointContentModerationConfigArgs'] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['AgentAgentEndpointGuardrailConfigArgs'] guardrail_config: (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        :param pulumi.Input['AgentAgentEndpointHumanInputConfigArgs'] human_input_config: (Updatable) Human Input Configuration for an AgentEndpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input['AgentAgentEndpointOutputConfigArgs'] output_config: (Updatable) Configuration to store results generated by agent.
        :param pulumi.Input['AgentAgentEndpointSessionConfigArgs'] session_config: (Updatable) Session Configuration on AgentEndpoint.
        :param pulumi.Input[_builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[_builtins.bool] should_enable_multi_language: (Updatable) Whether to enable multi-language for chat.
        :param pulumi.Input[_builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[_builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "agent_id", agent_id)
        pulumi.set(__self__, "compartment_id", compartment_id)
        if content_moderation_config is not None:
            pulumi.set(__self__, "content_moderation_config", content_moderation_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if guardrail_config is not None:
            pulumi.set(__self__, "guardrail_config", guardrail_config)
        if human_input_config is not None:
            pulumi.set(__self__, "human_input_config", human_input_config)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if output_config is not None:
            pulumi.set(__self__, "output_config", output_config)
        if session_config is not None:
            pulumi.set(__self__, "session_config", session_config)
        if should_enable_citation is not None:
            pulumi.set(__self__, "should_enable_citation", should_enable_citation)
        if should_enable_multi_language is not None:
            pulumi.set(__self__, "should_enable_multi_language", should_enable_multi_language)
        if should_enable_session is not None:
            pulumi.set(__self__, "should_enable_session", should_enable_session)
        if should_enable_trace is not None:
            pulumi.set(__self__, "should_enable_trace", should_enable_trace)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Input[_builtins.str]:
        """
        The OCID of the agent that this endpoint is associated with.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="contentModerationConfig")
    def content_moderation_config(self) -> Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]:
        """
        (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        """
        return pulumi.get(self, "content_moderation_config")

    @content_moderation_config.setter
    def content_moderation_config(self, value: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]):
        pulumi.set(self, "content_moderation_config", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="guardrailConfig")
    def guardrail_config(self) -> Optional[pulumi.Input['AgentAgentEndpointGuardrailConfigArgs']]:
        """
        (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        """
        return pulumi.get(self, "guardrail_config")

    @guardrail_config.setter
    def guardrail_config(self, value: Optional[pulumi.Input['AgentAgentEndpointGuardrailConfigArgs']]):
        pulumi.set(self, "guardrail_config", value)

    @_builtins.property
    @pulumi.getter(name="humanInputConfig")
    def human_input_config(self) -> Optional[pulumi.Input['AgentAgentEndpointHumanInputConfigArgs']]:
        """
        (Updatable) Human Input Configuration for an AgentEndpoint.
        """
        return pulumi.get(self, "human_input_config")

    @human_input_config.setter
    def human_input_config(self, value: Optional[pulumi.Input['AgentAgentEndpointHumanInputConfigArgs']]):
        pulumi.set(self, "human_input_config", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Key-value pairs to allow additional configurations.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="outputConfig")
    def output_config(self) -> Optional[pulumi.Input['AgentAgentEndpointOutputConfigArgs']]:
        """
        (Updatable) Configuration to store results generated by agent.
        """
        return pulumi.get(self, "output_config")

    @output_config.setter
    def output_config(self, value: Optional[pulumi.Input['AgentAgentEndpointOutputConfigArgs']]):
        pulumi.set(self, "output_config", value)

    @_builtins.property
    @pulumi.getter(name="sessionConfig")
    def session_config(self) -> Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]:
        """
        (Updatable) Session Configuration on AgentEndpoint.
        """
        return pulumi.get(self, "session_config")

    @session_config.setter
    def session_config(self, value: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]):
        pulumi.set(self, "session_config", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableCitation")
    def should_enable_citation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to show citations in the chat result.
        """
        return pulumi.get(self, "should_enable_citation")

    @should_enable_citation.setter
    def should_enable_citation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_citation", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableMultiLanguage")
    def should_enable_multi_language(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to enable multi-language for chat.
        """
        return pulumi.get(self, "should_enable_multi_language")

    @should_enable_multi_language.setter
    def should_enable_multi_language(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_multi_language", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableSession")
    def should_enable_session(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to enable Session-based chat.
        """
        return pulumi.get(self, "should_enable_session")

    @should_enable_session.setter
    def should_enable_session(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_session", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableTrace")
    def should_enable_trace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to show traces in the chat result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_enable_trace")

    @should_enable_trace.setter
    def should_enable_trace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_trace", value)


@pulumi.input_type
class _AgentAgentEndpointState:
    def __init__(__self__, *,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_moderation_config: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guardrail_config: Optional[pulumi.Input['AgentAgentEndpointGuardrailConfigArgs']] = None,
                 human_input_config: Optional[pulumi.Input['AgentAgentEndpointHumanInputConfigArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 output_config: Optional[pulumi.Input['AgentAgentEndpointOutputConfigArgs']] = None,
                 session_config: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']] = None,
                 should_enable_citation: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_multi_language: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[_builtins.bool]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering AgentAgentEndpoint resources.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input['AgentAgentEndpointContentModerationConfigArgs'] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input['AgentAgentEndpointGuardrailConfigArgs'] guardrail_config: (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        :param pulumi.Input['AgentAgentEndpointHumanInputConfigArgs'] human_input_config: (Updatable) Human Input Configuration for an AgentEndpoint.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input['AgentAgentEndpointOutputConfigArgs'] output_config: (Updatable) Configuration to store results generated by agent.
        :param pulumi.Input['AgentAgentEndpointSessionConfigArgs'] session_config: (Updatable) Session Configuration on AgentEndpoint.
        :param pulumi.Input[_builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[_builtins.bool] should_enable_multi_language: (Updatable) Whether to enable multi-language for chat.
        :param pulumi.Input[_builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[_builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        if agent_id is not None:
            pulumi.set(__self__, "agent_id", agent_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if content_moderation_config is not None:
            pulumi.set(__self__, "content_moderation_config", content_moderation_config)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if guardrail_config is not None:
            pulumi.set(__self__, "guardrail_config", guardrail_config)
        if human_input_config is not None:
            pulumi.set(__self__, "human_input_config", human_input_config)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if output_config is not None:
            pulumi.set(__self__, "output_config", output_config)
        if session_config is not None:
            pulumi.set(__self__, "session_config", session_config)
        if should_enable_citation is not None:
            pulumi.set(__self__, "should_enable_citation", should_enable_citation)
        if should_enable_multi_language is not None:
            pulumi.set(__self__, "should_enable_multi_language", should_enable_multi_language)
        if should_enable_session is not None:
            pulumi.set(__self__, "should_enable_session", should_enable_session)
        if should_enable_trace is not None:
            pulumi.set(__self__, "should_enable_trace", should_enable_trace)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The OCID of the agent that this endpoint is associated with.
        """
        return pulumi.get(self, "agent_id")

    @agent_id.setter
    def agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "agent_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="contentModerationConfig")
    def content_moderation_config(self) -> Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]:
        """
        (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        """
        return pulumi.get(self, "content_moderation_config")

    @content_moderation_config.setter
    def content_moderation_config(self, value: Optional[pulumi.Input['AgentAgentEndpointContentModerationConfigArgs']]):
        pulumi.set(self, "content_moderation_config", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="guardrailConfig")
    def guardrail_config(self) -> Optional[pulumi.Input['AgentAgentEndpointGuardrailConfigArgs']]:
        """
        (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        """
        return pulumi.get(self, "guardrail_config")

    @guardrail_config.setter
    def guardrail_config(self, value: Optional[pulumi.Input['AgentAgentEndpointGuardrailConfigArgs']]):
        pulumi.set(self, "guardrail_config", value)

    @_builtins.property
    @pulumi.getter(name="humanInputConfig")
    def human_input_config(self) -> Optional[pulumi.Input['AgentAgentEndpointHumanInputConfigArgs']]:
        """
        (Updatable) Human Input Configuration for an AgentEndpoint.
        """
        return pulumi.get(self, "human_input_config")

    @human_input_config.setter
    def human_input_config(self, value: Optional[pulumi.Input['AgentAgentEndpointHumanInputConfigArgs']]):
        pulumi.set(self, "human_input_config", value)

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lifecycle_details", value)

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Key-value pairs to allow additional configurations.
        """
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "metadata", value)

    @_builtins.property
    @pulumi.getter(name="outputConfig")
    def output_config(self) -> Optional[pulumi.Input['AgentAgentEndpointOutputConfigArgs']]:
        """
        (Updatable) Configuration to store results generated by agent.
        """
        return pulumi.get(self, "output_config")

    @output_config.setter
    def output_config(self, value: Optional[pulumi.Input['AgentAgentEndpointOutputConfigArgs']]):
        pulumi.set(self, "output_config", value)

    @_builtins.property
    @pulumi.getter(name="sessionConfig")
    def session_config(self) -> Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]:
        """
        (Updatable) Session Configuration on AgentEndpoint.
        """
        return pulumi.get(self, "session_config")

    @session_config.setter
    def session_config(self, value: Optional[pulumi.Input['AgentAgentEndpointSessionConfigArgs']]):
        pulumi.set(self, "session_config", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableCitation")
    def should_enable_citation(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to show citations in the chat result.
        """
        return pulumi.get(self, "should_enable_citation")

    @should_enable_citation.setter
    def should_enable_citation(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_citation", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableMultiLanguage")
    def should_enable_multi_language(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to enable multi-language for chat.
        """
        return pulumi.get(self, "should_enable_multi_language")

    @should_enable_multi_language.setter
    def should_enable_multi_language(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_multi_language", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableSession")
    def should_enable_session(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether or not to enable Session-based chat.
        """
        return pulumi.get(self, "should_enable_session")

    @should_enable_session.setter
    def should_enable_session(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_session", value)

    @_builtins.property
    @pulumi.getter(name="shouldEnableTrace")
    def should_enable_trace(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) Whether to show traces in the chat result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_enable_trace")

    @should_enable_trace.setter
    def should_enable_trace(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "should_enable_trace", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)


@pulumi.type_token("oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint")
class AgentAgentEndpoint(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_moderation_config: Optional[pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guardrail_config: Optional[pulumi.Input[Union['AgentAgentEndpointGuardrailConfigArgs', 'AgentAgentEndpointGuardrailConfigArgsDict']]] = None,
                 human_input_config: Optional[pulumi.Input[Union['AgentAgentEndpointHumanInputConfigArgs', 'AgentAgentEndpointHumanInputConfigArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 output_config: Optional[pulumi.Input[Union['AgentAgentEndpointOutputConfigArgs', 'AgentAgentEndpointOutputConfigArgsDict']]] = None,
                 session_config: Optional[pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']]] = None,
                 should_enable_citation: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_multi_language: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        This resource provides the Agent Endpoint resource in Oracle Cloud Infrastructure Generative Ai Agent service.

        Creates an endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent_endpoint = oci.generativeai.AgentAgentEndpoint("test_agent_endpoint",
            agent_id=test_agent["id"],
            compartment_id=compartment_id,
            content_moderation_config={
                "should_enable_on_input": agent_endpoint_content_moderation_config_should_enable_on_input,
                "should_enable_on_output": agent_endpoint_content_moderation_config_should_enable_on_output,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=agent_endpoint_description,
            display_name=agent_endpoint_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            guardrail_config={
                "content_moderation_config": {
                    "input_guardrail_mode": agent_endpoint_guardrail_config_content_moderation_config_input_guardrail_mode,
                    "output_guardrail_mode": agent_endpoint_guardrail_config_content_moderation_config_output_guardrail_mode,
                },
                "personally_identifiable_information_config": {
                    "input_guardrail_mode": agent_endpoint_guardrail_config_personally_identifiable_information_config_input_guardrail_mode,
                    "output_guardrail_mode": agent_endpoint_guardrail_config_personally_identifiable_information_config_output_guardrail_mode,
                },
                "prompt_injection_config": {
                    "input_guardrail_mode": agent_endpoint_guardrail_config_prompt_injection_config_input_guardrail_mode,
                },
            },
            human_input_config={
                "should_enable_human_input": agent_endpoint_human_input_config_should_enable_human_input,
            },
            metadata=agent_endpoint_metadata,
            output_config={
                "output_location": {
                    "bucket": agent_endpoint_output_config_output_location_bucket,
                    "namespace": agent_endpoint_output_config_output_location_namespace,
                    "output_location_type": agent_endpoint_output_config_output_location_output_location_type,
                    "prefix": agent_endpoint_output_config_output_location_prefix,
                },
                "retention_period_in_minutes": agent_endpoint_output_config_retention_period_in_minutes,
            },
            session_config={
                "idle_timeout_in_seconds": agent_endpoint_session_config_idle_timeout_in_seconds,
            },
            should_enable_citation=agent_endpoint_should_enable_citation,
            should_enable_multi_language=agent_endpoint_should_enable_multi_language,
            should_enable_session=agent_endpoint_should_enable_session,
            should_enable_trace=agent_endpoint_should_enable_trace)
        ```

        ## Import

        AgentEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint test_agent_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['AgentAgentEndpointGuardrailConfigArgs', 'AgentAgentEndpointGuardrailConfigArgsDict']] guardrail_config: (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        :param pulumi.Input[Union['AgentAgentEndpointHumanInputConfigArgs', 'AgentAgentEndpointHumanInputConfigArgsDict']] human_input_config: (Updatable) Human Input Configuration for an AgentEndpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input[Union['AgentAgentEndpointOutputConfigArgs', 'AgentAgentEndpointOutputConfigArgsDict']] output_config: (Updatable) Configuration to store results generated by agent.
        :param pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']] session_config: (Updatable) Session Configuration on AgentEndpoint.
        :param pulumi.Input[_builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[_builtins.bool] should_enable_multi_language: (Updatable) Whether to enable multi-language for chat.
        :param pulumi.Input[_builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[_builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AgentAgentEndpointArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Agent Endpoint resource in Oracle Cloud Infrastructure Generative Ai Agent service.

        Creates an endpoint.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_agent_endpoint = oci.generativeai.AgentAgentEndpoint("test_agent_endpoint",
            agent_id=test_agent["id"],
            compartment_id=compartment_id,
            content_moderation_config={
                "should_enable_on_input": agent_endpoint_content_moderation_config_should_enable_on_input,
                "should_enable_on_output": agent_endpoint_content_moderation_config_should_enable_on_output,
            },
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=agent_endpoint_description,
            display_name=agent_endpoint_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            guardrail_config={
                "content_moderation_config": {
                    "input_guardrail_mode": agent_endpoint_guardrail_config_content_moderation_config_input_guardrail_mode,
                    "output_guardrail_mode": agent_endpoint_guardrail_config_content_moderation_config_output_guardrail_mode,
                },
                "personally_identifiable_information_config": {
                    "input_guardrail_mode": agent_endpoint_guardrail_config_personally_identifiable_information_config_input_guardrail_mode,
                    "output_guardrail_mode": agent_endpoint_guardrail_config_personally_identifiable_information_config_output_guardrail_mode,
                },
                "prompt_injection_config": {
                    "input_guardrail_mode": agent_endpoint_guardrail_config_prompt_injection_config_input_guardrail_mode,
                },
            },
            human_input_config={
                "should_enable_human_input": agent_endpoint_human_input_config_should_enable_human_input,
            },
            metadata=agent_endpoint_metadata,
            output_config={
                "output_location": {
                    "bucket": agent_endpoint_output_config_output_location_bucket,
                    "namespace": agent_endpoint_output_config_output_location_namespace,
                    "output_location_type": agent_endpoint_output_config_output_location_output_location_type,
                    "prefix": agent_endpoint_output_config_output_location_prefix,
                },
                "retention_period_in_minutes": agent_endpoint_output_config_retention_period_in_minutes,
            },
            session_config={
                "idle_timeout_in_seconds": agent_endpoint_session_config_idle_timeout_in_seconds,
            },
            should_enable_citation=agent_endpoint_should_enable_citation,
            should_enable_multi_language=agent_endpoint_should_enable_multi_language,
            should_enable_session=agent_endpoint_should_enable_session,
            should_enable_trace=agent_endpoint_should_enable_trace)
        ```

        ## Import

        AgentEndpoints can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint test_agent_endpoint "id"
        ```

        :param str resource_name: The name of the resource.
        :param AgentAgentEndpointArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AgentAgentEndpointArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 content_moderation_config: Optional[pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 guardrail_config: Optional[pulumi.Input[Union['AgentAgentEndpointGuardrailConfigArgs', 'AgentAgentEndpointGuardrailConfigArgsDict']]] = None,
                 human_input_config: Optional[pulumi.Input[Union['AgentAgentEndpointHumanInputConfigArgs', 'AgentAgentEndpointHumanInputConfigArgsDict']]] = None,
                 metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 output_config: Optional[pulumi.Input[Union['AgentAgentEndpointOutputConfigArgs', 'AgentAgentEndpointOutputConfigArgsDict']]] = None,
                 session_config: Optional[pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']]] = None,
                 should_enable_citation: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_multi_language: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_session: Optional[pulumi.Input[_builtins.bool]] = None,
                 should_enable_trace: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AgentAgentEndpointArgs.__new__(AgentAgentEndpointArgs)

            if agent_id is None and not opts.urn:
                raise TypeError("Missing required property 'agent_id'")
            __props__.__dict__["agent_id"] = agent_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["content_moderation_config"] = content_moderation_config
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["guardrail_config"] = guardrail_config
            __props__.__dict__["human_input_config"] = human_input_config
            __props__.__dict__["metadata"] = metadata
            __props__.__dict__["output_config"] = output_config
            __props__.__dict__["session_config"] = session_config
            __props__.__dict__["should_enable_citation"] = should_enable_citation
            __props__.__dict__["should_enable_multi_language"] = should_enable_multi_language
            __props__.__dict__["should_enable_session"] = should_enable_session
            __props__.__dict__["should_enable_trace"] = should_enable_trace
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(AgentAgentEndpoint, __self__).__init__(
            'oci:GenerativeAi/agentAgentEndpoint:AgentAgentEndpoint',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            content_moderation_config: Optional[pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            guardrail_config: Optional[pulumi.Input[Union['AgentAgentEndpointGuardrailConfigArgs', 'AgentAgentEndpointGuardrailConfigArgsDict']]] = None,
            human_input_config: Optional[pulumi.Input[Union['AgentAgentEndpointHumanInputConfigArgs', 'AgentAgentEndpointHumanInputConfigArgsDict']]] = None,
            lifecycle_details: Optional[pulumi.Input[_builtins.str]] = None,
            metadata: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            output_config: Optional[pulumi.Input[Union['AgentAgentEndpointOutputConfigArgs', 'AgentAgentEndpointOutputConfigArgsDict']]] = None,
            session_config: Optional[pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']]] = None,
            should_enable_citation: Optional[pulumi.Input[_builtins.bool]] = None,
            should_enable_multi_language: Optional[pulumi.Input[_builtins.bool]] = None,
            should_enable_session: Optional[pulumi.Input[_builtins.bool]] = None,
            should_enable_trace: Optional[pulumi.Input[_builtins.bool]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'AgentAgentEndpoint':
        """
        Get an existing AgentAgentEndpoint resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] agent_id: The OCID of the agent that this endpoint is associated with.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        :param pulumi.Input[Union['AgentAgentEndpointContentModerationConfigArgs', 'AgentAgentEndpointContentModerationConfigArgsDict']] content_moderation_config: (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[_builtins.str] description: (Updatable) An optional description of the endpoint.
        :param pulumi.Input[_builtins.str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[Union['AgentAgentEndpointGuardrailConfigArgs', 'AgentAgentEndpointGuardrailConfigArgsDict']] guardrail_config: (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        :param pulumi.Input[Union['AgentAgentEndpointHumanInputConfigArgs', 'AgentAgentEndpointHumanInputConfigArgsDict']] human_input_config: (Updatable) Human Input Configuration for an AgentEndpoint.
        :param pulumi.Input[_builtins.str] lifecycle_details: A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] metadata: (Updatable) Key-value pairs to allow additional configurations.
        :param pulumi.Input[Union['AgentAgentEndpointOutputConfigArgs', 'AgentAgentEndpointOutputConfigArgsDict']] output_config: (Updatable) Configuration to store results generated by agent.
        :param pulumi.Input[Union['AgentAgentEndpointSessionConfigArgs', 'AgentAgentEndpointSessionConfigArgsDict']] session_config: (Updatable) Session Configuration on AgentEndpoint.
        :param pulumi.Input[_builtins.bool] should_enable_citation: (Updatable) Whether to show citations in the chat result.
        :param pulumi.Input[_builtins.bool] should_enable_multi_language: (Updatable) Whether to enable multi-language for chat.
        :param pulumi.Input[_builtins.bool] should_enable_session: Whether or not to enable Session-based chat.
        :param pulumi.Input[_builtins.bool] should_enable_trace: (Updatable) Whether to show traces in the chat result.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the endpoint.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_created: The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[_builtins.str] time_updated: The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AgentAgentEndpointState.__new__(_AgentAgentEndpointState)

        __props__.__dict__["agent_id"] = agent_id
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["content_moderation_config"] = content_moderation_config
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["guardrail_config"] = guardrail_config
        __props__.__dict__["human_input_config"] = human_input_config
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["metadata"] = metadata
        __props__.__dict__["output_config"] = output_config
        __props__.__dict__["session_config"] = session_config
        __props__.__dict__["should_enable_citation"] = should_enable_citation
        __props__.__dict__["should_enable_multi_language"] = should_enable_multi_language
        __props__.__dict__["should_enable_session"] = should_enable_session
        __props__.__dict__["should_enable_trace"] = should_enable_trace
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AgentAgentEndpoint(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="agentId")
    def agent_id(self) -> pulumi.Output[_builtins.str]:
        """
        The OCID of the agent that this endpoint is associated with.
        """
        return pulumi.get(self, "agent_id")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to create the endpoint in.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="contentModerationConfig")
    def content_moderation_config(self) -> pulumi.Output['outputs.AgentAgentEndpointContentModerationConfig']:
        """
        (Updatable) The configuration details about whether to apply the content moderation feature to input and output. Content moderation removes toxic and biased content from responses. It is recommended to use content moderation.
        """
        return pulumi.get(self, "content_moderation_config")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) An optional description of the endpoint.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="guardrailConfig")
    def guardrail_config(self) -> pulumi.Output['outputs.AgentAgentEndpointGuardrailConfig']:
        """
        (Updatable) The configuration details about whether to apply the guardrail checks to input and output.
        """
        return pulumi.get(self, "guardrail_config")

    @_builtins.property
    @pulumi.getter(name="humanInputConfig")
    def human_input_config(self) -> pulumi.Output['outputs.AgentAgentEndpointHumanInputConfig']:
        """
        (Updatable) Human Input Configuration for an AgentEndpoint.
        """
        return pulumi.get(self, "human_input_config")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[_builtins.str]:
        """
        A message that describes the current state of the endpoint in more detail. For example, can be used to provide actionable information for a resource in the Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter
    def metadata(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Key-value pairs to allow additional configurations.
        """
        return pulumi.get(self, "metadata")

    @_builtins.property
    @pulumi.getter(name="outputConfig")
    def output_config(self) -> pulumi.Output['outputs.AgentAgentEndpointOutputConfig']:
        """
        (Updatable) Configuration to store results generated by agent.
        """
        return pulumi.get(self, "output_config")

    @_builtins.property
    @pulumi.getter(name="sessionConfig")
    def session_config(self) -> pulumi.Output['outputs.AgentAgentEndpointSessionConfig']:
        """
        (Updatable) Session Configuration on AgentEndpoint.
        """
        return pulumi.get(self, "session_config")

    @_builtins.property
    @pulumi.getter(name="shouldEnableCitation")
    def should_enable_citation(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to show citations in the chat result.
        """
        return pulumi.get(self, "should_enable_citation")

    @_builtins.property
    @pulumi.getter(name="shouldEnableMultiLanguage")
    def should_enable_multi_language(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to enable multi-language for chat.
        """
        return pulumi.get(self, "should_enable_multi_language")

    @_builtins.property
    @pulumi.getter(name="shouldEnableSession")
    def should_enable_session(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether or not to enable Session-based chat.
        """
        return pulumi.get(self, "should_enable_session")

    @_builtins.property
    @pulumi.getter(name="shouldEnableTrace")
    def should_enable_trace(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) Whether to show traces in the chat result.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "should_enable_trace")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the endpoint.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the AgentEndpoint was created, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time the endpoint was updated, in the format defined by [RFC 3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")

