# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFleetDrsFileResult',
    'AwaitableGetFleetDrsFileResult',
    'get_fleet_drs_file',
    'get_fleet_drs_file_output',
]

@pulumi.output_type
class GetFleetDrsFileResult:
    """
    A collection of values returned by getFleetDrsFile.
    """
    def __init__(__self__, bucket=None, checksum_type=None, checksum_value=None, drs_file_key=None, drs_file_name=None, fleet_id=None, id=None, is_default=None, namespace=None):
        if bucket and not isinstance(bucket, str):
            raise TypeError("Expected argument 'bucket' to be a str")
        pulumi.set(__self__, "bucket", bucket)
        if checksum_type and not isinstance(checksum_type, str):
            raise TypeError("Expected argument 'checksum_type' to be a str")
        pulumi.set(__self__, "checksum_type", checksum_type)
        if checksum_value and not isinstance(checksum_value, str):
            raise TypeError("Expected argument 'checksum_value' to be a str")
        pulumi.set(__self__, "checksum_value", checksum_value)
        if drs_file_key and not isinstance(drs_file_key, str):
            raise TypeError("Expected argument 'drs_file_key' to be a str")
        pulumi.set(__self__, "drs_file_key", drs_file_key)
        if drs_file_name and not isinstance(drs_file_name, str):
            raise TypeError("Expected argument 'drs_file_name' to be a str")
        pulumi.set(__self__, "drs_file_name", drs_file_name)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @_builtins.property
    @pulumi.getter
    def bucket(self) -> _builtins.str:
        """
        The Object Storage bucket name where the DRS file is located.
        """
        return pulumi.get(self, "bucket")

    @_builtins.property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> _builtins.str:
        """
        The checksum type for the DRS file in Object Storage.
        """
        return pulumi.get(self, "checksum_type")

    @_builtins.property
    @pulumi.getter(name="checksumValue")
    def checksum_value(self) -> _builtins.str:
        """
        The checksum value for the DRS file in Object Storage.
        """
        return pulumi.get(self, "checksum_value")

    @_builtins.property
    @pulumi.getter(name="drsFileKey")
    def drs_file_key(self) -> _builtins.str:
        """
        The unique identifier of the DRS file in Object Storage.
        """
        return pulumi.get(self, "drs_file_key")

    @_builtins.property
    @pulumi.getter(name="drsFileName")
    def drs_file_name(self) -> _builtins.str:
        """
        The name of the DRS file in Object Store.
        """
        return pulumi.get(self, "drs_file_name")

    @_builtins.property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> _builtins.str:
        return pulumi.get(self, "fleet_id")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> _builtins.bool:
        """
        To check if the DRS file is the detfault ones.
        """
        return pulumi.get(self, "is_default")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        The namespace for Object Storage.
        """
        return pulumi.get(self, "namespace")


class AwaitableGetFleetDrsFileResult(GetFleetDrsFileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetDrsFileResult(
            bucket=self.bucket,
            checksum_type=self.checksum_type,
            checksum_value=self.checksum_value,
            drs_file_key=self.drs_file_key,
            drs_file_name=self.drs_file_name,
            fleet_id=self.fleet_id,
            id=self.id,
            is_default=self.is_default,
            namespace=self.namespace)


def get_fleet_drs_file(drs_file_key: Optional[_builtins.str] = None,
                       fleet_id: Optional[_builtins.str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetDrsFileResult:
    """
    This data source provides details about a specific Fleet Drs File resource in Oracle Cloud Infrastructure Jms service.

    Get the detail about the created DRS file in the Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_drs_file = oci.Jms.get_fleet_drs_file(drs_file_key=fleet_drs_file_drs_file_key,
        fleet_id=test_fleet["id"])
    ```


    :param _builtins.str drs_file_key: The unique identifier of the DRS File in Object Storage.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['drsFileKey'] = drs_file_key
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetDrsFile:getFleetDrsFile', __args__, opts=opts, typ=GetFleetDrsFileResult).value

    return AwaitableGetFleetDrsFileResult(
        bucket=pulumi.get(__ret__, 'bucket'),
        checksum_type=pulumi.get(__ret__, 'checksum_type'),
        checksum_value=pulumi.get(__ret__, 'checksum_value'),
        drs_file_key=pulumi.get(__ret__, 'drs_file_key'),
        drs_file_name=pulumi.get(__ret__, 'drs_file_name'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        namespace=pulumi.get(__ret__, 'namespace'))
def get_fleet_drs_file_output(drs_file_key: Optional[pulumi.Input[_builtins.str]] = None,
                              fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetDrsFileResult]:
    """
    This data source provides details about a specific Fleet Drs File resource in Oracle Cloud Infrastructure Jms service.

    Get the detail about the created DRS file in the Fleet.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_drs_file = oci.Jms.get_fleet_drs_file(drs_file_key=fleet_drs_file_drs_file_key,
        fleet_id=test_fleet["id"])
    ```


    :param _builtins.str drs_file_key: The unique identifier of the DRS File in Object Storage.
    :param _builtins.str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['drsFileKey'] = drs_file_key
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetDrsFile:getFleetDrsFile', __args__, opts=opts, typ=GetFleetDrsFileResult)
    return __ret__.apply(lambda __response__: GetFleetDrsFileResult(
        bucket=pulumi.get(__response__, 'bucket'),
        checksum_type=pulumi.get(__response__, 'checksum_type'),
        checksum_value=pulumi.get(__response__, 'checksum_value'),
        drs_file_key=pulumi.get(__response__, 'drs_file_key'),
        drs_file_name=pulumi.get(__response__, 'drs_file_name'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id'),
        is_default=pulumi.get(__response__, 'is_default'),
        namespace=pulumi.get(__response__, 'namespace')))
