# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['JavaDownloadsJavaLicenseAcceptanceRecordArgs', 'JavaDownloadsJavaLicenseAcceptanceRecord']

@pulumi.input_type
class JavaDownloadsJavaLicenseAcceptanceRecordArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 license_acceptance_status: pulumi.Input[_builtins.str],
                 license_type: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a JavaDownloadsJavaLicenseAcceptanceRecord resource.
        :param pulumi.Input[_builtins.str] compartment_id: The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        :param pulumi.Input[_builtins.str] license_acceptance_status: (Updatable) Status of license acceptance.
        :param pulumi.Input[_builtins.str] license_type: License type for the Java version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "license_acceptance_status", license_acceptance_status)
        pulumi.set(__self__, "license_type", license_type)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="licenseAcceptanceStatus")
    def license_acceptance_status(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Status of license acceptance.
        """
        return pulumi.get(self, "license_acceptance_status")

    @license_acceptance_status.setter
    def license_acceptance_status(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_acceptance_status", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[_builtins.str]:
        """
        License type for the Java version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)


@pulumi.input_type
class _JavaDownloadsJavaLicenseAcceptanceRecordState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 created_bies: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 last_updated_bies: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgs']]]] = None,
                 license_acceptance_status: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 time_accepted: Optional[pulumi.Input[_builtins.str]] = None,
                 time_last_updated: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering JavaDownloadsJavaLicenseAcceptanceRecord resources.
        :param pulumi.Input[_builtins.str] compartment_id: The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        :param pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgs']]] created_bies: An authorized principal.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgs']]] last_updated_bies: An authorized principal.
        :param pulumi.Input[_builtins.str] license_acceptance_status: (Updatable) Status of license acceptance.
        :param pulumi.Input[_builtins.str] license_type: License type for the Java version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the JavaLicenseAcceptanceRecord.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_accepted: The date and time of license acceptance (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_last_updated: The date and time of last update (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies is not None:
            pulumi.set(__self__, "created_bies", created_bies)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if last_updated_bies is not None:
            pulumi.set(__self__, "last_updated_bies", last_updated_bies)
        if license_acceptance_status is not None:
            pulumi.set(__self__, "license_acceptance_status", license_acceptance_status)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_accepted is not None:
            pulumi.set(__self__, "time_accepted", time_accepted)
        if time_last_updated is not None:
            pulumi.set(__self__, "time_last_updated", time_last_updated)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgs']]]]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @created_bies.setter
    def created_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgs']]]]):
        pulumi.set(self, "created_bies", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBies")
    def last_updated_bies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgs']]]]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "last_updated_bies")

    @last_updated_bies.setter
    def last_updated_bies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgs']]]]):
        pulumi.set(self, "last_updated_bies", value)

    @_builtins.property
    @pulumi.getter(name="licenseAcceptanceStatus")
    def license_acceptance_status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Status of license acceptance.
        """
        return pulumi.get(self, "license_acceptance_status")

    @license_acceptance_status.setter
    def license_acceptance_status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_acceptance_status", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        License type for the Java version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current state of the JavaLicenseAcceptanceRecord.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of license acceptance (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_accepted")

    @time_accepted.setter
    def time_accepted(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_accepted", value)

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time of last update (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_updated")

    @time_last_updated.setter
    def time_last_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_last_updated", value)


@pulumi.type_token("oci:Jms/javaDownloadsJavaLicenseAcceptanceRecord:JavaDownloadsJavaLicenseAcceptanceRecord")
class JavaDownloadsJavaLicenseAcceptanceRecord(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_acceptance_status: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Java License Acceptance Record resource in Oracle Cloud Infrastructure Jms Java Downloads service.

        Creates a Java license acceptance record for the specified license type in a tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_java_license_acceptance_record = oci.jms.JavaDownloadsJavaLicenseAcceptanceRecord("test_java_license_acceptance_record",
            compartment_id=tenancy_ocid,
            license_acceptance_status=java_license_acceptance_record_license_acceptance_status,
            license_type=java_license_acceptance_record_license_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[_builtins.str] license_acceptance_status: (Updatable) Status of license acceptance.
        :param pulumi.Input[_builtins.str] license_type: License type for the Java version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: JavaDownloadsJavaLicenseAcceptanceRecordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Java License Acceptance Record resource in Oracle Cloud Infrastructure Jms Java Downloads service.

        Creates a Java license acceptance record for the specified license type in a tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_java_license_acceptance_record = oci.jms.JavaDownloadsJavaLicenseAcceptanceRecord("test_java_license_acceptance_record",
            compartment_id=tenancy_ocid,
            license_acceptance_status=java_license_acceptance_record_license_acceptance_status,
            license_type=java_license_acceptance_record_license_type,
            defined_tags={
                "foo-namespace.bar-key": "value",
            })
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param JavaDownloadsJavaLicenseAcceptanceRecordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(JavaDownloadsJavaLicenseAcceptanceRecordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 license_acceptance_status: Optional[pulumi.Input[_builtins.str]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = JavaDownloadsJavaLicenseAcceptanceRecordArgs.__new__(JavaDownloadsJavaLicenseAcceptanceRecordArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            if license_acceptance_status is None and not opts.urn:
                raise TypeError("Missing required property 'license_acceptance_status'")
            __props__.__dict__["license_acceptance_status"] = license_acceptance_status
            if license_type is None and not opts.urn:
                raise TypeError("Missing required property 'license_type'")
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["created_bies"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["last_updated_bies"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_accepted"] = None
            __props__.__dict__["time_last_updated"] = None
        super(JavaDownloadsJavaLicenseAcceptanceRecord, __self__).__init__(
            'oci:Jms/javaDownloadsJavaLicenseAcceptanceRecord:JavaDownloadsJavaLicenseAcceptanceRecord',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            created_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgs', 'JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgsDict']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            last_updated_bies: Optional[pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgs', 'JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgsDict']]]]] = None,
            license_acceptance_status: Optional[pulumi.Input[_builtins.str]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            time_accepted: Optional[pulumi.Input[_builtins.str]] = None,
            time_last_updated: Optional[pulumi.Input[_builtins.str]] = None) -> 'JavaDownloadsJavaLicenseAcceptanceRecord':
        """
        Get an existing JavaDownloadsJavaLicenseAcceptanceRecord resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        :param pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgs', 'JavaDownloadsJavaLicenseAcceptanceRecordCreatedByArgsDict']]]] created_bies: An authorized principal.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        :param pulumi.Input[Sequence[pulumi.Input[Union['JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgs', 'JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedByArgsDict']]]] last_updated_bies: An authorized principal.
        :param pulumi.Input[_builtins.str] license_acceptance_status: (Updatable) Status of license acceptance.
        :param pulumi.Input[_builtins.str] license_type: License type for the Java version.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] state: The current state of the JavaLicenseAcceptanceRecord.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] time_accepted: The date and time of license acceptance (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        :param pulumi.Input[_builtins.str] time_last_updated: The date and time of last update (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _JavaDownloadsJavaLicenseAcceptanceRecordState.__new__(_JavaDownloadsJavaLicenseAcceptanceRecordState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["created_bies"] = created_bies
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["last_updated_bies"] = last_updated_bies
        __props__.__dict__["license_acceptance_status"] = license_acceptance_status
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_accepted"] = time_accepted
        __props__.__dict__["time_last_updated"] = time_last_updated
        return JavaDownloadsJavaLicenseAcceptanceRecord(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The tenancy [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the user accepting the license.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> pulumi.Output[Sequence['outputs.JavaDownloadsJavaLicenseAcceptanceRecordCreatedBy']]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="lastUpdatedBies")
    def last_updated_bies(self) -> pulumi.Output[Sequence['outputs.JavaDownloadsJavaLicenseAcceptanceRecordLastUpdatedBy']]:
        """
        An authorized principal.
        """
        return pulumi.get(self, "last_updated_bies")

    @_builtins.property
    @pulumi.getter(name="licenseAcceptanceStatus")
    def license_acceptance_status(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Status of license acceptance.
        """
        return pulumi.get(self, "license_acceptance_status")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[_builtins.str]:
        """
        License type for the Java version.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        The current state of the JavaLicenseAcceptanceRecord.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of license acceptance (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_accepted")

    @_builtins.property
    @pulumi.getter(name="timeLastUpdated")
    def time_last_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time of last update (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_last_updated")

