# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNamedCredentialResult',
    'AwaitableGetNamedCredentialResult',
    'get_named_credential',
    'get_named_credential_output',
]

@pulumi.output_type
class GetNamedCredentialResult:
    """
    A collection of values returned by getNamedCredential.
    """
    def __init__(__self__, defined_tags=None, description=None, freeform_tags=None, id=None, management_agent_id=None, name=None, named_credential_id=None, properties=None, state=None, system_tags=None, time_created=None, time_updated=None, type=None):
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if management_agent_id and not isinstance(management_agent_id, str):
            raise TypeError("Expected argument 'management_agent_id' to be a str")
        pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if named_credential_id and not isinstance(named_credential_id, str):
            raise TypeError("Expected argument 'named_credential_id' to be a str")
        pulumi.set(__self__, "named_credential_id", named_credential_id)
        if properties and not isinstance(properties, list):
            raise TypeError("Expected argument 'properties' to be a list")
        pulumi.set(__self__, "properties", properties)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter
    def description(self) -> _builtins.str:
        """
        Description of the Named Credential.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        Identifier for Named Credential.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> _builtins.str:
        """
        The Management Agent parent resource to associated with this named credential. This is the ManagementAgent resource OCID.
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the property
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="namedCredentialId")
    def named_credential_id(self) -> _builtins.str:
        return pulumi.get(self, "named_credential_id")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Sequence['outputs.GetNamedCredentialPropertyResult']:
        """
        Properties for the named credential
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the named credential
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The time the Named Credential was created. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The time the Named Credential data was last updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Named Credential.
        """
        return pulumi.get(self, "type")


class AwaitableGetNamedCredentialResult(GetNamedCredentialResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNamedCredentialResult(
            defined_tags=self.defined_tags,
            description=self.description,
            freeform_tags=self.freeform_tags,
            id=self.id,
            management_agent_id=self.management_agent_id,
            name=self.name,
            named_credential_id=self.named_credential_id,
            properties=self.properties,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            type=self.type)


def get_named_credential(named_credential_id: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNamedCredentialResult:
    """
    This data source provides details about a specific Named Credential resource in Oracle Cloud Infrastructure Management Agent service.

    Get Named credential details for given Id and given Management Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_named_credential = oci.ManagementAgent.get_named_credential(named_credential_id=test_named_credential_oci_management_agent_named_credential["id"])
    ```


    :param _builtins.str named_credential_id: Named credential ID
    """
    __args__ = dict()
    __args__['namedCredentialId'] = named_credential_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ManagementAgent/getNamedCredential:getNamedCredential', __args__, opts=opts, typ=GetNamedCredentialResult).value

    return AwaitableGetNamedCredentialResult(
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        description=pulumi.get(__ret__, 'description'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        management_agent_id=pulumi.get(__ret__, 'management_agent_id'),
        name=pulumi.get(__ret__, 'name'),
        named_credential_id=pulumi.get(__ret__, 'named_credential_id'),
        properties=pulumi.get(__ret__, 'properties'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        type=pulumi.get(__ret__, 'type'))
def get_named_credential_output(named_credential_id: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNamedCredentialResult]:
    """
    This data source provides details about a specific Named Credential resource in Oracle Cloud Infrastructure Management Agent service.

    Get Named credential details for given Id and given Management Agent.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_named_credential = oci.ManagementAgent.get_named_credential(named_credential_id=test_named_credential_oci_management_agent_named_credential["id"])
    ```


    :param _builtins.str named_credential_id: Named credential ID
    """
    __args__ = dict()
    __args__['namedCredentialId'] = named_credential_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:ManagementAgent/getNamedCredential:getNamedCredential', __args__, opts=opts, typ=GetNamedCredentialResult)
    return __ret__.apply(lambda __response__: GetNamedCredentialResult(
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        description=pulumi.get(__response__, 'description'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        management_agent_id=pulumi.get(__response__, 'management_agent_id'),
        name=pulumi.get(__response__, 'name'),
        named_credential_id=pulumi.get(__response__, 'named_credential_id'),
        properties=pulumi.get(__response__, 'properties'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        type=pulumi.get(__response__, 'type')))
