# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManagedKafkaKafkaClusterSuperusersManagementArgs', 'ManagedKafkaKafkaClusterSuperusersManagement']

@pulumi.input_type
class ManagedKafkaKafkaClusterSuperusersManagementArgs:
    def __init__(__self__, *,
                 enable_superuser: pulumi.Input[_builtins.bool],
                 kafka_cluster_id: pulumi.Input[_builtins.str],
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedKafkaKafkaClusterSuperusersManagement resource.
        :param pulumi.Input[_builtins.bool] enable_superuser: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] kafka_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        pulumi.set(__self__, "enable_superuser", enable_superuser)
        pulumi.set(__self__, "kafka_cluster_id", kafka_cluster_id)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter(name="enableSuperuser")
    def enable_superuser(self) -> pulumi.Input[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_superuser")

    @enable_superuser.setter
    def enable_superuser(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enable_superuser", value)

    @_builtins.property
    @pulumi.getter(name="kafkaClusterId")
    def kafka_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        """
        return pulumi.get(self, "kafka_cluster_id")

    @kafka_cluster_id.setter
    def kafka_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kafka_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)


@pulumi.input_type
class _ManagedKafkaKafkaClusterSuperusersManagementState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 kafka_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedKafkaKafkaClusterSuperusersManagement resources.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        :param pulumi.Input[_builtins.bool] enable_superuser: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] kafka_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if enable_superuser is not None:
            pulumi.set(__self__, "enable_superuser", enable_superuser)
        if kafka_cluster_id is not None:
            pulumi.set(__self__, "kafka_cluster_id", kafka_cluster_id)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter(name="enableSuperuser")
    def enable_superuser(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_superuser")

    @enable_superuser.setter
    def enable_superuser(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_superuser", value)

    @_builtins.property
    @pulumi.getter(name="kafkaClusterId")
    def kafka_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        """
        return pulumi.get(self, "kafka_cluster_id")

    @kafka_cluster_id.setter
    def kafka_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kafka_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secret_id", value)


@pulumi.type_token("oci:oci/managedKafkaKafkaClusterSuperusersManagement:ManagedKafkaKafkaClusterSuperusersManagement")
class ManagedKafkaKafkaClusterSuperusersManagement(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 kafka_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Kafka Cluster Superusers Management resource in Oracle Cloud Infrastructure Managed Kafka service.

        Adds a SASL superuser to the Kafka cluster. A generated password will be updated to the specified vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_kafka_cluster_superusers_management = oci.oci.ManagedKafkaKafkaClusterSuperusersManagement("test_kafka_cluster_superusers_management",
            kafka_cluster_id=test_kafka_cluster["id"],
            enable_superuser=enable_superuser,
            compartment_id=compartment_id,
            secret_id=test_secret["id"])
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        :param pulumi.Input[_builtins.bool] enable_superuser: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] kafka_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedKafkaKafkaClusterSuperusersManagementArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Kafka Cluster Superusers Management resource in Oracle Cloud Infrastructure Managed Kafka service.

        Adds a SASL superuser to the Kafka cluster. A generated password will be updated to the specified vault.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_kafka_cluster_superusers_management = oci.oci.ManagedKafkaKafkaClusterSuperusersManagement("test_kafka_cluster_superusers_management",
            kafka_cluster_id=test_kafka_cluster["id"],
            enable_superuser=enable_superuser,
            compartment_id=compartment_id,
            secret_id=test_secret["id"])
        ```

        :param str resource_name: The name of the resource.
        :param ManagedKafkaKafkaClusterSuperusersManagementArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedKafkaKafkaClusterSuperusersManagementArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_superuser: Optional[pulumi.Input[_builtins.bool]] = None,
                 kafka_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 secret_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedKafkaKafkaClusterSuperusersManagementArgs.__new__(ManagedKafkaKafkaClusterSuperusersManagementArgs)

            __props__.__dict__["compartment_id"] = compartment_id
            if enable_superuser is None and not opts.urn:
                raise TypeError("Missing required property 'enable_superuser'")
            __props__.__dict__["enable_superuser"] = enable_superuser
            if kafka_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'kafka_cluster_id'")
            __props__.__dict__["kafka_cluster_id"] = kafka_cluster_id
            __props__.__dict__["secret_id"] = secret_id
        super(ManagedKafkaKafkaClusterSuperusersManagement, __self__).__init__(
            'oci:oci/managedKafkaKafkaClusterSuperusersManagement:ManagedKafkaKafkaClusterSuperusersManagement',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_superuser: Optional[pulumi.Input[_builtins.bool]] = None,
            kafka_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            secret_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedKafkaKafkaClusterSuperusersManagement':
        """
        Get an existing ManagedKafkaKafkaClusterSuperusersManagement resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        :param pulumi.Input[_builtins.bool] enable_superuser: (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[_builtins.str] kafka_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        :param pulumi.Input[_builtins.str] secret_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedKafkaKafkaClusterSuperusersManagementState.__new__(_ManagedKafkaKafkaClusterSuperusersManagementState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["enable_superuser"] = enable_superuser
        __props__.__dict__["kafka_cluster_id"] = kafka_cluster_id
        __props__.__dict__["secret_id"] = secret_id
        return ManagedKafkaKafkaClusterSuperusersManagement(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the superuser secret.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="enableSuperuser")
    def enable_superuser(self) -> pulumi.Output[_builtins.bool]:
        """
        (Updatable) A required field when set to `true` calls enable action and when set to `false` calls disable action.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "enable_superuser")

    @_builtins.property
    @pulumi.getter(name="kafkaClusterId")
    def kafka_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the KafkaCluster.
        """
        return pulumi.get(self, "kafka_cluster_id")

    @_builtins.property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the secret that will be populated with the generated superuser password.
        """
        return pulumi.get(self, "secret_id")

