# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ClusterMaintenanceDetails',
    'ClusterOutboundClusterConfig',
    'ClusterOutboundClusterConfigOutboundCluster',
    'ClusterReverseConnectionEndpoint',
    'ClusterSecuritySamlConfig',
    'OpensearchClusterPipelineReverseConnectionEndpoint',
    'GetOpensearchClusterMaintenanceDetailResult',
    'GetOpensearchClusterOutboundClusterConfigResult',
    'GetOpensearchClusterOutboundClusterConfigOutboundClusterResult',
    'GetOpensearchClusterPipelineReverseConnectionEndpointResult',
    'GetOpensearchClusterPipelinesFilterResult',
    'GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionResult',
    'GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemResult',
    'GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemReverseConnectionEndpointResult',
    'GetOpensearchClusterReverseConnectionEndpointResult',
    'GetOpensearchClusterSecuritySamlConfigResult',
    'GetOpensearchClustersFilterResult',
    'GetOpensearchClustersOpensearchClusterCollectionResult',
    'GetOpensearchClustersOpensearchClusterCollectionItemResult',
    'GetOpensearchClustersOpensearchClusterCollectionItemMaintenanceDetailResult',
    'GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigResult',
    'GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigOutboundClusterResult',
    'GetOpensearchClustersOpensearchClusterCollectionItemReverseConnectionEndpointResult',
    'GetOpensearchClustersOpensearchClusterCollectionItemSecuritySamlConfigResult',
    'GetOpensearchVersionItemResult',
    'GetOpensearchVersionsFilterResult',
    'GetOpensearchVersionsOpensearchVersionsCollectionResult',
    'GetOpensearchVersionsOpensearchVersionsCollectionItemResult',
]

@pulumi.output_type
class ClusterMaintenanceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "notificationEmailIds":
            suggest = "notification_email_ids"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMaintenanceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMaintenanceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMaintenanceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 notification_email_ids: Optional[Sequence[_builtins.str]] = None,
                 start_time: Optional[_builtins.str] = None,
                 state: Optional[_builtins.str] = None):
        """
        :param _builtins.str end_time: End time of the maintenance activity
        :param Sequence[_builtins.str] notification_email_ids: (Updatable) The Email IDs given by the customer to get notified about maintenance activities
        :param _builtins.str start_time: Start time of the maintenance activity
        :param _builtins.str state: The current state of the cluster.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if notification_email_ids is not None:
            pulumi.set(__self__, "notification_email_ids", notification_email_ids)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        End time of the maintenance activity
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="notificationEmailIds")
    def notification_email_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        (Updatable) The Email IDs given by the customer to get notified about maintenance activities
        """
        return pulumi.get(self, "notification_email_ids")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        Start time of the maintenance activity
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[_builtins.str]:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class ClusterOutboundClusterConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isEnabled":
            suggest = "is_enabled"
        elif key == "outboundClusters":
            suggest = "outbound_clusters"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOutboundClusterConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOutboundClusterConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOutboundClusterConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_enabled: _builtins.bool,
                 outbound_clusters: Sequence['outputs.ClusterOutboundClusterConfigOutboundCluster']):
        """
        :param _builtins.bool is_enabled: (Updatable) Flag to indicate whether outbound cluster configuration is enabled
        :param Sequence['ClusterOutboundClusterConfigOutboundClusterArgs'] outbound_clusters: (Updatable) List of outbound clusters to be connected to the inbound cluster
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "outbound_clusters", outbound_clusters)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        (Updatable) Flag to indicate whether outbound cluster configuration is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="outboundClusters")
    def outbound_clusters(self) -> Sequence['outputs.ClusterOutboundClusterConfigOutboundCluster']:
        """
        (Updatable) List of outbound clusters to be connected to the inbound cluster
        """
        return pulumi.get(self, "outbound_clusters")


@pulumi.output_type
class ClusterOutboundClusterConfigOutboundCluster(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "displayName":
            suggest = "display_name"
        elif key == "seedClusterId":
            suggest = "seed_cluster_id"
        elif key == "isSkipUnavailable":
            suggest = "is_skip_unavailable"
        elif key == "pingSchedule":
            suggest = "ping_schedule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOutboundClusterConfigOutboundCluster. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOutboundClusterConfigOutboundCluster.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOutboundClusterConfigOutboundCluster.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 display_name: _builtins.str,
                 seed_cluster_id: _builtins.str,
                 is_skip_unavailable: Optional[_builtins.bool] = None,
                 mode: Optional[_builtins.str] = None,
                 ping_schedule: Optional[_builtins.str] = None):
        """
        :param _builtins.str display_name: (Updatable) Name of the Outbound cluster. Avoid entering confidential information.
        :param _builtins.str seed_cluster_id: (Updatable) OCID of the Outbound cluster
        :param _builtins.bool is_skip_unavailable: (Updatable) Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        :param _builtins.str mode: (Updatable) Mode for the cross cluster connection
        :param _builtins.str ping_schedule: (Updatable) Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "seed_cluster_id", seed_cluster_id)
        if is_skip_unavailable is not None:
            pulumi.set(__self__, "is_skip_unavailable", is_skip_unavailable)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if ping_schedule is not None:
            pulumi.set(__self__, "ping_schedule", ping_schedule)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        (Updatable) Name of the Outbound cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="seedClusterId")
    def seed_cluster_id(self) -> _builtins.str:
        """
        (Updatable) OCID of the Outbound cluster
        """
        return pulumi.get(self, "seed_cluster_id")

    @_builtins.property
    @pulumi.getter(name="isSkipUnavailable")
    def is_skip_unavailable(self) -> Optional[_builtins.bool]:
        """
        (Updatable) Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        """
        return pulumi.get(self, "is_skip_unavailable")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> Optional[_builtins.str]:
        """
        (Updatable) Mode for the cross cluster connection
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="pingSchedule")
    def ping_schedule(self) -> Optional[_builtins.str]:
        """
        (Updatable) Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
        return pulumi.get(self, "ping_schedule")


@pulumi.output_type
class ClusterReverseConnectionEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerIp":
            suggest = "customer_ip"
        elif key == "natIp":
            suggest = "nat_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterReverseConnectionEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterReverseConnectionEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterReverseConnectionEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_ip: Optional[_builtins.str] = None,
                 nat_ip: Optional[_builtins.str] = None):
        """
        :param _builtins.str customer_ip: The IP addresses of the endpoint in customer VCN
        :param _builtins.str nat_ip: The NAT IP addresses of the endpoint in service VCN
        """
        if customer_ip is not None:
            pulumi.set(__self__, "customer_ip", customer_ip)
        if nat_ip is not None:
            pulumi.set(__self__, "nat_ip", nat_ip)

    @_builtins.property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> Optional[_builtins.str]:
        """
        The IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "customer_ip")

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> Optional[_builtins.str]:
        """
        The NAT IP addresses of the endpoint in service VCN
        """
        return pulumi.get(self, "nat_ip")


@pulumi.output_type
class ClusterSecuritySamlConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "idpEntityId":
            suggest = "idp_entity_id"
        elif key == "idpMetadataContent":
            suggest = "idp_metadata_content"
        elif key == "isEnabled":
            suggest = "is_enabled"
        elif key == "adminBackendRole":
            suggest = "admin_backend_role"
        elif key == "opendashboardUrl":
            suggest = "opendashboard_url"
        elif key == "rolesKey":
            suggest = "roles_key"
        elif key == "subjectKey":
            suggest = "subject_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSecuritySamlConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSecuritySamlConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSecuritySamlConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 idp_entity_id: _builtins.str,
                 idp_metadata_content: _builtins.str,
                 is_enabled: _builtins.bool,
                 admin_backend_role: Optional[_builtins.str] = None,
                 opendashboard_url: Optional[_builtins.str] = None,
                 roles_key: Optional[_builtins.str] = None,
                 subject_key: Optional[_builtins.str] = None):
        """
        :param _builtins.str idp_entity_id: The unique name for a identity provider entity
        :param _builtins.str idp_metadata_content: The content of identity provider metadata
        :param _builtins.bool is_enabled: A flag determine whether SAML is enabled
        :param _builtins.str admin_backend_role: The backend role of admins who have all permissions like local master user
        :param _builtins.str opendashboard_url: The endpoint of opendashboard
        :param _builtins.str roles_key: The roles key is sued to get backend roles from SAML assertion
        :param _builtins.str subject_key: The subject key is used to get username from SAML assertion. By default, it is NameID
        """
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "idp_metadata_content", idp_metadata_content)
        pulumi.set(__self__, "is_enabled", is_enabled)
        if admin_backend_role is not None:
            pulumi.set(__self__, "admin_backend_role", admin_backend_role)
        if opendashboard_url is not None:
            pulumi.set(__self__, "opendashboard_url", opendashboard_url)
        if roles_key is not None:
            pulumi.set(__self__, "roles_key", roles_key)
        if subject_key is not None:
            pulumi.set(__self__, "subject_key", subject_key)

    @_builtins.property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> _builtins.str:
        """
        The unique name for a identity provider entity
        """
        return pulumi.get(self, "idp_entity_id")

    @_builtins.property
    @pulumi.getter(name="idpMetadataContent")
    def idp_metadata_content(self) -> _builtins.str:
        """
        The content of identity provider metadata
        """
        return pulumi.get(self, "idp_metadata_content")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        A flag determine whether SAML is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="adminBackendRole")
    def admin_backend_role(self) -> Optional[_builtins.str]:
        """
        The backend role of admins who have all permissions like local master user
        """
        return pulumi.get(self, "admin_backend_role")

    @_builtins.property
    @pulumi.getter(name="opendashboardUrl")
    def opendashboard_url(self) -> Optional[_builtins.str]:
        """
        The endpoint of opendashboard
        """
        return pulumi.get(self, "opendashboard_url")

    @_builtins.property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> Optional[_builtins.str]:
        """
        The roles key is sued to get backend roles from SAML assertion
        """
        return pulumi.get(self, "roles_key")

    @_builtins.property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> Optional[_builtins.str]:
        """
        The subject key is used to get username from SAML assertion. By default, it is NameID
        """
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class OpensearchClusterPipelineReverseConnectionEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customerFqdn":
            suggest = "customer_fqdn"
        elif key == "customerIp":
            suggest = "customer_ip"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OpensearchClusterPipelineReverseConnectionEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OpensearchClusterPipelineReverseConnectionEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OpensearchClusterPipelineReverseConnectionEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 customer_fqdn: _builtins.str,
                 customer_ip: _builtins.str):
        """
        :param _builtins.str customer_fqdn: (Updatable) The fully qualified domain name of the customerIp in the customer VCN
        :param _builtins.str customer_ip: (Updatable) The IPv4 address in the customer VCN
        """
        pulumi.set(__self__, "customer_fqdn", customer_fqdn)
        pulumi.set(__self__, "customer_ip", customer_ip)

    @_builtins.property
    @pulumi.getter(name="customerFqdn")
    def customer_fqdn(self) -> _builtins.str:
        """
        (Updatable) The fully qualified domain name of the customerIp in the customer VCN
        """
        return pulumi.get(self, "customer_fqdn")

    @_builtins.property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> _builtins.str:
        """
        (Updatable) The IPv4 address in the customer VCN
        """
        return pulumi.get(self, "customer_ip")


@pulumi.output_type
class GetOpensearchClusterMaintenanceDetailResult(dict):
    def __init__(__self__, *,
                 end_time: _builtins.str,
                 notification_email_ids: Sequence[_builtins.str],
                 start_time: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str end_time: End time of the maintenance activity
        :param Sequence[_builtins.str] notification_email_ids: The Email Ids given the by customer to get notified about maintenance activities
        :param _builtins.str start_time: Start time of the maintenance activity
        :param _builtins.str state: The current state of the cluster.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "notification_email_ids", notification_email_ids)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        End time of the maintenance activity
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="notificationEmailIds")
    def notification_email_ids(self) -> Sequence[_builtins.str]:
        """
        The Email Ids given the by customer to get notified about maintenance activities
        """
        return pulumi.get(self, "notification_email_ids")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Start time of the maintenance activity
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The current state of the cluster.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetOpensearchClusterOutboundClusterConfigResult(dict):
    def __init__(__self__, *,
                 is_enabled: _builtins.bool,
                 outbound_clusters: Sequence['outputs.GetOpensearchClusterOutboundClusterConfigOutboundClusterResult']):
        """
        :param _builtins.bool is_enabled: Flag to indicate whether outbound cluster configuration is enabled
        :param Sequence['GetOpensearchClusterOutboundClusterConfigOutboundClusterArgs'] outbound_clusters: List of outbound clusters to be connected to the inbound cluster
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "outbound_clusters", outbound_clusters)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Flag to indicate whether outbound cluster configuration is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="outboundClusters")
    def outbound_clusters(self) -> Sequence['outputs.GetOpensearchClusterOutboundClusterConfigOutboundClusterResult']:
        """
        List of outbound clusters to be connected to the inbound cluster
        """
        return pulumi.get(self, "outbound_clusters")


@pulumi.output_type
class GetOpensearchClusterOutboundClusterConfigOutboundClusterResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 is_skip_unavailable: _builtins.bool,
                 mode: _builtins.str,
                 ping_schedule: _builtins.str,
                 seed_cluster_id: _builtins.str):
        """
        :param _builtins.str display_name: Name of the Outbound cluster. Avoid entering confidential information.
        :param _builtins.bool is_skip_unavailable: Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        :param _builtins.str mode: Mode for the cross cluster connection
        :param _builtins.str ping_schedule: Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        :param _builtins.str seed_cluster_id: OCID of the Outbound cluster
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_skip_unavailable", is_skip_unavailable)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "ping_schedule", ping_schedule)
        pulumi.set(__self__, "seed_cluster_id", seed_cluster_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        Name of the Outbound cluster. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="isSkipUnavailable")
    def is_skip_unavailable(self) -> _builtins.bool:
        """
        Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        """
        return pulumi.get(self, "is_skip_unavailable")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Mode for the cross cluster connection
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="pingSchedule")
    def ping_schedule(self) -> _builtins.str:
        """
        Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
        return pulumi.get(self, "ping_schedule")

    @_builtins.property
    @pulumi.getter(name="seedClusterId")
    def seed_cluster_id(self) -> _builtins.str:
        """
        OCID of the Outbound cluster
        """
        return pulumi.get(self, "seed_cluster_id")


@pulumi.output_type
class GetOpensearchClusterPipelineReverseConnectionEndpointResult(dict):
    def __init__(__self__, *,
                 customer_fqdn: _builtins.str,
                 customer_ip: _builtins.str):
        """
        :param _builtins.str customer_fqdn: The fully qualified domain name of the customerIp in the customer VCN
        :param _builtins.str customer_ip: The IPv4 address in the customer VCN
        """
        pulumi.set(__self__, "customer_fqdn", customer_fqdn)
        pulumi.set(__self__, "customer_ip", customer_ip)

    @_builtins.property
    @pulumi.getter(name="customerFqdn")
    def customer_fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name of the customerIp in the customer VCN
        """
        return pulumi.get(self, "customer_fqdn")

    @_builtins.property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> _builtins.str:
        """
        The IPv4 address in the customer VCN
        """
        return pulumi.get(self, "customer_ip")


@pulumi.output_type
class GetOpensearchClusterPipelinesFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: _builtins.str,
                 data_prepper_configuration_body: _builtins.str,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 memory_gb: _builtins.int,
                 node_count: _builtins.int,
                 node_shape: _builtins.str,
                 nsg_id: _builtins.str,
                 ocpu_count: _builtins.int,
                 opc_dry_run: _builtins.bool,
                 opensearch_pipeline_fqdn: _builtins.str,
                 opensearch_pipeline_private_ip: _builtins.str,
                 pipeline_configuration_body: _builtins.str,
                 pipeline_mode: _builtins.str,
                 reverse_connection_endpoints: Sequence['outputs.GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemReverseConnectionEndpointResult'],
                 state: _builtins.str,
                 subnet_compartment_id: _builtins.str,
                 subnet_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_updated: _builtins.str,
                 vcn_compartment_id: _builtins.str,
                 vcn_id: _builtins.str):
        """
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param _builtins.str data_prepper_configuration_body: The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: unique OpensearchClusterPipeline identifier
        :param _builtins.int memory_gb: The amount of memory in GB, for each pipeline node.
        :param _builtins.int node_count: The number of nodes configured for the pipeline.
        :param _builtins.str node_shape: The pipeline node shape.
        :param _builtins.str nsg_id: The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        :param _builtins.int ocpu_count: The number of OCPUs configured for each pipeline node.
        :param _builtins.str opensearch_pipeline_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param _builtins.str opensearch_pipeline_private_ip: The pipeline's private IP address.
        :param _builtins.str pipeline_configuration_body: The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        :param _builtins.str pipeline_mode: The current state of the pipeline.
        :param Sequence['GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemReverseConnectionEndpointArgs'] reverse_connection_endpoints: The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        :param _builtins.str state: A filter to return only resources their lifecycleState matches the given lifecycleState.
        :param _builtins.str subnet_compartment_id: The OCID for the compartment where the pipeline's subnet is located.
        :param _builtins.str subnet_id: The OCID of the pipeline's subnet.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        :param _builtins.str time_updated: The amount of time in milliseconds since the pipeline was updated.
        :param _builtins.str vcn_compartment_id: The OCID for the compartment where the pipeline's VCN is located.
        :param _builtins.str vcn_id: The OCID of the pipeline's VCN.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "data_prepper_configuration_body", data_prepper_configuration_body)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "memory_gb", memory_gb)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "node_shape", node_shape)
        pulumi.set(__self__, "nsg_id", nsg_id)
        pulumi.set(__self__, "ocpu_count", ocpu_count)
        pulumi.set(__self__, "opc_dry_run", opc_dry_run)
        pulumi.set(__self__, "opensearch_pipeline_fqdn", opensearch_pipeline_fqdn)
        pulumi.set(__self__, "opensearch_pipeline_private_ip", opensearch_pipeline_private_ip)
        pulumi.set(__self__, "pipeline_configuration_body", pipeline_configuration_body)
        pulumi.set(__self__, "pipeline_mode", pipeline_mode)
        pulumi.set(__self__, "reverse_connection_endpoints", reverse_connection_endpoints)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="dataPrepperConfigurationBody")
    def data_prepper_configuration_body(self) -> _builtins.str:
        """
        The data prepper config in YAML format. The command accepts the data prepper config as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "data_prepper_configuration_body")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        unique OpensearchClusterPipeline identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> _builtins.int:
        """
        The amount of memory in GB, for each pipeline node.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The number of nodes configured for the pipeline.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> _builtins.str:
        """
        The pipeline node shape.
        """
        return pulumi.get(self, "node_shape")

    @_builtins.property
    @pulumi.getter(name="nsgId")
    def nsg_id(self) -> _builtins.str:
        """
        The OCID of the NSG where the pipeline private endpoint vnic will be attached.
        """
        return pulumi.get(self, "nsg_id")

    @_builtins.property
    @pulumi.getter(name="ocpuCount")
    def ocpu_count(self) -> _builtins.int:
        """
        The number of OCPUs configured for each pipeline node.
        """
        return pulumi.get(self, "ocpu_count")

    @_builtins.property
    @pulumi.getter(name="opcDryRun")
    def opc_dry_run(self) -> _builtins.bool:
        return pulumi.get(self, "opc_dry_run")

    @_builtins.property
    @pulumi.getter(name="opensearchPipelineFqdn")
    def opensearch_pipeline_fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_pipeline_fqdn")

    @_builtins.property
    @pulumi.getter(name="opensearchPipelinePrivateIp")
    def opensearch_pipeline_private_ip(self) -> _builtins.str:
        """
        The pipeline's private IP address.
        """
        return pulumi.get(self, "opensearch_pipeline_private_ip")

    @_builtins.property
    @pulumi.getter(name="pipelineConfigurationBody")
    def pipeline_configuration_body(self) -> _builtins.str:
        """
        The pipeline configuration in YAML format. The command accepts the pipeline configuration as a string or within a .yaml file. If you provide the configuration as a string, each new line must be escaped with \\.
        """
        return pulumi.get(self, "pipeline_configuration_body")

    @_builtins.property
    @pulumi.getter(name="pipelineMode")
    def pipeline_mode(self) -> _builtins.str:
        """
        The current state of the pipeline.
        """
        return pulumi.get(self, "pipeline_mode")

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> Sequence['outputs.GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemReverseConnectionEndpointResult']:
        """
        The customer IP and the corresponding fully qualified domain name that the pipeline will connect to.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only resources their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment where the pipeline's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The OCID of the pipeline's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The date and time the cluster pipeline was created. Format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The amount of time in milliseconds since the pipeline was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment where the pipeline's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        The OCID of the pipeline's VCN.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetOpensearchClusterPipelinesOpensearchClusterPipelineCollectionItemReverseConnectionEndpointResult(dict):
    def __init__(__self__, *,
                 customer_fqdn: _builtins.str,
                 customer_ip: _builtins.str):
        """
        :param _builtins.str customer_fqdn: The fully qualified domain name of the customerIp in the customer VCN
        :param _builtins.str customer_ip: The IPv4 address in the customer VCN
        """
        pulumi.set(__self__, "customer_fqdn", customer_fqdn)
        pulumi.set(__self__, "customer_ip", customer_ip)

    @_builtins.property
    @pulumi.getter(name="customerFqdn")
    def customer_fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name of the customerIp in the customer VCN
        """
        return pulumi.get(self, "customer_fqdn")

    @_builtins.property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> _builtins.str:
        """
        The IPv4 address in the customer VCN
        """
        return pulumi.get(self, "customer_ip")


@pulumi.output_type
class GetOpensearchClusterReverseConnectionEndpointResult(dict):
    def __init__(__self__, *,
                 customer_ip: _builtins.str,
                 nat_ip: _builtins.str):
        """
        :param _builtins.str customer_ip: The IP addresses of the endpoint in customer VCN
        :param _builtins.str nat_ip: The NAT IP addresses of the endpoint in service VCN
        """
        pulumi.set(__self__, "customer_ip", customer_ip)
        pulumi.set(__self__, "nat_ip", nat_ip)

    @_builtins.property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> _builtins.str:
        """
        The IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "customer_ip")

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> _builtins.str:
        """
        The NAT IP addresses of the endpoint in service VCN
        """
        return pulumi.get(self, "nat_ip")


@pulumi.output_type
class GetOpensearchClusterSecuritySamlConfigResult(dict):
    def __init__(__self__, *,
                 admin_backend_role: _builtins.str,
                 idp_entity_id: _builtins.str,
                 idp_metadata_content: _builtins.str,
                 is_enabled: _builtins.bool,
                 opendashboard_url: _builtins.str,
                 roles_key: _builtins.str,
                 subject_key: _builtins.str):
        """
        :param _builtins.bool is_enabled: Flag to indicate whether outbound cluster configuration is enabled
        """
        pulumi.set(__self__, "admin_backend_role", admin_backend_role)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "idp_metadata_content", idp_metadata_content)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "opendashboard_url", opendashboard_url)
        pulumi.set(__self__, "roles_key", roles_key)
        pulumi.set(__self__, "subject_key", subject_key)

    @_builtins.property
    @pulumi.getter(name="adminBackendRole")
    def admin_backend_role(self) -> _builtins.str:
        return pulumi.get(self, "admin_backend_role")

    @_builtins.property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> _builtins.str:
        return pulumi.get(self, "idp_entity_id")

    @_builtins.property
    @pulumi.getter(name="idpMetadataContent")
    def idp_metadata_content(self) -> _builtins.str:
        return pulumi.get(self, "idp_metadata_content")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Flag to indicate whether outbound cluster configuration is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="opendashboardUrl")
    def opendashboard_url(self) -> _builtins.str:
        return pulumi.get(self, "opendashboard_url")

    @_builtins.property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> _builtins.str:
        return pulumi.get(self, "roles_key")

    @_builtins.property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> _builtins.str:
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class GetOpensearchClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemResult']):
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionItemResult(dict):
    def __init__(__self__, *,
                 availability_domains: Sequence[_builtins.str],
                 compartment_id: _builtins.str,
                 configure_outbound_cluster_trigger: _builtins.int,
                 data_node_count: _builtins.int,
                 data_node_host_bare_metal_shape: _builtins.str,
                 data_node_host_memory_gb: _builtins.int,
                 data_node_host_ocpu_count: _builtins.int,
                 data_node_host_shape: _builtins.str,
                 data_node_host_type: _builtins.str,
                 data_node_storage_gb: _builtins.int,
                 defined_tags: Mapping[str, _builtins.str],
                 display_name: _builtins.str,
                 fqdn: _builtins.str,
                 freeform_tags: Mapping[str, _builtins.str],
                 id: _builtins.str,
                 inbound_cluster_ids: Sequence[_builtins.str],
                 lifecycle_details: _builtins.str,
                 maintenance_details: Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemMaintenanceDetailResult'],
                 master_node_count: _builtins.int,
                 master_node_host_bare_metal_shape: _builtins.str,
                 master_node_host_memory_gb: _builtins.int,
                 master_node_host_ocpu_count: _builtins.int,
                 master_node_host_shape: _builtins.str,
                 master_node_host_type: _builtins.str,
                 opendashboard_fqdn: _builtins.str,
                 opendashboard_node_count: _builtins.int,
                 opendashboard_node_host_memory_gb: _builtins.int,
                 opendashboard_node_host_ocpu_count: _builtins.int,
                 opendashboard_node_host_shape: _builtins.str,
                 opendashboard_private_ip: _builtins.str,
                 opensearch_fqdn: _builtins.str,
                 opensearch_private_ip: _builtins.str,
                 outbound_cluster_configs: Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigResult'],
                 reverse_connection_endpoint_customer_ips: Sequence[_builtins.str],
                 reverse_connection_endpoints: Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemReverseConnectionEndpointResult'],
                 search_node_count: _builtins.int,
                 search_node_host_memory_gb: _builtins.int,
                 search_node_host_ocpu_count: _builtins.int,
                 search_node_host_shape: _builtins.str,
                 search_node_host_type: _builtins.str,
                 search_node_storage_gb: _builtins.int,
                 security_master_user_name: _builtins.str,
                 security_master_user_password_hash: _builtins.str,
                 security_mode: _builtins.str,
                 security_saml_configs: Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemSecuritySamlConfigResult'],
                 software_version: _builtins.str,
                 state: _builtins.str,
                 subnet_compartment_id: _builtins.str,
                 subnet_id: _builtins.str,
                 system_tags: Mapping[str, _builtins.str],
                 time_created: _builtins.str,
                 time_deleted: _builtins.str,
                 time_updated: _builtins.str,
                 total_storage_gb: _builtins.int,
                 upgrade_major_version_trigger: _builtins.int,
                 vcn_compartment_id: _builtins.str,
                 vcn_id: _builtins.str):
        """
        :param Sequence[_builtins.str] availability_domains: The availability domains to distribute the cluser nodes across.
        :param _builtins.str compartment_id: The ID of the compartment in which to list resources.
        :param _builtins.int data_node_count: The number of data nodes configured for the cluster.
        :param _builtins.str data_node_host_bare_metal_shape: The bare metal shape for the cluster's data nodes.
        :param _builtins.int data_node_host_memory_gb: The amount of memory in GB, for the cluster's data nodes.
        :param _builtins.int data_node_host_ocpu_count: The number of OCPUs configured for the cluster's data nodes.
        :param _builtins.str data_node_host_shape: The node shape for the cluster's data nodes.
        :param _builtins.str data_node_host_type: The instance type for the cluster's data nodes.
        :param _builtins.int data_node_storage_gb: The amount of storage in GB, to configure per node for the cluster's data nodes.
        :param Mapping[str, _builtins.str] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.str fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param Mapping[str, _builtins.str] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param _builtins.str id: unique OpensearchCluster identifier
        :param Sequence[_builtins.str] inbound_cluster_ids: List of inbound clusters for which this cluster is an outbound cluster
        :param _builtins.str lifecycle_details: Additional information about the current lifecycle state of the cluster.
        :param Sequence['GetOpensearchClustersOpensearchClusterCollectionItemMaintenanceDetailArgs'] maintenance_details: Details for the maintenance activity.
        :param _builtins.int master_node_count: The number of master nodes configured for the cluster.
        :param _builtins.str master_node_host_bare_metal_shape: The bare metal shape for the cluster's master nodes.
        :param _builtins.int master_node_host_memory_gb: The amount of memory in GB, for the cluster's master nodes.
        :param _builtins.int master_node_host_ocpu_count: The number of OCPUs configured for cluster's master nodes.
        :param _builtins.str master_node_host_shape: The node shape for the cluster's master nodes.
        :param _builtins.str master_node_host_type: The instance type for the cluster's master nodes.
        :param _builtins.str opendashboard_fqdn: The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        :param _builtins.int opendashboard_node_count: The number of OpenSearch Dashboard nodes configured for the cluster.
        :param _builtins.int opendashboard_node_host_memory_gb: The amount of memory in GB, for the cluster's OpenSearch Dashboard nodes.
        :param _builtins.int opendashboard_node_host_ocpu_count: The amount of memory in GB, for the cluster's OpenSearch Dashboard nodes.
        :param _builtins.str opendashboard_node_host_shape: The node shape for the cluster's OpenSearch Dashboard nodes.
        :param _builtins.str opendashboard_private_ip: The private IP address for the cluster's OpenSearch Dashboard.
        :param _builtins.str opensearch_fqdn: The fully qualified domain name (FQDN) for the cluster's API endpoint.
        :param _builtins.str opensearch_private_ip: The cluster's private IP address.
        :param Sequence['GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigArgs'] outbound_cluster_configs: This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        :param Sequence[_builtins.str] reverse_connection_endpoint_customer_ips: The customer IP addresses of the endpoint in customer VCN
        :param Sequence['GetOpensearchClustersOpensearchClusterCollectionItemReverseConnectionEndpointArgs'] reverse_connection_endpoints: The list of reverse connection endpoints.
        :param _builtins.int search_node_count: The number of search nodes configured for the cluster.
        :param _builtins.int search_node_host_memory_gb: The amount of memory in GB, for the cluster's search nodes.
        :param _builtins.int search_node_host_ocpu_count: The number of OCPUs configured for the cluster's search nodes.
        :param _builtins.str search_node_host_shape: The node shape for the cluster's search nodes.
        :param _builtins.str search_node_host_type: The instance type for the cluster's search nodes.
        :param _builtins.int search_node_storage_gb: The amount of storage in GB, to configure per node for the cluster's search nodes.
        :param _builtins.str security_master_user_name: The name of the master user that are used to manage security config
        :param _builtins.str security_master_user_password_hash: The password hash of the master user that are used to manage security config
        :param _builtins.str security_mode: The security mode of the cluster.
        :param _builtins.str software_version: The software version the cluster is running.
        :param _builtins.str state: A filter to return only OpensearchClusters their lifecycleState matches the given lifecycleState.
        :param _builtins.str subnet_compartment_id: The OCID for the compartment where the cluster's subnet is located.
        :param _builtins.str subnet_id: The OCID of the cluster's subnet.
        :param Mapping[str, _builtins.str] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param _builtins.str time_created: The amount of time in milliseconds since the cluster was created.
        :param _builtins.str time_deleted: The amount of time in milliseconds since the cluster was updated.
        :param _builtins.str time_updated: The amount of time in milliseconds since the cluster was updated.
        :param _builtins.int total_storage_gb: The size in GB of the cluster's total storage.
        :param _builtins.str vcn_compartment_id: The OCID for the compartment where the cluster's VCN is located.
        :param _builtins.str vcn_id: The OCID of the cluster's VCN.
        """
        pulumi.set(__self__, "availability_domains", availability_domains)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "configure_outbound_cluster_trigger", configure_outbound_cluster_trigger)
        pulumi.set(__self__, "data_node_count", data_node_count)
        pulumi.set(__self__, "data_node_host_bare_metal_shape", data_node_host_bare_metal_shape)
        pulumi.set(__self__, "data_node_host_memory_gb", data_node_host_memory_gb)
        pulumi.set(__self__, "data_node_host_ocpu_count", data_node_host_ocpu_count)
        pulumi.set(__self__, "data_node_host_shape", data_node_host_shape)
        pulumi.set(__self__, "data_node_host_type", data_node_host_type)
        pulumi.set(__self__, "data_node_storage_gb", data_node_storage_gb)
        pulumi.set(__self__, "defined_tags", defined_tags)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "fqdn", fqdn)
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inbound_cluster_ids", inbound_cluster_ids)
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        pulumi.set(__self__, "maintenance_details", maintenance_details)
        pulumi.set(__self__, "master_node_count", master_node_count)
        pulumi.set(__self__, "master_node_host_bare_metal_shape", master_node_host_bare_metal_shape)
        pulumi.set(__self__, "master_node_host_memory_gb", master_node_host_memory_gb)
        pulumi.set(__self__, "master_node_host_ocpu_count", master_node_host_ocpu_count)
        pulumi.set(__self__, "master_node_host_shape", master_node_host_shape)
        pulumi.set(__self__, "master_node_host_type", master_node_host_type)
        pulumi.set(__self__, "opendashboard_fqdn", opendashboard_fqdn)
        pulumi.set(__self__, "opendashboard_node_count", opendashboard_node_count)
        pulumi.set(__self__, "opendashboard_node_host_memory_gb", opendashboard_node_host_memory_gb)
        pulumi.set(__self__, "opendashboard_node_host_ocpu_count", opendashboard_node_host_ocpu_count)
        pulumi.set(__self__, "opendashboard_node_host_shape", opendashboard_node_host_shape)
        pulumi.set(__self__, "opendashboard_private_ip", opendashboard_private_ip)
        pulumi.set(__self__, "opensearch_fqdn", opensearch_fqdn)
        pulumi.set(__self__, "opensearch_private_ip", opensearch_private_ip)
        pulumi.set(__self__, "outbound_cluster_configs", outbound_cluster_configs)
        pulumi.set(__self__, "reverse_connection_endpoint_customer_ips", reverse_connection_endpoint_customer_ips)
        pulumi.set(__self__, "reverse_connection_endpoints", reverse_connection_endpoints)
        pulumi.set(__self__, "search_node_count", search_node_count)
        pulumi.set(__self__, "search_node_host_memory_gb", search_node_host_memory_gb)
        pulumi.set(__self__, "search_node_host_ocpu_count", search_node_host_ocpu_count)
        pulumi.set(__self__, "search_node_host_shape", search_node_host_shape)
        pulumi.set(__self__, "search_node_host_type", search_node_host_type)
        pulumi.set(__self__, "search_node_storage_gb", search_node_storage_gb)
        pulumi.set(__self__, "security_master_user_name", security_master_user_name)
        pulumi.set(__self__, "security_master_user_password_hash", security_master_user_password_hash)
        pulumi.set(__self__, "security_mode", security_mode)
        pulumi.set(__self__, "security_saml_configs", security_saml_configs)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "subnet_compartment_id", subnet_compartment_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "system_tags", system_tags)
        pulumi.set(__self__, "time_created", time_created)
        pulumi.set(__self__, "time_deleted", time_deleted)
        pulumi.set(__self__, "time_updated", time_updated)
        pulumi.set(__self__, "total_storage_gb", total_storage_gb)
        pulumi.set(__self__, "upgrade_major_version_trigger", upgrade_major_version_trigger)
        pulumi.set(__self__, "vcn_compartment_id", vcn_compartment_id)
        pulumi.set(__self__, "vcn_id", vcn_id)

    @_builtins.property
    @pulumi.getter(name="availabilityDomains")
    def availability_domains(self) -> Sequence[_builtins.str]:
        """
        The availability domains to distribute the cluser nodes across.
        """
        return pulumi.get(self, "availability_domains")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> _builtins.str:
        """
        The ID of the compartment in which to list resources.
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter(name="configureOutboundClusterTrigger")
    def configure_outbound_cluster_trigger(self) -> _builtins.int:
        return pulumi.get(self, "configure_outbound_cluster_trigger")

    @_builtins.property
    @pulumi.getter(name="dataNodeCount")
    def data_node_count(self) -> _builtins.int:
        """
        The number of data nodes configured for the cluster.
        """
        return pulumi.get(self, "data_node_count")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostBareMetalShape")
    def data_node_host_bare_metal_shape(self) -> _builtins.str:
        """
        The bare metal shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_bare_metal_shape")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostMemoryGb")
    def data_node_host_memory_gb(self) -> _builtins.int:
        """
        The amount of memory in GB, for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostOcpuCount")
    def data_node_host_ocpu_count(self) -> _builtins.int:
        """
        The number of OCPUs configured for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostShape")
    def data_node_host_shape(self) -> _builtins.str:
        """
        The node shape for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="dataNodeHostType")
    def data_node_host_type(self) -> _builtins.str:
        """
        The instance type for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_host_type")

    @_builtins.property
    @pulumi.getter(name="dataNodeStorageGb")
    def data_node_storage_gb(self) -> _builtins.int:
        """
        The amount of storage in GB, to configure per node for the cluster's data nodes.
        """
        return pulumi.get(self, "data_node_storage_gb")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, _builtins.str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, _builtins.str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        unique OpensearchCluster identifier
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="inboundClusterIds")
    def inbound_cluster_ids(self) -> Sequence[_builtins.str]:
        """
        List of inbound clusters for which this cluster is an outbound cluster
        """
        return pulumi.get(self, "inbound_cluster_ids")

    @_builtins.property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> _builtins.str:
        """
        Additional information about the current lifecycle state of the cluster.
        """
        return pulumi.get(self, "lifecycle_details")

    @_builtins.property
    @pulumi.getter(name="maintenanceDetails")
    def maintenance_details(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemMaintenanceDetailResult']:
        """
        Details for the maintenance activity.
        """
        return pulumi.get(self, "maintenance_details")

    @_builtins.property
    @pulumi.getter(name="masterNodeCount")
    def master_node_count(self) -> _builtins.int:
        """
        The number of master nodes configured for the cluster.
        """
        return pulumi.get(self, "master_node_count")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostBareMetalShape")
    def master_node_host_bare_metal_shape(self) -> _builtins.str:
        """
        The bare metal shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_bare_metal_shape")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostMemoryGb")
    def master_node_host_memory_gb(self) -> _builtins.int:
        """
        The amount of memory in GB, for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostOcpuCount")
    def master_node_host_ocpu_count(self) -> _builtins.int:
        """
        The number of OCPUs configured for cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostShape")
    def master_node_host_shape(self) -> _builtins.str:
        """
        The node shape for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="masterNodeHostType")
    def master_node_host_type(self) -> _builtins.str:
        """
        The instance type for the cluster's master nodes.
        """
        return pulumi.get(self, "master_node_host_type")

    @_builtins.property
    @pulumi.getter(name="opendashboardFqdn")
    def opendashboard_fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name (FQDN) for the cluster's OpenSearch Dashboard API endpoint.
        """
        return pulumi.get(self, "opendashboard_fqdn")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeCount")
    def opendashboard_node_count(self) -> _builtins.int:
        """
        The number of OpenSearch Dashboard nodes configured for the cluster.
        """
        return pulumi.get(self, "opendashboard_node_count")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostMemoryGb")
    def opendashboard_node_host_memory_gb(self) -> _builtins.int:
        """
        The amount of memory in GB, for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostOcpuCount")
    def opendashboard_node_host_ocpu_count(self) -> _builtins.int:
        """
        The amount of memory in GB, for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="opendashboardNodeHostShape")
    def opendashboard_node_host_shape(self) -> _builtins.str:
        """
        The node shape for the cluster's OpenSearch Dashboard nodes.
        """
        return pulumi.get(self, "opendashboard_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="opendashboardPrivateIp")
    def opendashboard_private_ip(self) -> _builtins.str:
        """
        The private IP address for the cluster's OpenSearch Dashboard.
        """
        return pulumi.get(self, "opendashboard_private_ip")

    @_builtins.property
    @pulumi.getter(name="opensearchFqdn")
    def opensearch_fqdn(self) -> _builtins.str:
        """
        The fully qualified domain name (FQDN) for the cluster's API endpoint.
        """
        return pulumi.get(self, "opensearch_fqdn")

    @_builtins.property
    @pulumi.getter(name="opensearchPrivateIp")
    def opensearch_private_ip(self) -> _builtins.str:
        """
        The cluster's private IP address.
        """
        return pulumi.get(self, "opensearch_private_ip")

    @_builtins.property
    @pulumi.getter(name="outboundClusterConfigs")
    def outbound_cluster_configs(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigResult']:
        """
        This configuration is used for passing request details to connect outbound cluster(s) to the inbound cluster (coordinating cluster)
        """
        return pulumi.get(self, "outbound_cluster_configs")

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpointCustomerIps")
    def reverse_connection_endpoint_customer_ips(self) -> Sequence[_builtins.str]:
        """
        The customer IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "reverse_connection_endpoint_customer_ips")

    @_builtins.property
    @pulumi.getter(name="reverseConnectionEndpoints")
    def reverse_connection_endpoints(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemReverseConnectionEndpointResult']:
        """
        The list of reverse connection endpoints.
        """
        return pulumi.get(self, "reverse_connection_endpoints")

    @_builtins.property
    @pulumi.getter(name="searchNodeCount")
    def search_node_count(self) -> _builtins.int:
        """
        The number of search nodes configured for the cluster.
        """
        return pulumi.get(self, "search_node_count")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostMemoryGb")
    def search_node_host_memory_gb(self) -> _builtins.int:
        """
        The amount of memory in GB, for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_memory_gb")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostOcpuCount")
    def search_node_host_ocpu_count(self) -> _builtins.int:
        """
        The number of OCPUs configured for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_ocpu_count")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostShape")
    def search_node_host_shape(self) -> _builtins.str:
        """
        The node shape for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_shape")

    @_builtins.property
    @pulumi.getter(name="searchNodeHostType")
    def search_node_host_type(self) -> _builtins.str:
        """
        The instance type for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_host_type")

    @_builtins.property
    @pulumi.getter(name="searchNodeStorageGb")
    def search_node_storage_gb(self) -> _builtins.int:
        """
        The amount of storage in GB, to configure per node for the cluster's search nodes.
        """
        return pulumi.get(self, "search_node_storage_gb")

    @_builtins.property
    @pulumi.getter(name="securityMasterUserName")
    def security_master_user_name(self) -> _builtins.str:
        """
        The name of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_name")

    @_builtins.property
    @pulumi.getter(name="securityMasterUserPasswordHash")
    def security_master_user_password_hash(self) -> _builtins.str:
        """
        The password hash of the master user that are used to manage security config
        """
        return pulumi.get(self, "security_master_user_password_hash")

    @_builtins.property
    @pulumi.getter(name="securityMode")
    def security_mode(self) -> _builtins.str:
        """
        The security mode of the cluster.
        """
        return pulumi.get(self, "security_mode")

    @_builtins.property
    @pulumi.getter(name="securitySamlConfigs")
    def security_saml_configs(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemSecuritySamlConfigResult']:
        return pulumi.get(self, "security_saml_configs")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> _builtins.str:
        """
        The software version the cluster is running.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only OpensearchClusters their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subnetCompartmentId")
    def subnet_compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment where the cluster's subnet is located.
        """
        return pulumi.get(self, "subnet_compartment_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The OCID of the cluster's subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, _builtins.str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> _builtins.str:
        """
        The amount of time in milliseconds since the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> _builtins.str:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_deleted")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> _builtins.str:
        """
        The amount of time in milliseconds since the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter(name="totalStorageGb")
    def total_storage_gb(self) -> _builtins.int:
        """
        The size in GB of the cluster's total storage.
        """
        return pulumi.get(self, "total_storage_gb")

    @_builtins.property
    @pulumi.getter(name="upgradeMajorVersionTrigger")
    def upgrade_major_version_trigger(self) -> _builtins.int:
        return pulumi.get(self, "upgrade_major_version_trigger")

    @_builtins.property
    @pulumi.getter(name="vcnCompartmentId")
    def vcn_compartment_id(self) -> _builtins.str:
        """
        The OCID for the compartment where the cluster's VCN is located.
        """
        return pulumi.get(self, "vcn_compartment_id")

    @_builtins.property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> _builtins.str:
        """
        The OCID of the cluster's VCN.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionItemMaintenanceDetailResult(dict):
    def __init__(__self__, *,
                 end_time: _builtins.str,
                 notification_email_ids: Sequence[_builtins.str],
                 start_time: _builtins.str,
                 state: _builtins.str):
        """
        :param _builtins.str end_time: End time of the maintenance activity
        :param Sequence[_builtins.str] notification_email_ids: The Email Ids given the by customer to get notified about maintenance activities
        :param _builtins.str start_time: Start time of the maintenance activity
        :param _builtins.str state: A filter to return only OpensearchClusters their lifecycleState matches the given lifecycleState.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "notification_email_ids", notification_email_ids)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "state", state)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> _builtins.str:
        """
        End time of the maintenance activity
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="notificationEmailIds")
    def notification_email_ids(self) -> Sequence[_builtins.str]:
        """
        The Email Ids given the by customer to get notified about maintenance activities
        """
        return pulumi.get(self, "notification_email_ids")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> _builtins.str:
        """
        Start time of the maintenance activity
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        A filter to return only OpensearchClusters their lifecycleState matches the given lifecycleState.
        """
        return pulumi.get(self, "state")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigResult(dict):
    def __init__(__self__, *,
                 is_enabled: _builtins.bool,
                 outbound_clusters: Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigOutboundClusterResult']):
        """
        :param _builtins.bool is_enabled: Flag to indicate whether outbound cluster configuration is enabled
        :param Sequence['GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigOutboundClusterArgs'] outbound_clusters: List of outbound clusters to be connected to the inbound cluster
        """
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "outbound_clusters", outbound_clusters)

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Flag to indicate whether outbound cluster configuration is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="outboundClusters")
    def outbound_clusters(self) -> Sequence['outputs.GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigOutboundClusterResult']:
        """
        List of outbound clusters to be connected to the inbound cluster
        """
        return pulumi.get(self, "outbound_clusters")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionItemOutboundClusterConfigOutboundClusterResult(dict):
    def __init__(__self__, *,
                 display_name: _builtins.str,
                 is_skip_unavailable: _builtins.bool,
                 mode: _builtins.str,
                 ping_schedule: _builtins.str,
                 seed_cluster_id: _builtins.str):
        """
        :param _builtins.str display_name: A filter to return only resources that match the entire display name given.
        :param _builtins.bool is_skip_unavailable: Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        :param _builtins.str mode: Mode for the cross cluster connection
        :param _builtins.str ping_schedule: Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        :param _builtins.str seed_cluster_id: OCID of the Outbound cluster
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "is_skip_unavailable", is_skip_unavailable)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "ping_schedule", ping_schedule)
        pulumi.set(__self__, "seed_cluster_id", seed_cluster_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        A filter to return only resources that match the entire display name given.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="isSkipUnavailable")
    def is_skip_unavailable(self) -> _builtins.bool:
        """
        Flag to indicate whether to skip the Outbound cluster during cross cluster search, if it is unavailable
        """
        return pulumi.get(self, "is_skip_unavailable")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        Mode for the cross cluster connection
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="pingSchedule")
    def ping_schedule(self) -> _builtins.str:
        """
        Sets the time interval between regular application-level ping messages that are sent to try and keep outbound cluster connections alive. If set to -1, application-level ping messages to this outbound cluster are not sent. If unset, application-level ping messages are sent according to the global transport.ping_schedule setting, which defaults to -1 meaning that pings are not sent.
        """
        return pulumi.get(self, "ping_schedule")

    @_builtins.property
    @pulumi.getter(name="seedClusterId")
    def seed_cluster_id(self) -> _builtins.str:
        """
        OCID of the Outbound cluster
        """
        return pulumi.get(self, "seed_cluster_id")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionItemReverseConnectionEndpointResult(dict):
    def __init__(__self__, *,
                 customer_ip: _builtins.str,
                 nat_ip: _builtins.str):
        """
        :param _builtins.str customer_ip: The IP addresses of the endpoint in customer VCN
        :param _builtins.str nat_ip: The NAT IP addresses of the endpoint in service VCN
        """
        pulumi.set(__self__, "customer_ip", customer_ip)
        pulumi.set(__self__, "nat_ip", nat_ip)

    @_builtins.property
    @pulumi.getter(name="customerIp")
    def customer_ip(self) -> _builtins.str:
        """
        The IP addresses of the endpoint in customer VCN
        """
        return pulumi.get(self, "customer_ip")

    @_builtins.property
    @pulumi.getter(name="natIp")
    def nat_ip(self) -> _builtins.str:
        """
        The NAT IP addresses of the endpoint in service VCN
        """
        return pulumi.get(self, "nat_ip")


@pulumi.output_type
class GetOpensearchClustersOpensearchClusterCollectionItemSecuritySamlConfigResult(dict):
    def __init__(__self__, *,
                 admin_backend_role: _builtins.str,
                 idp_entity_id: _builtins.str,
                 idp_metadata_content: _builtins.str,
                 is_enabled: _builtins.bool,
                 opendashboard_url: _builtins.str,
                 roles_key: _builtins.str,
                 subject_key: _builtins.str):
        """
        :param _builtins.bool is_enabled: Flag to indicate whether outbound cluster configuration is enabled
        """
        pulumi.set(__self__, "admin_backend_role", admin_backend_role)
        pulumi.set(__self__, "idp_entity_id", idp_entity_id)
        pulumi.set(__self__, "idp_metadata_content", idp_metadata_content)
        pulumi.set(__self__, "is_enabled", is_enabled)
        pulumi.set(__self__, "opendashboard_url", opendashboard_url)
        pulumi.set(__self__, "roles_key", roles_key)
        pulumi.set(__self__, "subject_key", subject_key)

    @_builtins.property
    @pulumi.getter(name="adminBackendRole")
    def admin_backend_role(self) -> _builtins.str:
        return pulumi.get(self, "admin_backend_role")

    @_builtins.property
    @pulumi.getter(name="idpEntityId")
    def idp_entity_id(self) -> _builtins.str:
        return pulumi.get(self, "idp_entity_id")

    @_builtins.property
    @pulumi.getter(name="idpMetadataContent")
    def idp_metadata_content(self) -> _builtins.str:
        return pulumi.get(self, "idp_metadata_content")

    @_builtins.property
    @pulumi.getter(name="isEnabled")
    def is_enabled(self) -> _builtins.bool:
        """
        Flag to indicate whether outbound cluster configuration is enabled
        """
        return pulumi.get(self, "is_enabled")

    @_builtins.property
    @pulumi.getter(name="opendashboardUrl")
    def opendashboard_url(self) -> _builtins.str:
        return pulumi.get(self, "opendashboard_url")

    @_builtins.property
    @pulumi.getter(name="rolesKey")
    def roles_key(self) -> _builtins.str:
        return pulumi.get(self, "roles_key")

    @_builtins.property
    @pulumi.getter(name="subjectKey")
    def subject_key(self) -> _builtins.str:
        return pulumi.get(self, "subject_key")


@pulumi.output_type
class GetOpensearchVersionItemResult(dict):
    def __init__(__self__, *,
                 version: _builtins.str):
        """
        :param _builtins.str version: The version of OpenSearch.
        """
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of OpenSearch.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetOpensearchVersionsFilterResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 regex: Optional[_builtins.bool] = None):
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def regex(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetOpensearchVersionsOpensearchVersionsCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetOpensearchVersionsOpensearchVersionsCollectionItemResult']):
        """
        :param Sequence['GetOpensearchVersionsOpensearchVersionsCollectionItemArgs'] items: A list of OpenSearch versions.
        """
        pulumi.set(__self__, "items", items)

    @_builtins.property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetOpensearchVersionsOpensearchVersionsCollectionItemResult']:
        """
        A list of OpenSearch versions.
        """
        return pulumi.get(self, "items")


@pulumi.output_type
class GetOpensearchVersionsOpensearchVersionsCollectionItemResult(dict):
    def __init__(__self__, *,
                 version: _builtins.str):
        """
        :param _builtins.str version: The version of OpenSearch.
        """
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The version of OpenSearch.
        """
        return pulumi.get(self, "version")


