# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RedisClusterCreateIdentityTokenArgs', 'RedisClusterCreateIdentityToken']

@pulumi.input_type
class RedisClusterCreateIdentityTokenArgs:
    def __init__(__self__, *,
                 public_key: pulumi.Input[_builtins.str],
                 redis_cluster_id: pulumi.Input[_builtins.str],
                 redis_user: pulumi.Input[_builtins.str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RedisClusterCreateIdentityToken resource.
        :param pulumi.Input[_builtins.str] public_key: User public key pair
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        :param pulumi.Input[_builtins.str] redis_user: Redis User generating identity token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)
        pulumi.set(__self__, "redis_user", redis_user)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Input[_builtins.str]:
        """
        User public key pair
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "redis_cluster_id")

    @redis_cluster_id.setter
    def redis_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "redis_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="redisUser")
    def redis_user(self) -> pulumi.Input[_builtins.str]:
        """
        Redis User generating identity token.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "redis_user")

    @redis_user.setter
    def redis_user(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "redis_user", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _RedisClusterCreateIdentityTokenState:
    def __init__(__self__, *,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 identity_token: Optional[pulumi.Input[_builtins.str]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_user: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering RedisClusterCreateIdentityToken resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] identity_token: Generated Identity token
        :param pulumi.Input[_builtins.str] public_key: User public key pair
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        :param pulumi.Input[_builtins.str] redis_user: Redis User generating identity token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if identity_token is not None:
            pulumi.set(__self__, "identity_token", identity_token)
        if public_key is not None:
            pulumi.set(__self__, "public_key", public_key)
        if redis_cluster_id is not None:
            pulumi.set(__self__, "redis_cluster_id", redis_cluster_id)
        if redis_user is not None:
            pulumi.set(__self__, "redis_user", redis_user)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="identityToken")
    def identity_token(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generated Identity token
        """
        return pulumi.get(self, "identity_token")

    @identity_token.setter
    def identity_token(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_token", value)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        User public key pair
        """
        return pulumi.get(self, "public_key")

    @public_key.setter
    def public_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_key", value)

    @_builtins.property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "redis_cluster_id")

    @redis_cluster_id.setter
    def redis_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="redisUser")
    def redis_user(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Redis User generating identity token.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "redis_user")

    @redis_user.setter
    def redis_user(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "redis_user", value)


@pulumi.type_token("oci:Redis/redisClusterCreateIdentityToken:RedisClusterCreateIdentityToken")
class RedisClusterCreateIdentityToken(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Redis Cluster Create Identity Token resource in Oracle Cloud Infrastructure Redis service.

        Generates an identity token to sign in with the specified redis user for the redis cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_redis_cluster_create_identity_token = oci.redis.RedisClusterCreateIdentityToken("test_redis_cluster_create_identity_token",
            public_key=redis_cluster_create_identity_token_public_key,
            redis_cluster_id=test_redis_cluster["id"],
            redis_user=redis_cluster_create_identity_token_redis_user,
            defined_tags=redis_cluster_create_identity_token_defined_tags,
            freeform_tags=redis_cluster_create_identity_token_freeform_tags)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] public_key: User public key pair
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        :param pulumi.Input[_builtins.str] redis_user: Redis User generating identity token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RedisClusterCreateIdentityTokenArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Redis Cluster Create Identity Token resource in Oracle Cloud Infrastructure Redis service.

        Generates an identity token to sign in with the specified redis user for the redis cluster

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_redis_cluster_create_identity_token = oci.redis.RedisClusterCreateIdentityToken("test_redis_cluster_create_identity_token",
            public_key=redis_cluster_create_identity_token_public_key,
            redis_cluster_id=test_redis_cluster["id"],
            redis_user=redis_cluster_create_identity_token_redis_user,
            defined_tags=redis_cluster_create_identity_token_defined_tags,
            freeform_tags=redis_cluster_create_identity_token_freeform_tags)
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param RedisClusterCreateIdentityTokenArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RedisClusterCreateIdentityTokenArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 public_key: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 redis_user: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RedisClusterCreateIdentityTokenArgs.__new__(RedisClusterCreateIdentityTokenArgs)

            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            if public_key is None and not opts.urn:
                raise TypeError("Missing required property 'public_key'")
            __props__.__dict__["public_key"] = public_key
            if redis_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'redis_cluster_id'")
            __props__.__dict__["redis_cluster_id"] = redis_cluster_id
            if redis_user is None and not opts.urn:
                raise TypeError("Missing required property 'redis_user'")
            __props__.__dict__["redis_user"] = redis_user
            __props__.__dict__["identity_token"] = None
        super(RedisClusterCreateIdentityToken, __self__).__init__(
            'oci:Redis/redisClusterCreateIdentityToken:RedisClusterCreateIdentityToken',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            identity_token: Optional[pulumi.Input[_builtins.str]] = None,
            public_key: Optional[pulumi.Input[_builtins.str]] = None,
            redis_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            redis_user: Optional[pulumi.Input[_builtins.str]] = None) -> 'RedisClusterCreateIdentityToken':
        """
        Get an existing RedisClusterCreateIdentityToken resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] identity_token: Generated Identity token
        :param pulumi.Input[_builtins.str] public_key: User public key pair
        :param pulumi.Input[_builtins.str] redis_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        :param pulumi.Input[_builtins.str] redis_user: Redis User generating identity token.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RedisClusterCreateIdentityTokenState.__new__(_RedisClusterCreateIdentityTokenState)

        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["identity_token"] = identity_token
        __props__.__dict__["public_key"] = public_key
        __props__.__dict__["redis_cluster_id"] = redis_cluster_id
        __props__.__dict__["redis_user"] = redis_user
        return RedisClusterCreateIdentityToken(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="identityToken")
    def identity_token(self) -> pulumi.Output[_builtins.str]:
        """
        Generated Identity token
        """
        return pulumi.get(self, "identity_token")

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> pulumi.Output[_builtins.str]:
        """
        User public key pair
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter(name="redisClusterId")
    def redis_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm#Oracle) of the cluster.
        """
        return pulumi.get(self, "redis_cluster_id")

    @_builtins.property
    @pulumi.getter(name="redisUser")
    def redis_user(self) -> pulumi.Output[_builtins.str]:
        """
        Redis User generating identity token.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "redis_user")

