# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MonitoredResourceArgs', 'MonitoredResource']

@pulumi.input_type
class MonitoredResourceArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]] = None,
                 aliases: Optional[pulumi.Input['MonitoredResourceAliasesArgs']] = None,
                 credentials: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']] = None,
                 database_connection_details: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MonitoredResource resource.
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input['MonitoredResourceAliasesArgs'] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input['MonitoredResourceCredentialsArgs'] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs'] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[_builtins.str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[_builtins.str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[_builtins.str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[_builtins.str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "type", type)
        if additional_aliases is not None:
            pulumi.set(__self__, "additional_aliases", additional_aliases)
        if additional_credentials is not None:
            pulumi.set(__self__, "additional_credentials", additional_credentials)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_connection_details is not None:
            pulumi.set(__self__, "database_connection_details", database_connection_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_resource_id is not None:
            pulumi.set(__self__, "external_resource_id", external_resource_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_time_zone is not None:
            pulumi.set(__self__, "resource_time_zone", resource_time_zone)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[_builtins.str]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="additionalAliases")
    def additional_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]:
        """
        (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        """
        return pulumi.get(self, "additional_aliases")

    @additional_aliases.setter
    def additional_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]):
        pulumi.set(self, "additional_aliases", value)

    @_builtins.property
    @pulumi.getter(name="additionalCredentials")
    def additional_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]:
        """
        (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        """
        return pulumi.get(self, "additional_credentials")

    @additional_credentials.setter
    def additional_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]):
        pulumi.set(self, "additional_credentials", value)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input['MonitoredResourceAliasesArgs']]:
        """
        (Updatable) Monitored Resource Alias Credential Details
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input['MonitoredResourceAliasesArgs']]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]:
        """
        (Updatable) Monitored Resource Credential Details.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="databaseConnectionDetails")
    def database_connection_details(self) -> Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]:
        """
        (Updatable) Connection details for the database.
        """
        return pulumi.get(self, "database_connection_details")

    @database_connection_details.setter
    def database_connection_details(self, value: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]):
        pulumi.set(self, "database_connection_details", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="externalResourceId")
    def external_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        """
        return pulumi.get(self, "external_resource_id")

    @external_resource_id.setter
    def external_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Host name of the monitored resource.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @resource_time_zone.setter
    def resource_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_time_zone", value)


@pulumi.input_type
class _MonitoredResourceState:
    def __init__(__self__, *,
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]] = None,
                 aliases: Optional[pulumi.Input['MonitoredResourceAliasesArgs']] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']] = None,
                 database_connection_details: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]] = None,
                 resource_category: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 source_type: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 time_created: Optional[pulumi.Input[_builtins.str]] = None,
                 time_updated: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MonitoredResource resources.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input['MonitoredResourceAliasesArgs'] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input['MonitoredResourceCredentialsArgs'] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs'] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[_builtins.str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[_builtins.str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[_builtins.str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[_builtins.str] resource_category: Resource Category to indicate the kind of resource type.
        :param pulumi.Input[_builtins.str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] source_type: Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        :param pulumi.Input[_builtins.str] state: Lifecycle state of the monitored resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] tenant_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] time_created: The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[_builtins.str] time_updated: The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[_builtins.str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if additional_aliases is not None:
            pulumi.set(__self__, "additional_aliases", additional_aliases)
        if additional_credentials is not None:
            pulumi.set(__self__, "additional_credentials", additional_credentials)
        if aliases is not None:
            pulumi.set(__self__, "aliases", aliases)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if credentials is not None:
            pulumi.set(__self__, "credentials", credentials)
        if database_connection_details is not None:
            pulumi.set(__self__, "database_connection_details", database_connection_details)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if external_id is not None:
            pulumi.set(__self__, "external_id", external_id)
        if external_resource_id is not None:
            pulumi.set(__self__, "external_resource_id", external_resource_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if host_name is not None:
            pulumi.set(__self__, "host_name", host_name)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if management_agent_id is not None:
            pulumi.set(__self__, "management_agent_id", management_agent_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if properties is not None:
            pulumi.set(__self__, "properties", properties)
        if resource_category is not None:
            pulumi.set(__self__, "resource_category", resource_category)
        if resource_time_zone is not None:
            pulumi.set(__self__, "resource_time_zone", resource_time_zone)
        if source_type is not None:
            pulumi.set(__self__, "source_type", source_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="additionalAliases")
    def additional_aliases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]:
        """
        (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        """
        return pulumi.get(self, "additional_aliases")

    @additional_aliases.setter
    def additional_aliases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalAliasArgs']]]]):
        pulumi.set(self, "additional_aliases", value)

    @_builtins.property
    @pulumi.getter(name="additionalCredentials")
    def additional_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]:
        """
        (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        """
        return pulumi.get(self, "additional_credentials")

    @additional_credentials.setter
    def additional_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourceAdditionalCredentialArgs']]]]):
        pulumi.set(self, "additional_credentials", value)

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> Optional[pulumi.Input['MonitoredResourceAliasesArgs']]:
        """
        (Updatable) Monitored Resource Alias Credential Details
        """
        return pulumi.get(self, "aliases")

    @aliases.setter
    def aliases(self, value: Optional[pulumi.Input['MonitoredResourceAliasesArgs']]):
        pulumi.set(self, "aliases", value)

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "compartment_id", value)

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]:
        """
        (Updatable) Monitored Resource Credential Details.
        """
        return pulumi.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: Optional[pulumi.Input['MonitoredResourceCredentialsArgs']]):
        pulumi.set(self, "credentials", value)

    @_builtins.property
    @pulumi.getter(name="databaseConnectionDetails")
    def database_connection_details(self) -> Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]:
        """
        (Updatable) Connection details for the database.
        """
        return pulumi.get(self, "database_connection_details")

    @database_connection_details.setter
    def database_connection_details(self, value: Optional[pulumi.Input['MonitoredResourceDatabaseConnectionDetailsArgs']]):
        pulumi.set(self, "database_connection_details", value)

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "defined_tags", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @external_id.setter
    def external_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_id", value)

    @_builtins.property
    @pulumi.getter(name="externalResourceId")
    def external_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        """
        return pulumi.get(self, "external_resource_id")

    @external_resource_id.setter
    def external_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "external_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Host name of the monitored resource.
        """
        return pulumi.get(self, "host_name")

    @host_name.setter
    def host_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "host_name", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "management_agent_id")

    @management_agent_id.setter
    def management_agent_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "management_agent_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def properties(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @properties.setter
    def properties(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MonitoredResourcePropertyArgs']]]]):
        pulumi.set(self, "properties", value)

    @_builtins.property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @resource_category.setter
    def resource_category(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_category", value)

    @_builtins.property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @resource_time_zone.setter
    def resource_time_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_time_zone", value)

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        """
        return pulumi.get(self, "source_type")

    @source_type.setter
    def source_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_type", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Lifecycle state of the monitored resource.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "system_tags", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_created", value)

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_updated", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)


@pulumi.type_token("oci:StackMonitoring/monitoredResource:MonitoredResource")
class MonitoredResource(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalAliasArgs', 'MonitoredResourceAdditionalAliasArgsDict']]]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalCredentialArgs', 'MonitoredResourceAdditionalCredentialArgsDict']]]]] = None,
                 aliases: Optional[pulumi.Input[Union['MonitoredResourceAliasesArgs', 'MonitoredResourceAliasesArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['MonitoredResourceCredentialsArgs', 'MonitoredResourceCredentialsArgsDict']]] = None,
                 database_connection_details: Optional[pulumi.Input[Union['MonitoredResourceDatabaseConnectionDetailsArgs', 'MonitoredResourceDatabaseConnectionDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcePropertyArgs', 'MonitoredResourcePropertyArgsDict']]]]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        This resource provides the Monitored Resource resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitored resource for the given resource type with the details and submits
        a work request for promoting the resource to agent. Once the resource is successfully
        added to agent, resource state will be marked active.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource = oci.stackmonitoring.MonitoredResource("test_monitored_resource",
            compartment_id=compartment_id,
            name=monitored_resource_name,
            type=monitored_resource_type,
            additional_aliases=[{
                "credential": {
                    "name": monitored_resource_additional_aliases_credential_name,
                    "service": monitored_resource_additional_aliases_credential_service,
                    "source": monitored_resource_additional_aliases_credential_source,
                },
                "name": monitored_resource_additional_aliases_name,
                "source": monitored_resource_additional_aliases_source,
            }],
            additional_credentials=[{
                "credential_type": monitored_resource_additional_credentials_credential_type,
                "description": monitored_resource_additional_credentials_description,
                "key_id": test_key["id"],
                "name": monitored_resource_additional_credentials_name,
                "properties": [{
                    "name": monitored_resource_additional_credentials_properties_name,
                    "value": monitored_resource_additional_credentials_properties_value,
                }],
                "source": monitored_resource_additional_credentials_source,
                "type": monitored_resource_additional_credentials_type,
            }],
            aliases={
                "credential": {
                    "name": monitored_resource_aliases_credential_name,
                    "service": monitored_resource_aliases_credential_service,
                    "source": monitored_resource_aliases_credential_source,
                },
                "name": monitored_resource_aliases_name,
                "source": monitored_resource_aliases_source,
            },
            credentials={
                "credential_type": monitored_resource_credentials_credential_type,
                "description": monitored_resource_credentials_description,
                "key_id": monitored_resource_credentials_key_id,
                "name": monitored_resource_credentials_name,
                "properties": [{
                    "name": monitored_resource_credentials_properties_name,
                    "value": monitored_resource_credentials_properties_value,
                }],
                "source": monitored_resource_credentials_source,
                "type": monitored_resource_credentials_type,
            },
            database_connection_details={
                "port": monitored_resource_database_connection_details_port,
                "protocol": monitored_resource_database_connection_details_protocol,
                "service_name": monitored_resource_database_service_name,
                "connector_id": monitored_resource_database_connector_id,
                "db_id": monitored_resource_database_id,
                "db_unique_name": monitored_resource_database_connection_details_db_unique_name,
                "ssl_secret_id": test_secret["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=monitored_resource_display_name,
            external_resource_id=monitored_resource_external_resource_id,
            external_id=test_external["id"],
            freeform_tags={
                "bar-key": "value",
            },
            host_name=monitored_resource_host_name,
            license=monitored_resource_license,
            management_agent_id=test_management_agent["id"],
            properties=[{
                "name": monitored_resource_properties_name,
                "value": monitored_resource_properties_value,
            }],
            resource_time_zone=monitored_resource_resource_time_zone)
        ```

        ## Import

        MonitoredResources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResource:MonitoredResource test_monitored_resource "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalAliasArgs', 'MonitoredResourceAdditionalAliasArgsDict']]]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalCredentialArgs', 'MonitoredResourceAdditionalCredentialArgsDict']]]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input[Union['MonitoredResourceAliasesArgs', 'MonitoredResourceAliasesArgsDict']] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Union['MonitoredResourceCredentialsArgs', 'MonitoredResourceCredentialsArgsDict']] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input[Union['MonitoredResourceDatabaseConnectionDetailsArgs', 'MonitoredResourceDatabaseConnectionDetailsArgsDict']] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[_builtins.str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[_builtins.str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[_builtins.str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcePropertyArgs', 'MonitoredResourcePropertyArgsDict']]]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[_builtins.str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MonitoredResourceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Monitored Resource resource in Oracle Cloud Infrastructure Stack Monitoring service.

        Creates a new monitored resource for the given resource type with the details and submits
        a work request for promoting the resource to agent. Once the resource is successfully
        added to agent, resource state will be marked active.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_monitored_resource = oci.stackmonitoring.MonitoredResource("test_monitored_resource",
            compartment_id=compartment_id,
            name=monitored_resource_name,
            type=monitored_resource_type,
            additional_aliases=[{
                "credential": {
                    "name": monitored_resource_additional_aliases_credential_name,
                    "service": monitored_resource_additional_aliases_credential_service,
                    "source": monitored_resource_additional_aliases_credential_source,
                },
                "name": monitored_resource_additional_aliases_name,
                "source": monitored_resource_additional_aliases_source,
            }],
            additional_credentials=[{
                "credential_type": monitored_resource_additional_credentials_credential_type,
                "description": monitored_resource_additional_credentials_description,
                "key_id": test_key["id"],
                "name": monitored_resource_additional_credentials_name,
                "properties": [{
                    "name": monitored_resource_additional_credentials_properties_name,
                    "value": monitored_resource_additional_credentials_properties_value,
                }],
                "source": monitored_resource_additional_credentials_source,
                "type": monitored_resource_additional_credentials_type,
            }],
            aliases={
                "credential": {
                    "name": monitored_resource_aliases_credential_name,
                    "service": monitored_resource_aliases_credential_service,
                    "source": monitored_resource_aliases_credential_source,
                },
                "name": monitored_resource_aliases_name,
                "source": monitored_resource_aliases_source,
            },
            credentials={
                "credential_type": monitored_resource_credentials_credential_type,
                "description": monitored_resource_credentials_description,
                "key_id": monitored_resource_credentials_key_id,
                "name": monitored_resource_credentials_name,
                "properties": [{
                    "name": monitored_resource_credentials_properties_name,
                    "value": monitored_resource_credentials_properties_value,
                }],
                "source": monitored_resource_credentials_source,
                "type": monitored_resource_credentials_type,
            },
            database_connection_details={
                "port": monitored_resource_database_connection_details_port,
                "protocol": monitored_resource_database_connection_details_protocol,
                "service_name": monitored_resource_database_service_name,
                "connector_id": monitored_resource_database_connector_id,
                "db_id": monitored_resource_database_id,
                "db_unique_name": monitored_resource_database_connection_details_db_unique_name,
                "ssl_secret_id": test_secret["id"],
            },
            defined_tags={
                "foo-namespace.bar-key": "value",
            },
            display_name=monitored_resource_display_name,
            external_resource_id=monitored_resource_external_resource_id,
            external_id=test_external["id"],
            freeform_tags={
                "bar-key": "value",
            },
            host_name=monitored_resource_host_name,
            license=monitored_resource_license,
            management_agent_id=test_management_agent["id"],
            properties=[{
                "name": monitored_resource_properties_name,
                "value": monitored_resource_properties_value,
            }],
            resource_time_zone=monitored_resource_resource_time_zone)
        ```

        ## Import

        MonitoredResources can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:StackMonitoring/monitoredResource:MonitoredResource test_monitored_resource "id"
        ```

        :param str resource_name: The name of the resource.
        :param MonitoredResourceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MonitoredResourceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalAliasArgs', 'MonitoredResourceAdditionalAliasArgsDict']]]]] = None,
                 additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalCredentialArgs', 'MonitoredResourceAdditionalCredentialArgsDict']]]]] = None,
                 aliases: Optional[pulumi.Input[Union['MonitoredResourceAliasesArgs', 'MonitoredResourceAliasesArgsDict']]] = None,
                 compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
                 credentials: Optional[pulumi.Input[Union['MonitoredResourceCredentialsArgs', 'MonitoredResourceCredentialsArgsDict']]] = None,
                 database_connection_details: Optional[pulumi.Input[Union['MonitoredResourceDatabaseConnectionDetailsArgs', 'MonitoredResourceDatabaseConnectionDetailsArgsDict']]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 external_id: Optional[pulumi.Input[_builtins.str]] = None,
                 external_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 host_name: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcePropertyArgs', 'MonitoredResourcePropertyArgsDict']]]]] = None,
                 resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MonitoredResourceArgs.__new__(MonitoredResourceArgs)

            __props__.__dict__["additional_aliases"] = additional_aliases
            __props__.__dict__["additional_credentials"] = additional_credentials
            __props__.__dict__["aliases"] = aliases
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["credentials"] = credentials
            __props__.__dict__["database_connection_details"] = database_connection_details
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["external_id"] = external_id
            __props__.__dict__["external_resource_id"] = external_resource_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["host_name"] = host_name
            __props__.__dict__["license"] = license
            __props__.__dict__["management_agent_id"] = management_agent_id
            __props__.__dict__["name"] = name
            __props__.__dict__["properties"] = properties
            __props__.__dict__["resource_time_zone"] = resource_time_zone
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["resource_category"] = None
            __props__.__dict__["source_type"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["tenant_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(MonitoredResource, __self__).__init__(
            'oci:StackMonitoring/monitoredResource:MonitoredResource',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_aliases: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalAliasArgs', 'MonitoredResourceAdditionalAliasArgsDict']]]]] = None,
            additional_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalCredentialArgs', 'MonitoredResourceAdditionalCredentialArgsDict']]]]] = None,
            aliases: Optional[pulumi.Input[Union['MonitoredResourceAliasesArgs', 'MonitoredResourceAliasesArgsDict']]] = None,
            compartment_id: Optional[pulumi.Input[_builtins.str]] = None,
            credentials: Optional[pulumi.Input[Union['MonitoredResourceCredentialsArgs', 'MonitoredResourceCredentialsArgsDict']]] = None,
            database_connection_details: Optional[pulumi.Input[Union['MonitoredResourceDatabaseConnectionDetailsArgs', 'MonitoredResourceDatabaseConnectionDetailsArgsDict']]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            external_id: Optional[pulumi.Input[_builtins.str]] = None,
            external_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            host_name: Optional[pulumi.Input[_builtins.str]] = None,
            license: Optional[pulumi.Input[_builtins.str]] = None,
            management_agent_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            properties: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcePropertyArgs', 'MonitoredResourcePropertyArgsDict']]]]] = None,
            resource_category: Optional[pulumi.Input[_builtins.str]] = None,
            resource_time_zone: Optional[pulumi.Input[_builtins.str]] = None,
            source_type: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            time_created: Optional[pulumi.Input[_builtins.str]] = None,
            time_updated: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None) -> 'MonitoredResource':
        """
        Get an existing MonitoredResource resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalAliasArgs', 'MonitoredResourceAdditionalAliasArgsDict']]]] additional_aliases: (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourceAdditionalCredentialArgs', 'MonitoredResourceAdditionalCredentialArgsDict']]]] additional_credentials: (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        :param pulumi.Input[Union['MonitoredResourceAliasesArgs', 'MonitoredResourceAliasesArgsDict']] aliases: (Updatable) Monitored Resource Alias Credential Details
        :param pulumi.Input[_builtins.str] compartment_id: (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Union['MonitoredResourceCredentialsArgs', 'MonitoredResourceCredentialsArgsDict']] credentials: (Updatable) Monitored Resource Credential Details.
        :param pulumi.Input[Union['MonitoredResourceDatabaseConnectionDetailsArgs', 'MonitoredResourceDatabaseConnectionDetailsArgsDict']] database_connection_details: (Updatable) Connection details for the database.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[_builtins.str] display_name: (Updatable) Monitored resource display name.
        :param pulumi.Input[_builtins.str] external_id: External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        :param pulumi.Input[_builtins.str] external_resource_id: Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[_builtins.str] host_name: (Updatable) Host name of the monitored resource.
        :param pulumi.Input[_builtins.str] license: (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        :param pulumi.Input[_builtins.str] management_agent_id: Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] name: Monitored Resource Name.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MonitoredResourcePropertyArgs', 'MonitoredResourcePropertyArgsDict']]]] properties: (Updatable) List of monitored resource properties.
        :param pulumi.Input[_builtins.str] resource_category: Resource Category to indicate the kind of resource type.
        :param pulumi.Input[_builtins.str] resource_time_zone: (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        :param pulumi.Input[_builtins.str] source_type: Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        :param pulumi.Input[_builtins.str] state: Lifecycle state of the monitored resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[_builtins.str] tenant_id: Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[_builtins.str] time_created: The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[_builtins.str] time_updated: The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        :param pulumi.Input[_builtins.str] type: Monitored Resource Type. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MonitoredResourceState.__new__(_MonitoredResourceState)

        __props__.__dict__["additional_aliases"] = additional_aliases
        __props__.__dict__["additional_credentials"] = additional_credentials
        __props__.__dict__["aliases"] = aliases
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["credentials"] = credentials
        __props__.__dict__["database_connection_details"] = database_connection_details
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["external_id"] = external_id
        __props__.__dict__["external_resource_id"] = external_resource_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["host_name"] = host_name
        __props__.__dict__["license"] = license
        __props__.__dict__["management_agent_id"] = management_agent_id
        __props__.__dict__["name"] = name
        __props__.__dict__["properties"] = properties
        __props__.__dict__["resource_category"] = resource_category
        __props__.__dict__["resource_time_zone"] = resource_time_zone
        __props__.__dict__["source_type"] = source_type
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        return MonitoredResource(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalAliases")
    def additional_aliases(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoredResourceAdditionalAlias']]]:
        """
        (Updatable) List of MonitoredResourceAliasCredentials. This property complements the existing  "aliases" property by allowing user to specify more than one credential alias.  If both "aliases" and "additionalAliases" are specified, union of the  values is used as list of aliases applicable for this resource. If any duplicate found in the combined list of "alias" and "additionalAliases",  an error will be thrown.
        """
        return pulumi.get(self, "additional_aliases")

    @_builtins.property
    @pulumi.getter(name="additionalCredentials")
    def additional_credentials(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoredResourceAdditionalCredential']]]:
        """
        (Updatable) List of MonitoredResourceCredentials. This property complements the existing  "credentials" property by allowing user to specify more than one credential.  If both "credential" and "additionalCredentials" are specified, union of the  values is used as list of credentials applicable for this resource. If any duplicate found in the combined list of "credentials" and "additionalCredentials",  an error will be thrown.
        """
        return pulumi.get(self, "additional_credentials")

    @_builtins.property
    @pulumi.getter
    def aliases(self) -> pulumi.Output[Optional['outputs.MonitoredResourceAliases']]:
        """
        (Updatable) Monitored Resource Alias Credential Details
        """
        return pulumi.get(self, "aliases")

    @_builtins.property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) Compartment Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "compartment_id")

    @_builtins.property
    @pulumi.getter
    def credentials(self) -> pulumi.Output[Optional['outputs.MonitoredResourceCredentials']]:
        """
        (Updatable) Monitored Resource Credential Details.
        """
        return pulumi.get(self, "credentials")

    @_builtins.property
    @pulumi.getter(name="databaseConnectionDetails")
    def database_connection_details(self) -> pulumi.Output[Optional['outputs.MonitoredResourceDatabaseConnectionDetails']]:
        """
        (Updatable) Connection details for the database.
        """
        return pulumi.get(self, "database_connection_details")

    @_builtins.property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) Monitored resource display name.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        External resource is any Oracle Cloud Infrastructure resource identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) which is not a Stack Monitoring service resource. Currently supports only Oracle Cloud Infrastructure compute instance.
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="externalResourceId")
    def external_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Generally used by DBaaS to send the Database OCID stored on the DBaaS. The same will be passed to resource service to enable Stack Monitoring Service on DBM. This will be stored in Stack Monitoring Resource Service data store as identifier for monitored resource. If this header is not set as part of the request, then an id will be generated and stored for the resource.
        """
        return pulumi.get(self, "external_resource_id")

    @_builtins.property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @_builtins.property
    @pulumi.getter(name="hostName")
    def host_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) Host name of the monitored resource.
        """
        return pulumi.get(self, "host_name")

    @_builtins.property
    @pulumi.getter
    def license(self) -> pulumi.Output[_builtins.str]:
        """
        (Updatable) License edition of the monitored resource. If not provided  the default license type for the compartment will be used.
        """
        return pulumi.get(self, "license")

    @_builtins.property
    @pulumi.getter(name="managementAgentId")
    def management_agent_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Management Agent Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "management_agent_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Monitored Resource Name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def properties(self) -> pulumi.Output[Optional[Sequence['outputs.MonitoredResourceProperty']]]:
        """
        (Updatable) List of monitored resource properties.
        """
        return pulumi.get(self, "properties")

    @_builtins.property
    @pulumi.getter(name="resourceCategory")
    def resource_category(self) -> pulumi.Output[_builtins.str]:
        """
        Resource Category to indicate the kind of resource type.
        """
        return pulumi.get(self, "resource_category")

    @_builtins.property
    @pulumi.getter(name="resourceTimeZone")
    def resource_time_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        (Updatable) Time zone in the form of tz database canonical zone ID. Specifies the preference with a value that uses the IANA Time Zone Database format (x-obmcs-time-zone). For example - America/Los_Angeles
        """
        return pulumi.get(self, "resource_time_zone")

    @_builtins.property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> pulumi.Output[_builtins.str]:
        """
        Source type to indicate if the resource is stack monitoring discovered, Oracle Cloud Infrastructure native resource, etc.
        """
        return pulumi.get(self, "source_type")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Lifecycle state of the monitored resource.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[_builtins.str]:
        """
        Tenancy Identifier [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the monitored resource was created, expressed in  [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_created")

    @_builtins.property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[_builtins.str]:
        """
        The date and time when the monitored resource was last updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.
        """
        return pulumi.get(self, "time_updated")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        Monitored Resource Type. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "type")

