# coding: utf-8

"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from binance_sdk_derivatives_trading_options.rest_api.models.exchange_information_response_option_symbols_inner_filters_inner import (
    ExchangeInformationResponseOptionSymbolsInnerFiltersInner,
)
from typing import Set
from typing_extensions import Self


class ExchangeInformationResponseOptionSymbolsInner(BaseModel):
    """
    ExchangeInformationResponseOptionSymbolsInner
    """  # noqa: E501

    expiry_date: Optional[StrictInt] = Field(default=None, alias="expiryDate")
    filters: Optional[
        List[ExchangeInformationResponseOptionSymbolsInnerFiltersInner]
    ] = None
    symbol: Optional[StrictStr] = None
    side: Optional[StrictStr] = None
    strike_price: Optional[StrictStr] = Field(default=None, alias="strikePrice")
    underlying: Optional[StrictStr] = None
    unit: Optional[StrictInt] = None
    maker_fee_rate: Optional[StrictStr] = Field(default=None, alias="makerFeeRate")
    taker_fee_rate: Optional[StrictStr] = Field(default=None, alias="takerFeeRate")
    liquidation_fee_rate: Optional[StrictStr] = Field(
        default=None, alias="liquidationFeeRate"
    )
    min_qty: Optional[StrictStr] = Field(default=None, alias="minQty")
    max_qty: Optional[StrictStr] = Field(default=None, alias="maxQty")
    initial_margin: Optional[StrictStr] = Field(default=None, alias="initialMargin")
    maintenance_margin: Optional[StrictStr] = Field(
        default=None, alias="maintenanceMargin"
    )
    min_initial_margin: Optional[StrictStr] = Field(
        default=None, alias="minInitialMargin"
    )
    min_maintenance_margin: Optional[StrictStr] = Field(
        default=None, alias="minMaintenanceMargin"
    )
    price_scale: Optional[StrictInt] = Field(default=None, alias="priceScale")
    quantity_scale: Optional[StrictInt] = Field(default=None, alias="quantityScale")
    quote_asset: Optional[StrictStr] = Field(default=None, alias="quoteAsset")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = [
        "expiryDate",
        "filters",
        "symbol",
        "side",
        "strikePrice",
        "underlying",
        "unit",
        "makerFeeRate",
        "takerFeeRate",
        "liquidationFeeRate",
        "minQty",
        "maxQty",
        "initialMargin",
        "maintenanceMargin",
        "minInitialMargin",
        "minMaintenanceMargin",
        "priceScale",
        "quantityScale",
        "quoteAsset",
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def is_array(cls) -> bool:
        return False

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of ExchangeInformationResponseOptionSymbolsInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set(
            [
                "additional_properties",
            ]
        )

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in filters (list)
        _items = []
        if self.filters:
            for _item_filters in self.filters:
                if _item_filters:
                    _items.append(_item_filters.to_dict())
            _dict["filters"] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of ExchangeInformationResponseOptionSymbolsInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate(
            {
                "expiryDate": obj.get("expiryDate"),
                "filters": (
                    [
                        ExchangeInformationResponseOptionSymbolsInnerFiltersInner.from_dict(
                            _item
                        )
                        for _item in obj["filters"]
                    ]
                    if obj.get("filters") is not None
                    else None
                ),
                "symbol": obj.get("symbol"),
                "side": obj.get("side"),
                "strikePrice": obj.get("strikePrice"),
                "underlying": obj.get("underlying"),
                "unit": obj.get("unit"),
                "makerFeeRate": obj.get("makerFeeRate"),
                "takerFeeRate": obj.get("takerFeeRate"),
                "liquidationFeeRate": obj.get("liquidationFeeRate"),
                "minQty": obj.get("minQty"),
                "maxQty": obj.get("maxQty"),
                "initialMargin": obj.get("initialMargin"),
                "maintenanceMargin": obj.get("maintenanceMargin"),
                "minInitialMargin": obj.get("minInitialMargin"),
                "minMaintenanceMargin": obj.get("minMaintenanceMargin"),
                "priceScale": obj.get("priceScale"),
                "quantityScale": obj.get("quantityScale"),
                "quoteAsset": obj.get("quoteAsset"),
            }
        )
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj
