"""
Binance Derivatives Trading Options REST API

OpenAPI Specification for the Binance Derivatives Trading Options REST API
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

import requests
from typing import Optional, List, TypeVar
from binance_common.configuration import ConfigurationRestAPI
from binance_common.models import ApiResponse
from binance_common.signature import Signers
from binance_common.utils import send_request
from .api.account_api import AccountApi
from .api.market_data_api import MarketDataApi
from .api.market_maker_block_trade_api import MarketMakerBlockTradeApi
from .api.market_maker_endpoints_api import MarketMakerEndpointsApi
from .api.trade_api import TradeApi
from .api.user_data_streams_api import UserDataStreamsApi

from .models import AccountFundingFlowResponse
from .models import GetDownloadIdForOptionTransactionHistoryResponse
from .models import GetOptionTransactionHistoryDownloadLinkByIdResponse
from .models import OptionAccountInformationResponse
from .models import OptionMarginAccountInformationResponse
from .models import CheckServerTimeResponse
from .models import ExchangeInformationResponse
from .models import HistoricalExerciseRecordsResponse
from .models import KlineCandlestickDataResponse
from .models import OldTradesLookupResponse
from .models import OpenInterestResponse
from .models import OptionMarkPriceResponse
from .models import OrderBookResponse
from .models import RecentBlockTradesListResponse
from .models import RecentTradesListResponse
from .models import SymbolPriceTickerResponse

from .models import Ticker24hrPriceChangeStatisticsResponse
from .models import AcceptBlockTradeOrderResponse
from .models import AccountBlockTradeListResponse

from .models import ExtendBlockTradeOrderResponse
from .models import NewBlockTradeOrderResponse
from .models import QueryBlockTradeDetailsResponse
from .models import QueryBlockTradeOrderResponse
from .models import AutoCancelAllOpenOrdersResponse
from .models import GetAutoCancelAllOpenOrdersResponse
from .models import GetMarketMakerProtectionConfigResponse
from .models import ResetMarketMakerProtectionConfigResponse
from .models import SetAutoCancelAllOpenOrdersResponse
from .models import SetMarketMakerProtectionConfigResponse
from .models import AccountTradeListResponse
from .models import CancelAllOptionOrdersByUnderlyingResponse
from .models import CancelAllOptionOrdersOnSpecificSymbolResponse
from .models import CancelMultipleOptionOrdersResponse
from .models import CancelOptionOrderResponse
from .models import NewOrderResponse
from .models import OptionPositionInformationResponse
from .models import PlaceMultipleOrdersResponse
from .models import QueryCurrentOpenOptionOrdersResponse
from .models import QueryOptionOrderHistoryResponse
from .models import QuerySingleOrderResponse
from .models import UserExerciseRecordResponse


from .models import StartUserDataStreamResponse


from .models import NewBlockTradeOrderSideEnum
from .models import NewOrderSideEnum
from .models import NewOrderTypeEnum
from .models import NewOrderTimeInForceEnum
from .models import NewOrderNewOrderRespTypeEnum


from .models import PlaceMultipleOrdersOrdersParameterInner

T = TypeVar("T")


class DerivativesTradingOptionsRestAPI:
    def __init__(
        self,
        configuration: ConfigurationRestAPI,
    ) -> None:
        self.configuration = configuration
        self._session = requests.Session()
        self._signer = (
            Signers.get_signer(
                configuration.private_key, configuration.private_key_passphrase
            )
            if configuration.private_key is not None
            else None
        )

        self._accountApi = AccountApi(self.configuration, self._session, self._signer)
        self._marketDataApi = MarketDataApi(
            self.configuration, self._session, self._signer
        )
        self._marketMakerBlockTradeApi = MarketMakerBlockTradeApi(
            self.configuration, self._session, self._signer
        )
        self._marketMakerEndpointsApi = MarketMakerEndpointsApi(
            self.configuration, self._session, self._signer
        )
        self._tradeApi = TradeApi(self.configuration, self._session, self._signer)
        self._userDataStreamsApi = UserDataStreamsApi(
            self.configuration, self._session, self._signer
        )

    def send_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends an request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session, self.configuration, method, endpoint, params
        )

    def send_signed_request(
        self, endpoint: str, method: str, params: Optional[dict] = None
    ) -> ApiResponse[T]:
        """
        Sends a signed request to the Binance REST API.

        Args:
            endpoint (str): The API endpoint path to send the request to.
            method (str): The HTTP method to use for the request (e.g. "GET", "POST", "PUT", "DELETE").
            params (Optional[dict]): The request payload as a dictionary, or None if no payload is required.

        Returns:
            ApiResponse[T]: The API response, where T is the expected response type.
        """
        return send_request[T](
            self._session,
            self.configuration,
            method,
            endpoint,
            params,
            is_signed=True,
            signer=self._signer,
        )

    def account_funding_flow(
        self,
        currency: str = None,
        record_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountFundingFlowResponse]:
        """
                Account Funding Flow (USER_DATA)

                Query account funding flows.

        Weight: 1

                Args:
                    currency (str): Asset type, only support USDT  as of now
                    record_id (Optional[int]): Return the recordId and subsequent data, the latest data is returned by default, e.g 100000
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AccountFundingFlowResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.account_funding_flow(
            currency, record_id, start_time, end_time, limit, recv_window
        )

    def get_download_id_for_option_transaction_history(
        self,
        start_time: int = None,
        end_time: int = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetDownloadIdForOptionTransactionHistoryResponse]:
        """
                Get Download Id For Option Transaction History (USER_DATA)

                Get download id for option transaction history

        * Request Limitation is 5 times per month, shared by > front end download page and rest api
        * The time between `startTime` and `endTime` can not be longer than 1 year

        Weight: 5

                Args:
                    start_time (int): Timestamp in ms
                    end_time (int): Timestamp in ms
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetDownloadIdForOptionTransactionHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_download_id_for_option_transaction_history(
            start_time, end_time, recv_window
        )

    def get_option_transaction_history_download_link_by_id(
        self,
        download_id: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetOptionTransactionHistoryDownloadLinkByIdResponse]:
        """
                Get Option Transaction History Download Link by Id (USER_DATA)

                Get option transaction history download Link by Id

        * Download link expiration: 24h

        Weight: 5

                Args:
                    download_id (str): get by download id api
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetOptionTransactionHistoryDownloadLinkByIdResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.get_option_transaction_history_download_link_by_id(
            download_id, recv_window
        )

    def option_account_information(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[OptionAccountInformationResponse]:
        """
                Option Account Information(TRADE)

                Get current account information.

        Weight: 3

                Args:
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[OptionAccountInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.option_account_information(recv_window)

    def option_margin_account_information(
        self,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[OptionMarginAccountInformationResponse]:
        """
                Option Margin Account Information (USER_DATA)

                Get current account information.

        Weight: 3

                Args:
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[OptionMarginAccountInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._accountApi.option_margin_account_information(recv_window)

    def check_server_time(
        self,
    ) -> ApiResponse[CheckServerTimeResponse]:
        """
                Check Server Time

                Test connectivity to the Rest API and get the current server time.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[CheckServerTimeResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.check_server_time()

    def exchange_information(
        self,
    ) -> ApiResponse[ExchangeInformationResponse]:
        """
                Exchange Information

                Current exchange trading rules and symbol information

        Weight: 1

                Args:

                Returns:
                    ApiResponse[ExchangeInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.exchange_information()

    def historical_exercise_records(
        self,
        underlying: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[HistoricalExerciseRecordsResponse]:
        """
                Historical Exercise Records

                Get historical exercise records.
        * REALISTIC_VALUE_STRICKEN -> Exercised
        * EXTRINSIC_VALUE_EXPIRED -> Expired OTM

        Weight: 3

                Args:
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[HistoricalExerciseRecordsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.historical_exercise_records(
            underlying, start_time, end_time, limit
        )

    def kline_candlestick_data(
        self,
        symbol: str = None,
        interval: str = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[KlineCandlestickDataResponse]:
        """
                Kline/Candlestick Data

                Kline/candlestick bars for an option symbol.
        Klines are uniquely identified by their open time.

        * If startTime and endTime are not sent, the most recent klines are returned.

        Weight: 1

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    interval (str): Time interval
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[KlineCandlestickDataResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.kline_candlestick_data(
            symbol, interval, start_time, end_time, limit
        )

    def old_trades_lookup(
        self,
        symbol: str = None,
        from_id: Optional[int] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[OldTradesLookupResponse]:
        """
                Old Trades Lookup (MARKET_DATA)

                Get older market historical trades.

        Weight: 20

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    from_id (Optional[int]): The UniqueId ID from which to return. The latest deal record is returned by default
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[OldTradesLookupResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.old_trades_lookup(symbol, from_id, limit)

    def open_interest(
        self,
        underlying_asset: str = None,
        expiration: str = None,
    ) -> ApiResponse[OpenInterestResponse]:
        """
                Open Interest

                Get open interest for specific underlying asset on specific expiration date.

        Weight: 0

                Args:
                    underlying_asset (str): underlying asset, e.g ETH/BTC
                    expiration (str): expiration date, e.g 221225

                Returns:
                    ApiResponse[OpenInterestResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.open_interest(underlying_asset, expiration)

    def option_mark_price(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[OptionMarkPriceResponse]:
        """
                Option Mark Price

                Option mark price and greek info.

        Weight: 5

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C

                Returns:
                    ApiResponse[OptionMarkPriceResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.option_mark_price(symbol)

    def order_book(
        self,
        symbol: str = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[OrderBookResponse]:
        """
                Order Book

                Check orderbook depth on specific symbol

        Weight: limit         | weight
        ------------  | ------------
        5, 10, 20, 50 | 2
        100           | 5
        500           | 10
        1000          | 20

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[OrderBookResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.order_book(symbol, limit)

    def recent_block_trades_list(
        self,
        symbol: Optional[str] = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[RecentBlockTradesListResponse]:
        """
                Recent Block Trades List

                Get recent block trades

        Weight: 5

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[RecentBlockTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.recent_block_trades_list(symbol, limit)

    def recent_trades_list(
        self,
        symbol: str = None,
        limit: Optional[int] = None,
    ) -> ApiResponse[RecentTradesListResponse]:
        """
                Recent Trades List

                Get recent market trades

        Weight: 5

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000

                Returns:
                    ApiResponse[RecentTradesListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.recent_trades_list(symbol, limit)

    def symbol_price_ticker(
        self,
        underlying: str = None,
    ) -> ApiResponse[SymbolPriceTickerResponse]:
        """
                Symbol Price Ticker

                Get spot index price for option underlying.

        Weight: 1

                Args:
                    underlying (str): Option underlying, e.g BTCUSDT

                Returns:
                    ApiResponse[SymbolPriceTickerResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.symbol_price_ticker(underlying)

    def test_connectivity(
        self,
    ) -> ApiResponse[None]:
        """
                Test Connectivity

                Test connectivity to the Rest API.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.test_connectivity()

    def ticker24hr_price_change_statistics(
        self,
        symbol: Optional[str] = None,
    ) -> ApiResponse[Ticker24hrPriceChangeStatisticsResponse]:
        """
                24hr Ticker Price Change Statistics

                24 hour rolling window price change statistics.

        Weight: 5

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C

                Returns:
                    ApiResponse[Ticker24hrPriceChangeStatisticsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketDataApi.ticker24hr_price_change_statistics(symbol)

    def accept_block_trade_order(
        self,
        block_order_matching_key: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AcceptBlockTradeOrderResponse]:
        """
                Accept Block Trade Order (TRADE)

                Accept a block trade order

        Weight: 5

                Args:
                    block_order_matching_key (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AcceptBlockTradeOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.accept_block_trade_order(
            block_order_matching_key, recv_window
        )

    def account_block_trade_list(
        self,
        end_time: Optional[int] = None,
        start_time: Optional[int] = None,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountBlockTradeListResponse]:
        """
                Account Block Trade List (USER_DATA)

                Gets block trades for a specific account.

        Weight: 5

                Args:
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AccountBlockTradeListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.account_block_trade_list(
            end_time, start_time, underlying, recv_window
        )

    def cancel_block_trade_order(
        self,
        block_order_matching_key: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[None]:
        """
                Cancel Block Trade Order (TRADE)

                Cancel a block trade order.

        Weight: 5

                Args:
                    block_order_matching_key (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.cancel_block_trade_order(
            block_order_matching_key, recv_window
        )

    def extend_block_trade_order(
        self,
        block_order_matching_key: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ExtendBlockTradeOrderResponse]:
        """
                Extend Block Trade Order (TRADE)

                Extends a block trade expire time by 30 mins from the current time.

        Weight: 5

                Args:
                    block_order_matching_key (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ExtendBlockTradeOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.extend_block_trade_order(
            block_order_matching_key, recv_window
        )

    def new_block_trade_order(
        self,
        liquidity: str = None,
        legs: List[object] = None,
        symbol: str = None,
        side: NewBlockTradeOrderSideEnum = None,
        price: float = None,
        quantity: float = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NewBlockTradeOrderResponse]:
        """
                New Block Trade Order (TRADE)

                Send in a new block trade order.

        Weight: 5

                Args:
                    liquidity (str): Taker or Maker
                    legs (List[object]): Max 1 (only single leg supported), list of legs parameters in JSON; example: eapi/v1/block/order/create?orders=[{"symbol":"BTC-210115-35000-C", "price":"100","quantity":"0.0002","side":"BUY","type":"LIMIT"}]
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    side (NewBlockTradeOrderSideEnum): BUY or SELL
                    price (float): Order Price
                    quantity (float): Order Quantity
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[NewBlockTradeOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.new_block_trade_order(
            liquidity, legs, symbol, side, price, quantity, recv_window
        )

    def query_block_trade_details(
        self,
        block_order_matching_key: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryBlockTradeDetailsResponse]:
        """
                Query Block Trade Details (USER_DATA)

                Query block trade details; returns block trade details from counterparty's perspective.

        Weight: 5

                Args:
                    block_order_matching_key (str):
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QueryBlockTradeDetailsResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.query_block_trade_details(
            block_order_matching_key, recv_window
        )

    def query_block_trade_order(
        self,
        block_order_matching_key: Optional[str] = None,
        end_time: Optional[int] = None,
        start_time: Optional[int] = None,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryBlockTradeOrderResponse]:
        """
                Query Block Trade Order (TRADE)

                Check block trade order status.

        Weight: 5

                Args:
                    block_order_matching_key (Optional[str]): If specified, returns the specific block trade associated with the blockOrderMatchingKey
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QueryBlockTradeOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerBlockTradeApi.query_block_trade_order(
            block_order_matching_key, end_time, start_time, underlying, recv_window
        )

    def auto_cancel_all_open_orders(
        self,
        underlyings: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AutoCancelAllOpenOrdersResponse]:
        """
                Auto-Cancel All Open Orders (Kill-Switch) Heartbeat (TRADE)

                This endpoint resets the time from which the countdown will begin to the time this messaged is received.  It should be called repeatedly as heartbeats.  Multiple heartbeats can be updated at once by specifying the underlying symbols as a list (ex. BTCUSDT,ETHUSDT) in the underlyings parameter.

        * The response will only include underlying symbols where the heartbeat has been successfully updated.

        Weight: 10

                Args:
                    underlyings (str): Option Underlying Symbols, e.g BTCUSDT,ETHUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerEndpointsApi.auto_cancel_all_open_orders(
            underlyings, recv_window
        )

    def get_auto_cancel_all_open_orders(
        self,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetAutoCancelAllOpenOrdersResponse]:
        """
                Get Auto-Cancel All Open Orders (Kill-Switch) Config (TRADE)

                This endpoint returns the auto-cancel parameters for each underlying symbol. Note only active auto-cancel parameters will be returned, if countdownTime is set to 0 (ie. countdownTime has been turned off), the underlying symbol and corresponding countdownTime parameter will not be returned in the response.

        * countdownTime = 0 means the function is disabled.

        Weight: 1

                Args:
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetAutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerEndpointsApi.get_auto_cancel_all_open_orders(
            underlying, recv_window
        )

    def get_market_maker_protection_config(
        self,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[GetMarketMakerProtectionConfigResponse]:
        """
                Get Market Maker Protection Config (TRADE)

                Get config for MMP.

        Weight: 1

                Args:
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[GetMarketMakerProtectionConfigResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerEndpointsApi.get_market_maker_protection_config(
            underlying, recv_window
        )

    def reset_market_maker_protection_config(
        self,
        underlying: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[ResetMarketMakerProtectionConfigResponse]:
        """
                Reset Market Maker Protection Config (TRADE)

                Reset MMP, start MMP order again.

        Weight: 1

                Args:
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[ResetMarketMakerProtectionConfigResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerEndpointsApi.reset_market_maker_protection_config(
            underlying, recv_window
        )

    def set_auto_cancel_all_open_orders(
        self,
        underlying: str = None,
        countdown_time: int = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetAutoCancelAllOpenOrdersResponse]:
        """
                Set Auto-Cancel All Open Orders (Kill-Switch) Config (TRADE)

                This endpoint sets the parameters of the auto-cancel feature which cancels all open orders (both market maker protection and non market maker protection order types) of the underlying symbol at the end of the specified countdown time period if no heartbeat message is sent.  After the countdown time period, all open orders will be cancelled and new orders will be rejected with error code -2010 until either a heartbeat message is sent or the auto-cancel feature is turned off by setting countdownTime to 0.


        * This rest endpoint sets up the parameters to cancel your open orders in case of an outage or disconnection.
        * Example usage:
        Call this endpoint with a countdownTime value of 10000 (10 seconds) to turn on the auto-cancel feature. If the corresponding countdownCancelAllHeartBeat endpoint is not called within 10 seconds with the specified underlying symbol, all open orders of the specified symbol will be automatically canceled. If this endpoint is called with an countdownTime of 0, the countdown timer will be stopped.
        * The system will check all countdowns approximately every 1000 milliseconds, **please note that sufficient redundancy should be considered when using this function**. We do not recommend setting the countdown time to be too precise or too small.

        Weight: 1

                Args:
                    underlying (str): Option underlying, e.g BTCUSDT
                    countdown_time (int): Countdown time in milliseconds (ex. 1,000 for 1 second). 0 to disable the timer. Negative values (ex. -10000) are not accepted. Minimum acceptable value is 5,000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[SetAutoCancelAllOpenOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerEndpointsApi.set_auto_cancel_all_open_orders(
            underlying, countdown_time, recv_window
        )

    def set_market_maker_protection_config(
        self,
        underlying: Optional[str] = None,
        window_time_in_milliseconds: Optional[int] = None,
        frozen_time_in_milliseconds: Optional[int] = None,
        qty_limit: Optional[float] = None,
        delta_limit: Optional[float] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[SetMarketMakerProtectionConfigResponse]:
        """
                Set Market Maker Protection Config (TRADE)

                Set config for MMP.
        Market Maker Protection(MMP) is a set of protection mechanism for option market maker, this mechanism is able to prevent mass trading in short period time. Once market maker's account branches the threshold, the Market Maker Protection will be triggered. When Market Maker Protection triggers, all the current MMP orders will be canceled, new MMP orders will be rejected. Market maker can use this time to reevaluate market and modify order price.

        Weight: 1

                Args:
                    underlying (Optional[str]): underlying, e.g BTCUSDT
                    window_time_in_milliseconds (Optional[int]): MMP Interval in milliseconds; Range (0,5000]
                    frozen_time_in_milliseconds (Optional[int]): MMP frozen time in milliseconds, if set to 0 manual reset is required
                    qty_limit (Optional[float]): quantity limit
                    delta_limit (Optional[float]): net delta limit
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[SetMarketMakerProtectionConfigResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._marketMakerEndpointsApi.set_market_maker_protection_config(
            underlying,
            window_time_in_milliseconds,
            frozen_time_in_milliseconds,
            qty_limit,
            delta_limit,
            recv_window,
        )

    def account_trade_list(
        self,
        symbol: Optional[str] = None,
        from_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[AccountTradeListResponse]:
        """
                Account Trade List (USER_DATA)

                Get trades for a specific account and symbol.

        Weight: 5

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C
                    from_id (Optional[int]): The UniqueId ID from which to return. The latest deal record is returned by default
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[AccountTradeListResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.account_trade_list(
            symbol, from_id, start_time, end_time, limit, recv_window
        )

    def cancel_all_option_orders_by_underlying(
        self,
        underlying: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelAllOptionOrdersByUnderlyingResponse]:
        """
                Cancel All Option Orders By Underlying (TRADE)

                Cancel all active orders on specified underlying.

        Weight: 1

                Args:
                    underlying (str): Option underlying, e.g BTCUSDT
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelAllOptionOrdersByUnderlyingResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_all_option_orders_by_underlying(
            underlying, recv_window
        )

    def cancel_all_option_orders_on_specific_symbol(
        self,
        symbol: str = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelAllOptionOrdersOnSpecificSymbolResponse]:
        """
                Cancel all Option orders on specific symbol (TRADE)

                Cancel all active order on a symbol.

        Weight: 1

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelAllOptionOrdersOnSpecificSymbolResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_all_option_orders_on_specific_symbol(
            symbol, recv_window
        )

    def cancel_multiple_option_orders(
        self,
        symbol: str = None,
        order_ids: Optional[List[int]] = None,
        client_order_ids: Optional[List[str]] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelMultipleOptionOrdersResponse]:
        """
                Cancel Multiple Option Orders (TRADE)

                Cancel multiple orders.

        * At least one instance of `orderId` and `clientOrderId` must be sent.

        Weight: 1

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    order_ids (Optional[List[int]]): Order ID, e.g [4611875134427365377,4611875134427365378]
                    client_order_ids (Optional[List[str]]): User-defined order ID, e.g ["my_id_1","my_id_2"]
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelMultipleOptionOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_multiple_option_orders(
            symbol, order_ids, client_order_ids, recv_window
        )

    def cancel_option_order(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[CancelOptionOrderResponse]:
        """
                Cancel Option Order (TRADE)

                Cancel an active order.

        * At least one instance of `orderId` and `clientOrderId` must be sent.

        Weight: 1

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int]): Order ID, e.g 4611875134427365377
                    client_order_id (Optional[str]): User-defined order ID, e.g 10000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[CancelOptionOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.cancel_option_order(
            symbol, order_id, client_order_id, recv_window
        )

    def new_order(
        self,
        symbol: str = None,
        side: NewOrderSideEnum = None,
        type: NewOrderTypeEnum = None,
        quantity: float = None,
        price: Optional[float] = None,
        time_in_force: Optional[NewOrderTimeInForceEnum] = None,
        reduce_only: Optional[bool] = None,
        post_only: Optional[bool] = None,
        new_order_resp_type: Optional[NewOrderNewOrderRespTypeEnum] = None,
        client_order_id: Optional[str] = None,
        is_mmp: Optional[bool] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[NewOrderResponse]:
        """
                New Order (TRADE)

                Send a new order.

        Weight: 0

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    side (NewOrderSideEnum): BUY or SELL
                    type (NewOrderTypeEnum): Order Type: LIMIT(only support limit)
                    quantity (float): Order Quantity
                    price (Optional[float]): Order Price
                    time_in_force (Optional[NewOrderTimeInForceEnum]): Time in force method（Default GTC）
                    reduce_only (Optional[bool]): Reduce Only（Default false）
                    post_only (Optional[bool]): Post Only（Default false）
                    new_order_resp_type (Optional[NewOrderNewOrderRespTypeEnum]): "ACK", "RESULT", Default "ACK"
                    client_order_id (Optional[str]): User-defined order ID, e.g 10000
                    is_mmp (Optional[bool]): is market maker protection order, true/false
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[NewOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.new_order(
            symbol,
            side,
            type,
            quantity,
            price,
            time_in_force,
            reduce_only,
            post_only,
            new_order_resp_type,
            client_order_id,
            is_mmp,
            recv_window,
        )

    def option_position_information(
        self,
        symbol: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[OptionPositionInformationResponse]:
        """
                Option Position Information (USER_DATA)

                Get current position information.

        Weight: 5

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[OptionPositionInformationResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.option_position_information(symbol, recv_window)

    def place_multiple_orders(
        self,
        orders: List[PlaceMultipleOrdersOrdersParameterInner] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[PlaceMultipleOrdersResponse]:
        """
                Place Multiple Orders(TRADE)

                Send multiple option orders.

        * Parameter rules are same with New Order
        * Batch orders are processed concurrently, and the order of matching is not guaranteed.

        Weight: 5

                Args:
                    orders (List[PlaceMultipleOrdersOrdersParameterInner]): order list. Max 5 orders
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[PlaceMultipleOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.place_multiple_orders(orders, recv_window)

    def query_current_open_option_orders(
        self,
        symbol: Optional[str] = None,
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryCurrentOpenOptionOrdersResponse]:
        """
                Query Current Open Option Orders (USER_DATA)

                Query current all open orders, status: ACCEPTED PARTIALLY_FILLED

        Weight: 1 for a single symbol; 40 when the symbol parameter is omitted

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int]): Order ID, e.g 4611875134427365377
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QueryCurrentOpenOptionOrdersResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.query_current_open_option_orders(
            symbol, order_id, start_time, end_time, limit, recv_window
        )

    def query_option_order_history(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QueryOptionOrderHistoryResponse]:
        """
                Query Option Order History (TRADE)

                Query all finished orders within 5 days, finished status: CANCELLED FILLED REJECTED.

        Weight: 3

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int]): Order ID, e.g 4611875134427365377
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QueryOptionOrderHistoryResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.query_option_order_history(
            symbol, order_id, start_time, end_time, limit, recv_window
        )

    def query_single_order(
        self,
        symbol: str = None,
        order_id: Optional[int] = None,
        client_order_id: Optional[str] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[QuerySingleOrderResponse]:
        """
                Query Single Order (TRADE)

                Check an order status.

        * These orders will not be found:
        * order status is `CANCELED` or `REJECTED`, **AND**
        * order has NO filled trade, **AND**
        * created time + 3 days < current time


        * Either `orderId` or `clientOrderId ` must be sent.

        Weight: 1

                Args:
                    symbol (str): Option trading pair, e.g BTC-200730-9000-C
                    order_id (Optional[int]): Order ID, e.g 4611875134427365377
                    client_order_id (Optional[str]): User-defined order ID, e.g 10000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[QuerySingleOrderResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.query_single_order(
            symbol, order_id, client_order_id, recv_window
        )

    def user_exercise_record(
        self,
        symbol: Optional[str] = None,
        start_time: Optional[int] = None,
        end_time: Optional[int] = None,
        limit: Optional[int] = None,
        recv_window: Optional[int] = None,
    ) -> ApiResponse[UserExerciseRecordResponse]:
        """
                User Exercise Record (USER_DATA)

                Get account exercise records.

        Weight: 5

                Args:
                    symbol (Optional[str]): Option trading pair, e.g BTC-200730-9000-C
                    start_time (Optional[int]): Start Time, e.g 1593511200000
                    end_time (Optional[int]): End Time, e.g 1593512200000
                    limit (Optional[int]): Number of result sets returned Default:100 Max:1000
                    recv_window (Optional[int]):

                Returns:
                    ApiResponse[UserExerciseRecordResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._tradeApi.user_exercise_record(
            symbol, start_time, end_time, limit, recv_window
        )

    def close_user_data_stream(
        self,
    ) -> ApiResponse[None]:
        """
                Close User Data Stream (USER_STREAM)

                Close out a user data stream.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._userDataStreamsApi.close_user_data_stream()

    def keepalive_user_data_stream(
        self,
    ) -> ApiResponse[None]:
        """
                Keepalive User Data Stream (USER_STREAM)

                Keepalive a user data stream to prevent a time out. User data streams will close after 60 minutes. It's recommended to send a ping about every 60 minutes.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[None]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._userDataStreamsApi.keepalive_user_data_stream()

    def start_user_data_stream(
        self,
    ) -> ApiResponse[StartUserDataStreamResponse]:
        """
                Start User Data Stream (USER_STREAM)

                Start a new user data stream. The stream will close after 60 minutes unless a keepalive is sent. If the account has an active `listenKey`, that `listenKey` will be returned and its validity will be extended for 60 minutes.

        Weight: 1

                Args:

                Returns:
                    ApiResponse[StartUserDataStreamResponse]

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return self._userDataStreamsApi.start_user_data_stream()
