"""
Binance Derivatives Trading Options WebSocket Market Streams

OpenAPI Specification for the Binance Derivatives Trading Options WebSocket Market Streams
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from binance_common.errors import RequiredError
from binance_common.utils import ws_streams_placeholder
from binance_common.websocket import WebSocketStreamBase, RequestStream

from ..models import IndexPriceStreamsResponse
from ..models import KlineCandlestickStreamsResponse
from ..models import MarkPriceResponse
from ..models import NewSymbolInfoResponse
from ..models import OpenInterestResponse
from ..models import PartialBookDepthStreamsResponse
from ..models import Ticker24HourResponse
from ..models import Ticker24HourByUnderlyingAssetAndExpirationDataResponse
from ..models import TradeStreamsResponse


from typing import Optional


class WebsocketMarketStreamsApi:
    """Client for WebsocketMarketStreamsApi endpoints."""

    def __init__(self, websocket_base: WebSocketStreamBase) -> None:
        self.websocket_base = websocket_base

    async def index_price_streams(
        self,
        symbol: str = None,
        id: Optional[str] = None,
    ) -> IndexPriceStreamsResponse:
        r"""
            Index Price Streams
            POST /<symbol>@index
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/Index-Price-Streams

            Underlying(e.g ETHUSDT) index stream.

        Update Speed: 1000ms

            Args:
                symbol (str): The symbol parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                IndexPriceStreamsResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@index".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=IndexPriceStreamsResponse
        )

    async def kline_candlestick_streams(
        self,
        symbol: str = None,
        interval: str = None,
        id: Optional[str] = None,
    ) -> KlineCandlestickStreamsResponse:
        r"""
            Kline/Candlestick Streams
            POST /<symbol>@kline_<interval>
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/Kline-Candlestick-Streams

            The Kline/Candlestick Stream push updates to the current klines/candlestick every 1000 milliseconds (if existing).

        Update Speed: 1000ms

            Args:
                symbol (str): The symbol parameter
                interval (str): The interval parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                KlineCandlestickStreamsResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if interval is None:
            raise RequiredError(
                field="interval", error_message="Missing required parameter 'interval'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@kline_<interval>".replace("/", ""),
            {
                "symbol": symbol,
                "interval": interval,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=KlineCandlestickStreamsResponse,
        )

    async def mark_price(
        self,
        underlying_asset: str = None,
        id: Optional[str] = None,
    ) -> MarkPriceResponse:
        r"""
            Mark Price
            POST /<underlyingAsset>@markPrice
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/Mark-Price

            The mark price for all option symbols on specific underlying asset. E.g.[ETH@markPrice](wss://nbstream.binance.com/eoptions/stream?streams=ETH@markPrice)

        Update Speed: 1000ms

            Args:
                underlying_asset (str): The underlyingAsset parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                MarkPriceResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if underlying_asset is None:
            raise RequiredError(
                field="underlying_asset",
                error_message="Missing required parameter 'underlying_asset'",
            )

        stream = ws_streams_placeholder(
            "/<underlyingAsset>@markPrice".replace("/", ""),
            {
                "underlying_asset": underlying_asset,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=MarkPriceResponse
        )

    async def new_symbol_info(
        self,
        id: Optional[str] = None,
    ) -> NewSymbolInfoResponse:
        r"""
            New Symbol Info
            POST /option_pair
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/New-Symbol-Info

            New symbol listing stream.

        Update Speed: 50ms

            Args:
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                NewSymbolInfoResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        stream = ws_streams_placeholder(
            "/option_pair".replace("/", ""),
            {
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=NewSymbolInfoResponse
        )

    async def open_interest(
        self,
        underlying_asset: str = None,
        expiration_date: str = None,
        id: Optional[str] = None,
    ) -> OpenInterestResponse:
        r"""
            Open Interest
            POST /<underlyingAsset>@openInterest@<expirationDate>
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/Open-Interest

            Option open interest for specific underlying asset on specific expiration date. E.g.[ETH@openInterest@221125](wss://nbstream.binance.com/eoptions/stream?streams=ETH@openInterest@221125)

        Update Speed: 60s

            Args:
                underlying_asset (str): The underlyingAsset parameter
                expiration_date (str): The expirationDate parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                OpenInterestResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if underlying_asset is None:
            raise RequiredError(
                field="underlying_asset",
                error_message="Missing required parameter 'underlying_asset'",
            )
        if expiration_date is None:
            raise RequiredError(
                field="expiration_date",
                error_message="Missing required parameter 'expiration_date'",
            )

        stream = ws_streams_placeholder(
            "/<underlyingAsset>@openInterest@<expirationDate>".replace("/", ""),
            {
                "underlying_asset": underlying_asset,
                "expiration_date": expiration_date,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=OpenInterestResponse
        )

    async def partial_book_depth_streams(
        self,
        symbol: str = None,
        levels: int = None,
        id: Optional[str] = None,
        update_speed: Optional[str] = None,
    ) -> PartialBookDepthStreamsResponse:
        r"""
            Partial Book Depth Streams
            POST /<symbol>@depth<levels>@<updateSpeed>
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/Partial-Book-Depth-Streams

            Top **<levels\>** bids and asks, Valid levels are **<levels\>** are 10, 20, 50, 100.

        Update Speed: 100ms or 1000ms, 500ms(default when update speed isn't used)

            Args:
                symbol (str): The symbol parameter
                levels (int): The levels parameter
                id (Optional[str]): Unique WebSocket request ID.
                update_speed (Optional[str]): WebSocket stream update speed

            Returns:
                PartialBookDepthStreamsResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )
        if levels is None:
            raise RequiredError(
                field="levels", error_message="Missing required parameter 'levels'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@depth<levels>@<updateSpeed>".replace("/", ""),
            {
                "symbol": symbol,
                "levels": levels,
                "id": id,
                "update_speed": update_speed,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=PartialBookDepthStreamsResponse,
        )

    async def ticker24_hour(
        self,
        symbol: str = None,
        id: Optional[str] = None,
    ) -> Ticker24HourResponse:
        r"""
            24-hour TICKER
            POST /<symbol>@ticker
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/24-hour-TICKER

            24hr ticker info for all symbols. Only symbols whose ticker info changed will be sent.

        Update Speed: 1000ms

            Args:
                symbol (str): The symbol parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                Ticker24HourResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@ticker".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=Ticker24HourResponse
        )

    async def ticker24_hour_by_underlying_asset_and_expiration_data(
        self,
        underlying_asset: str = None,
        expiration_date: str = None,
        id: Optional[str] = None,
    ) -> Ticker24HourByUnderlyingAssetAndExpirationDataResponse:
        r"""
            24-hour TICKER by underlying asset and expiration data
            POST /<underlyingAsset>@ticker@<expirationDate>
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/24-hour-TICKER-by-underlying-asset-and-expiration-data

            24hr ticker info by underlying asset and expiration date. E.g.[ETH@ticker@220930](wss://nbstream.binance.com/eoptions/stream?streams=ETH@ticker@220930)

        Update Speed: 1000ms

            Args:
                underlying_asset (str): The underlyingAsset parameter
                expiration_date (str): The expirationDate parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                Ticker24HourByUnderlyingAssetAndExpirationDataResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if underlying_asset is None:
            raise RequiredError(
                field="underlying_asset",
                error_message="Missing required parameter 'underlying_asset'",
            )
        if expiration_date is None:
            raise RequiredError(
                field="expiration_date",
                error_message="Missing required parameter 'expiration_date'",
            )

        stream = ws_streams_placeholder(
            "/<underlyingAsset>@ticker@<expirationDate>".replace("/", ""),
            {
                "underlying_asset": underlying_asset,
                "expiration_date": expiration_date,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base,
            stream=stream,
            response_model=Ticker24HourByUnderlyingAssetAndExpirationDataResponse,
        )

    async def trade_streams(
        self,
        symbol: str = None,
        id: Optional[str] = None,
    ) -> TradeStreamsResponse:
        r"""
            Trade Streams
            POST /<symbol>@trade
            https://developers.binance.com/docs/derivatives/option/websocket-market-streams/Trade-Streams

            The Trade Streams push raw trade information for specific symbol or underlying asset. E.g.[ETH@trade](wss://nbstream.binance.com/eoptions/stream?streams=ETH@trade)

        Update Speed: 50ms

            Args:
                symbol (str): The symbol parameter
                id (Optional[str]): Unique WebSocket request ID.

            Returns:
                TradeStreamsResponse

            Raises:
                RequiredError: If a required parameter is missing.

        """

        if symbol is None:
            raise RequiredError(
                field="symbol", error_message="Missing required parameter 'symbol'"
            )

        stream = ws_streams_placeholder(
            "/<symbol>@trade".replace("/", ""),
            {
                "symbol": symbol,
                "id": id,
            },
        )

        return await RequestStream(
            self.websocket_base, stream=stream, response_model=TradeStreamsResponse
        )
