"""
Binance Derivatives Trading Options WebSocket Market Streams

OpenAPI Specification for the Binance Derivatives Trading Options WebSocket Market Streams
The version of the OpenAPI document: 1.0.0
Generated by OpenAPI Generator (https://openapi-generator.tech)

Do not edit the class manually.
"""

from pydantic import BaseModel
from typing import Callable, Optional, TypeVar

from binance_common.configuration import ConfigurationWebSocketStreams
from binance_common.websocket import (
    WebSocketStreamBase,
    WebSocketConnection,
    RequestStream,
)

from .models import UserDataStreamEventsResponse


from .streams.websocket_market_streams_api import WebsocketMarketStreamsApi

from .models import IndexPriceStreamsResponse
from .models import KlineCandlestickStreamsResponse
from .models import MarkPriceResponse
from .models import NewSymbolInfoResponse
from .models import OpenInterestResponse
from .models import PartialBookDepthStreamsResponse
from .models import Ticker24HourResponse
from .models import Ticker24HourByUnderlyingAssetAndExpirationDataResponse
from .models import TradeStreamsResponse


T = TypeVar("T", bound=BaseModel)


class DerivativesTradingOptionsWebSocketStreams(WebSocketStreamBase):
    def __init__(
        self,
        configuration: ConfigurationWebSocketStreams,
    ) -> None:
        super().__init__(configuration)
        self.configuration = configuration

        self._websocketMarketStreamsApi = WebsocketMarketStreamsApi(self)

    async def ping_server(self, connection: WebSocketConnection):
        """Sends a ping message to the WebSocket server to check the connection status.

        Args:
            connection (WebSocketConnection): The WebSocket connection to send the ping message to.
        """

        if self.session:
            await super().ping_ws_stream(connection=connection)
        else:
            raise ValueError("WebSocket session is not initialized.")

    async def subscribe(self, streams, response_model: Optional[T] = None):
        """Subscribes to the specified WebSocket streams.

        Args:
            streams (list): A list of WebSocket streams to subscribe to.
            response_model (Optional[T]): The Pydantic model to validate the response against.
        """

        await super().subscribe(streams, response_model=response_model)

    async def unsubscribe(self, streams):
        """Unsubscribes from the specified WebSocket streams.

        Args:
            streams (list): A list of WebSocket streams to unsubscribe from.
        """

        await super().unsubscribe(streams)

    def on(self, event: str, callback: Callable[[T], None], stream: str):
        """Registers a callback function for a specific WebSocket event.

        Args:
            event (str): The event type to listen for (e.g., 'message', 'error').
            callback (Callable[[T], None]): The callback function to be called when the event occurs.
            stream (str): The specific WebSocket stream to listen to.
        """

        super().on(event, callback, stream)

    async def list_subscribe(self) -> dict:
        """Lists all currently subscribed WebSocket streams.

        Returns:
            dict: A dictionary containing the current subscriptions.
        """

        return await super().list_subscribe()

    async def close_connection(
        self, connection: WebSocketConnection = None, close_session: bool = True
    ):
        """Closes the WebSocket connection and optionally the session.

        Args:
            connection (WebSocketConnection, optional): The WebSocket connection to close. If None, the current session's connection is used.
            close_session (bool, optional): Whether to close the session after closing the connection. Defaults to True.
        """

        await super().close_connection(connection, close_session)

    async def user_data(self, listenKey: str) -> UserDataStreamEventsResponse:
        """Subscribe to User Data Stream (USER_STREAM)

        Args:
            listenKey (str): The listen key for the user data stream.
        Returns:
            UserDataStreamEventsResponse: The response model containing user data stream events.
        """

        return await RequestStream(
            self, listenKey, response_model=UserDataStreamEventsResponse
        )

    async def index_price_streams(
        self,
        symbol: str = None,
        id: Optional[str] = None,
    ) -> IndexPriceStreamsResponse:
        r"""
                Index Price Streams

                Underlying(e.g ETHUSDT) index stream.

        Update Speed: 1000ms

                Args:
                    symbol (str): The symbol parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    IndexPriceStreamsResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.index_price_streams(symbol, id)

    async def kline_candlestick_streams(
        self,
        symbol: str = None,
        interval: str = None,
        id: Optional[str] = None,
    ) -> KlineCandlestickStreamsResponse:
        r"""
                Kline/Candlestick Streams

                The Kline/Candlestick Stream push updates to the current klines/candlestick every 1000 milliseconds (if existing).

        Update Speed: 1000ms

                Args:
                    symbol (str): The symbol parameter
                    interval (str): The interval parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    KlineCandlestickStreamsResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.kline_candlestick_streams(
            symbol, interval, id
        )

    async def mark_price(
        self,
        underlying_asset: str = None,
        id: Optional[str] = None,
    ) -> MarkPriceResponse:
        r"""
                Mark Price

                The mark price for all option symbols on specific underlying asset. E.g.[ETH@markPrice](wss://nbstream.binance.com/eoptions/stream?streams=ETH@markPrice)

        Update Speed: 1000ms

                Args:
                    underlying_asset (str): The underlyingAsset parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    MarkPriceResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.mark_price(underlying_asset, id)

    async def new_symbol_info(
        self,
        id: Optional[str] = None,
    ) -> NewSymbolInfoResponse:
        r"""
                New Symbol Info

                New symbol listing stream.

        Update Speed: 50ms

                Args:
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    NewSymbolInfoResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.new_symbol_info(id)

    async def open_interest(
        self,
        underlying_asset: str = None,
        expiration_date: str = None,
        id: Optional[str] = None,
    ) -> OpenInterestResponse:
        r"""
                Open Interest

                Option open interest for specific underlying asset on specific expiration date. E.g.[ETH@openInterest@221125](wss://nbstream.binance.com/eoptions/stream?streams=ETH@openInterest@221125)

        Update Speed: 60s

                Args:
                    underlying_asset (str): The underlyingAsset parameter
                    expiration_date (str): The expirationDate parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    OpenInterestResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.open_interest(
            underlying_asset, expiration_date, id
        )

    async def partial_book_depth_streams(
        self,
        symbol: str = None,
        levels: int = None,
        id: Optional[str] = None,
        update_speed: Optional[str] = None,
    ) -> PartialBookDepthStreamsResponse:
        r"""
                Partial Book Depth Streams

                Top **<levels\>** bids and asks, Valid levels are **<levels\>** are 10, 20, 50, 100.

        Update Speed: 100ms or 1000ms, 500ms(default when update speed isn't used)

                Args:
                    symbol (str): The symbol parameter
                    levels (int): The levels parameter
                    id (Optional[str]): Unique WebSocket request ID.
                    update_speed (Optional[str]): WebSocket stream update speed

                Returns:
                    PartialBookDepthStreamsResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.partial_book_depth_streams(
            symbol, levels, id, update_speed
        )

    async def ticker24_hour(
        self,
        symbol: str = None,
        id: Optional[str] = None,
    ) -> Ticker24HourResponse:
        r"""
                24-hour TICKER

                24hr ticker info for all symbols. Only symbols whose ticker info changed will be sent.

        Update Speed: 1000ms

                Args:
                    symbol (str): The symbol parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    Ticker24HourResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.ticker24_hour(symbol, id)

    async def ticker24_hour_by_underlying_asset_and_expiration_data(
        self,
        underlying_asset: str = None,
        expiration_date: str = None,
        id: Optional[str] = None,
    ) -> Ticker24HourByUnderlyingAssetAndExpirationDataResponse:
        r"""
                24-hour TICKER by underlying asset and expiration data

                24hr ticker info by underlying asset and expiration date. E.g.[ETH@ticker@220930](wss://nbstream.binance.com/eoptions/stream?streams=ETH@ticker@220930)

        Update Speed: 1000ms

                Args:
                    underlying_asset (str): The underlyingAsset parameter
                    expiration_date (str): The expirationDate parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    Ticker24HourByUnderlyingAssetAndExpirationDataResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.ticker24_hour_by_underlying_asset_and_expiration_data(
            underlying_asset, expiration_date, id
        )

    async def trade_streams(
        self,
        symbol: str = None,
        id: Optional[str] = None,
    ) -> TradeStreamsResponse:
        r"""
                Trade Streams

                The Trade Streams push raw trade information for specific symbol or underlying asset. E.g.[ETH@trade](wss://nbstream.binance.com/eoptions/stream?streams=ETH@trade)

        Update Speed: 50ms

                Args:
                    symbol (str): The symbol parameter
                    id (Optional[str]): Unique WebSocket request ID.

                Returns:
                    TradeStreamsResponse

                Raises:
                    RequiredError: If a required parameter is missing.

        """

        return await self._websocketMarketStreamsApi.trade_streams(symbol, id)
