import { Construct } from '@aws-cdk/cdk';
import { IEncryptionKey } from './key';
export interface EncryptionKeyAliasProps {
    /**
     * The name of the alias. The name must start with alias followed by a
     * forward slash, such as alias/. You can't specify aliases that begin with
     * alias/AWS. These aliases are reserved.
     */
    readonly alias: string;
    /**
     * The ID of the key for which you are creating the alias. Specify the key's
     * globally unique identifier or Amazon Resource Name (ARN). You can't
     * specify another alias.
     */
    readonly key: IEncryptionKey;
}
/**
 * Defines a display name for a customer master key (CMK) in AWS Key Management
 * Service (AWS KMS). Using an alias to refer to a key can help you simplify key
 * management. For example, when rotating keys, you can just update the alias
 * mapping instead of tracking and changing key IDs. For more information, see
 * Working with Aliases in the AWS Key Management Service Developer Guide.
 *
 * You can also add an alias for a key by calling `key.addAlias(alias)`.
 */
export declare class EncryptionKeyAlias extends Construct {
    /**
     * The name of the alias.
     */
    aliasName: string;
    constructor(scope: Construct, id: string, props: EncryptionKeyAliasProps);
}
