"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_iam_1 = require("@aws-cdk/aws-iam");
const cdk_1 = require("@aws-cdk/cdk");
const lib_1 = require("../lib");
const app = new cdk_1.App();
const stack = new cdk_1.Stack(app, `aws-cdk-kms-1`);
const key = new lib_1.EncryptionKey(stack, 'MyKey', { retain: false });
key.addToResourcePolicy(new aws_iam_1.PolicyStatement()
    .addAllResources()
    .addAction('kms:encrypt')
    .addAwsPrincipal(stack.accountId));
key.addAlias('alias/bar');
app.run();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcua2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcua2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsOENBQW1EO0FBQ25ELHNDQUEwQztBQUMxQyxnQ0FBdUM7QUFFdkMsTUFBTSxHQUFHLEdBQUcsSUFBSSxTQUFHLEVBQUUsQ0FBQztBQUV0QixNQUFNLEtBQUssR0FBRyxJQUFJLFdBQUssQ0FBQyxHQUFHLEVBQUUsZUFBZSxDQUFDLENBQUM7QUFFOUMsTUFBTSxHQUFHLEdBQUcsSUFBSSxtQkFBYSxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztBQUVqRSxHQUFHLENBQUMsbUJBQW1CLENBQUMsSUFBSSx5QkFBZSxFQUFFO0tBQzFDLGVBQWUsRUFBRTtLQUNqQixTQUFTLENBQUMsYUFBYSxDQUFDO0tBQ3hCLGVBQWUsQ0FBQyxLQUFLLENBQUMsU0FBUyxDQUFDLENBQUMsQ0FBQztBQUVyQyxHQUFHLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFDO0FBRTFCLEdBQUcsQ0FBQyxHQUFHLEVBQUUsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IFBvbGljeVN0YXRlbWVudCB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1pYW0nO1xuaW1wb3J0IHsgQXBwLCBTdGFjayB9IGZyb20gJ0Bhd3MtY2RrL2Nkayc7XG5pbXBvcnQgeyBFbmNyeXB0aW9uS2V5IH0gZnJvbSAnLi4vbGliJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsIGBhd3MtY2RrLWttcy0xYCk7XG5cbmNvbnN0IGtleSA9IG5ldyBFbmNyeXB0aW9uS2V5KHN0YWNrLCAnTXlLZXknLCB7IHJldGFpbjogZmFsc2UgfSk7XG5cbmtleS5hZGRUb1Jlc291cmNlUG9saWN5KG5ldyBQb2xpY3lTdGF0ZW1lbnQoKVxuICAuYWRkQWxsUmVzb3VyY2VzKClcbiAgLmFkZEFjdGlvbigna21zOmVuY3J5cHQnKVxuICAuYWRkQXdzUHJpbmNpcGFsKHN0YWNrLmFjY291bnRJZCkpO1xuXG5rZXkuYWRkQWxpYXMoJ2FsaWFzL2JhcicpO1xuXG5hcHAucnVuKCk7XG4iXX0=