"use strict";
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/cdk");
const kms = require("../lib");
module.exports = {
    'Via service, any principal'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const statement = new iam.PolicyStatement()
            .addAction('abc:call')
            .addPrincipal(new kms.ViaServicePrincipal('bla.amazonaws.com'))
            .addResource('*');
        // THEN
        test.deepEqual(stack.node.resolve(statement), {
            Action: 'abc:call',
            Condition: { StringEquals: { 'kms:ViaService': 'bla.amazonaws.com' } },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
    'Via service, principal with conditions'(test) {
        // GIVEN
        const stack = new cdk.Stack();
        // WHEN
        const statement = new iam.PolicyStatement()
            .addAction('abc:call')
            .addPrincipal(new kms.ViaServicePrincipal('bla.amazonaws.com', new iam.OrganizationPrincipal('o-1234')))
            .addResource('*');
        // THEN
        test.deepEqual(stack.node.resolve(statement), {
            Action: 'abc:call',
            Condition: {
                StringEquals: {
                    'kms:ViaService': 'bla.amazonaws.com',
                    'aws:PrincipalOrgID': 'o-1234'
                }
            },
            Effect: 'Allow',
            Principal: '*',
            Resource: '*'
        });
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGVzdC52aWEtc2VydmljZS1wcmluY2lwYWwuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ0ZXN0LnZpYS1zZXJ2aWNlLXByaW5jaXBhbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiO0FBQUEsd0NBQXlDO0FBQ3pDLG9DQUFxQztBQUVyQyw4QkFBK0I7QUFFL0IsaUJBQVM7SUFDUCw0QkFBNEIsQ0FBQyxJQUFVO1FBQ3JDLFFBQVE7UUFDUixNQUFNLEtBQUssR0FBRyxJQUFJLEdBQUcsQ0FBQyxLQUFLLEVBQUUsQ0FBQztRQUU5QixPQUFPO1FBQ1AsTUFBTSxTQUFTLEdBQUcsSUFBSSxHQUFHLENBQUMsZUFBZSxFQUFFO2FBQ3hDLFNBQVMsQ0FBQyxVQUFVLENBQUM7YUFDckIsWUFBWSxDQUFDLElBQUksR0FBRyxDQUFDLG1CQUFtQixDQUFDLG1CQUFtQixDQUFDLENBQUM7YUFDOUQsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBRXBCLE9BQU87UUFDUCxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUFFO1lBQzVDLE1BQU0sRUFBRSxVQUFVO1lBQ2xCLFNBQVMsRUFBRSxFQUFFLFlBQVksRUFBRSxFQUFFLGdCQUFnQixFQUFFLG1CQUFtQixFQUFFLEVBQUU7WUFDdEUsTUFBTSxFQUFFLE9BQU87WUFDZixTQUFTLEVBQUUsR0FBRztZQUNkLFFBQVEsRUFBRSxHQUFHO1NBQ2QsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO0lBQ2QsQ0FBQztJQUVELHdDQUF3QyxDQUFDLElBQVU7UUFDakQsUUFBUTtRQUNSLE1BQU0sS0FBSyxHQUFHLElBQUksR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDO1FBRTlCLE9BQU87UUFDUCxNQUFNLFNBQVMsR0FBRyxJQUFJLEdBQUcsQ0FBQyxlQUFlLEVBQUU7YUFDeEMsU0FBUyxDQUFDLFVBQVUsQ0FBQzthQUNyQixZQUFZLENBQUMsSUFBSSxHQUFHLENBQUMsbUJBQW1CLENBQUMsbUJBQW1CLEVBQUUsSUFBSSxHQUFHLENBQUMscUJBQXFCLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQzthQUN2RyxXQUFXLENBQUMsR0FBRyxDQUFDLENBQUM7UUFFcEIsT0FBTztRQUNQLElBQUksQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsU0FBUyxDQUFDLEVBQUU7WUFDNUMsTUFBTSxFQUFFLFVBQVU7WUFDbEIsU0FBUyxFQUFFO2dCQUNULFlBQVksRUFBRTtvQkFDWixnQkFBZ0IsRUFBRSxtQkFBbUI7b0JBQ3JDLG9CQUFvQixFQUFFLFFBQVE7aUJBQy9CO2FBQ0Y7WUFDRCxNQUFNLEVBQUUsT0FBTztZQUNmLFNBQVMsRUFBRSxHQUFHO1lBQ2QsUUFBUSxFQUFFLEdBQUc7U0FDZCxDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsSUFBSSxFQUFFLENBQUM7SUFDZCxDQUFDO0NBQ0YsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBpYW0gPSByZXF1aXJlKCdAYXdzLWNkay9hd3MtaWFtJyk7XG5pbXBvcnQgY2RrID0gcmVxdWlyZSgnQGF3cy1jZGsvY2RrJyk7XG5pbXBvcnQgeyBUZXN0IH0gZnJvbSAnbm9kZXVuaXQnO1xuaW1wb3J0IGttcyA9IHJlcXVpcmUoJy4uL2xpYicpO1xuXG5leHBvcnQgPSB7XG4gICdWaWEgc2VydmljZSwgYW55IHByaW5jaXBhbCcodGVzdDogVGVzdCkge1xuICAgIC8vIEdJVkVOXG4gICAgY29uc3Qgc3RhY2sgPSBuZXcgY2RrLlN0YWNrKCk7XG5cbiAgICAvLyBXSEVOXG4gICAgY29uc3Qgc3RhdGVtZW50ID0gbmV3IGlhbS5Qb2xpY3lTdGF0ZW1lbnQoKVxuICAgICAgLmFkZEFjdGlvbignYWJjOmNhbGwnKVxuICAgICAgLmFkZFByaW5jaXBhbChuZXcga21zLlZpYVNlcnZpY2VQcmluY2lwYWwoJ2JsYS5hbWF6b25hd3MuY29tJykpXG4gICAgICAuYWRkUmVzb3VyY2UoJyonKTtcblxuICAgIC8vIFRIRU5cbiAgICB0ZXN0LmRlZXBFcXVhbChzdGFjay5ub2RlLnJlc29sdmUoc3RhdGVtZW50KSwge1xuICAgICAgQWN0aW9uOiAnYWJjOmNhbGwnLFxuICAgICAgQ29uZGl0aW9uOiB7IFN0cmluZ0VxdWFsczogeyAna21zOlZpYVNlcnZpY2UnOiAnYmxhLmFtYXpvbmF3cy5jb20nIH0gfSxcbiAgICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICAgIFByaW5jaXBhbDogJyonLFxuICAgICAgUmVzb3VyY2U6ICcqJ1xuICAgIH0pO1xuXG4gICAgdGVzdC5kb25lKCk7XG4gIH0sXG5cbiAgJ1ZpYSBzZXJ2aWNlLCBwcmluY2lwYWwgd2l0aCBjb25kaXRpb25zJyh0ZXN0OiBUZXN0KSB7XG4gICAgLy8gR0lWRU5cbiAgICBjb25zdCBzdGFjayA9IG5ldyBjZGsuU3RhY2soKTtcblxuICAgIC8vIFdIRU5cbiAgICBjb25zdCBzdGF0ZW1lbnQgPSBuZXcgaWFtLlBvbGljeVN0YXRlbWVudCgpXG4gICAgICAuYWRkQWN0aW9uKCdhYmM6Y2FsbCcpXG4gICAgICAuYWRkUHJpbmNpcGFsKG5ldyBrbXMuVmlhU2VydmljZVByaW5jaXBhbCgnYmxhLmFtYXpvbmF3cy5jb20nLCBuZXcgaWFtLk9yZ2FuaXphdGlvblByaW5jaXBhbCgnby0xMjM0JykpKVxuICAgICAgLmFkZFJlc291cmNlKCcqJyk7XG5cbiAgICAvLyBUSEVOXG4gICAgdGVzdC5kZWVwRXF1YWwoc3RhY2subm9kZS5yZXNvbHZlKHN0YXRlbWVudCksIHtcbiAgICAgIEFjdGlvbjogJ2FiYzpjYWxsJyxcbiAgICAgIENvbmRpdGlvbjoge1xuICAgICAgICBTdHJpbmdFcXVhbHM6IHtcbiAgICAgICAgICAna21zOlZpYVNlcnZpY2UnOiAnYmxhLmFtYXpvbmF3cy5jb20nLFxuICAgICAgICAgICdhd3M6UHJpbmNpcGFsT3JnSUQnOiAnby0xMjM0J1xuICAgICAgICB9XG4gICAgICB9LFxuICAgICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgICAgUHJpbmNpcGFsOiAnKicsXG4gICAgICBSZXNvdXJjZTogJyonXG4gICAgfSk7XG5cbiAgICB0ZXN0LmRvbmUoKTtcbiAgfSxcbn07Il19