/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import java.io.Serializable;

public class HalfFloat
implements Serializable,
Comparable<HalfFloat> {
    private final short value;
    private static short exponentMask = (short)31744;
    private static short significantMask = (short)1023;
    private static int signOffset = 15;
    private static int exponentOffset = 10;
    private static int significantOffset = 0;
    private static final long serialVersionUID = 1L;
    public static final int MAX_EXPONENT = 15;
    public static final HalfFloat MAX_VALUE = new HalfFloat(31743);
    public static final int MIN_EXPONENT = -15;
    public static final HalfFloat MIN_NORMAL = new HalfFloat(1024);
    public static final HalfFloat MIN_VALUE = new HalfFloat(1);
    public static final HalfFloat NaN = new HalfFloat(32256);
    public static final HalfFloat NEGATIVE_INFINITY = new HalfFloat(64512);
    public static final HalfFloat POSITIVE_INFINITY = new HalfFloat(31744);
    public static final int SIZE = 16;

    protected HalfFloat(int n) {
        assert ((n & 0xFFFF) == n);
        this.value = (short)n;
    }

    public HalfFloat(double d) {
        if (Double.isNaN(d)) {
            this.value = HalfFloat.NaN.value;
        } else if (Double.isInfinite(d) || Math.abs(d) > MAX_VALUE.doubleValue()) {
            this.value = d > 0.0 ? HalfFloat.POSITIVE_INFINITY.value : HalfFloat.NEGATIVE_INFINITY.value;
        } else {
            long l = Double.doubleToRawLongBits(d);
            long l2 = l >> 63 & 1L;
            long l3 = l >> 52 & 0x7FFL;
            long l4 = l & 0xFFFFFFFFFFFFFL;
            if ((l3 -= 1075L) != -1075L) {
                l4 |= 0x10000000000000L;
            } else {
                ++l3;
            }
            if (l3 > -37L) {
                this.value = l2 == 0L ? HalfFloat.POSITIVE_INFINITY.value : HalfFloat.NEGATIVE_INFINITY.value;
            } else {
                l4 >>= 42;
                long l5 = -25L - (l3 += 42L) + 1L;
                if (l5 > 0L) {
                    l4 >>= (int)l5;
                    l3 = -25L;
                }
                long l6 = l2 << signOffset;
                long l7 = ((l3 += 10L) + 15L & 0x1FL) << exponentOffset;
                long l8 = l4 & (long)significantMask;
                this.value = (short)(l6 | l7 | l8);
            }
        }
    }

    public HalfFloat(float f) {
        this((double)f);
    }

    public HalfFloat(String string) {
        this(new Double(string));
    }

    public byte byteValue() {
        return new Float(this.floatValue()).byteValue();
    }

    @Override
    public int compareTo(HalfFloat halfFloat) {
        Float f = new Float(this.floatValue());
        Float f2 = new Float(halfFloat.floatValue());
        return f.compareTo(f2);
    }

    public double doubleValue() {
        return this.floatValue();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return HalfFloat.halfFloatToShortBits(this) == HalfFloat.halfFloatToShortBits((HalfFloat)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public static short halfFloatToShortBits(HalfFloat halfFloat) {
        return HalfFloat.halfFloatToRawShortBits(halfFloat.isNaN() ? NaN : halfFloat);
    }

    public static short halfFloatToRawShortBits(HalfFloat halfFloat) {
        return halfFloat.value;
    }

    public float floatValue() {
        int n = this.value >> signOffset & 1;
        int n2 = (this.value & exponentMask) >> exponentOffset;
        int n3 = (this.value & significantMask) >> significantOffset;
        n = 1 - 2 * n;
        if (this.isNaN()) {
            return Float.NaN;
        }
        if (this.isInfinite()) {
            if (n > 0) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        if (n2 == 0 && n3 == 0) {
            if (n > 0) {
                return 0.0f;
            }
            return -0.0f;
        }
        if (n2 != 0) {
            n3 |= 1 << exponentOffset;
        } else {
            ++n2;
        }
        return (float)(n3 *= n) * (float)Math.pow(2.0, n2 -= 25);
    }

    public int hashCode() {
        return HalfFloat.halfFloatToShortBits(this);
    }

    public static HalfFloat shortBitsToFloat(short s) {
        int n = s & 0xFFFF;
        return new HalfFloat(n);
    }

    public int intValue() {
        return new Float(this.floatValue()).intValue();
    }

    public boolean isInfinite() {
        return (this.value & HalfFloat.POSITIVE_INFINITY.value) == HalfFloat.POSITIVE_INFINITY.value && (this.value & significantMask) == 0;
    }

    public boolean isNaN() {
        return (this.value & HalfFloat.POSITIVE_INFINITY.value) == HalfFloat.POSITIVE_INFINITY.value && (this.value & significantMask) != 0;
    }

    public boolean isNormal() {
        return (this.value & exponentMask) >> exponentOffset != 0 || (this.value & significantMask) == 0;
    }

    public long longValue() {
        return new Float(this.floatValue()).longValue();
    }

    public short shortValue() {
        return new Float(this.floatValue()).shortValue();
    }

    public static String toHexString(HalfFloat halfFloat) {
        return Float.toHexString(new Float(halfFloat.floatValue()).floatValue());
    }

    public String toString() {
        return new Float(this.floatValue()).toString();
    }
}

