/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import java.util.Arrays;
import java.util.concurrent.Callable;

public class Histogram
implements Callable<Histogram> {
    final int[] counts;
    final float min;
    final float max;
    final float step;
    final float[] values;
    boolean called = false;
    final float[] bins;
    int outOfRangeCount = 0;

    private float[] intitializeBins() {
        float[] fArray = new float[this.counts.length + 1];
        fArray[0] = this.min;
        for (int i = 1; i < fArray.length; ++i) {
            fArray[i] = fArray[i - 1] + this.step;
        }
        return fArray;
    }

    public Histogram(float[] fArray, float f, float f2, float f3) {
        this.min = f;
        this.max = f2;
        this.values = fArray;
        this.step = f3;
        this.counts = new int[(int)Math.ceil((f2 - f) / f3)];
        this.bins = this.intitializeBins();
    }

    public Histogram(float[] fArray, float f, float f2, int n) {
        this.min = f;
        this.max = f2;
        this.values = fArray;
        this.step = (f2 - f) / (float)n;
        this.counts = new int[n];
        this.bins = this.intitializeBins();
    }

    private static float min(float[] fArray) {
        float f = Float.POSITIVE_INFINITY;
        for (float f2 : fArray) {
            if (!(f2 < f)) continue;
            f = f2;
        }
        return f;
    }

    private static float max(float[] fArray) {
        float f = Float.NEGATIVE_INFINITY;
        for (float f2 : fArray) {
            if (!(f2 > f)) continue;
            f = f2;
        }
        return f;
    }

    public Histogram(float[] fArray, float f) {
        this(fArray, Histogram.min(fArray), Histogram.max(fArray), f);
    }

    public Histogram(float[] fArray, int n) {
        this(fArray, Histogram.min(fArray), Histogram.max(fArray), n);
    }

    @Override
    public Histogram call() {
        for (float f : this.values) {
            int n = Arrays.binarySearch(this.bins, f);
            if (n < 0 && ((n = Math.abs(n + 1)) == 0 || n == this.bins.length)) {
                ++this.outOfRangeCount;
                continue;
            }
            if (n == this.counts.length) {
                // empty if block
            }
            int n2 = --n;
            this.counts[n2] = this.counts[n2] + 1;
        }
        this.called = true;
        return this;
    }

    public float[] getMidPoints() {
        assert (this.called);
        float[] fArray = new float[this.counts.length];
        if (fArray.length > 0) {
            fArray[0] = this.min + this.step / 2.0f;
        }
        for (int i = 1; i < fArray.length; ++i) {
            fArray[i] = fArray[i - 1] + this.step;
        }
        return fArray;
    }

    public int[] getCounts() {
        assert (this.called);
        return this.counts;
    }

    public float getMax() {
        assert (this.called);
        return this.max;
    }

    public float getMin() {
        assert (this.called);
        return this.min;
    }

    public float getStep() {
        assert (this.called);
        return this.step;
    }

    public int getOutOfRangeCount() {
        assert (this.called);
        return this.outOfRangeCount;
    }

    public float[] getBins() {
        assert (this.called);
        return this.bins;
    }

    private static int clipRange(int n, int n2) {
        return n < 0 ? 0 : (n >= n2 ? n2 - 1 : n);
    }

    public static double[] getQuartiles(double[] dArray) {
        assert (dArray.length > 0);
        double[] dArray2 = Arrays.copyOf(dArray, dArray.length);
        Arrays.sort(dArray2);
        float f = ((float)dArray2.length + 1.0f) * 0.25f - 1.0f;
        float f2 = ((float)dArray2.length + 1.0f) * 0.5f - 1.0f;
        float f3 = ((float)dArray2.length + 1.0f) * 0.75f - 1.0f;
        int n = (int)Math.floor(f);
        int n2 = (int)Math.ceil(f);
        int n3 = (int)Math.floor(f2);
        int n4 = (int)Math.ceil(f2);
        int n5 = (int)Math.floor(f3);
        int n6 = (int)Math.ceil(f3);
        double d = dArray2[0];
        double d2 = dArray2[dArray2.length - 1];
        n = Histogram.clipRange(n, dArray2.length);
        n2 = Histogram.clipRange(n2, dArray2.length);
        n3 = Histogram.clipRange(n3, dArray2.length);
        n4 = Histogram.clipRange(n4, dArray2.length);
        n5 = Histogram.clipRange(n5, dArray2.length);
        n6 = Histogram.clipRange(n6, dArray2.length);
        double d3 = dArray2[n] * (double)(1.0f - f + (float)n) + dArray2[n2] * (double)(f - (float)n);
        double d4 = dArray2[n3] * (double)(1.0f - f2 + (float)n3) + dArray2[n4] * (double)(f2 - (float)n3);
        double d5 = dArray2[n5] * (double)(1.0f - f3 + (float)n5) + dArray2[n6] * (double)(f3 - (float)n5);
        double[] dArray3 = new double[]{d, d3, d4, d5, d2};
        return dArray3;
    }

    public static double[] getQuartiles(int[] nArray) {
        double[] dArray = new double[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            dArray[i] = nArray[i];
        }
        return Histogram.getQuartiles(dArray);
    }
}

