/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciAnalysis.ImageCompareInterface;
import GiciException.WarningException;
import java.util.Arrays;

public final class ImageCompareLowMem
implements ImageCompareInterface {
    private double[] variance;
    private double[] mae;
    private double[] pae;
    private double[] mse;
    private double[] rmse;
    private double[] me;
    private double[] snr;
    private double[] snrVar;
    private double[] psnr;
    private double[] psnrSalomon;
    private boolean[] equal;
    private double[] rrmse;
    private double[] nmse;
    private double[] psnrNc;
    private double totalVariance;
    private double totalEnergy;
    private double totalMAE;
    private double totalPAE;
    private double totalMSE;
    private double totalRMSE;
    private double totalME;
    private double totalSNR;
    private double totalSNRVAR;
    private double totalPSNR;
    private double totalPSNRSALOMON;
    private boolean totalEQUAL;
    private double totalRRMSE;
    private double totalNMSE;
    private double totalPSNRNC;
    final int zSize;
    final int ySize;
    final int xSize;
    final long perBandImagePixels;
    final long totalImagePixels;
    final int pixelBitDepth;
    final boolean isSigned;
    final double[] mean1;
    final double[] mean2;
    final double[] sum1;
    final double[] sum2;
    final double[] min1;
    final double[] max1;
    final double[] min2;
    final double[] max2;
    final double[] absoluteErrorSum;
    final double[] absoluteErrorPeak;
    final double[] squaredErrorSum;
    final double[] errorSum;
    final double[] squaredRelativeErrorSum;
    final double[] energy1;
    final double[] energy2;
    final boolean[] perBandResultsCalculated;
    boolean totalResultsCalculated;

    private double getRealRange(int n) {
        assert (this.perBandResultsCalculated[n]);
        double d = Math.min(this.min1[n], this.min2[n]);
        double d2 = Math.max(this.max1[n], this.max2[n]);
        int n2 = this.isSigned ? (int)Math.max(Math.ceil(Math.log(d2 + 1.0) / Math.log(2.0)), Math.ceil(Math.log(Math.abs(d)) / Math.log(2.0))) + 1 : (int)Math.ceil(Math.log(d2 + 1.0) / Math.log(2.0));
        double d3 = Math.pow(2.0, n2) - 1.0;
        return d3;
    }

    private double getRange(int n) {
        return Math.pow(2.0, n) - 1.0;
    }

    private int imprecisionBits(double d, int n) {
        int n2 = 0;
        if (d > 9.007199254740991E15) {
            n2 = Math.max(n, (int)Math.ceil(Math.log(d / 9.007199254740991E15) / Math.log(2.0)));
        }
        return n2;
    }

    private void reportOverflow(int n) {
        if (n > 0) {
            System.err.println("Inexact results may be produced due to insufficient mantissa bits (at least " + n + " more bits required).");
            double d = this.totalImagePixels;
            double d2 = 0.0;
            if (this.pixelBitDepth > 12) {
                for (int i = 0; i < this.zSize; ++i) {
                    d2 = Math.max(this.getRealRange(i), d2);
                }
            } else {
                d2 = this.getRange(this.pixelBitDepth);
            }
            double d3 = Math.ceil(Math.log(d * d2 * d2) / Math.log(2.0));
            double d4 = Math.ceil(Math.log(d * d2) / Math.log(2.0));
            double d5 = Math.ceil(Math.log((double)(this.ySize * this.xSize) * d2 * d2) / Math.log(2.0));
            double d6 = Math.ceil(Math.log((double)(this.ySize * this.xSize) * d2) / Math.log(2.0));
            if (d3 > 52.0) {
                System.err.println("Image too large for exact computations. Required precision for this image is " + d3 + " bits.");
                if (d4 <= 52.0) {
                    System.err.println("* All but MSE related measures (MSE, PSNR, SNR) are still accurate.");
                }
                if (d5 <= 52.0) {
                    System.err.println("* Individual component results are still accurate");
                }
                if (d6 <= 52.0 && d4 > 52.0 && d5 > 52.0) {
                    System.err.println("* Individual component results of all but MSE related measures (MSE, PSNR, SNR) are still accurate.");
                }
            }
        }
    }

    public ImageCompareLowMem(int[] nArray, int[] nArray2) throws WarningException {
        this.zSize = nArray[0];
        this.ySize = nArray[1];
        this.xSize = nArray[2];
        this.perBandImagePixels = (long)this.ySize * (long)this.xSize;
        this.totalImagePixels = (long)this.zSize * (long)this.ySize * (long)this.xSize;
        if (this.zSize != nArray2[0] || this.ySize != nArray2[1] || this.xSize != nArray2[2]) {
            throw new WarningException("Image sizes (zSize, ySize and xSize) must be the same on both images to perform comparisons for a specific components.");
        }
        switch (nArray[3]) {
            case 0: {
                this.pixelBitDepth = 1;
                this.isSigned = false;
                break;
            }
            case 1: {
                this.pixelBitDepth = 8;
                this.isSigned = false;
                break;
            }
            case 2: {
                this.pixelBitDepth = 16;
                this.isSigned = false;
                break;
            }
            case 3: {
                this.pixelBitDepth = 16;
                this.isSigned = true;
                break;
            }
            case 4: {
                this.pixelBitDepth = 32;
                this.isSigned = true;
                break;
            }
            default: {
                throw new WarningException("Unsupported image data type.");
            }
        }
        this.variance = new double[this.zSize];
        this.mae = new double[this.zSize];
        this.pae = new double[this.zSize];
        this.mse = new double[this.zSize];
        this.rmse = new double[this.zSize];
        this.me = new double[this.zSize];
        this.snr = new double[this.zSize];
        this.snrVar = new double[this.zSize];
        this.psnr = new double[this.zSize];
        this.psnrSalomon = new double[this.zSize];
        this.equal = new boolean[this.zSize];
        this.rrmse = new double[this.zSize];
        this.nmse = new double[this.zSize];
        this.psnrNc = new double[this.zSize];
        this.mean1 = new double[this.zSize];
        this.mean2 = new double[this.zSize];
        this.sum1 = new double[this.zSize];
        this.sum2 = new double[this.zSize];
        this.min1 = new double[this.zSize];
        this.max1 = new double[this.zSize];
        this.min2 = new double[this.zSize];
        this.max2 = new double[this.zSize];
        this.absoluteErrorSum = new double[this.zSize];
        this.absoluteErrorPeak = new double[this.zSize];
        this.squaredErrorSum = new double[this.zSize];
        this.errorSum = new double[this.zSize];
        this.squaredRelativeErrorSum = new double[this.zSize];
        this.energy1 = new double[this.zSize];
        this.energy2 = new double[this.zSize];
        this.perBandResultsCalculated = new boolean[this.zSize];
    }

    public void processBand(int[][] nArray, int[][] nArray2, int n) {
        this.min1[n] = Double.POSITIVE_INFINITY;
        this.max1[n] = Double.NEGATIVE_INFINITY;
        this.min2[n] = Double.POSITIVE_INFINITY;
        this.max2[n] = Double.NEGATIVE_INFINITY;
        this.absoluteErrorPeak[n] = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.ySize; ++i) {
            for (int j = 0; j < this.xSize; ++j) {
                double d = nArray[i][j];
                double d2 = nArray2[i][j];
                double d3 = nArray[i][j] - nArray2[i][j];
                int n2 = n;
                this.sum1[n2] = this.sum1[n2] + d;
                int n3 = n;
                this.sum2[n3] = this.sum2[n3] + d2;
                int n4 = n;
                this.energy1[n4] = this.energy1[n4] + d * d;
                int n5 = n;
                this.energy2[n5] = this.energy2[n5] + d2 * d2;
                this.max1[n] = Math.max(this.max1[n], d);
                this.max2[n] = Math.max(this.max2[n], d2);
                this.min1[n] = Math.min(this.min1[n], d);
                this.min2[n] = Math.min(this.min2[n], d2);
                int n6 = n;
                this.absoluteErrorSum[n6] = this.absoluteErrorSum[n6] + Math.abs(d3);
                this.absoluteErrorPeak[n] = Math.max(this.absoluteErrorPeak[n], Math.abs(d3));
                int n7 = n;
                this.squaredErrorSum[n7] = this.squaredErrorSum[n7] + d3 * d3;
                int n8 = n;
                this.errorSum[n8] = this.errorSum[n8] + d3;
                double d4 = d3 == 0.0 ? 0.0 : d3 * d3 / (d * d);
                int n9 = n;
                this.squaredRelativeErrorSum[n9] = this.squaredRelativeErrorSum[n9] + d4;
            }
        }
        this.mean1[n] = this.sum1[n] / (double)this.perBandImagePixels;
        this.mean2[n] = this.sum2[n] / (double)this.perBandImagePixels;
        this.variance[n] = (this.energy1[n] - this.sum1[n] * this.sum1[n] / (double)this.perBandImagePixels) / (double)this.perBandImagePixels;
        double d = this.getRange(this.pixelBitDepth);
        this.mae[n] = this.absoluteErrorSum[n] / (double)this.perBandImagePixels;
        this.pae[n] = this.absoluteErrorPeak[n];
        this.mse[n] = this.squaredErrorSum[n] / (double)this.perBandImagePixels;
        this.rmse[n] = Math.sqrt(this.mse[n]);
        this.me[n] = this.errorSum[n] / (double)this.perBandImagePixels;
        this.snr[n] = 10.0 * Math.log10(this.energy1[n] / (this.mse[n] * (double)this.perBandImagePixels));
        this.snrVar[n] = 10.0 * Math.log10(this.variance[n] / this.mse[n]);
        this.psnr[n] = 10.0 * Math.log10(d * d / this.mse[n]);
        this.psnrSalomon[n] = 10.0 * Math.log10((d + 1.0) * (d + 1.0) / (4.0 * this.mse[n]));
        this.equal[n] = this.absoluteErrorSum[n] == 0.0;
        this.rrmse[n] = Math.sqrt(this.squaredRelativeErrorSum[n] / (double)this.perBandImagePixels);
        this.nmse[n] = 100.0 * this.mse[n] / this.energy1[n];
        this.psnrNc[n] = 10.0 * Math.log10(this.max1[n] * this.max1[n] / this.mse[n]);
        this.perBandResultsCalculated[n] = true;
    }

    public void produceTotalResults() {
        int n = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = 0.0;
        double d5 = Double.NEGATIVE_INFINITY;
        double d6 = 0.0;
        double d7 = 0.0;
        this.totalRRMSE = 0.0;
        for (int i = 0; i < this.zSize; ++i) {
            d += this.sum1[i];
            d2 += this.sum2[i];
            this.totalEnergy += this.energy1[i];
            d3 = Math.max(d3, this.max1[i]);
            d4 += this.absoluteErrorSum[i];
            d5 = Math.max(d5, this.absoluteErrorPeak[i]);
            d6 += this.squaredErrorSum[i];
            d7 += this.errorSum[i];
            this.totalRRMSE += this.squaredRelativeErrorSum[i];
        }
        n = this.imprecisionBits(this.totalEnergy, n);
        n = this.imprecisionBits(d, n);
        n = this.imprecisionBits(d * d, n);
        n = this.imprecisionBits(d2, n);
        n = this.imprecisionBits(d4, n);
        n = this.imprecisionBits(d5, n);
        n = this.imprecisionBits(d6, n);
        this.totalVariance = (this.totalEnergy - d * d / (double)this.perBandImagePixels) / (double)this.perBandImagePixels;
        System.err.println(this.totalEnergy + " " + d + " " + this.totalVariance);
        double d8 = this.getRange(this.pixelBitDepth);
        this.totalMAE = d4 / (double)this.totalImagePixels;
        this.totalPAE = d5;
        this.totalMSE = d6 / (double)this.totalImagePixels;
        this.totalRMSE = Math.sqrt(this.totalMSE);
        this.totalME = d7 / (double)this.totalImagePixels;
        this.totalSNR = 10.0 * Math.log10(this.totalEnergy / (this.totalMSE * (double)this.totalImagePixels));
        this.totalSNRVAR = 10.0 * Math.log10(this.totalVariance / this.totalMSE);
        this.totalPSNR = 10.0 * Math.log10(d8 * d8 / this.totalMSE);
        this.totalPSNRSALOMON = 10.0 * Math.log10((d8 + 1.0) * (d8 + 1.0) / (4.0 * this.totalMSE));
        this.totalEQUAL = d4 == 0.0;
        this.totalRRMSE = Math.sqrt(this.totalRRMSE / (double)this.totalImagePixels);
        this.totalNMSE = 100.0 * this.totalMSE / this.totalEnergy;
        this.totalPSNRNC = 10.0 * Math.log10(d3 * d3 / this.totalMSE);
        this.totalResultsCalculated = true;
        this.reportOverflow(n);
    }

    @Override
    public double[] getMAE() {
        return this.mae;
    }

    @Override
    public double getTotalMAE() {
        return this.totalMAE;
    }

    @Override
    public double[] getPAE() {
        return this.pae;
    }

    @Override
    public double getTotalPAE() {
        return this.totalPAE;
    }

    @Override
    public double[] getMSE() {
        return this.mse;
    }

    @Override
    public double getTotalMSE() {
        return this.totalMSE;
    }

    @Override
    public double[] getRMSE() {
        return this.rmse;
    }

    @Override
    public double getTotalRMSE() {
        return this.totalRMSE;
    }

    @Override
    public double[] getME() {
        return this.me;
    }

    @Override
    public double getTotalME() {
        return this.totalME;
    }

    @Override
    public double[] getSNR() {
        return this.snr;
    }

    @Override
    public double getTotalSNR() {
        return this.totalSNR;
    }

    @Override
    public double[] getPSNR() {
        return this.psnr;
    }

    @Override
    public double getTotalPSNR() {
        return this.totalPSNR;
    }

    @Override
    public double[] getPSNRSALOMON() {
        return this.psnrSalomon;
    }

    @Override
    public double getTotalPSNRSALOMON() {
        return this.totalPSNRSALOMON;
    }

    @Override
    public boolean[] getEQUAL() {
        return this.equal;
    }

    @Override
    public boolean getTotalEQUAL() {
        return this.totalEQUAL;
    }

    @Override
    public double[] getSNRVAR() {
        return this.snrVar;
    }

    @Override
    public double getTotalSNRVAR() {
        return this.totalSNRVAR;
    }

    @Override
    public double[] getRRMSE() {
        return this.rrmse;
    }

    @Override
    public double getTotalRRMSE() {
        return this.totalRRMSE;
    }

    @Override
    public double[] getNMSE() {
        return this.nmse;
    }

    @Override
    public double getTotalNMSE() {
        return this.totalNMSE;
    }

    @Override
    public double[] getPSNRNC() {
        return this.psnrNc;
    }

    @Override
    public double getTotalPSNRNC() {
        return this.totalPSNRNC;
    }

    @Override
    public double[] getCovariance() {
        double[] dArray = new double[this.zSize];
        Arrays.fill(dArray, Double.NaN);
        return dArray;
    }

    @Override
    public double[] getSSIM() {
        double[] dArray = new double[this.zSize];
        Arrays.fill(dArray, Double.NaN);
        return dArray;
    }

    @Override
    public double getTotalSSIM() {
        return Double.NaN;
    }
}

