/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciAnalysis.ImageCompareInterface;
import GiciException.WarningException;
import GiciParallel.ParallelMap;
import java.util.Set;
import java.util.TreeSet;

public final class ImageCompareSA
implements ImageCompareInterface {
    private double[] covariance = null;
    private double[] variance = null;
    private double[] variance2 = null;
    private double totalVariance;
    private double[] energy = null;
    private double totalEnergy = 0.0;
    private double[] mae = null;
    private double totalMAE = 0.0;
    private double[] pae = null;
    private double totalPAE = 0.0;
    private double[] mse = null;
    private double totalMSE = 0.0;
    private double[] rmse = null;
    private double totalRMSE = 0.0;
    private double[] me = null;
    private double totalME = 0.0;
    private double[] snr = null;
    private double[] snrVar = null;
    private double totalSNR = 0.0;
    private double totalSNRVAR = 0.0;
    private double[] psnr = null;
    private double[] psnrSalomon = null;
    private double totalPSNR;
    private double totalPSNRSALOMON;
    private boolean[] equal;
    private boolean totalEQUAL;
    private double[] ssim = null;
    private double totalSSIM = 0.0;
    private double[] rrmse = null;
    private double totalRRMSE = 0.0;
    private double[] nmse = null;
    private double totalNMSE = 0.0;
    private double[] psnrNc = null;
    private double totalPSNRNC = 0.0;
    private long[] imagePixels = null;
    private float[] regionOfInterest = null;
    private float[][][] image1 = null;
    private float[][][] image2 = null;
    private byte[][][] mask = null;

    public ImageCompareSA(final float[][][] fArray, final float[][][] fArray2, int[] nArray, final byte[][][] byArray, float[] fArray3, int n, Set<Integer> set) throws WarningException {
        double d;
        double d2;
        double d3;
        int n22;
        this.image1 = fArray;
        this.image2 = fArray2;
        this.mask = byArray;
        int n3 = fArray.length;
        int n4 = fArray[0].length;
        int n5 = fArray[0][0].length;
        int n6 = fArray2.length;
        int n7 = fArray2[0].length;
        int n8 = fArray2[0][0].length;
        if (n4 != n7 || n5 != n8) {
            throw new WarningException("Image sizes (ySize and xSize) must be the same on both images to perform comparisons for a specific components.");
        }
        for (int n22 : set) {
            if (n22 < n3 && n22 < n6) continue;
            throw new WarningException("Component " + n22 + " (zero based offset) does not exists for one of the images.");
        }
        int n9 = 0;
        n22 = 0;
        int n10 = 0;
        if (byArray != null) {
            n9 = byArray.length;
            n22 = byArray[0].length;
            n10 = byArray[0][0].length;
            if (n9 != n6 || n22 != n7 || n10 != n8) {
                throw new WarningException("Mask size must match image size to perform the comparison.");
            }
        }
        int n11 = 0;
        this.regionOfInterest = fArray3;
        this.imagePixels = new long[n3];
        long l = 0L;
        Object object = set.iterator();
        while (object.hasNext()) {
            int n12 = object.next();
            if (byArray != null) {
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n5; ++j) {
                        if (byArray[n12][i][j] != 1) continue;
                        int n13 = n12;
                        this.imagePixels[n13] = this.imagePixels[n13] + 1L;
                    }
                }
            } else {
                this.imagePixels[n12] = n5 * n4;
            }
            l += this.imagePixels[n12];
        }
        this.energy = new double[n3];
        this.variance = new double[n3];
        this.variance2 = new double[n6];
        this.covariance = new double[n3];
        this.totalEnergy = 0.0;
        this.totalVariance = 0.0;
        object = new double[n3];
        double[] dArray = new double[n6];
        final double[] dArray2 = new double[n3];
        final double[] dArray3 = new double[n3];
        final double[] dArray4 = new double[n3];
        ParallelMap.map(new ParallelMap.ListIterator(set), new ParallelMap.MapInterface<Integer>((double[])object, dArray){
            final /* synthetic */ double[] val$mean;
            final /* synthetic */ double[] val$mean2;
            {
                this.val$mean = dArray42;
                this.val$mean2 = dArray5;
            }

            @Override
            public void apply(Integer n) {
                double d = 0.0;
                double d2 = 0.0;
                dArray4[n.intValue()] = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < fArray[n].length; ++i) {
                    for (int j = 0; j < fArray[n][i].length; ++j) {
                        if (byArray != null && byArray[n][i][j] != 1) continue;
                        double d3 = fArray[n][i][j];
                        double d4 = fArray2[n][i][j];
                        int n2 = n;
                        dArray2[n2] = dArray2[n2] + d3;
                        int n3 = n;
                        dArray3[n3] = dArray3[n3] + d4;
                        d += d3 * d3;
                        d2 += d4 * d4;
                        dArray4[n.intValue()] = Math.max(dArray4[n], d3);
                    }
                }
                this.val$mean[n.intValue()] = dArray2[n] / (double)ImageCompareSA.this.imagePixels[n];
                this.val$mean2[n.intValue()] = dArray3[n] / (double)ImageCompareSA.this.imagePixels[n];
                ImageCompareSA.this.energy[n.intValue()] = d;
            }
        });
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = Double.NEGATIVE_INFINITY;
        for (int n14 : set) {
            d4 += dArray2[n14];
            d5 += dArray3[n14];
            this.totalEnergy += this.energy[n14];
            d6 = Math.max(d6, dArray4[n14]);
        }
        n11 = this.imprecisionBits(this.totalEnergy, n11);
        n11 = this.imprecisionBits(d4, n11);
        n11 = this.imprecisionBits(d5, n11);
        double d7 = d4 / (double)l;
        double d8 = d5 / (double)l;
        double[] dArray5 = new double[n3];
        double[] dArray6 = new double[n3];
        ParallelMap.map(new ParallelMap.ListIterator(set), new ParallelMap.MapInterface<Integer>((double[])object, fArray2, dArray, d7, d8, dArray5, dArray6){
            final /* synthetic */ double[] val$mean;
            final /* synthetic */ float[][][] val$inputImage2;
            final /* synthetic */ double[] val$mean2;
            final /* synthetic */ double val$totalMean;
            final /* synthetic */ double val$totalMean2;
            final /* synthetic */ double[] val$localSquaredDifferenceSum;
            final /* synthetic */ double[] val$localSquaredDifferenceSum2;
            {
                this.val$mean = dArray;
                this.val$inputImage2 = fArray2;
                this.val$mean2 = dArray2;
                this.val$totalMean = d;
                this.val$totalMean2 = d2;
                this.val$localSquaredDifferenceSum = dArray3;
                this.val$localSquaredDifferenceSum2 = dArray4;
            }

            @Override
            public void apply(Integer n) {
                double d = 0.0;
                double d2 = 0.0;
                double d3 = 0.0;
                for (int i = 0; i < fArray[n].length; ++i) {
                    for (int j = 0; j < fArray[n][i].length; ++j) {
                        if (byArray != null && byArray[n][i][j] != 1) continue;
                        double d4 = (double)fArray[n][i][j] - this.val$mean[n];
                        double d5 = (double)this.val$inputImage2[n][i][j] - this.val$mean2[n];
                        d += d4 * d4;
                        d2 += d5 * d5;
                        d3 += d4 * d5;
                        double d6 = (double)fArray[n][i][j] - this.val$totalMean;
                        double d7 = (double)this.val$inputImage2[n][i][j] - this.val$totalMean2;
                        int n2 = n;
                        this.val$localSquaredDifferenceSum[n2] = this.val$localSquaredDifferenceSum[n2] + d6 * d6;
                        int n3 = n;
                        this.val$localSquaredDifferenceSum2[n3] = this.val$localSquaredDifferenceSum2[n3] + d7 * d7;
                    }
                }
                ImageCompareSA.this.variance[n.intValue()] = d / (double)ImageCompareSA.this.imagePixels[n];
                ImageCompareSA.this.variance2[n.intValue()] = d2 / (double)ImageCompareSA.this.imagePixels[n];
                ImageCompareSA.this.covariance[n.intValue()] = d3 / (double)ImageCompareSA.this.imagePixels[n];
            }
        });
        double d9 = 0.0;
        double d10 = 0.0;
        Object object2 = set.iterator();
        while (object2.hasNext()) {
            int n15 = object2.next();
            d9 += dArray5[n15];
            d10 += dArray6[n15];
        }
        n11 = this.imprecisionBits(d9, n11);
        this.totalVariance = d9 / (double)l;
        object2 = new double[n3];
        final double[] dArray7 = new double[n3];
        double[] dArray8 = new double[n3];
        double[] dArray9 = new double[n3];
        double[] dArray10 = new double[n3];
        ParallelMap.map(new ParallelMap.ListIterator(set), new ParallelMap.MapInterface<Integer>((double[])object2, dArray8, dArray9, dArray10){
            final /* synthetic */ double[] val$absoluteErrorSum;
            final /* synthetic */ double[] val$squaredErrorSum;
            final /* synthetic */ double[] val$errorSum;
            final /* synthetic */ double[] val$squaredRelativeErrorSum;
            {
                this.val$absoluteErrorSum = dArray2;
                this.val$squaredErrorSum = dArray3;
                this.val$errorSum = dArray4;
                this.val$squaredRelativeErrorSum = dArray5;
            }

            @Override
            public void apply(Integer n) {
                dArray7[n.intValue()] = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < fArray[n].length; ++i) {
                    for (int j = 0; j < fArray[n][i].length; ++j) {
                        double d = ImageCompareSA.this.getDiff(n, i, j);
                        double d2 = fArray[n][i][j];
                        int n2 = n;
                        this.val$absoluteErrorSum[n2] = this.val$absoluteErrorSum[n2] + Math.abs(d);
                        dArray7[n.intValue()] = Math.max(dArray7[n], Math.abs(d));
                        int n3 = n;
                        this.val$squaredErrorSum[n3] = this.val$squaredErrorSum[n3] + d * d;
                        int n4 = n;
                        this.val$errorSum[n4] = this.val$errorSum[n4] + d;
                        double d3 = d == 0.0 ? 0.0 : d * d / (d2 * d2);
                        int n5 = n;
                        this.val$squaredRelativeErrorSum[n5] = this.val$squaredRelativeErrorSum[n5] + d3;
                    }
                }
            }
        });
        this.mae = new double[n3];
        this.pae = new double[n3];
        this.mse = new double[n3];
        this.rmse = new double[n3];
        this.me = new double[n3];
        this.snr = new double[n3];
        this.snrVar = new double[n3];
        this.psnr = new double[n3];
        this.psnrSalomon = new double[n3];
        this.equal = new boolean[n3];
        this.ssim = new double[n3];
        this.rrmse = new double[n3];
        this.nmse = new double[n3];
        this.psnrNc = new double[n3];
        for (int n16 : set) {
            d3 = this.getRange(nArray[n16]);
            this.mae[n16] = (double)(object2[n16] / (double)this.imagePixels[n16]);
            this.pae[n16] = dArray7[n16];
            this.mse[n16] = dArray8[n16] / (double)this.imagePixels[n16];
            this.rmse[n16] = Math.sqrt(this.mse[n16]);
            this.me[n16] = dArray9[n16] / (double)this.imagePixels[n16];
            this.snr[n16] = 10.0 * Math.log10(this.energy[n16] / (this.mse[n16] * (double)this.imagePixels[n16]));
            this.snrVar[n16] = 10.0 * Math.log10(this.variance[n16] / this.mse[n16]);
            this.psnr[n16] = 10.0 * Math.log10(d3 * d3 / this.mse[n16]);
            this.psnrSalomon[n16] = 10.0 * Math.log10((d3 + 1.0) * (d3 + 1.0) / (4.0 * this.mse[n16]));
            this.equal[n16] = object2[n16] == 0.0;
            d2 = 0.01 * d3 * (0.01 * d3);
            d = 0.03 * d3 * (0.03 * d3);
            this.ssim[n16] = (2.0 * object[n16] * dArray[n16] + d2) * (2.0 * this.covariance[n16] + d) / ((object[n16] * object[n16] + dArray[n16] * dArray[n16] + d2) * (this.variance[n16] + this.variance2[n16] + d));
            this.rrmse[n16] = Math.sqrt(dArray10[n16] / (double)this.imagePixels[n16]);
            this.nmse[n16] = 100.0 * this.mse[n16] / this.energy[n16];
            this.psnrNc[n16] = 10.0 * Math.log10(dArray4[n16] * dArray4[n16] / this.mse[n16]);
        }
        double d11 = 0.0;
        d3 = Double.NEGATIVE_INFINITY;
        d2 = 0.0;
        d = 0.0;
        this.totalSSIM = 0.0;
        this.totalRRMSE = 0.0;
        for (int n17 : set) {
            d11 += object2[n17];
            d3 = Math.max(d3, dArray7[n17]);
            d2 += dArray8[n17];
            d += dArray9[n17];
            this.totalSSIM += this.ssim[n17];
            this.totalRRMSE += dArray10[n17];
        }
        n11 = this.imprecisionBits(d11, n11);
        n11 = this.imprecisionBits(d3, n11);
        n11 = this.imprecisionBits(d2, n11);
        double d12 = this.getRange(nArray[0]);
        for (int n18 : nArray) {
            if (this.getRange(n18) == d12) continue;
            throw new WarningException("Totals may be undefined as bit depth varies across components.");
        }
        this.totalMAE = d11 / (double)l;
        this.totalPAE = d3;
        this.totalMSE = d2 / (double)l;
        this.totalRMSE = Math.sqrt(this.totalMSE);
        this.totalME = d / (double)l;
        this.totalSNR = 10.0 * Math.log10(this.totalEnergy / (this.totalMSE * (double)l));
        this.totalSNRVAR = 10.0 * Math.log10(this.totalVariance / this.totalMSE);
        this.totalPSNR = 10.0 * Math.log10(d12 * d12 / this.totalMSE);
        this.totalPSNRSALOMON = 10.0 * Math.log10((d12 + 1.0) * (d12 + 1.0) / (4.0 * this.totalMSE));
        this.totalEQUAL = d11 == 0.0;
        this.totalSSIM /= (double)set.size();
        this.totalRRMSE = Math.sqrt(this.totalRRMSE / (double)l);
        this.totalNMSE = 100.0 * this.totalMSE / this.totalEnergy;
        this.totalPSNRNC = 10.0 * Math.log10(d6 * d6 / this.totalMSE);
        if (n11 > 0) {
            System.err.println("Inexact results may be produced due to insufficient mantissa bits (at least " + n11 + " more bits required).");
            double d13 = set.size() * n4 * n5;
            double d14 = 0.0;
            for (int n19 : set) {
                if (nArray[n19] > 12) {
                    d14 = Math.max(this.getRealRange(n19), d14);
                    continue;
                }
                d14 = Math.max(this.getRange(nArray[n19]), d14);
            }
            double d15 = Math.ceil(Math.log(d13 * d14 * d14) / Math.log(2.0));
            double d16 = Math.ceil(Math.log(d13 * d14) / Math.log(2.0));
            double d17 = Math.ceil(Math.log((double)(n4 * n5) * d14 * d14) / Math.log(2.0));
            double d18 = Math.ceil(Math.log((double)(n4 * n5) * d14) / Math.log(2.0));
            if (d15 > 52.0) {
                System.err.println("Image too large for exact computations. Required precision for this image is " + d15 + " bits.");
                if (d16 <= 52.0) {
                    System.err.println("* All but MSE related measures (MSE, PSNR, SNR) are still accurate.");
                }
                if (d17 <= 52.0) {
                    System.err.println("* Individual component results are still accurate");
                }
                if (d18 <= 52.0 && d16 > 52.0 && d17 > 52.0) {
                    System.err.println("* Individual component results of all but MSE related measures (MSE, PSNR, SNR) are still accurate.");
                }
            }
        }
    }

    private static Set<Integer> buildSetOfComponentsFromIntegerParameter(int n, int n2) {
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        if (n < 0) {
            for (int i = 0; i < n2; ++i) {
                treeSet.add(i);
            }
        } else {
            treeSet.add(n);
        }
        return treeSet;
    }

    public ImageCompareSA(float[][][] fArray, float[][][] fArray2, int[] nArray, byte[][][] byArray, float[] fArray3, int n, int n2, int n3, double[] dArray, double[] dArray2) throws WarningException {
        this(fArray, fArray2, nArray, byArray, fArray3, n, ImageCompareSA.buildSetOfComponentsFromIntegerParameter(n2, fArray.length));
    }

    private int imprecisionBits(double d, int n) {
        int n2 = 0;
        if (d > 9.007199254740991E15) {
            n2 = Math.max(n, (int)Math.ceil(Math.log(d / 9.007199254740991E15) / Math.log(2.0)));
        }
        return n2;
    }

    public double getRealRange(int n) {
        int n2;
        float f = Float.MAX_VALUE;
        float f2 = Float.MIN_VALUE;
        for (n2 = 0; n2 < this.image1[n].length; ++n2) {
            for (int i = 0; i < this.image1[n][n2].length; ++i) {
                f = Math.min(Math.min(this.image1[n][n2][i], this.image2[n][n2][i]), f);
                f2 = Math.max(Math.max(this.image1[n][n2][i], this.image2[n][n2][i]), f2);
            }
        }
        n2 = (int)Math.max(Math.ceil(Math.log(f2 + 1.0f) / Math.log(2.0)), Math.ceil(Math.log(Math.abs(f)) / Math.log(2.0))) + 1;
        double d = 0.0;
        double d2 = 0.0;
        if (this.regionOfInterest != null) {
            for (int i = 0; i < this.regionOfInterest.length / 2; ++i) {
                if (!((double)this.regionOfInterest[i * 2 + 1] > d2)) continue;
                d2 = this.regionOfInterest[i * 2 + 1];
            }
            d = Math.pow(2.0, n2) * d2 - 1.0;
        } else {
            d = Math.pow(2.0, n2) - 1.0;
        }
        return d;
    }

    public double getRange(int n) {
        double d = 0.0;
        double d2 = 0.0;
        if (this.regionOfInterest != null) {
            for (int i = 0; i < this.regionOfInterest.length / 2; ++i) {
                if (!((double)this.regionOfInterest[i * 2 + 1] > d2)) continue;
                d2 = this.regionOfInterest[i * 2 + 1];
            }
            d = Math.pow(2.0, n) * d2 - 1.0;
        } else {
            d = Math.pow(2.0, n) - 1.0;
        }
        return d;
    }

    private double getDiff(int n, int n2, int n3) {
        double d = 1.0;
        double d2 = 0.0;
        if (this.regionOfInterest != null) {
            for (int i = 0; i < this.regionOfInterest.length / 2; ++i) {
                if (this.regionOfInterest[i * 2] - 128.0f != (float)this.mask[n][n2][n3]) continue;
                d = this.regionOfInterest[i * 2 + 1];
                i = this.regionOfInterest.length;
            }
            d2 = (double)(this.image1[n][n2][n3] - this.image2[n][n2][n3]) * d;
        } else if (this.mask == null || this.mask[n][n2][n3] == 1) {
            d2 = this.image1[n][n2][n3] - this.image2[n][n2][n3];
        }
        return d2;
    }

    @Override
    public double[] getMAE() {
        return this.mae;
    }

    @Override
    public double getTotalMAE() {
        return this.totalMAE;
    }

    @Override
    public double[] getPAE() {
        return this.pae;
    }

    @Override
    public double getTotalPAE() {
        return this.totalPAE;
    }

    @Override
    public double[] getMSE() {
        return this.mse;
    }

    @Override
    public double getTotalMSE() {
        return this.totalMSE;
    }

    @Override
    public double[] getRMSE() {
        return this.rmse;
    }

    @Override
    public double getTotalRMSE() {
        return this.totalRMSE;
    }

    @Override
    public double[] getME() {
        return this.me;
    }

    @Override
    public double getTotalME() {
        return this.totalME;
    }

    @Override
    public double[] getSNR() {
        return this.snr;
    }

    @Override
    public double getTotalSNR() {
        return this.totalSNR;
    }

    @Override
    public double[] getPSNR() {
        return this.psnr;
    }

    @Override
    public double getTotalPSNR() {
        return this.totalPSNR;
    }

    @Override
    public double[] getPSNRSALOMON() {
        return this.psnrSalomon;
    }

    @Override
    public double getTotalPSNRSALOMON() {
        return this.totalPSNRSALOMON;
    }

    @Override
    public boolean[] getEQUAL() {
        return this.equal;
    }

    @Override
    public boolean getTotalEQUAL() {
        return this.totalEQUAL;
    }

    @Override
    public double[] getSNRVAR() {
        return this.snrVar;
    }

    @Override
    public double getTotalSNRVAR() {
        return this.totalSNRVAR;
    }

    @Override
    public double[] getCovariance() {
        return this.covariance;
    }

    @Override
    public double[] getSSIM() {
        return this.ssim;
    }

    @Override
    public double getTotalSSIM() {
        return this.totalSSIM;
    }

    @Override
    public double[] getRRMSE() {
        return this.rrmse;
    }

    @Override
    public double getTotalRRMSE() {
        return this.totalRRMSE;
    }

    @Override
    public double[] getNMSE() {
        return this.nmse;
    }

    @Override
    public double getTotalNMSE() {
        return this.totalNMSE;
    }

    @Override
    public double[] getPSNRNC() {
        return this.psnrNc;
    }

    @Override
    public double getTotalPSNRNC() {
        return this.totalPSNRNC;
    }
}

