/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciAnalysis.ChiSquare;

public class ImageStatisticalSA {
    double[] regressionDR = null;
    double[] regressionNDR = null;
    double totalRegressionDR = 0.0;
    double totalRegressionNDR = 0.0;
    float[][] minMax = null;
    float[] totalMinMax = null;
    double[] energyDR = null;
    double totalEnergyDR = 0.0;
    double[] averageDR = null;
    double totalAverageDR;
    double[] averageNDR = null;
    double totalAverageNDR;
    float[] centerRange = null;
    float totalCenterRange = 0.0f;
    long[] numberOfPixelsData = null;
    long[] numberOfPixelsNoData = null;
    long totalNumberOfPixelsData;
    long totalNumberOfPixelsNoData;
    double[] averageStdDevDR = null;
    double totalAverageStdDevDR = 0.0;
    double[] averageStdDevNDR = null;
    double totalAverageStdDevNDR = 0.0;
    double[] averageStdDevDNDR = null;
    double totalAverageStdDevDNDR = 0.0;
    double[] variance = null;
    double totalVariance = 0.0;
    int[][] hist = null;
    int[] totalHist = null;
    double[] entropy = null;
    double totalEntropy = 0.0;
    long[] numberOfZeros;
    long totalNumberOfZeros;
    float[][] allImageBitplaneSignificanceLevels = null;
    float[] totalChi2AllImageSignificance;
    float[][] regionsBitplaneSignificanceLevels = null;
    float[] totalChi2RegionsSignificance;
    float[] byValueSignificanceLevels;
    float totalByValueSignificanceLevels;
    float[][] bitplaneEntropy;
    float[] totalBitplaneEntropy;

    public ImageStatisticalSA(float[][][] fArray, byte[][][] byArray) {
        this(fArray, byArray, 16, 64);
    }

    public ImageStatisticalSA(float[][][] fArray, byte[][][] byArray, int n) {
        this(fArray, byArray, n, 64);
    }

    public ImageStatisticalSA(float[][][] fArray, byte[][][] byArray, int n, int n2) {
        this(fArray, byArray, n, n2, false);
    }

    public ImageStatisticalSA(float[][][] fArray, byte[][][] byArray, int n, int n2, boolean bl) {
        this(fArray, byArray, n, n2, bl, -1);
    }

    public ImageStatisticalSA(float[][][] fArray, byte[][][] byArray, int n, int n2, boolean bl, int n3) {
        float f;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = fArray.length;
        int n11 = fArray[0].length;
        int n12 = fArray[0][0].length;
        this.minMax = new float[n10][2];
        this.energyDR = new double[n10];
        this.averageDR = new double[n10];
        this.averageNDR = new double[n10];
        this.centerRange = new float[n10];
        this.totalMinMax = new float[2];
        this.numberOfPixelsData = new long[n10];
        this.numberOfPixelsNoData = new long[n10];
        this.averageStdDevDR = new double[n10];
        this.averageStdDevNDR = new double[n10];
        this.averageStdDevDNDR = new double[n10];
        this.variance = new double[n10];
        this.regressionDR = new double[n10 - 1];
        this.regressionNDR = new double[n10 - 1];
        this.allImageBitplaneSignificanceLevels = new float[n10][n];
        this.regionsBitplaneSignificanceLevels = new float[n10][n];
        this.byValueSignificanceLevels = new float[n10];
        this.bitplaneEntropy = new float[n10][n];
        this.totalBitplaneEntropy = new float[n];
        this.numberOfZeros = new long[n10];
        this.totalMinMax[0] = Float.POSITIVE_INFINITY;
        this.totalMinMax[1] = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < n10; ++i) {
            this.minMax[i][0] = Float.POSITIVE_INFINITY;
            this.minMax[i][1] = Float.NEGATIVE_INFINITY;
            this.averageDR[i] = 0.0;
            this.averageNDR[i] = 0.0;
            this.variance[i] = 0.0;
        }
        int[] nArray = new int[n];
        long[][] lArray = new long[n10][n];
        int n13 = (int)Math.ceil((float)n12 / (float)n2);
        int n14 = (int)Math.ceil((float)n11 / (float)n2);
        long[][][][] lArray2 = new long[n10][n14][n13][n];
        long[][][] lArray3 = new long[n10][n14][n13];
        for (n9 = 0; n9 < n10; ++n9) {
            for (n8 = 0; n8 < n; ++n8) {
                nArray[n8] = 1 << n8;
                lArray[n9][n8] = 0L;
                for (n7 = 0; n7 < n13; ++n7) {
                    for (n6 = 0; n6 < n14; ++n6) {
                        lArray2[n9][n6][n7][n8] = 0L;
                    }
                }
            }
        }
        for (n9 = 0; n9 < n10; ++n9) {
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < n12; ++n7) {
                    if (byArray == null || byArray[n9][n8][n7] != 0) {
                        int n15 = n9;
                        this.numberOfPixelsData[n15] = this.numberOfPixelsData[n15] + 1L;
                        long[] lArray4 = lArray3[n9][n8 / n2];
                        int n16 = n7 / n2;
                        lArray4[n16] = lArray4[n16] + 1L;
                        continue;
                    }
                    int n17 = n9;
                    this.numberOfPixelsNoData[n17] = this.numberOfPixelsNoData[n17] + 1L;
                }
            }
        }
        for (n9 = 0; n9 < n10; ++n9) {
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < n12; ++n7) {
                    if (byArray == null || byArray[n9][n8][n7] != 0) {
                        this.minMax[n9][0] = Math.min(this.minMax[n9][0], fArray[n9][n8][n7]);
                        this.minMax[n9][1] = Math.max(this.minMax[n9][1], fArray[n9][n8][n7]);
                        int n18 = n9;
                        this.averageDR[n18] = this.averageDR[n18] + (double)fArray[n9][n8][n7];
                        for (n6 = 0; n6 < n; ++n6) {
                            if (((int)fArray[n9][n8][n7] & nArray[n6]) == 0) continue;
                            long[] lArray5 = lArray2[n9][n8 / n2][n7 / n2];
                            int n19 = n6;
                            lArray5[n19] = lArray5[n19] + 1L;
                            long[] lArray6 = lArray[n9];
                            int n20 = n6;
                            lArray6[n20] = lArray6[n20] + 1L;
                        }
                        continue;
                    }
                    int n21 = n9;
                    this.averageNDR[n21] = this.averageNDR[n21] + (double)fArray[n9][n8][n7];
                }
            }
            this.totalMinMax[0] = Math.min(this.totalMinMax[0], this.minMax[n9][0]);
            this.totalMinMax[1] = Math.max(this.totalMinMax[1], this.minMax[n9][1]);
            int n22 = n9;
            this.averageDR[n22] = this.averageDR[n22] / (double)this.numberOfPixelsData[n9];
            int n23 = n9;
            this.averageNDR[n23] = this.averageNDR[n23] / (double)((long)(n12 * n11) - this.numberOfPixelsData[n9]);
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < n12; ++n7) {
                    if (byArray != null && byArray[n9][n8][n7] == 0) continue;
                    int n24 = n9;
                    this.variance[n24] = this.variance[n24] + ((double)fArray[n9][n8][n7] - this.averageDR[n9]) * ((double)fArray[n9][n8][n7] - this.averageDR[n9]);
                }
            }
            int n25 = n9;
            this.variance[n25] = this.variance[n25] / (double)this.numberOfPixelsData[n9];
        }
        for (n9 = 0; n9 < n10; ++n9) {
            for (n8 = 0; n8 < n11; ++n8) {
                for (n7 = 0; n7 < n12; ++n7) {
                    if (byArray == null || byArray[n9][n8][n7] != 0) {
                        int n26 = n9;
                        this.averageStdDevDR[n26] = this.averageStdDevDR[n26] + Math.pow(this.averageDR[n9] - (double)fArray[n9][n8][n7], 2.0);
                        int n27 = n9;
                        this.energyDR[n27] = this.energyDR[n27] + (double)(fArray[n9][n8][n7] * fArray[n9][n8][n7]);
                        continue;
                    }
                    int n28 = n9;
                    this.averageStdDevDNDR[n28] = this.averageStdDevDNDR[n28] + Math.pow(this.averageDR[n9] - (double)fArray[n9][n8][n7], 2.0);
                    int n29 = n9;
                    this.averageStdDevNDR[n29] = this.averageStdDevNDR[n29] + Math.pow(this.averageNDR[n9] - (double)fArray[n9][n8][n7], 2.0);
                }
            }
            this.averageStdDevDR[n9] = Math.sqrt(this.averageStdDevDR[n9] / (double)this.numberOfPixelsData[n9]);
            this.averageStdDevNDR[n9] = Math.sqrt(this.averageStdDevNDR[n9] / (double)((long)(n12 * n11) - this.numberOfPixelsData[n9]));
            this.averageStdDevDNDR[n9] = Math.sqrt(this.averageStdDevDNDR[n9] / (double)((long)(n12 * n11) - this.numberOfPixelsData[n9]));
            this.totalEnergyDR += this.energyDR[n9];
        }
        for (n9 = 0; n9 < n10; ++n9) {
            this.centerRange[n9] = (this.minMax[n9][0] + this.minMax[n9][1]) / 2.0f;
        }
        double d = 0.0;
        double d2 = 0.0;
        for (n5 = 0; n5 < n10 - 1; ++n5) {
            d = 0.0;
            d2 = 0.0;
            for (n4 = 0; n4 < n11; ++n4) {
                for (int i = 0; i < n12; ++i) {
                    if (byArray == null || byArray[n5][n4][i] != 0) {
                        d += ((double)fArray[n5][n4][i] - this.averageDR[n5]) * ((double)fArray[n5 + 1][n4][i] - this.averageDR[n5 + 1]);
                        continue;
                    }
                    d2 += ((double)fArray[n5][n4][i] - this.averageNDR[n5]) * ((double)fArray[n5 + 1][n4][i] - this.averageNDR[n5 + 1]);
                }
            }
            this.regressionDR[n5] = d / ((double)(this.numberOfPixelsData[n5] - 1L) * (this.averageStdDevDR[n5] * this.averageStdDevDR[n5 + 1]));
            this.regressionNDR[n5] = d2 / ((double)(this.numberOfPixelsData[n5] - 1L) * (this.averageStdDevNDR[n5] * this.averageStdDevNDR[n5 + 1]));
        }
        for (n5 = 0; n5 < n10; ++n5) {
            for (n4 = 0; n4 < n; ++n4) {
                float f2 = this.numberOfPixelsData[n5] - lArray[n5][n4];
                float f3 = (float)this.numberOfPixelsData[n5] / 2.0f;
                float f4 = lArray[n5][n4];
                float f5 = (float)this.numberOfPixelsData[n5] / 2.0f;
                double d3 = Math.pow(f2 - f3, 2.0) / (double)f3 + Math.pow(f4 - f5, 2.0) / (double)f5;
                double d4 = ChiSquare.getSignificanceLevel(1, d3);
                if (bl) {
                    System.out.println(">>>>>> z=" + n5 + " bitplane#" + n4 + ": Whole component");
                    System.out.println("    Zeros observed/expected(%) = " + f2 + "/" + f3 + "(" + 100.0 * (double)f2 / (double)f3 + "%)");
                    System.out.println("    X2=" + d3);
                    System.out.printf("    Chi-square CV for 0.05/0.01 = %.5f/%.5f\n", ChiSquare.getCriticalValue(1, 0.05), ChiSquare.getCriticalValue(1, 0.01));
                }
                this.allImageBitplaneSignificanceLevels[n5][n4] = (float)d4;
            }
        }
        if (n13 * n14 > 1) {
            for (n5 = 0; n5 < n10; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    double d5 = 0.0;
                    int n30 = 0;
                    for (int i = 0; i < n14; ++i) {
                        for (int j = 0; j < n13; ++j) {
                            if (lArray3[n5][i][j] == 0L) {
                                ++n30;
                                continue;
                            }
                            f = lArray2[n5][i][j][n4];
                            float f6 = (float)lArray3[n5][i][j] / 2.0f;
                            d5 += Math.pow(f - f6, 2.0) / (double)f6;
                        }
                    }
                    if (bl) {
                        System.out.println(">>>>>> z=" + n5 + " bitplane#" + n4 + ": By region");
                        System.out.println("    Regions (total/skipped)=(" + n13 * n14 + "/" + n30 + ")");
                        System.out.println("    X2=" + d5);
                        System.out.printf("    Chi-square CV alpha=0.05/0.01 = %.5f/%.5f\n", ChiSquare.getCriticalValue(n13 * n14 - n30 - 1, 0.05), ChiSquare.getCriticalValue(n13 * n14 - n30 - 1, 0.01));
                    }
                    double d6 = ChiSquare.getSignificanceLevel(n13 * n14 - n30 - 1, d5);
                    this.regionsBitplaneSignificanceLevels[n5][n4] = (float)d6;
                }
            }
        } else {
            for (n5 = 0; n5 < n10; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    this.regionsBitplaneSignificanceLevels[n5][n4] = this.allImageBitplaneSignificanceLevels[n5][n4];
                }
            }
        }
        this.totalAverageDR = 0.0;
        this.totalAverageNDR = 0.0;
        this.totalCenterRange = 0.0f;
        this.totalAverageStdDevDR = 0.0;
        this.totalAverageStdDevNDR = 0.0;
        this.totalAverageStdDevDNDR = 0.0;
        this.totalNumberOfPixelsData = 0L;
        this.totalNumberOfPixelsNoData = 0L;
        this.totalRegressionDR = 0.0;
        this.totalRegressionNDR = 0.0;
        this.totalChi2AllImageSignificance = new float[n];
        this.totalChi2RegionsSignificance = new float[n];
        for (n5 = 0; n5 < n; ++n5) {
            this.totalChi2AllImageSignificance[n5] = 0.0f;
            this.totalChi2RegionsSignificance[n5] = 0.0f;
        }
        for (n5 = 0; n5 < n10; ++n5) {
            this.totalAverageDR += this.averageDR[n5];
            this.totalCenterRange += this.centerRange[n5];
            this.totalAverageStdDevDR += this.averageStdDevDR[n5];
            this.totalNumberOfPixelsData += this.numberOfPixelsData[n5];
            this.totalNumberOfPixelsNoData += this.numberOfPixelsNoData[n5];
            for (n4 = 0; n4 < n; ++n4) {
                int n31 = n4;
                this.totalChi2AllImageSignificance[n31] = this.totalChi2AllImageSignificance[n31] + this.allImageBitplaneSignificanceLevels[n5][n4];
                int n32 = n4;
                this.totalChi2RegionsSignificance[n32] = this.totalChi2RegionsSignificance[n32] + this.regionsBitplaneSignificanceLevels[n5][n4];
            }
        }
        for (n5 = 0; n5 < n10 - 1; ++n5) {
            this.totalRegressionDR += this.regressionDR[n5];
            this.totalRegressionNDR += this.regressionNDR[n5];
        }
        this.totalAverageDR /= (double)n10;
        this.totalAverageNDR /= (double)n10;
        this.totalCenterRange /= (float)n10;
        this.totalAverageStdDevDR /= (double)n10;
        this.totalAverageStdDevNDR /= (double)n10;
        this.totalAverageStdDevDNDR /= (double)n10;
        this.totalRegressionDR /= (double)(n10 - 1);
        this.totalRegressionNDR /= (double)(n10 - 1);
        n5 = 0;
        while (n5 < n) {
            int n33 = n5;
            this.totalChi2AllImageSignificance[n33] = this.totalChi2AllImageSignificance[n33] / (float)n10;
            int n34 = n5++;
            this.totalChi2RegionsSignificance[n34] = this.totalChi2RegionsSignificance[n34] / (float)n10;
        }
        this.hist = new int[n10][];
        this.totalHist = new int[(int)this.totalMinMax[1] - (int)this.totalMinMax[0] + 1];
        n5 = (int)this.totalMinMax[0];
        for (n4 = 0; n4 < n10; ++n4) {
            int n35;
            int n36 = (int)this.minMax[n4][0];
            this.hist[n4] = new int[(int)this.minMax[n4][1] - (int)this.minMax[n4][0] + 1];
            for (n35 = 0; n35 < this.hist[n4].length; ++n35) {
                this.hist[n4][n35] = 0;
            }
            for (n35 = 0; n35 < n11; ++n35) {
                for (int i = 0; i < n12; ++i) {
                    if (byArray != null && byArray[n4][n35][i] == 0) continue;
                    this.totalVariance += ((double)fArray[n4][n35][i] - this.totalAverageDR) * ((double)fArray[n4][n35][i] - this.totalAverageDR);
                    int[] nArray2 = this.hist[n4];
                    int n37 = (int)fArray[n4][n35][i] - n36;
                    nArray2[n37] = nArray2[n37] + 1;
                    int n38 = (int)fArray[n4][n35][i] - n5;
                    this.totalHist[n38] = this.totalHist[n38] + 1;
                }
            }
            this.numberOfZeros[n4] = n36 <= 0 ? (long)this.hist[n4][0 - n36] : 0L;
        }
        this.totalVariance /= (double)this.totalNumberOfPixelsData;
        this.totalNumberOfZeros = n5 <= 0 ? (long)this.totalHist[0 - n5] : 0L;
        this.totalByValueSignificanceLevels = 0.0f;
        for (n4 = 0; n4 < n10; ++n4) {
            int n39;
            int n40 = (int)this.minMax[n4][1];
            int n41 = n3;
            if (n41 < 0) {
                n41 = n40;
            }
            int n42 = 0;
            for (int i = n39 = (int)this.minMax[n4][0]; i <= n41; ++i) {
                n42 += this.hist[n4][i - n39];
            }
            float f7 = (float)n42 / ((float)n41 + 1.0f);
            f = 0.0f;
            for (int i = n39; i <= n41; ++i) {
                f += ((float)this.hist[n4][i - n39] - f7) * ((float)this.hist[n4][i - n39] - f7) / f7;
            }
            this.byValueSignificanceLevels[n4] = (float)ChiSquare.getSignificanceLevel(n41, f);
            if (bl) {
                System.out.println(">>>>>> byValueSignificanceLevels[" + n4 + "]=" + this.byValueSignificanceLevels[n4]);
                System.out.println("\tX2=" + f);
                System.out.printf("\tcritical k=" + n41 + " 0.05/0.01 = %.3f/%.3f\n", ChiSquare.getCriticalValue(n41, 0.05), ChiSquare.getCriticalValue(n41, 0.01));
            }
            this.totalByValueSignificanceLevels += this.byValueSignificanceLevels[n4];
        }
        this.totalByValueSignificanceLevels /= (float)n10;
        this.entropy = new double[n10];
        n4 = 0;
        while (n4 < n10) {
            this.entropy[n4] = 0.0;
            for (int i = 0; i < this.hist[n4].length; ++i) {
                double d7 = (double)this.hist[n4][i] / (double)this.numberOfPixelsData[n4];
                if (!(d7 > 0.0)) continue;
                int n43 = n4;
                this.entropy[n43] = this.entropy[n43] - d7 * Math.log(d7);
            }
            int n44 = n4++;
            this.entropy[n44] = this.entropy[n44] / Math.log(2.0);
        }
        this.totalEntropy = 0.0;
        for (n4 = 0; n4 < this.totalHist.length; ++n4) {
            double d8 = (double)this.totalHist[n4] / (double)this.totalNumberOfPixelsData;
            if (!(d8 > 0.0)) continue;
            this.totalEntropy -= d8 * Math.log(d8);
        }
        this.totalEntropy /= Math.log(2.0);
        this.bitplaneEntropy = new float[n10][n];
        for (n4 = 0; n4 < n10; ++n4) {
            for (int i = 0; i < n; ++i) {
                double d9 = this.numberOfPixelsData[n4];
                double d10 = lArray[n4][i];
                double d11 = d9 - d10;
                this.bitplaneEntropy[n4][i] = 0.0f;
                if (d11 == 0.0 || d10 == 0.0) continue;
                double d12 = d11 / d9;
                double d13 = d10 / d9;
                this.bitplaneEntropy[n4][i] = (float)(-1.0 * (d12 * Math.log(d12) + d13 * Math.log(d13)));
                float[] fArray2 = this.bitplaneEntropy[n4];
                int n45 = i;
                fArray2[n45] = (float)((double)fArray2[n45] / Math.log(2.0));
            }
        }
        this.totalBitplaneEntropy = new float[n];
        n4 = 0;
        while (n4 < n) {
            this.totalBitplaneEntropy[n4] = 0.0f;
            for (int i = 0; i < n10; ++i) {
                int n46 = n4;
                this.totalBitplaneEntropy[n46] = this.totalBitplaneEntropy[n46] + this.bitplaneEntropy[i][n4];
            }
            int n47 = n4++;
            this.totalBitplaneEntropy[n47] = this.totalBitplaneEntropy[n47] / (float)n10;
        }
    }

    public double[][] jointChiTest(float[][][] fArray, byte[][][] byArray) {
        int n = fArray.length;
        int n2 = fArray[0].length;
        int n3 = fArray[0][0].length;
        int n4 = n3 * n2 / 8 * 8;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int[][] nArrayArray = new int[n][];
        int[][] nArrayArray2 = new int[n][];
        int n10 = n3 * n2;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        double[][] dArrayArray = new double[n][];
        double[][] dArrayArray2 = new double[n][];
        double[][] dArrayArray3 = new double[n][];
        for (int i = 0; i < fArray.length; ++i) {
            n7 = (int)(Math.log(this.getMinMax()[i][1]) / Math.log(2.0)) + 1;
            System.out.println("Num BP: " + n7);
            if (n7 <= 0) {
                return dArrayArray3;
            }
            nArrayArray[i] = new int[n7];
            nArrayArray2[i] = new int[n7];
            dArrayArray3[i] = new double[n7];
            dArrayArray[i] = new double[n7];
            dArrayArray2[i] = new double[n7];
            for (int j = 0; j < n7; ++j) {
                for (int k = 0; k < n4; ++k) {
                    int n11;
                    int n12;
                    nArrayArray[i][j] = 0;
                    nArrayArray2[i][j] = 0;
                    f = 2 * (2 * n2 * n3 - n2 - n3);
                    f2 = 2.0f * f;
                    f3 = 8 * (8 * n2 * n3 - 7 * n2 - 7 * n3 + 4);
                    System.out.println("S0: " + f);
                    System.out.println("S1: " + f2);
                    System.out.println("S2: " + f3);
                    n5 = 8 * k % n3;
                    n6 = 8 * (k / (n3 / 8));
                    for (n12 = 0; n12 < 8; ++n12) {
                        for (n11 = 0; n11 < 7; ++n11) {
                            if (((int)fArray[i][n12 + n6][n11 + n5] & (int)Math.pow(2.0, j)) != ((int)fArray[i][n12 + n6][n11 + n5 + 1] & (int)Math.pow(2.0, j))) {
                                int[] nArray = nArrayArray[i];
                                int n13 = j;
                                nArray[n13] = nArray[n13] + 1;
                            } else {
                                int[] nArray = nArrayArray2[i];
                                int n14 = j;
                                nArray[n14] = nArray[n14] + 1;
                            }
                            if (((int)fArray[i][n12 + n6][n11 + n5] & (int)Math.pow(2.0, j)) == (int)Math.pow(2.0, j)) {
                                ++n9;
                                continue;
                            }
                            ++n8;
                        }
                        if (((int)fArray[i][n12 + n6][7 + n5] & (int)Math.pow(2.0, j)) == (int)Math.pow(2.0, j)) {
                            ++n9;
                            continue;
                        }
                        ++n8;
                    }
                    for (n12 = 0; n12 < fArray[i].length - 1; ++n12) {
                        for (n11 = 0; n11 < fArray[i][n12].length; ++n11) {
                            try {
                                if (((int)fArray[i][n12 + n6][n11 + n5] & (int)Math.pow(2.0, j)) != ((int)fArray[i][n12 + n6 + 1][n11 + n5] & (int)Math.pow(2.0, j))) {
                                    int[] nArray = nArrayArray[i];
                                    int n15 = j;
                                    nArray[n15] = nArray[n15] + 1;
                                    continue;
                                }
                                int[] nArray = nArrayArray2[i];
                                int n16 = j;
                                nArray[n16] = nArray[n16] + 1;
                                continue;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                System.out.println("IndexOutOfBounds. x=" + n11 + ", y=" + n12);
                            }
                        }
                    }
                    System.out.println("b: " + n8);
                    System.out.println("w: " + n9);
                    f4 = 2 * n8 * n9;
                    f5 = 2.0f * f4;
                    f6 = n10 * n8 * n9;
                    System.out.println("T0: " + f4);
                    System.out.println("T1: " + f5);
                    System.out.println("T2: " + f6);
                    dArrayArray[i][j] = f * f4 / (float)(2 * n10 * (n10 - 1));
                    dArrayArray2[i][j] = (double)((f - 2.0f * f2) * (f4 - 2.0f * f5) / (float)(16 * n10 * (n10 - 1) * (n10 - 2)) + f2 * f5 / (float)(8 * n10 * (n10 - 1))) + (Math.pow(f, 2.0) + (double)f2 - (double)f3) * (Math.pow(f4, 2.0) + (double)f5 - (double)f6) / (double)(4 * n10 * (n10 - 1) * (n10 - 2) * (n10 - 3)) - Math.pow(dArrayArray[i][j], 2.0);
                    dArrayArray3[i][j] = ((double)nArrayArray[i][j] - dArrayArray[i][j]) / Math.sqrt(dArrayArray2[i][j]);
                    System.out.println("BW: " + nArrayArray[i][j]);
                    System.out.println("mean: " + dArrayArray[i][j]);
                    System.out.println("desv: " + dArrayArray2[i][j]);
                    System.out.println("Z: " + dArrayArray3[i][j]);
                    n8 = 0;
                    n9 = 0;
                }
            }
        }
        return dArrayArray3;
    }

    public float[][] getMinMax() {
        return this.minMax;
    }

    public float[] getTotalMinMax() {
        return this.totalMinMax;
    }

    public double[] getEnergyDR() {
        return this.energyDR;
    }

    public double getTotalEnergyDR() {
        return this.totalEnergyDR;
    }

    public double[] getAverageDR() {
        return this.averageDR;
    }

    public double getTotalAverageDR() {
        return this.totalAverageDR;
    }

    public double[] getAverageNDR() {
        return this.averageNDR;
    }

    public double getTotalAverageNDR() {
        return this.totalAverageNDR;
    }

    public double[] getAverageStdDevDR() {
        return this.averageStdDevDR;
    }

    public double getTotalAverageStdDevDR() {
        return this.totalAverageStdDevDR;
    }

    public double[] getAverageStdDevNDR() {
        return this.averageStdDevNDR;
    }

    public double getTotalAverageStdDevNDR() {
        return this.totalAverageStdDevNDR;
    }

    public double[] getAverageStdDevDNDR() {
        return this.averageStdDevDNDR;
    }

    public double getTotalAverageStdDevDNDR() {
        return this.totalAverageStdDevDNDR;
    }

    public float[] getCenterRange() {
        return this.centerRange;
    }

    public float getTotalCenterRange() {
        return this.totalCenterRange;
    }

    public long[] getNumberOfPixelsData() {
        return this.numberOfPixelsData;
    }

    public long[] getNumberOfPixelsNoData() {
        return this.numberOfPixelsNoData;
    }

    public long getTotalNumberOfPixelsData() {
        return this.totalNumberOfPixelsData;
    }

    public long getTotalNumberOfPixelsNoData() {
        return this.totalNumberOfPixelsNoData;
    }

    public double[] getVariance() {
        return this.variance;
    }

    public double getTotalVariance() {
        return (float)this.totalVariance;
    }

    public double[] getEntropy() {
        return this.entropy;
    }

    public double getTotalEntropy() {
        return this.totalEntropy;
    }

    public double[] getRegressionDR() {
        return this.regressionDR;
    }

    public double[] getRegressionNDR() {
        return this.regressionNDR;
    }

    public double getTotalRegressionDR() {
        return this.totalRegressionDR;
    }

    public double getTotalRegressionNDR() {
        return this.totalRegressionNDR;
    }

    public float[][] getAllImageBitplaneSignificanceLevels() {
        return this.allImageBitplaneSignificanceLevels;
    }

    public float[] getTotalAllImageBitplaneSignificanceLevels() {
        return this.totalChi2AllImageSignificance;
    }

    public float[][] getRegionsBitplaneSignificanceLevels() {
        return this.regionsBitplaneSignificanceLevels;
    }

    public float[] getTotalRegionsBitplaneSignificanceLevels() {
        return this.totalChi2RegionsSignificance;
    }

    public float[] getByValueSignificanceLevels() {
        return this.byValueSignificanceLevels;
    }

    public float getTotalByValueSignificanceLevels() {
        return this.totalByValueSignificanceLevels;
    }

    public float[][] getBitplaneEntropy() {
        return this.bitplaneEntropy;
    }

    public float[] getAverageBitplaneEntropy() {
        return this.totalBitplaneEntropy;
    }

    public long[] getNumberOfZeros() {
        return this.numberOfZeros;
    }

    public long getTotalNumberOfZeros() {
        return this.totalNumberOfZeros;
    }

    public int[][] getImageHist() {
        return this.hist;
    }
}

