/*
 * Decompiled with CFR 0.152.
 */
package GiciAnalysis;

import GiciTransform.Permutation;
import java.util.ArrayDeque;
import java.util.Set;
import java.util.TreeSet;

public class MinimalSpanningTree
implements Runnable {
    final float[][] adjacencyMatrix;
    final int N;
    final int[] parents;
    final float[] costs;
    final Set<Integer> remainingNodes = new TreeSet<Integer>();

    public MinimalSpanningTree(float[][] fArray) {
        this.adjacencyMatrix = fArray;
        this.N = fArray.length;
        assert (this.N == fArray[0].length);
        assert (this.N > 0);
        this.parents = new int[this.N];
        this.costs = new float[this.N];
        for (int i = 0; i < this.N; ++i) {
            this.remainingNodes.add(i);
            this.parents[i] = -1;
            this.costs[i] = Float.POSITIVE_INFINITY;
        }
    }

    private void updateCostsAndRemove(int n) {
        this.remainingNodes.remove(n);
        for (int n2 : this.remainingNodes) {
            if (!(this.adjacencyMatrix[n][n2] < this.costs[n2])) continue;
            this.costs[n2] = this.adjacencyMatrix[n][n2];
            this.parents[n2] = n;
        }
    }

    private int getNearestNode() {
        float f = Float.POSITIVE_INFINITY;
        int n = -1;
        for (int n2 : this.remainingNodes) {
            if (!(this.costs[n2] <= f)) continue;
            f = this.costs[n2];
            n = n2;
        }
        return n;
    }

    public int[] getPermutation(int n) {
        int n2;
        int[] nArray = new int[this.N];
        if (n == 0 || n == 1 || n == 3) {
            int n3 = 0;
            ArrayDeque<Integer> arrayDeque = new ArrayDeque<Integer>();
            arrayDeque.add(-1);
            while (arrayDeque.size() != 0) {
                int n4 = (Integer)arrayDeque.peek();
                float f = Float.POSITIVE_INFINITY;
                n2 = -1;
                for (int i = 0; i < this.N; ++i) {
                    if (this.parents[i] != n4 || arrayDeque.contains(i) || !(this.adjacencyMatrix[i][i] < f)) continue;
                    f = this.adjacencyMatrix[i][i];
                    n2 = i;
                }
                if (n2 != -1) {
                    nArray[n3++] = n2;
                    arrayDeque.add(n2);
                    continue;
                }
                arrayDeque.remove(n4);
            }
        }
        if (n == 2) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            for (int i = 0; i < this.N; ++i) {
                float f = Float.NEGATIVE_INFINITY;
                int n5 = -1;
                for (n2 = 0; n2 < this.N; ++n2) {
                    if (treeSet.contains(n2) || !(this.adjacencyMatrix[n2][n2] > f)) continue;
                    n5 = n2;
                    f = this.adjacencyMatrix[n2][n2];
                }
                treeSet.add(n5);
                nArray[i] = n5;
            }
        }
        if (n == 4) {
            Permutation permutation = new Permutation(this.N);
            permutation.permutationBringTo(7, 0, 50);
            permutation.permutationBringTo(76, 50, 45);
            permutation.permutationBringTo(134, 95, 32);
            nArray = permutation.getPermutation();
        }
        if (n == 5) {
            Permutation permutation = new Permutation(this.N);
            permutation.permutationBringTo(7, 0, 50);
            permutation.permutationBringTo(76, 50, 148);
            nArray = permutation.getPermutation();
        }
        return nArray;
    }

    public int[] getParents() {
        return this.parents;
    }

    @Override
    public void run() {
        while (this.remainingNodes.size() != 0) {
            int n = this.getNearestNode();
            this.updateCostsAndRemove(n);
        }
    }
}

