/*
 * Decompiled with CFR 0.152.
 */
package GiciBitStream;

import GiciBitStream.FinishableOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutputStream
extends FilterOutputStream
implements FinishableOutputStream {
    protected int bits = 0;
    protected int bitPos = 0;
    public static final int ZERO = 0;
    public static final int ONE = 1;
    protected long target = 0L;
    protected boolean rateTarget = false;
    protected long streamSize = 0L;

    public BitOutputStream(OutputStream outputStream) {
        super(outputStream);
        this.rateTarget = false;
        this.target = 0L;
        this.streamSize = 0L;
    }

    public BitOutputStream(OutputStream outputStream, long l) {
        super(outputStream);
        if (l != 0L) {
            this.rateTarget = true;
            this.target = l;
        } else {
            this.rateTarget = false;
        }
        this.streamSize = 0L;
    }

    @Override
    public void finish() throws IOException {
        this.flushByte();
    }

    @Override
    public void close() throws IOException {
        this.finish();
        super.close();
    }

    protected void flushByte() throws IOException {
        if (this.bitPos == 0) {
            return;
        }
        this.out.write(this.bits);
        this.bits = 0;
        this.bitPos = 0;
    }

    public void byteAlign() throws IOException {
        this.flushByte();
    }

    public void writeBitFlag(boolean bl) throws IOException {
        this.writeUBits(bl ? 1L : 0L, 1);
    }

    public void writeSBits(long l, int n) throws IOException {
        long l2 = l & Integer.MAX_VALUE;
        if (l < 0L) {
            l2 |= 1L << n - 1;
        }
        this.writeUBits(l2, n);
    }

    public void writeFBits(float f, int n) throws IOException {
        if (n == 0) {
            return;
        }
        long l = (long)(f * 65536.0f);
        this.writeUBits(l, n);
    }

    public void writeUBits(long l, int n) throws IOException {
        if (n == 0) {
            return;
        }
        if (this.bitPos == 0) {
            this.bitPos = 8;
        }
        int n2 = n;
        while (n2 > 0) {
            while (this.bitPos > 0 && n2 > 0) {
                long l2 = l & 1L << n2 - 1;
                int n3 = this.bitPos - n2;
                l2 = n3 < 0 ? (l2 >>= -n3) : (l2 <<= n3);
                this.bits = (int)((long)this.bits | l2);
                --n2;
                --this.bitPos;
            }
            if (this.bitPos != 0) continue;
            this.write(this.bits);
            this.bits = 0;
            if (n2 > 0) {
                this.bitPos = 8;
            }
            ++this.streamSize;
            if (!this.rateTarget || this.streamSize < this.target) continue;
            throw new IOException("Target: " + this.target + " (bytes) Size: " + this.streamSize + " (bytes)");
        }
    }

    public void writeMulti(int n) throws IOException {
        this.writeUBits(n, 1);
    }

    public static int minBits(int n) {
        return BitOutputStream.minBits((long)n);
    }

    public static int minBits(float f) {
        return BitOutputStream.minBits((int)(f / 65536.0f)) + 16;
    }

    public static int minBits(long l) {
        int n;
        boolean bl = l < 0L;
        l = Math.abs(l);
        long l2 = 1L;
        for (n = 1; n <= 64 && (l2 <<= 1) <= l; ++n) {
        }
        return n + (bl ? 1 : 0);
    }
}

