/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.ArithmeticCoder;

import GiciEntropyCoder.ProbabilityTable;
import java.math.BigInteger;

class BinaryProbabilityMapping {
    final ProbabilityTable probabilityTable;
    final int bitsPerSymbol;
    final BigInteger symbolCount;
    final boolean observationCountFitsLong;

    public BinaryProbabilityMapping(ProbabilityTable probabilityTable) {
        this.probabilityTable = probabilityTable;
        boolean bl = this.observationCountFitsLong = probabilityTable.getObservationCount().compareTo(BigInteger.valueOf(Long.MAX_VALUE)) < 0;
        assert (this.observationCountFitsLong);
        this.symbolCount = probabilityTable.getSymbolCount();
        this.bitsPerSymbol = this.symbolCount.subtract(BigInteger.ONE).bitLength();
    }

    public int[] getProbabilities(boolean[] blArray) {
        assert (blArray.length == this.bitsPerSymbol);
        int[] nArray = new int[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            nArray[i] = this.getPartialProbability(blArray, i);
        }
        return nArray;
    }

    public int getBitLength() {
        return this.bitsPerSymbol;
    }

    public strictfp int getPartialProbability(boolean[] blArray, int n) {
        assert (n < blArray.length && n >= 0);
        int n2 = blArray.length - n;
        BigInteger bigInteger = this.bitsToSymbol(blArray, n);
        BigInteger bigInteger2 = bigInteger.add(BigInteger.ONE.shiftLeft(n2));
        if (bigInteger2.compareTo(this.symbolCount) > 0) {
            bigInteger2 = this.symbolCount;
        }
        assert (bigInteger.compareTo(this.symbolCount) < 0);
        BigInteger bigInteger3 = bigInteger.add(BigInteger.ONE.shiftLeft(n2 - 1));
        if (bigInteger3.compareTo(bigInteger2) > 0) {
            bigInteger3 = bigInteger2;
        }
        assert (bigInteger.compareTo(bigInteger3) <= 0);
        long l = this.probabilityTable.getCumulativeFrequency(bigInteger2).longValue();
        long l2 = this.probabilityTable.getCumulativeFrequency(bigInteger).longValue();
        long l3 = this.probabilityTable.getCumulativeFrequency(bigInteger3).longValue();
        long l4 = l - l2;
        long l5 = l - l3;
        int n3 = (int)Math.rint((double)l5 * 44034.0 / (double)l4);
        assert (n3 >= 0 && n3 <= 44035);
        if (n3 < 1) {
            n3 = 1;
        } else if (n3 > 44033) {
            n3 = 44033;
        }
        return n3;
    }

    public boolean[] getBits(BigInteger bigInteger) {
        boolean[] blArray = new boolean[this.bitsPerSymbol];
        for (int i = 0; i < this.bitsPerSymbol; ++i) {
            blArray[i] = bigInteger.testBit(this.bitsPerSymbol - i - 1);
        }
        return blArray;
    }

    public BigInteger bitsToSymbol(boolean[] blArray) {
        return this.bitsToSymbol(blArray, blArray.length);
    }

    private BigInteger bitsToSymbol(boolean[] blArray, int n) {
        assert (blArray.length == this.bitsPerSymbol);
        assert (n <= blArray.length);
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < n; ++i) {
            if (!blArray[i]) continue;
            bigInteger = bigInteger.setBit(this.bitsPerSymbol - i - 1);
        }
        return bigInteger;
    }
}

