/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.BlockAdaptiveCoder;

import GiciEntropyCoder.BlockAdaptiveCoder.CodingType;
import GiciEntropyCoder.Interface.BlockCoder;
import GiciEntropyCoder.RiceCoder.RiceCoder;
import GiciStream.BitOutputStream;
import java.io.IOException;

public class BlockAdaptiveCoder
extends RiceCoder
implements BlockCoder {
    private CodingType codingType;
    private final BlockCounter blockCounter;
    private final ZeroBlock zeroBlock;
    private final SecondExtension secExt;
    private final boolean referenceSamples;

    public BlockAdaptiveCoder(BitOutputStream bitOutputStream, int n, int n2, boolean bl, int n3, int n4, int n5) {
        super(bitOutputStream, n, n2, n5 == 1 && n2 <= 4);
        if (bl) {
            throw new RuntimeException("Inserting Reference Samples is not yet supported.");
        }
        this.referenceSamples = bl;
        if (n3 < 1 || n3 > 4096) {
            throw new RuntimeException("Reference Sample Interval should be between 1 and 4096.");
        }
        if (n4 < 1) {
            throw new RuntimeException("Segment Size should be positive. Recommended value is 64.");
        }
        this.blockCounter = new BlockCounter(n3, n4);
        this.zeroBlock = new ZeroBlock();
        this.secExt = new SecondExtension();
    }

    @Override
    public void codeBlock(int[] nArray) throws IOException {
        int[] nArray2 = this.maskBlockBits(nArray);
        this.findBestCodingOption(nArray2);
        if (this.codingType == CodingType.ZERO_BLOCK) {
            this.zeroBlock.addBlock();
        } else {
            this.zeroBlock.flushBlocks();
            this.writeId(this.codingType, this.codingOption);
            switch (this.codingType) {
                case SECOND_EXT: {
                    this.secExt.codeBlock();
                    break;
                }
                case BACKUP: {
                    this.backupBlock(nArray2);
                    break;
                }
                case SAMPLE_SPLIT: {
                    this.riceCodeBlock(nArray2, this.codingOption);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
        this.blockCounter.increment();
        if (this.blockCounter.sOffset() == 0 || this.blockCounter.rOffset() == 0) {
            this.zeroBlock.flushRosBlock();
        }
    }

    @Override
    public void finish() throws IOException {
        this.zeroBlock.flushRosBlock();
        this.bos.flush();
    }

    @Override
    protected void findBestCodingOption(int[] nArray) {
        long l;
        this.codingType = CodingType.BACKUP;
        this.codingOption = this.backupOption;
        long l2 = nArray.length * this.dynamicRange + this.idBits;
        long l3 = this.sumBlock(nArray);
        if (l3 == 0L) {
            this.codingType = CodingType.ZERO_BLOCK;
            return;
        }
        this.secExt.convertToSecExt(nArray);
        long[] lArray = this.secExt.getBlock();
        long l4 = 0L;
        for (long l5 : lArray) {
            if (l5 < 0L || l5 > l2) {
                l4 = l2;
                break;
            }
            l4 += l5;
        }
        if ((l = l4 + (long)lArray.length + (long)this.idBits + 1L) < l2) {
            this.codingType = CodingType.SECOND_EXT;
            l2 = l;
        }
        for (int i = 0; i < this.numOptions - 2; ++i) {
            l3 = 0L;
            for (int n : nArray) {
                l3 += ((long)n & 0xFFFFFFFFL) >>> i;
            }
            l = l3 + (long)((i + 1) * nArray.length) + (long)this.idBits;
            if (l >= l2) continue;
            this.codingType = CodingType.SAMPLE_SPLIT;
            this.codingOption = i;
            l2 = l;
        }
    }

    void writeId(CodingType codingType, int n) throws IOException {
        switch (codingType) {
            case ZERO_BLOCK: {
                this.bos.write(this.idBits + 1, 0);
                break;
            }
            case SECOND_EXT: {
                this.bos.write(this.idBits + 1, 1);
                break;
            }
            case BACKUP: {
                this.bos.write(this.idBits, 0xFFFFFF);
                break;
            }
            case SAMPLE_SPLIT: {
                this.bos.write(this.idBits, n + 1);
            }
        }
    }

    private class SecondExtension {
        long[] secExtBlock;

        private SecondExtension() {
        }

        public void codeBlock() throws IOException {
            for (long l : this.secExtBlock) {
                BlockAdaptiveCoder.this.unaryCoder.codeSample((int)l);
            }
        }

        public void convertToSecExt(int[] nArray) {
            int n = (nArray.length + 1) / 2;
            this.secExtBlock = new long[n];
            boolean bl = nArray.length % 2 == 1;
            int n2 = 0;
            if (bl) {
                this.secExtBlock[0] = this.transform(0, nArray[0]);
                ++n2;
            }
            while (n2 < nArray.length) {
                this.secExtBlock[(n2 + 1) / 2] = this.transform(nArray[n2], nArray[n2 + 1]);
                n2 += 2;
            }
        }

        public long[] getBlock() {
            return this.secExtBlock;
        }

        long transform(int n, int n2) {
            long l = (long)n & 0xFFFFFFFFL;
            long l2 = (long)n2 & 0xFFFFFFFFL;
            return (l + l2) * (l + l2 + 1L) / 2L + l2;
        }
    }

    private class ZeroBlock {
        int numZeroBlocks = 0;
        final int rosCode = 4;

        private ZeroBlock() {
        }

        public void addBlock() {
            ++this.numZeroBlocks;
        }

        public void flushBlocks() throws IOException {
            if (this.numZeroBlocks == 0) {
                return;
            }
            if (this.numZeroBlocks <= 4) {
                --this.numZeroBlocks;
            }
            this.writeZeroBlock();
        }

        public void flushRosBlock() throws IOException {
            if (this.numZeroBlocks <= 4) {
                this.flushBlocks();
                return;
            }
            this.numZeroBlocks = 4;
            this.writeZeroBlock();
        }

        void writeZeroBlock() throws IOException {
            BlockAdaptiveCoder.this.writeId(CodingType.ZERO_BLOCK, 0);
            BlockAdaptiveCoder.this.unaryCoder.codeSample(this.numZeroBlocks);
            this.numZeroBlocks = 0;
        }
    }

    private class BlockCounter {
        int r;
        int rOffset = 0;
        int s;
        int sOffset = 0;

        public BlockCounter(int n, int n2) {
            this.r = n;
            this.s = n2;
        }

        public void increment() {
            this.rOffset = (this.rOffset + 1) % this.r;
            this.sOffset = (this.sOffset + 1) % this.s;
        }

        public int rOffset() {
            return this.rOffset;
        }

        public int sOffset() {
            return this.sOffset;
        }
    }
}

