/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.BlockAdaptiveCoder;

import GiciEntropyCoder.BlockAdaptiveCoder.CodingType;
import GiciEntropyCoder.Interface.BlockDecoder;
import GiciEntropyCoder.RiceCoder.RiceDecoder;
import GiciStream.BitInputStream;
import java.io.IOException;

public class BlockAdaptiveDecoder
extends RiceDecoder
implements BlockDecoder {
    private CodingType codingType;
    private final BlockCounter blockCounter;
    private final ZeroBlock zeroBlock;
    private final SecondExtension secExt;
    private final boolean referenceSamples;

    public BlockAdaptiveDecoder(BitInputStream bitInputStream, int n, int n2, boolean bl, int n3, int n4, int n5) {
        super(bitInputStream, n, n2, n5 == 1 && n2 <= 4);
        if (bl) {
            throw new RuntimeException("Inserting Reference Samples is not yet supported.");
        }
        this.referenceSamples = bl;
        if (n3 < 1 || n3 > 4096) {
            throw new RuntimeException("Reference Sample Interval should be between 1 and 4096.");
        }
        if (n4 < 1) {
            throw new RuntimeException("Segment Size should be positive. Recommended value is 64.");
        }
        this.blockCounter = new BlockCounter(n3, n4);
        this.zeroBlock = new ZeroBlock();
        this.secExt = new SecondExtension();
    }

    @Override
    public void decodeBlock(int[] nArray) throws IOException {
        if (this.zeroBlock.getBlock(nArray)) {
            this.blockCounter.increment();
            return;
        }
        this.readId();
        switch (this.codingType) {
            case ZERO_BLOCK: {
                this.zeroBlock.readBlocks();
                this.zeroBlock.getBlock(nArray);
                break;
            }
            case SECOND_EXT: {
                this.secExt.decodeBlock(nArray);
                break;
            }
            case SAMPLE_SPLIT: {
                this.riceDecodeBlock(nArray, this.codingOption);
                break;
            }
            case BACKUP: {
                this.restoreBlock(nArray);
            }
        }
        this.blockCounter.increment();
    }

    void readId() throws IOException {
        int n = this.bis.read(this.idBits);
        if (n == 0) {
            n = this.bis.read(1);
            this.codingType = n == 0 ? CodingType.ZERO_BLOCK : CodingType.SECOND_EXT;
        } else if (n == this.backupOption) {
            this.codingType = CodingType.BACKUP;
        } else {
            this.codingType = CodingType.SAMPLE_SPLIT;
            this.codingOption = n - 1;
        }
    }

    private class SecondExtension {
        long[] secExtBlock;
        int b;
        int ms;

        private SecondExtension() {
        }

        public void decodeBlock(int[] nArray) throws IOException {
            int n = (nArray.length + 1) / 2;
            this.secExtBlock = new long[n];
            for (int i = 0; i < n; ++i) {
                this.secExtBlock[i] = BlockAdaptiveDecoder.this.unaryDecoder.decodeSample();
            }
            this.convertFromSecExt(nArray);
        }

        void convertFromSecExt(int[] nArray) {
            boolean bl = nArray.length % 2 == 1;
            int n = 0;
            if (bl) {
                this.transform((int)this.secExtBlock[0]);
                nArray[0] = (int)(this.secExtBlock[0] - (long)this.ms);
                ++n;
            }
            while (n < nArray.length) {
                int n2 = (int)this.secExtBlock[(n + 1) / 2];
                this.transform(n2);
                nArray[n + 1] = n2 - this.ms;
                nArray[n] = this.b - nArray[n + 1];
                n += 2;
            }
        }

        void transform(int n) {
            this.b = 0;
            this.ms = 0;
            long l = (long)n & 0xFFFFFFFFL;
            while (l > (long)(this.b + this.ms)) {
                ++this.b;
                this.ms += this.b;
            }
        }
    }

    private class ZeroBlock {
        int numZeroBlocks = 0;
        int rosCode = 4;

        private ZeroBlock() {
        }

        boolean getBlock(int[] nArray) {
            if (this.numZeroBlocks == 0) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = 0;
            }
            --this.numZeroBlocks;
            return true;
        }

        void readBlocks() throws IOException {
            this.numZeroBlocks = BlockAdaptiveDecoder.this.unaryDecoder.decodeSample();
            if (this.numZeroBlocks == this.rosCode) {
                this.numZeroBlocks = Math.min(BlockAdaptiveDecoder.this.blockCounter.rDistance(), BlockAdaptiveDecoder.this.blockCounter.sDistance());
            } else if (this.numZeroBlocks < this.rosCode) {
                ++this.numZeroBlocks;
            }
        }
    }

    private class BlockCounter {
        int r;
        int rOffset = 0;
        int s;
        int sOffset = 0;

        public BlockCounter(int n, int n2) {
            this.r = n;
            this.s = n2;
        }

        public void increment() {
            this.rOffset = (this.rOffset + 1) % this.r;
            this.sOffset = (this.sOffset + 1) % this.s;
        }

        public int rDistance() {
            return this.r - this.rOffset;
        }

        public int sDistance() {
            return this.s - this.sOffset;
        }
    }
}

