/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.EntropyIntegerCoder;

import GiciEntropyCoder.Interface.EntropyCoder;
import GiciException.ParameterException;
import GiciMath.IntegerMath;
import GiciStream.BitOutputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

public class EntropyIntegerCoder
implements EntropyCoder {
    private final int BITCOST_SIZE = 64;
    private BitOutputStream bos = null;
    private int[] accumulator;
    private int[] counter;
    private long numBitsWritten;
    private final int initialCountExponent;
    private final int accumulatorInitConstant;
    private final int rescalingCounterSize;
    private final int dynamicRange;
    private final int unaryLengthLimit;
    private int[] accumulatorTable = null;
    private DataOutputStream bitCostDos = null;
    private int bitCost;
    private long totalBitsCoded = 0L;

    public EntropyIntegerCoder(BitOutputStream bitOutputStream, int n, int n2, int n3, int n4, int n5, int[] nArray, int n6, long l, int n7, String string) {
        this.bos = bitOutputStream;
        this.initialCountExponent = n;
        this.accumulatorInitConstant = n2;
        this.rescalingCounterSize = n3;
        this.dynamicRange = n4;
        this.unaryLengthLimit = n5;
        this.accumulatorTable = nArray;
        this.numBitsWritten = l;
        this.bitCost = n7;
        try {
            if (n7 > 0) {
                File file = new File(string + ".bitCost");
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                this.bitCostDos = new DataOutputStream(new BufferedOutputStream(fileOutputStream));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        this.accumulator = new int[n6];
        this.counter = new int[n6];
    }

    @Override
    public void init(int n) {
        int n2 = 0;
        this.counter[n] = 1 << this.initialCountExponent;
        if (this.accumulatorInitConstant < 15) {
            n2 = this.accumulatorInitConstant;
        } else if (this.accumulatorInitConstant == 15) {
            n2 = this.accumulatorTable[n];
        } else {
            try {
                throw new ParameterException("PARAMS ERROR: ACCUMULATOR_INITIALIZATION_CONSTANT has been set to an invalid value: " + this.accumulatorInitConstant);
            }
            catch (ParameterException parameterException) {
                parameterException.printStackTrace();
            }
        }
        this.accumulator[n] = (3 * (1 << n2 + 6) - 49) * this.counter[n];
        int n3 = n;
        this.accumulator[n3] = this.accumulator[n3] >> 7;
    }

    @Override
    public void update(int n, int n2, int n3) {
        int n4 = (1 << this.rescalingCounterSize) - 1;
        if (n2 > 0) {
            if (this.counter[n3] < n4) {
                int n5 = n3;
                this.accumulator[n5] = this.accumulator[n5] + n;
                int n6 = n3;
                this.counter[n6] = this.counter[n6] + 1;
            } else {
                this.accumulator[n3] = this.accumulator[n3] + n + 1 >> 1;
                this.counter[n3] = this.counter[n3] + 1 >> 1;
            }
        }
    }

    @Override
    public void codeSample(int n, int n2, int n3) throws IOException {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 == 0) {
            if (n > 1 << this.dynamicRange) {
                try {
                    throw new ParameterException("PARAMS ERROR: dynamic range too small for this image: " + n);
                }
                catch (ParameterException parameterException) {
                    parameterException.printStackTrace();
                    System.exit(-1);
                }
            }
            this.bos.write(this.dynamicRange, n);
            n6 = this.dynamicRange;
        } else {
            n4 = IntegerMath.log2((this.accumulator[n3] + (49 * this.counter[n3] >> 7)) / this.counter[n3]);
            n4 = n4 < 0 ? 0 : n4;
            n4 = n4 > this.dynamicRange - 2 ? this.dynamicRange - 2 : n4;
            n5 = n >> n4;
            int n7 = n5 = n5 < 0 ? 0 : n5;
            if (n5 < this.unaryLengthLimit) {
                this.bos.write(n5, 0);
                this.bos.write(1, 1);
                this.bos.write(n4, n);
                n6 = n4 + 1 + n5;
            } else {
                this.bos.write(this.unaryLengthLimit, 0);
                this.bos.write(this.dynamicRange, n);
                n6 = this.dynamicRange + this.unaryLengthLimit;
            }
        }
        this.numBitsWritten += (long)n6;
        this.totalBitsCoded += (long)n6;
        if (this.bitCostDos != null) {
            switch (this.bitCost) {
                case 1: {
                    this.bitCostDos.writeLong(n6);
                    break;
                }
                case 2: {
                    if (n2 != 0) {
                        this.bitCostDos.writeLong(n5);
                        this.bitCostDos.writeLong(n4);
                        break;
                    }
                    this.bitCostDos.writeLong(-1L);
                }
            }
        }
    }

    @Override
    public void terminate() throws IOException {
        this.terminate(false);
    }

    public void terminate(boolean bl) throws IOException {
        this.bos.flush();
        if (this.bitCostDos != null) {
            this.bitCostDos.flush();
        }
        if (bl) {
            System.out.println("total bits written: " + this.numBitsWritten);
        }
    }

    public int[] getAccumulator() {
        return this.accumulator;
    }

    public int[] getCounter() {
        return this.counter;
    }
}

