/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.RangeCoder;

import GiciEntropyCoder.EntropyCoder;
import GiciEntropyCoder.ProbabilityTable;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class RangeCoder
implements EntropyCoder {
    final ProbabilityTable probabilityTable;
    final OutputStream outputStream;
    final ByteArrayOutputStream os = new ByteArrayOutputStream();
    final boolean countIsPowerOfTwo;
    final int equivalentShift;
    BigInteger low = BigInteger.ZERO;
    BigInteger range = BigInteger.ONE;
    int count = 0;

    public RangeCoder(ProbabilityTable probabilityTable, OutputStream outputStream) {
        this.probabilityTable = probabilityTable;
        this.outputStream = new BufferedOutputStream(outputStream);
        this.countIsPowerOfTwo = probabilityTable.getObservationCount().bitCount() == 1;
        this.equivalentShift = probabilityTable.getObservationCount().getLowestSetBit();
    }

    @Override
    public void codeSymbol(BigInteger bigInteger) throws IOException {
        BigInteger bigInteger2 = this.probabilityTable.getCumulativeFrequency(bigInteger);
        BigInteger bigInteger3 = this.probabilityTable.getFrequency(bigInteger);
        BigInteger bigInteger4 = this.probabilityTable.getObservationCount();
        this.low = this.countIsPowerOfTwo ? this.low.shiftLeft(this.equivalentShift).add(bigInteger2.multiply(this.range)) : this.low.multiply(bigInteger4).add(bigInteger2.multiply(this.range));
        this.range = this.range.multiply(bigInteger3);
        ++this.count;
        if (this.count == Short.MAX_VALUE) {
            this.terminate();
        }
    }

    @Override
    public void terminate() throws IOException {
        BigInteger bigInteger;
        int n;
        assert (this.range.compareTo(BigInteger.ZERO) != 0);
        for (n = this.range.bitLength() - 2; n >= 0 && this.low.testBit(n); --n) {
        }
        if (n < 0) {
            n = 0;
            bigInteger = this.low;
        } else {
            bigInteger = this.low.setBit(n).shiftRight(n);
        }
        assert (bigInteger.shiftLeft(n).compareTo(this.low) >= 0);
        assert (bigInteger.shiftLeft(n).compareTo(this.low.add(this.range)) < 0);
        byte[] byArray = bigInteger.toByteArray();
        ByteBuffer byteBuffer = ByteBuffer.allocate(10);
        byteBuffer.putShort((short)this.count);
        byteBuffer.putInt(n);
        byteBuffer.putInt(byArray.length);
        this.outputStream.write(byteBuffer.array());
        this.outputStream.write(byArray);
        this.outputStream.flush();
        this.low = BigInteger.ZERO;
        this.range = BigInteger.ONE;
        this.count = 0;
    }

    protected BigInteger myToBigInt(byte[] byArray) {
        if (new BigInteger(byArray).compareTo(BigInteger.ZERO) != 0) {
            return new BigInteger(1, byArray);
        }
        return BigInteger.ZERO;
    }

    public void codeSymbol(byte[] byArray) throws IOException {
        int n;
        this.os.write(byArray);
        byte[] byArray2 = this.os.toByteArray();
        int n2 = this.probabilityTable.getSymbolByteSize();
        for (n = 0; n < byArray2.length; n += n2) {
            byte[] byArray3 = Arrays.copyOfRange(byArray2, n, n + n2);
            this.codeSymbol(this.myToBigInt(byArray3));
        }
        this.os.reset();
        n = byArray2.length % n2;
        this.os.write(byArray2, byArray2.length - n, n);
    }
}

