/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder.RangeCoder;

import GiciEntropyCoder.EntropyDecoder;
import GiciEntropyCoder.ProbabilityTable;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;

public class RangeDecoder
implements EntropyDecoder {
    final ProbabilityTable probabilityTable;
    final InputStream inputStream;
    final boolean countIsPowerOfTwo;
    final int equivalentShift;
    BigInteger low = BigInteger.ZERO;
    BigInteger range = BigInteger.ONE;
    int count = 0;

    public RangeDecoder(ProbabilityTable probabilityTable, InputStream inputStream) {
        this.probabilityTable = probabilityTable;
        this.inputStream = new BufferedInputStream(inputStream);
        this.countIsPowerOfTwo = probabilityTable.getObservationCount().bitCount() == 1;
        this.equivalentShift = probabilityTable.getObservationCount().getLowestSetBit();
    }

    @Override
    public BigInteger decodeSymbol() throws IOException {
        Comparable<ByteBuffer> comparable;
        Object object;
        BigInteger bigInteger = this.probabilityTable.getObservationCount();
        if (this.count == 0) {
            object = new byte[10];
            if (this.inputStream.read((byte[])object) < ((byte[])object).length) {
                throw new IOException("Invalid header received");
            }
            comparable = ByteBuffer.wrap(object);
            this.count = ((ByteBuffer)comparable).getShort();
            assert (this.count >= 0);
            int n = ((ByteBuffer)comparable).getInt();
            assert (n >= 0);
            int n2 = ((ByteBuffer)comparable).getInt();
            assert (n2 >= 0);
            byte[] byArray = new byte[n2];
            if (this.inputStream.read(byArray) < byArray.length) {
                throw new IOException("Partial codeword received");
            }
            this.low = new BigInteger(byArray);
            this.low = this.low.shiftLeft(n);
            if (!this.countIsPowerOfTwo) {
                this.range = bigInteger.pow(this.count);
            }
        }
        if (this.countIsPowerOfTwo) {
            object = this.low.shiftRight((this.count - 1) * this.equivalentShift);
        } else {
            this.range = this.range.divide(bigInteger);
            object = this.low.divide(this.range);
        }
        comparable = this.probabilityTable.findSymbolFromFrequency((BigInteger)object);
        BigInteger bigInteger2 = this.probabilityTable.getCumulativeFrequency((BigInteger)comparable);
        BigInteger bigInteger3 = this.probabilityTable.getFrequency((BigInteger)comparable);
        this.low = this.countIsPowerOfTwo ? this.low.subtract(bigInteger2.shiftLeft((this.count - 1) * this.equivalentShift)).divide(bigInteger3) : this.low.subtract(this.range.multiply(bigInteger2)).divide(bigInteger3);
        --this.count;
        return comparable;
    }

    protected byte[] myToByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        byte[] byArray2 = new byte[n];
        int n2 = bigInteger.bitLength();
        if ((n2 = n2 / 8 + (n2 % 8 != 0 ? 1 : 0)) > n) {
            n2 = n;
        }
        System.arraycopy(byArray, byArray.length - n2, byArray2, n - n2, n2);
        return byArray2;
    }

    public byte[] decodeSymbolBytes() throws IOException {
        return this.myToByteArray(this.decodeSymbol(), this.probabilityTable.getSymbolByteSize());
    }
}

