/*
 * Decompiled with CFR 0.152.
 */
package GiciEntropyCoder;

import GiciEntropyCoder.StaticProbabilityTable;
import java.math.BigInteger;

public class SimpleProbabilityTables
extends StaticProbabilityTable {
    protected SimpleProbabilityTables(BigInteger bigInteger) {
        super(null);
    }

    public static StaticProbabilityTable getProbabilityTableByRange(BigInteger[] bigIntegerArray) {
        BigInteger[] bigIntegerArray2 = new BigInteger[bigIntegerArray.length];
        for (int i = 0; i < bigIntegerArray.length; ++i) {
            bigIntegerArray2[i] = bigIntegerArray[i].multiply(BigInteger.valueOf(0x200000L)).divide(bigIntegerArray[bigIntegerArray.length - 1]);
        }
        assert (bigIntegerArray2[bigIntegerArray.length - 1].bitLength() == bigIntegerArray2[bigIntegerArray.length - 1].getLowestSetBit() + 1);
        return new StaticProbabilityTable(bigIntegerArray2);
    }

    public static StaticProbabilityTable getBinaryProbabilityTable(float f) {
        BigInteger[] bigIntegerArray = new BigInteger[]{BigInteger.ZERO, BigInteger.valueOf((int)(f * 2097152.0f)), BigInteger.valueOf(0x200000L)};
        if (bigIntegerArray[1].compareTo(bigIntegerArray[0]) <= 0) {
            bigIntegerArray[1] = BigInteger.ONE;
        } else if (bigIntegerArray[1].compareTo(bigIntegerArray[2]) >= 0) {
            bigIntegerArray[1] = bigIntegerArray[2].subtract(BigInteger.ONE);
        }
        return new StaticProbabilityTable(bigIntegerArray);
    }

    public static StaticProbabilityTable getEquiprobableTable(int n) {
        assert (n > 1);
        BigInteger[] bigIntegerArray = new BigInteger[n + 1];
        BigInteger bigInteger = BigInteger.valueOf(n);
        BigInteger bigInteger2 = BigInteger.ONE;
        while (bigInteger2.compareTo(bigInteger) < 0) {
            bigInteger2 = bigInteger2.shiftLeft(1);
        }
        for (int i = 0; i < n; ++i) {
            bigIntegerArray[i] = BigInteger.valueOf(i).multiply(bigInteger2).divide(bigInteger);
        }
        bigIntegerArray[n] = bigInteger2;
        return new StaticProbabilityTable(bigIntegerArray);
    }
}

